// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class BucketObjectLockConfigurationRuleDefaultRetention {
    /**
     * @return The number of days that you want to specify for the default retention period.
     * 
     */
    private @Nullable Integer days;
    /**
     * @return The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
     * 
     */
    private String mode;
    /**
     * @return The number of years that you want to specify for the default retention period.
     * 
     * Either `days` or `years` must be specified, but not both.
     * 
     * &gt; **NOTE on `object_lock_configuration`:** You can only enable S3 Object Lock for new buckets. If you need to turn on S3 Object Lock for an existing bucket, please contact AWS Support.
     * When you create a bucket with S3 Object Lock enabled, Amazon S3 automatically enables versioning for the bucket.
     * Once you create a bucket with S3 Object Lock enabled, you can&#39;t disable Object Lock or suspend versioning for the bucket.
     * 
     */
    private @Nullable Integer years;

    private BucketObjectLockConfigurationRuleDefaultRetention() {}
    /**
     * @return The number of days that you want to specify for the default retention period.
     * 
     */
    public Optional<Integer> days() {
        return Optional.ofNullable(this.days);
    }
    /**
     * @return The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
     * 
     */
    public String mode() {
        return this.mode;
    }
    /**
     * @return The number of years that you want to specify for the default retention period.
     * 
     * Either `days` or `years` must be specified, but not both.
     * 
     * &gt; **NOTE on `object_lock_configuration`:** You can only enable S3 Object Lock for new buckets. If you need to turn on S3 Object Lock for an existing bucket, please contact AWS Support.
     * When you create a bucket with S3 Object Lock enabled, Amazon S3 automatically enables versioning for the bucket.
     * Once you create a bucket with S3 Object Lock enabled, you can&#39;t disable Object Lock or suspend versioning for the bucket.
     * 
     */
    public Optional<Integer> years() {
        return Optional.ofNullable(this.years);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BucketObjectLockConfigurationRuleDefaultRetention defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Integer days;
        private String mode;
        private @Nullable Integer years;
        public Builder() {}
        public Builder(BucketObjectLockConfigurationRuleDefaultRetention defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.days = defaults.days;
    	      this.mode = defaults.mode;
    	      this.years = defaults.years;
        }

        @CustomType.Setter
        public Builder days(@Nullable Integer days) {
            this.days = days;
            return this;
        }
        @CustomType.Setter
        public Builder mode(String mode) {
            this.mode = Objects.requireNonNull(mode);
            return this;
        }
        @CustomType.Setter
        public Builder years(@Nullable Integer years) {
            this.years = years;
            return this;
        }
        public BucketObjectLockConfigurationRuleDefaultRetention build() {
            final var o = new BucketObjectLockConfigurationRuleDefaultRetention();
            o.days = days;
            o.mode = mode;
            o.years = years;
            return o;
        }
    }
}
