// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3.inputs;

import com.pulumi.aws.s3.inputs.InventoryDestinationArgs;
import com.pulumi.aws.s3.inputs.InventoryFilterArgs;
import com.pulumi.aws.s3.inputs.InventoryScheduleArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class InventoryState extends com.pulumi.resources.ResourceArgs {

    public static final InventoryState Empty = new InventoryState();

    /**
     * Name of the source bucket that inventory lists the objects for.
     * 
     */
    @Import(name="bucket")
    private @Nullable Output<String> bucket;

    /**
     * @return Name of the source bucket that inventory lists the objects for.
     * 
     */
    public Optional<Output<String>> bucket() {
        return Optional.ofNullable(this.bucket);
    }

    /**
     * Contains information about where to publish the inventory results (documented below).
     * 
     */
    @Import(name="destination")
    private @Nullable Output<InventoryDestinationArgs> destination;

    /**
     * @return Contains information about where to publish the inventory results (documented below).
     * 
     */
    public Optional<Output<InventoryDestinationArgs>> destination() {
        return Optional.ofNullable(this.destination);
    }

    /**
     * Specifies whether the inventory is enabled or disabled.
     * 
     */
    @Import(name="enabled")
    private @Nullable Output<Boolean> enabled;

    /**
     * @return Specifies whether the inventory is enabled or disabled.
     * 
     */
    public Optional<Output<Boolean>> enabled() {
        return Optional.ofNullable(this.enabled);
    }

    /**
     * Specifies an inventory filter. The inventory only includes objects that meet the filter&#39;s criteria (documented below).
     * 
     */
    @Import(name="filter")
    private @Nullable Output<InventoryFilterArgs> filter;

    /**
     * @return Specifies an inventory filter. The inventory only includes objects that meet the filter&#39;s criteria (documented below).
     * 
     */
    public Optional<Output<InventoryFilterArgs>> filter() {
        return Optional.ofNullable(this.filter);
    }

    /**
     * Object versions to include in the inventory list. Valid values: `All`, `Current`.
     * 
     */
    @Import(name="includedObjectVersions")
    private @Nullable Output<String> includedObjectVersions;

    /**
     * @return Object versions to include in the inventory list. Valid values: `All`, `Current`.
     * 
     */
    public Optional<Output<String>> includedObjectVersions() {
        return Optional.ofNullable(this.includedObjectVersions);
    }

    /**
     * Unique identifier of the inventory configuration for the bucket.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Unique identifier of the inventory configuration for the bucket.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
     * 
     */
    @Import(name="optionalFields")
    private @Nullable Output<List<String>> optionalFields;

    /**
     * @return List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
     * 
     */
    public Optional<Output<List<String>>> optionalFields() {
        return Optional.ofNullable(this.optionalFields);
    }

    /**
     * Specifies the schedule for generating inventory results (documented below).
     * 
     */
    @Import(name="schedule")
    private @Nullable Output<InventoryScheduleArgs> schedule;

    /**
     * @return Specifies the schedule for generating inventory results (documented below).
     * 
     */
    public Optional<Output<InventoryScheduleArgs>> schedule() {
        return Optional.ofNullable(this.schedule);
    }

    private InventoryState() {}

    private InventoryState(InventoryState $) {
        this.bucket = $.bucket;
        this.destination = $.destination;
        this.enabled = $.enabled;
        this.filter = $.filter;
        this.includedObjectVersions = $.includedObjectVersions;
        this.name = $.name;
        this.optionalFields = $.optionalFields;
        this.schedule = $.schedule;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(InventoryState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private InventoryState $;

        public Builder() {
            $ = new InventoryState();
        }

        public Builder(InventoryState defaults) {
            $ = new InventoryState(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucket Name of the source bucket that inventory lists the objects for.
         * 
         * @return builder
         * 
         */
        public Builder bucket(@Nullable Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket Name of the source bucket that inventory lists the objects for.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param destination Contains information about where to publish the inventory results (documented below).
         * 
         * @return builder
         * 
         */
        public Builder destination(@Nullable Output<InventoryDestinationArgs> destination) {
            $.destination = destination;
            return this;
        }

        /**
         * @param destination Contains information about where to publish the inventory results (documented below).
         * 
         * @return builder
         * 
         */
        public Builder destination(InventoryDestinationArgs destination) {
            return destination(Output.of(destination));
        }

        /**
         * @param enabled Specifies whether the inventory is enabled or disabled.
         * 
         * @return builder
         * 
         */
        public Builder enabled(@Nullable Output<Boolean> enabled) {
            $.enabled = enabled;
            return this;
        }

        /**
         * @param enabled Specifies whether the inventory is enabled or disabled.
         * 
         * @return builder
         * 
         */
        public Builder enabled(Boolean enabled) {
            return enabled(Output.of(enabled));
        }

        /**
         * @param filter Specifies an inventory filter. The inventory only includes objects that meet the filter&#39;s criteria (documented below).
         * 
         * @return builder
         * 
         */
        public Builder filter(@Nullable Output<InventoryFilterArgs> filter) {
            $.filter = filter;
            return this;
        }

        /**
         * @param filter Specifies an inventory filter. The inventory only includes objects that meet the filter&#39;s criteria (documented below).
         * 
         * @return builder
         * 
         */
        public Builder filter(InventoryFilterArgs filter) {
            return filter(Output.of(filter));
        }

        /**
         * @param includedObjectVersions Object versions to include in the inventory list. Valid values: `All`, `Current`.
         * 
         * @return builder
         * 
         */
        public Builder includedObjectVersions(@Nullable Output<String> includedObjectVersions) {
            $.includedObjectVersions = includedObjectVersions;
            return this;
        }

        /**
         * @param includedObjectVersions Object versions to include in the inventory list. Valid values: `All`, `Current`.
         * 
         * @return builder
         * 
         */
        public Builder includedObjectVersions(String includedObjectVersions) {
            return includedObjectVersions(Output.of(includedObjectVersions));
        }

        /**
         * @param name Unique identifier of the inventory configuration for the bucket.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Unique identifier of the inventory configuration for the bucket.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param optionalFields List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
         * 
         * @return builder
         * 
         */
        public Builder optionalFields(@Nullable Output<List<String>> optionalFields) {
            $.optionalFields = optionalFields;
            return this;
        }

        /**
         * @param optionalFields List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
         * 
         * @return builder
         * 
         */
        public Builder optionalFields(List<String> optionalFields) {
            return optionalFields(Output.of(optionalFields));
        }

        /**
         * @param optionalFields List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
         * 
         * @return builder
         * 
         */
        public Builder optionalFields(String... optionalFields) {
            return optionalFields(List.of(optionalFields));
        }

        /**
         * @param schedule Specifies the schedule for generating inventory results (documented below).
         * 
         * @return builder
         * 
         */
        public Builder schedule(@Nullable Output<InventoryScheduleArgs> schedule) {
            $.schedule = schedule;
            return this;
        }

        /**
         * @param schedule Specifies the schedule for generating inventory results (documented below).
         * 
         * @return builder
         * 
         */
        public Builder schedule(InventoryScheduleArgs schedule) {
            return schedule(Output.of(schedule));
        }

        public InventoryState build() {
            return $;
        }
    }

}
