// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3.inputs;

import com.pulumi.aws.s3.inputs.BucketV2CorsRuleArgs;
import com.pulumi.aws.s3.inputs.BucketV2GrantArgs;
import com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleArgs;
import com.pulumi.aws.s3.inputs.BucketV2LoggingArgs;
import com.pulumi.aws.s3.inputs.BucketV2ObjectLockConfigurationArgs;
import com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationArgs;
import com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationArgs;
import com.pulumi.aws.s3.inputs.BucketV2VersioningArgs;
import com.pulumi.aws.s3.inputs.BucketV2WebsiteArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketV2State extends com.pulumi.resources.ResourceArgs {

    public static final BucketV2State Empty = new BucketV2State();

    /**
     * Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_accelerate_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_accelerate_configuration resource instead */
    @Import(name="accelerationStatus")
    private @Nullable Output<String> accelerationStatus;

    /**
     * @return Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_accelerate_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_accelerate_configuration resource instead */
    public Optional<Output<String>> accelerationStatus() {
        return Optional.ofNullable(this.accelerationStatus);
    }

    /**
     * The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_acl resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_acl resource instead */
    @Import(name="acl")
    private @Nullable Output<String> acl;

    /**
     * @return The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_acl resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_acl resource instead */
    public Optional<Output<String>> acl() {
        return Optional.ofNullable(this.acl);
    }

    /**
     * ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     * 
     */
    @Import(name="bucket")
    private @Nullable Output<String> bucket;

    /**
     * @return Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     * 
     */
    public Optional<Output<String>> bucket() {
        return Optional.ofNullable(this.bucket);
    }

    /**
     * Bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
     * 
     */
    @Import(name="bucketDomainName")
    private @Nullable Output<String> bucketDomainName;

    /**
     * @return Bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
     * 
     */
    public Optional<Output<String>> bucketDomainName() {
        return Optional.ofNullable(this.bucketDomainName);
    }

    /**
     * Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     * 
     */
    @Import(name="bucketPrefix")
    private @Nullable Output<String> bucketPrefix;

    /**
     * @return Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
     * 
     */
    public Optional<Output<String>> bucketPrefix() {
        return Optional.ofNullable(this.bucketPrefix);
    }

    /**
     * The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the [S3 endpoints reference](https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region) for format. Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin. This will prevent redirect issues from CloudFront to the S3 Origin URL. For more information, see the [Virtual Hosted-Style Requests for Other Regions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/VirtualHosting.html#deprecated-global-endpoint) section in the AWS S3 User Guide.
     * 
     */
    @Import(name="bucketRegionalDomainName")
    private @Nullable Output<String> bucketRegionalDomainName;

    /**
     * @return The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the [S3 endpoints reference](https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region) for format. Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin. This will prevent redirect issues from CloudFront to the S3 Origin URL. For more information, see the [Virtual Hosted-Style Requests for Other Regions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/VirtualHosting.html#deprecated-global-endpoint) section in the AWS S3 User Guide.
     * 
     */
    public Optional<Output<String>> bucketRegionalDomainName() {
        return Optional.ofNullable(this.bucketRegionalDomainName);
    }

    /**
     * Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_cors_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_cors_configuration resource instead */
    @Import(name="corsRules")
    private @Nullable Output<List<BucketV2CorsRuleArgs>> corsRules;

    /**
     * @return Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_cors_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_cors_configuration resource instead */
    public Optional<Output<List<BucketV2CorsRuleArgs>>> corsRules() {
        return Optional.ofNullable(this.corsRules);
    }

    /**
     * Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
     * 
     */
    @Import(name="forceDestroy")
    private @Nullable Output<Boolean> forceDestroy;

    /**
     * @return Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
     * 
     */
    public Optional<Output<Boolean>> forceDestroy() {
        return Optional.ofNullable(this.forceDestroy);
    }

    /**
     * An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_acl resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_acl resource instead */
    @Import(name="grants")
    private @Nullable Output<List<BucketV2GrantArgs>> grants;

    /**
     * @return An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_acl resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_acl resource instead */
    public Optional<Output<List<BucketV2GrantArgs>>> grants() {
        return Optional.ofNullable(this.grants);
    }

    /**
     * [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket&#39;s region.
     * 
     */
    @Import(name="hostedZoneId")
    private @Nullable Output<String> hostedZoneId;

    /**
     * @return [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket&#39;s region.
     * 
     */
    public Optional<Output<String>> hostedZoneId() {
        return Optional.ofNullable(this.hostedZoneId);
    }

    /**
     * Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_lifecycle_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_lifecycle_configuration resource instead */
    @Import(name="lifecycleRules")
    private @Nullable Output<List<BucketV2LifecycleRuleArgs>> lifecycleRules;

    /**
     * @return Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_lifecycle_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_lifecycle_configuration resource instead */
    public Optional<Output<List<BucketV2LifecycleRuleArgs>>> lifecycleRules() {
        return Optional.ofNullable(this.lifecycleRules);
    }

    /**
     * Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_logging resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_logging resource instead */
    @Import(name="loggings")
    private @Nullable Output<List<BucketV2LoggingArgs>> loggings;

    /**
     * @return Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketLoggingV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_logging resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_logging resource instead */
    public Optional<Output<List<BucketV2LoggingArgs>>> loggings() {
        return Optional.ofNullable(this.loggings);
    }

    /**
     * Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
     * The provider wil only perform drift detection if a configuration value is provided.
     * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
     * 
     * @deprecated
     * Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration resource instead
     * 
     */
    @Deprecated /* Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration resource instead */
    @Import(name="objectLockConfiguration")
    private @Nullable Output<BucketV2ObjectLockConfigurationArgs> objectLockConfiguration;

    /**
     * @return Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
     * The provider wil only perform drift detection if a configuration value is provided.
     * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
     * 
     * @deprecated
     * Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration resource instead
     * 
     */
    @Deprecated /* Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration resource instead */
    public Optional<Output<BucketV2ObjectLockConfigurationArgs>> objectLockConfiguration() {
        return Optional.ofNullable(this.objectLockConfiguration);
    }

    /**
     * Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
     * 
     */
    @Import(name="objectLockEnabled")
    private @Nullable Output<Boolean> objectLockEnabled;

    /**
     * @return Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
     * 
     */
    public Optional<Output<Boolean>> objectLockEnabled() {
        return Optional.ofNullable(this.objectLockEnabled);
    }

    /**
     * Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketPolicy` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_policy resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_policy resource instead */
    @Import(name="policy")
    private @Nullable Output<String> policy;

    /**
     * @return Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketPolicy` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_policy resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_policy resource instead */
    public Optional<Output<String>> policy() {
        return Optional.ofNullable(this.policy);
    }

    /**
     * AWS region this bucket resides in.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return AWS region this bucket resides in.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_replication_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_replication_configuration resource instead */
    @Import(name="replicationConfigurations")
    private @Nullable Output<List<BucketV2ReplicationConfigurationArgs>> replicationConfigurations;

    /**
     * @return Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketReplicationConfig` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_replication_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_replication_configuration resource instead */
    public Optional<Output<List<BucketV2ReplicationConfigurationArgs>>> replicationConfigurations() {
        return Optional.ofNullable(this.replicationConfigurations);
    }

    /**
     * Specifies who should bear the cost of Amazon S3 data transfer.
     * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
     * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_request_payment_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_request_payment_configuration resource instead */
    @Import(name="requestPayer")
    private @Nullable Output<String> requestPayer;

    /**
     * @return Specifies who should bear the cost of Amazon S3 data transfer.
     * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
     * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_request_payment_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_request_payment_configuration resource instead */
    public Optional<Output<String>> requestPayer() {
        return Optional.ofNullable(this.requestPayer);
    }

    /**
     * Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_server_side_encryption_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_server_side_encryption_configuration resource instead */
    @Import(name="serverSideEncryptionConfigurations")
    private @Nullable Output<List<BucketV2ServerSideEncryptionConfigurationArgs>> serverSideEncryptionConfigurations;

    /**
     * @return Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
     * The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_server_side_encryption_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_server_side_encryption_configuration resource instead */
    public Optional<Output<List<BucketV2ServerSideEncryptionConfigurationArgs>>> serverSideEncryptionConfigurations() {
        return Optional.ofNullable(this.serverSideEncryptionConfigurations);
    }

    /**
     * Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     * The following arguments are deprecated, and will be removed in a future major version:
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     * The following arguments are deprecated, and will be removed in a future major version:
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_versioning resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_versioning resource instead */
    @Import(name="versionings")
    private @Nullable Output<List<BucketV2VersioningArgs>> versionings;

    /**
     * @return Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_versioning resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_versioning resource instead */
    public Optional<Output<List<BucketV2VersioningArgs>>> versionings() {
        return Optional.ofNullable(this.versionings);
    }

    /**
     * (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_website_configuration resource
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_website_configuration resource */
    @Import(name="websiteDomain")
    private @Nullable Output<String> websiteDomain;

    /**
     * @return (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_website_configuration resource
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_website_configuration resource */
    public Optional<Output<String>> websiteDomain() {
        return Optional.ofNullable(this.websiteDomain);
    }

    /**
     * (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_website_configuration resource
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_website_configuration resource */
    @Import(name="websiteEndpoint")
    private @Nullable Output<String> websiteEndpoint;

    /**
     * @return (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_website_configuration resource
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_website_configuration resource */
    public Optional<Output<String>> websiteEndpoint() {
        return Optional.ofNullable(this.websiteEndpoint);
    }

    /**
     * Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_website_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_website_configuration resource instead */
    @Import(name="websites")
    private @Nullable Output<List<BucketV2WebsiteArgs>> websites;

    /**
     * @return Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
     * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
     * 
     * @deprecated
     * Use the aws_s3_bucket_website_configuration resource instead
     * 
     */
    @Deprecated /* Use the aws_s3_bucket_website_configuration resource instead */
    public Optional<Output<List<BucketV2WebsiteArgs>>> websites() {
        return Optional.ofNullable(this.websites);
    }

    private BucketV2State() {}

    private BucketV2State(BucketV2State $) {
        this.accelerationStatus = $.accelerationStatus;
        this.acl = $.acl;
        this.arn = $.arn;
        this.bucket = $.bucket;
        this.bucketDomainName = $.bucketDomainName;
        this.bucketPrefix = $.bucketPrefix;
        this.bucketRegionalDomainName = $.bucketRegionalDomainName;
        this.corsRules = $.corsRules;
        this.forceDestroy = $.forceDestroy;
        this.grants = $.grants;
        this.hostedZoneId = $.hostedZoneId;
        this.lifecycleRules = $.lifecycleRules;
        this.loggings = $.loggings;
        this.objectLockConfiguration = $.objectLockConfiguration;
        this.objectLockEnabled = $.objectLockEnabled;
        this.policy = $.policy;
        this.region = $.region;
        this.replicationConfigurations = $.replicationConfigurations;
        this.requestPayer = $.requestPayer;
        this.serverSideEncryptionConfigurations = $.serverSideEncryptionConfigurations;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.versionings = $.versionings;
        this.websiteDomain = $.websiteDomain;
        this.websiteEndpoint = $.websiteEndpoint;
        this.websites = $.websites;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketV2State defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketV2State $;

        public Builder() {
            $ = new BucketV2State();
        }

        public Builder(BucketV2State defaults) {
            $ = new BucketV2State(Objects.requireNonNull(defaults));
        }

        /**
         * @param accelerationStatus Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_accelerate_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_accelerate_configuration resource instead */
        public Builder accelerationStatus(@Nullable Output<String> accelerationStatus) {
            $.accelerationStatus = accelerationStatus;
            return this;
        }

        /**
         * @param accelerationStatus Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketAccelerateConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_accelerate_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_accelerate_configuration resource instead */
        public Builder accelerationStatus(String accelerationStatus) {
            return accelerationStatus(Output.of(accelerationStatus));
        }

        /**
         * @param acl The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_acl resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_acl resource instead */
        public Builder acl(@Nullable Output<String> acl) {
            $.acl = acl;
            return this;
        }

        /**
         * @param acl The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_acl resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_acl resource instead */
        public Builder acl(String acl) {
            return acl(Output.of(acl));
        }

        /**
         * @param arn ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param bucket Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
         * 
         * @return builder
         * 
         */
        public Builder bucket(@Nullable Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param bucketDomainName Bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
         * 
         * @return builder
         * 
         */
        public Builder bucketDomainName(@Nullable Output<String> bucketDomainName) {
            $.bucketDomainName = bucketDomainName;
            return this;
        }

        /**
         * @param bucketDomainName Bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
         * 
         * @return builder
         * 
         */
        public Builder bucketDomainName(String bucketDomainName) {
            return bucketDomainName(Output.of(bucketDomainName));
        }

        /**
         * @param bucketPrefix Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
         * 
         * @return builder
         * 
         */
        public Builder bucketPrefix(@Nullable Output<String> bucketPrefix) {
            $.bucketPrefix = bucketPrefix;
            return this;
        }

        /**
         * @param bucketPrefix Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
         * 
         * @return builder
         * 
         */
        public Builder bucketPrefix(String bucketPrefix) {
            return bucketPrefix(Output.of(bucketPrefix));
        }

        /**
         * @param bucketRegionalDomainName The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the [S3 endpoints reference](https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region) for format. Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin. This will prevent redirect issues from CloudFront to the S3 Origin URL. For more information, see the [Virtual Hosted-Style Requests for Other Regions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/VirtualHosting.html#deprecated-global-endpoint) section in the AWS S3 User Guide.
         * 
         * @return builder
         * 
         */
        public Builder bucketRegionalDomainName(@Nullable Output<String> bucketRegionalDomainName) {
            $.bucketRegionalDomainName = bucketRegionalDomainName;
            return this;
        }

        /**
         * @param bucketRegionalDomainName The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the [S3 endpoints reference](https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region) for format. Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin. This will prevent redirect issues from CloudFront to the S3 Origin URL. For more information, see the [Virtual Hosted-Style Requests for Other Regions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/VirtualHosting.html#deprecated-global-endpoint) section in the AWS S3 User Guide.
         * 
         * @return builder
         * 
         */
        public Builder bucketRegionalDomainName(String bucketRegionalDomainName) {
            return bucketRegionalDomainName(Output.of(bucketRegionalDomainName));
        }

        /**
         * @param corsRules Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_cors_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_cors_configuration resource instead */
        public Builder corsRules(@Nullable Output<List<BucketV2CorsRuleArgs>> corsRules) {
            $.corsRules = corsRules;
            return this;
        }

        /**
         * @param corsRules Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_cors_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_cors_configuration resource instead */
        public Builder corsRules(List<BucketV2CorsRuleArgs> corsRules) {
            return corsRules(Output.of(corsRules));
        }

        /**
         * @param corsRules Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketCorsConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_cors_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_cors_configuration resource instead */
        public Builder corsRules(BucketV2CorsRuleArgs... corsRules) {
            return corsRules(List.of(corsRules));
        }

        /**
         * @param forceDestroy Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
         * 
         * @return builder
         * 
         */
        public Builder forceDestroy(@Nullable Output<Boolean> forceDestroy) {
            $.forceDestroy = forceDestroy;
            return this;
        }

        /**
         * @param forceDestroy Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
         * 
         * @return builder
         * 
         */
        public Builder forceDestroy(Boolean forceDestroy) {
            return forceDestroy(Output.of(forceDestroy));
        }

        /**
         * @param grants An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_acl resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_acl resource instead */
        public Builder grants(@Nullable Output<List<BucketV2GrantArgs>> grants) {
            $.grants = grants;
            return this;
        }

        /**
         * @param grants An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_acl resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_acl resource instead */
        public Builder grants(List<BucketV2GrantArgs> grants) {
            return grants(Output.of(grants));
        }

        /**
         * @param grants An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketAclV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_acl resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_acl resource instead */
        public Builder grants(BucketV2GrantArgs... grants) {
            return grants(List.of(grants));
        }

        /**
         * @param hostedZoneId [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket&#39;s region.
         * 
         * @return builder
         * 
         */
        public Builder hostedZoneId(@Nullable Output<String> hostedZoneId) {
            $.hostedZoneId = hostedZoneId;
            return this;
        }

        /**
         * @param hostedZoneId [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket&#39;s region.
         * 
         * @return builder
         * 
         */
        public Builder hostedZoneId(String hostedZoneId) {
            return hostedZoneId(Output.of(hostedZoneId));
        }

        /**
         * @param lifecycleRules Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_lifecycle_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_lifecycle_configuration resource instead */
        public Builder lifecycleRules(@Nullable Output<List<BucketV2LifecycleRuleArgs>> lifecycleRules) {
            $.lifecycleRules = lifecycleRules;
            return this;
        }

        /**
         * @param lifecycleRules Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_lifecycle_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_lifecycle_configuration resource instead */
        public Builder lifecycleRules(List<BucketV2LifecycleRuleArgs> lifecycleRules) {
            return lifecycleRules(Output.of(lifecycleRules));
        }

        /**
         * @param lifecycleRules Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketLifecycleConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_lifecycle_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_lifecycle_configuration resource instead */
        public Builder lifecycleRules(BucketV2LifecycleRuleArgs... lifecycleRules) {
            return lifecycleRules(List.of(lifecycleRules));
        }

        /**
         * @param loggings Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketLoggingV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_logging resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_logging resource instead */
        public Builder loggings(@Nullable Output<List<BucketV2LoggingArgs>> loggings) {
            $.loggings = loggings;
            return this;
        }

        /**
         * @param loggings Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketLoggingV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_logging resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_logging resource instead */
        public Builder loggings(List<BucketV2LoggingArgs> loggings) {
            return loggings(Output.of(loggings));
        }

        /**
         * @param loggings Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketLoggingV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_logging resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_logging resource instead */
        public Builder loggings(BucketV2LoggingArgs... loggings) {
            return loggings(List.of(loggings));
        }

        /**
         * @param objectLockConfiguration Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
         * The provider wil only perform drift detection if a configuration value is provided.
         * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration resource instead
         * 
         */
        @Deprecated /* Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration resource instead */
        public Builder objectLockConfiguration(@Nullable Output<BucketV2ObjectLockConfigurationArgs> objectLockConfiguration) {
            $.objectLockConfiguration = objectLockConfiguration;
            return this;
        }

        /**
         * @param objectLockConfiguration Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
         * The provider wil only perform drift detection if a configuration value is provided.
         * Use the `object_lock_enabled` parameter and the resource `aws.s3.BucketObjectLockConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration resource instead
         * 
         */
        @Deprecated /* Use the top-level parameter object_lock_enabled and the aws_s3_bucket_object_lock_configuration resource instead */
        public Builder objectLockConfiguration(BucketV2ObjectLockConfigurationArgs objectLockConfiguration) {
            return objectLockConfiguration(Output.of(objectLockConfiguration));
        }

        /**
         * @param objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
         * 
         * @return builder
         * 
         */
        public Builder objectLockEnabled(@Nullable Output<Boolean> objectLockEnabled) {
            $.objectLockEnabled = objectLockEnabled;
            return this;
        }

        /**
         * @param objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
         * 
         * @return builder
         * 
         */
        public Builder objectLockEnabled(Boolean objectLockEnabled) {
            return objectLockEnabled(Output.of(objectLockEnabled));
        }

        /**
         * @param policy Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
         * The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketPolicy` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_policy resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_policy resource instead */
        public Builder policy(@Nullable Output<String> policy) {
            $.policy = policy;
            return this;
        }

        /**
         * @param policy Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
         * The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketPolicy` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_policy resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_policy resource instead */
        public Builder policy(String policy) {
            return policy(Output.of(policy));
        }

        /**
         * @param region AWS region this bucket resides in.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region AWS region this bucket resides in.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param replicationConfigurations Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketReplicationConfig` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_replication_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_replication_configuration resource instead */
        public Builder replicationConfigurations(@Nullable Output<List<BucketV2ReplicationConfigurationArgs>> replicationConfigurations) {
            $.replicationConfigurations = replicationConfigurations;
            return this;
        }

        /**
         * @param replicationConfigurations Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketReplicationConfig` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_replication_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_replication_configuration resource instead */
        public Builder replicationConfigurations(List<BucketV2ReplicationConfigurationArgs> replicationConfigurations) {
            return replicationConfigurations(Output.of(replicationConfigurations));
        }

        /**
         * @param replicationConfigurations Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketReplicationConfig` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_replication_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_replication_configuration resource instead */
        public Builder replicationConfigurations(BucketV2ReplicationConfigurationArgs... replicationConfigurations) {
            return replicationConfigurations(List.of(replicationConfigurations));
        }

        /**
         * @param requestPayer Specifies who should bear the cost of Amazon S3 data transfer.
         * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
         * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
         * The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_request_payment_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_request_payment_configuration resource instead */
        public Builder requestPayer(@Nullable Output<String> requestPayer) {
            $.requestPayer = requestPayer;
            return this;
        }

        /**
         * @param requestPayer Specifies who should bear the cost of Amazon S3 data transfer.
         * Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
         * See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
         * The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketRequestPaymentConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_request_payment_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_request_payment_configuration resource instead */
        public Builder requestPayer(String requestPayer) {
            return requestPayer(Output.of(requestPayer));
        }

        /**
         * @param serverSideEncryptionConfigurations Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
         * The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_server_side_encryption_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_server_side_encryption_configuration resource instead */
        public Builder serverSideEncryptionConfigurations(@Nullable Output<List<BucketV2ServerSideEncryptionConfigurationArgs>> serverSideEncryptionConfigurations) {
            $.serverSideEncryptionConfigurations = serverSideEncryptionConfigurations;
            return this;
        }

        /**
         * @param serverSideEncryptionConfigurations Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
         * The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_server_side_encryption_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_server_side_encryption_configuration resource instead */
        public Builder serverSideEncryptionConfigurations(List<BucketV2ServerSideEncryptionConfigurationArgs> serverSideEncryptionConfigurations) {
            return serverSideEncryptionConfigurations(Output.of(serverSideEncryptionConfigurations));
        }

        /**
         * @param serverSideEncryptionConfigurations Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
         * The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketServerSideEncryptionConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_server_side_encryption_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_server_side_encryption_configuration resource instead */
        public Builder serverSideEncryptionConfigurations(BucketV2ServerSideEncryptionConfigurationArgs... serverSideEncryptionConfigurations) {
            return serverSideEncryptionConfigurations(List.of(serverSideEncryptionConfigurations));
        }

        /**
         * @param tags Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * The following arguments are deprecated, and will be removed in a future major version:
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * The following arguments are deprecated, and will be removed in a future major version:
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param versionings Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_versioning resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_versioning resource instead */
        public Builder versionings(@Nullable Output<List<BucketV2VersioningArgs>> versionings) {
            $.versionings = versionings;
            return this;
        }

        /**
         * @param versionings Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_versioning resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_versioning resource instead */
        public Builder versionings(List<BucketV2VersioningArgs> versionings) {
            return versionings(Output.of(versionings));
        }

        /**
         * @param versionings Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `aws.s3.BucketVersioningV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_versioning resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_versioning resource instead */
        public Builder versionings(BucketV2VersioningArgs... versionings) {
            return versionings(List.of(versionings));
        }

        /**
         * @param websiteDomain (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_website_configuration resource
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_website_configuration resource */
        public Builder websiteDomain(@Nullable Output<String> websiteDomain) {
            $.websiteDomain = websiteDomain;
            return this;
        }

        /**
         * @param websiteDomain (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_website_configuration resource
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_website_configuration resource */
        public Builder websiteDomain(String websiteDomain) {
            return websiteDomain(Output.of(websiteDomain));
        }

        /**
         * @param websiteEndpoint (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_website_configuration resource
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_website_configuration resource */
        public Builder websiteEndpoint(@Nullable Output<String> websiteEndpoint) {
            $.websiteEndpoint = websiteEndpoint;
            return this;
        }

        /**
         * @param websiteEndpoint (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_website_configuration resource
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_website_configuration resource */
        public Builder websiteEndpoint(String websiteEndpoint) {
            return websiteEndpoint(Output.of(websiteEndpoint));
        }

        /**
         * @param websites Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_website_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_website_configuration resource instead */
        public Builder websites(@Nullable Output<List<BucketV2WebsiteArgs>> websites) {
            $.websites = websites;
            return this;
        }

        /**
         * @param websites Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_website_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_website_configuration resource instead */
        public Builder websites(List<BucketV2WebsiteArgs> websites) {
            return websites(Output.of(websites));
        }

        /**
         * @param websites Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
         * Use the resource `aws.s3.BucketWebsiteConfigurationV2` instead.
         * 
         * @return builder
         * 
         * @deprecated
         * Use the aws_s3_bucket_website_configuration resource instead
         * 
         */
        @Deprecated /* Use the aws_s3_bucket_website_configuration resource instead */
        public Builder websites(BucketV2WebsiteArgs... websites) {
            return websites(List.of(websites));
        }

        public BucketV2State build() {
            return $;
        }
    }

}
