// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketV2GrantArgs extends com.pulumi.resources.ResourceArgs {

    public static final BucketV2GrantArgs Empty = new BucketV2GrantArgs();

    /**
     * Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
     * 
     */
    @Import(name="id")
    private @Nullable Output<String> id;

    /**
     * @return Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
     * 
     */
    public Optional<Output<String>> id() {
        return Optional.ofNullable(this.id);
    }

    /**
     * List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     * 
     */
    @Import(name="permissions", required=true)
    private Output<List<String>> permissions;

    /**
     * @return List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     * 
     */
    public Output<List<String>> permissions() {
        return this.permissions;
    }

    /**
     * Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
     * 
     */
    @Import(name="type", required=true)
    private Output<String> type;

    /**
     * @return Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    /**
     * Uri address to grant for. Used only when `type` is `Group`.
     * 
     */
    @Import(name="uri")
    private @Nullable Output<String> uri;

    /**
     * @return Uri address to grant for. Used only when `type` is `Group`.
     * 
     */
    public Optional<Output<String>> uri() {
        return Optional.ofNullable(this.uri);
    }

    private BucketV2GrantArgs() {}

    private BucketV2GrantArgs(BucketV2GrantArgs $) {
        this.id = $.id;
        this.permissions = $.permissions;
        this.type = $.type;
        this.uri = $.uri;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketV2GrantArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketV2GrantArgs $;

        public Builder() {
            $ = new BucketV2GrantArgs();
        }

        public Builder(BucketV2GrantArgs defaults) {
            $ = new BucketV2GrantArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param id Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
         * 
         * @return builder
         * 
         */
        public Builder id(@Nullable Output<String> id) {
            $.id = id;
            return this;
        }

        /**
         * @param id Canonical user id to grant for. Used only when `type` is `CanonicalUser`.
         * 
         * @return builder
         * 
         */
        public Builder id(String id) {
            return id(Output.of(id));
        }

        /**
         * @param permissions List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
         * 
         * @return builder
         * 
         */
        public Builder permissions(Output<List<String>> permissions) {
            $.permissions = permissions;
            return this;
        }

        /**
         * @param permissions List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
         * 
         * @return builder
         * 
         */
        public Builder permissions(List<String> permissions) {
            return permissions(Output.of(permissions));
        }

        /**
         * @param permissions List of permissions to apply for grantee. Valid values are `READ`, `WRITE`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
         * 
         * @return builder
         * 
         */
        public Builder permissions(String... permissions) {
            return permissions(List.of(permissions));
        }

        /**
         * @param type Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
         * 
         * @return builder
         * 
         */
        public Builder type(Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type Type of grantee to apply for. Valid values are `CanonicalUser` and `Group`. `AmazonCustomerByEmail` is not supported.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        /**
         * @param uri Uri address to grant for. Used only when `type` is `Group`.
         * 
         * @return builder
         * 
         */
        public Builder uri(@Nullable Output<String> uri) {
            $.uri = uri;
            return this;
        }

        /**
         * @param uri Uri address to grant for. Used only when `type` is `Group`.
         * 
         * @return builder
         * 
         */
        public Builder uri(String uri) {
            return uri(Output.of(uri));
        }

        public BucketV2GrantArgs build() {
            $.permissions = Objects.requireNonNull($.permissions, "expected parameter 'permissions' to be non-null");
            $.type = Objects.requireNonNull($.type, "expected parameter 'type' to be non-null");
            return $;
        }
    }

}
