// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3.inputs;

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationAccessControlTranslationArgs;
import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs;
import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationMetricsArgs;
import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationReplicationTimeArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketReplicationConfigRuleDestinationArgs extends com.pulumi.resources.ResourceArgs {

    public static final BucketReplicationConfigRuleDestinationArgs Empty = new BucketReplicationConfigRuleDestinationArgs();

    /**
     * Configuration block that specifies the overrides to use for object owners on replication. See below. Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object. Must be used in conjunction with `account` owner override configuration.
     * 
     */
    @Import(name="accessControlTranslation")
    private @Nullable Output<BucketReplicationConfigRuleDestinationAccessControlTranslationArgs> accessControlTranslation;

    /**
     * @return Configuration block that specifies the overrides to use for object owners on replication. See below. Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object. Must be used in conjunction with `account` owner override configuration.
     * 
     */
    public Optional<Output<BucketReplicationConfigRuleDestinationAccessControlTranslationArgs>> accessControlTranslation() {
        return Optional.ofNullable(this.accessControlTranslation);
    }

    /**
     * Account ID to specify the replica ownership. Must be used in conjunction with `access_control_translation` override configuration.
     * 
     */
    @Import(name="account")
    private @Nullable Output<String> account;

    /**
     * @return Account ID to specify the replica ownership. Must be used in conjunction with `access_control_translation` override configuration.
     * 
     */
    public Optional<Output<String>> account() {
        return Optional.ofNullable(this.account);
    }

    /**
     * ARN of the bucket where you want Amazon S3 to store the results.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return ARN of the bucket where you want Amazon S3 to store the results.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * Configuration block that provides information about encryption. See below. If `source_selection_criteria` is specified, you must specify this element.
     * 
     */
    @Import(name="encryptionConfiguration")
    private @Nullable Output<BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs> encryptionConfiguration;

    /**
     * @return Configuration block that provides information about encryption. See below. If `source_selection_criteria` is specified, you must specify this element.
     * 
     */
    public Optional<Output<BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs>> encryptionConfiguration() {
        return Optional.ofNullable(this.encryptionConfiguration);
    }

    /**
     * Configuration block that specifies replication metrics-related settings enabling replication metrics and events. See below.
     * 
     */
    @Import(name="metrics")
    private @Nullable Output<BucketReplicationConfigRuleDestinationMetricsArgs> metrics;

    /**
     * @return Configuration block that specifies replication metrics-related settings enabling replication metrics and events. See below.
     * 
     */
    public Optional<Output<BucketReplicationConfigRuleDestinationMetricsArgs>> metrics() {
        return Optional.ofNullable(this.metrics);
    }

    /**
     * Configuration block that specifies S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. See below. Replication Time Control must be used in conjunction with `metrics`.
     * 
     */
    @Import(name="replicationTime")
    private @Nullable Output<BucketReplicationConfigRuleDestinationReplicationTimeArgs> replicationTime;

    /**
     * @return Configuration block that specifies S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. See below. Replication Time Control must be used in conjunction with `metrics`.
     * 
     */
    public Optional<Output<BucketReplicationConfigRuleDestinationReplicationTimeArgs>> replicationTime() {
        return Optional.ofNullable(this.replicationTime);
    }

    /**
     * The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
     * 
     */
    @Import(name="storageClass")
    private @Nullable Output<String> storageClass;

    /**
     * @return The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
     * 
     */
    public Optional<Output<String>> storageClass() {
        return Optional.ofNullable(this.storageClass);
    }

    private BucketReplicationConfigRuleDestinationArgs() {}

    private BucketReplicationConfigRuleDestinationArgs(BucketReplicationConfigRuleDestinationArgs $) {
        this.accessControlTranslation = $.accessControlTranslation;
        this.account = $.account;
        this.bucket = $.bucket;
        this.encryptionConfiguration = $.encryptionConfiguration;
        this.metrics = $.metrics;
        this.replicationTime = $.replicationTime;
        this.storageClass = $.storageClass;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketReplicationConfigRuleDestinationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketReplicationConfigRuleDestinationArgs $;

        public Builder() {
            $ = new BucketReplicationConfigRuleDestinationArgs();
        }

        public Builder(BucketReplicationConfigRuleDestinationArgs defaults) {
            $ = new BucketReplicationConfigRuleDestinationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessControlTranslation Configuration block that specifies the overrides to use for object owners on replication. See below. Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object. Must be used in conjunction with `account` owner override configuration.
         * 
         * @return builder
         * 
         */
        public Builder accessControlTranslation(@Nullable Output<BucketReplicationConfigRuleDestinationAccessControlTranslationArgs> accessControlTranslation) {
            $.accessControlTranslation = accessControlTranslation;
            return this;
        }

        /**
         * @param accessControlTranslation Configuration block that specifies the overrides to use for object owners on replication. See below. Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object. Must be used in conjunction with `account` owner override configuration.
         * 
         * @return builder
         * 
         */
        public Builder accessControlTranslation(BucketReplicationConfigRuleDestinationAccessControlTranslationArgs accessControlTranslation) {
            return accessControlTranslation(Output.of(accessControlTranslation));
        }

        /**
         * @param account Account ID to specify the replica ownership. Must be used in conjunction with `access_control_translation` override configuration.
         * 
         * @return builder
         * 
         */
        public Builder account(@Nullable Output<String> account) {
            $.account = account;
            return this;
        }

        /**
         * @param account Account ID to specify the replica ownership. Must be used in conjunction with `access_control_translation` override configuration.
         * 
         * @return builder
         * 
         */
        public Builder account(String account) {
            return account(Output.of(account));
        }

        /**
         * @param bucket ARN of the bucket where you want Amazon S3 to store the results.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket ARN of the bucket where you want Amazon S3 to store the results.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param encryptionConfiguration Configuration block that provides information about encryption. See below. If `source_selection_criteria` is specified, you must specify this element.
         * 
         * @return builder
         * 
         */
        public Builder encryptionConfiguration(@Nullable Output<BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs> encryptionConfiguration) {
            $.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * @param encryptionConfiguration Configuration block that provides information about encryption. See below. If `source_selection_criteria` is specified, you must specify this element.
         * 
         * @return builder
         * 
         */
        public Builder encryptionConfiguration(BucketReplicationConfigRuleDestinationEncryptionConfigurationArgs encryptionConfiguration) {
            return encryptionConfiguration(Output.of(encryptionConfiguration));
        }

        /**
         * @param metrics Configuration block that specifies replication metrics-related settings enabling replication metrics and events. See below.
         * 
         * @return builder
         * 
         */
        public Builder metrics(@Nullable Output<BucketReplicationConfigRuleDestinationMetricsArgs> metrics) {
            $.metrics = metrics;
            return this;
        }

        /**
         * @param metrics Configuration block that specifies replication metrics-related settings enabling replication metrics and events. See below.
         * 
         * @return builder
         * 
         */
        public Builder metrics(BucketReplicationConfigRuleDestinationMetricsArgs metrics) {
            return metrics(Output.of(metrics));
        }

        /**
         * @param replicationTime Configuration block that specifies S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. See below. Replication Time Control must be used in conjunction with `metrics`.
         * 
         * @return builder
         * 
         */
        public Builder replicationTime(@Nullable Output<BucketReplicationConfigRuleDestinationReplicationTimeArgs> replicationTime) {
            $.replicationTime = replicationTime;
            return this;
        }

        /**
         * @param replicationTime Configuration block that specifies S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. See below. Replication Time Control must be used in conjunction with `metrics`.
         * 
         * @return builder
         * 
         */
        public Builder replicationTime(BucketReplicationConfigRuleDestinationReplicationTimeArgs replicationTime) {
            return replicationTime(Output.of(replicationTime));
        }

        /**
         * @param storageClass The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
         * 
         * @return builder
         * 
         */
        public Builder storageClass(@Nullable Output<String> storageClass) {
            $.storageClass = storageClass;
            return this;
        }

        /**
         * @param storageClass The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
         * 
         * @return builder
         * 
         */
        public Builder storageClass(String storageClass) {
            return storageClass(Output.of(storageClass));
        }

        public BucketReplicationConfigRuleDestinationArgs build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            return $;
        }
    }

}
