// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketObjectLockConfigurationRuleDefaultRetentionArgs extends com.pulumi.resources.ResourceArgs {

    public static final BucketObjectLockConfigurationRuleDefaultRetentionArgs Empty = new BucketObjectLockConfigurationRuleDefaultRetentionArgs();

    /**
     * The number of days that you want to specify for the default retention period.
     * 
     */
    @Import(name="days")
    private @Nullable Output<Integer> days;

    /**
     * @return The number of days that you want to specify for the default retention period.
     * 
     */
    public Optional<Output<Integer>> days() {
        return Optional.ofNullable(this.days);
    }

    /**
     * The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
     * 
     */
    @Import(name="mode", required=true)
    private Output<String> mode;

    /**
     * @return The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
     * 
     */
    public Output<String> mode() {
        return this.mode;
    }

    /**
     * The number of years that you want to specify for the default retention period.
     * 
     * Either `days` or `years` must be specified, but not both.
     * 
     * &gt; **NOTE on `object_lock_configuration`:** You can only enable S3 Object Lock for new buckets. If you need to turn on S3 Object Lock for an existing bucket, please contact AWS Support.
     * When you create a bucket with S3 Object Lock enabled, Amazon S3 automatically enables versioning for the bucket.
     * Once you create a bucket with S3 Object Lock enabled, you can&#39;t disable Object Lock or suspend versioning for the bucket.
     * 
     */
    @Import(name="years")
    private @Nullable Output<Integer> years;

    /**
     * @return The number of years that you want to specify for the default retention period.
     * 
     * Either `days` or `years` must be specified, but not both.
     * 
     * &gt; **NOTE on `object_lock_configuration`:** You can only enable S3 Object Lock for new buckets. If you need to turn on S3 Object Lock for an existing bucket, please contact AWS Support.
     * When you create a bucket with S3 Object Lock enabled, Amazon S3 automatically enables versioning for the bucket.
     * Once you create a bucket with S3 Object Lock enabled, you can&#39;t disable Object Lock or suspend versioning for the bucket.
     * 
     */
    public Optional<Output<Integer>> years() {
        return Optional.ofNullable(this.years);
    }

    private BucketObjectLockConfigurationRuleDefaultRetentionArgs() {}

    private BucketObjectLockConfigurationRuleDefaultRetentionArgs(BucketObjectLockConfigurationRuleDefaultRetentionArgs $) {
        this.days = $.days;
        this.mode = $.mode;
        this.years = $.years;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketObjectLockConfigurationRuleDefaultRetentionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketObjectLockConfigurationRuleDefaultRetentionArgs $;

        public Builder() {
            $ = new BucketObjectLockConfigurationRuleDefaultRetentionArgs();
        }

        public Builder(BucketObjectLockConfigurationRuleDefaultRetentionArgs defaults) {
            $ = new BucketObjectLockConfigurationRuleDefaultRetentionArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param days The number of days that you want to specify for the default retention period.
         * 
         * @return builder
         * 
         */
        public Builder days(@Nullable Output<Integer> days) {
            $.days = days;
            return this;
        }

        /**
         * @param days The number of days that you want to specify for the default retention period.
         * 
         * @return builder
         * 
         */
        public Builder days(Integer days) {
            return days(Output.of(days));
        }

        /**
         * @param mode The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
         * 
         * @return builder
         * 
         */
        public Builder mode(Output<String> mode) {
            $.mode = mode;
            return this;
        }

        /**
         * @param mode The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
         * 
         * @return builder
         * 
         */
        public Builder mode(String mode) {
            return mode(Output.of(mode));
        }

        /**
         * @param years The number of years that you want to specify for the default retention period.
         * 
         * Either `days` or `years` must be specified, but not both.
         * 
         * &gt; **NOTE on `object_lock_configuration`:** You can only enable S3 Object Lock for new buckets. If you need to turn on S3 Object Lock for an existing bucket, please contact AWS Support.
         * When you create a bucket with S3 Object Lock enabled, Amazon S3 automatically enables versioning for the bucket.
         * Once you create a bucket with S3 Object Lock enabled, you can&#39;t disable Object Lock or suspend versioning for the bucket.
         * 
         * @return builder
         * 
         */
        public Builder years(@Nullable Output<Integer> years) {
            $.years = years;
            return this;
        }

        /**
         * @param years The number of years that you want to specify for the default retention period.
         * 
         * Either `days` or `years` must be specified, but not both.
         * 
         * &gt; **NOTE on `object_lock_configuration`:** You can only enable S3 Object Lock for new buckets. If you need to turn on S3 Object Lock for an existing bucket, please contact AWS Support.
         * When you create a bucket with S3 Object Lock enabled, Amazon S3 automatically enables versioning for the bucket.
         * Once you create a bucket with S3 Object Lock enabled, you can&#39;t disable Object Lock or suspend versioning for the bucket.
         * 
         * @return builder
         * 
         */
        public Builder years(Integer years) {
            return years(Output.of(years));
        }

        public BucketObjectLockConfigurationRuleDefaultRetentionArgs build() {
            $.mode = Objects.requireNonNull($.mode, "expected parameter 'mode' to be non-null");
            return $;
        }
    }

}
