// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs;
import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs;
import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RedirectAllRequestsToArgs;
import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketWebsiteConfigurationV2Args extends com.pulumi.resources.ResourceArgs {

    public static final BucketWebsiteConfigurationV2Args Empty = new BucketWebsiteConfigurationV2Args();

    /**
     * Name of the bucket.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return Name of the bucket.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * Name of the error document for the website. See below.
     * 
     */
    @Import(name="errorDocument")
    private @Nullable Output<BucketWebsiteConfigurationV2ErrorDocumentArgs> errorDocument;

    /**
     * @return Name of the error document for the website. See below.
     * 
     */
    public Optional<Output<BucketWebsiteConfigurationV2ErrorDocumentArgs>> errorDocument() {
        return Optional.ofNullable(this.errorDocument);
    }

    /**
     * Account ID of the expected bucket owner.
     * 
     */
    @Import(name="expectedBucketOwner")
    private @Nullable Output<String> expectedBucketOwner;

    /**
     * @return Account ID of the expected bucket owner.
     * 
     */
    public Optional<Output<String>> expectedBucketOwner() {
        return Optional.ofNullable(this.expectedBucketOwner);
    }

    /**
     * Name of the index document for the website. See below.
     * 
     */
    @Import(name="indexDocument")
    private @Nullable Output<BucketWebsiteConfigurationV2IndexDocumentArgs> indexDocument;

    /**
     * @return Name of the index document for the website. See below.
     * 
     */
    public Optional<Output<BucketWebsiteConfigurationV2IndexDocumentArgs>> indexDocument() {
        return Optional.ofNullable(this.indexDocument);
    }

    /**
     * Redirect behavior for every request to this bucket&#39;s website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
     * 
     */
    @Import(name="redirectAllRequestsTo")
    private @Nullable Output<BucketWebsiteConfigurationV2RedirectAllRequestsToArgs> redirectAllRequestsTo;

    /**
     * @return Redirect behavior for every request to this bucket&#39;s website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
     * 
     */
    public Optional<Output<BucketWebsiteConfigurationV2RedirectAllRequestsToArgs>> redirectAllRequestsTo() {
        return Optional.ofNullable(this.redirectAllRequestsTo);
    }

    /**
     * JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied. Use this parameter when your routing rules contain empty String values (`&#34;&#34;`) as seen in the example above.
     * 
     */
    @Import(name="routingRuleDetails")
    private @Nullable Output<String> routingRuleDetails;

    /**
     * @return JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied. Use this parameter when your routing rules contain empty String values (`&#34;&#34;`) as seen in the example above.
     * 
     */
    public Optional<Output<String>> routingRuleDetails() {
        return Optional.ofNullable(this.routingRuleDetails);
    }

    /**
     * List of rules that define when a redirect is applied and the redirect behavior. See below.
     * 
     */
    @Import(name="routingRules")
    private @Nullable Output<List<BucketWebsiteConfigurationV2RoutingRuleArgs>> routingRules;

    /**
     * @return List of rules that define when a redirect is applied and the redirect behavior. See below.
     * 
     */
    public Optional<Output<List<BucketWebsiteConfigurationV2RoutingRuleArgs>>> routingRules() {
        return Optional.ofNullable(this.routingRules);
    }

    private BucketWebsiteConfigurationV2Args() {}

    private BucketWebsiteConfigurationV2Args(BucketWebsiteConfigurationV2Args $) {
        this.bucket = $.bucket;
        this.errorDocument = $.errorDocument;
        this.expectedBucketOwner = $.expectedBucketOwner;
        this.indexDocument = $.indexDocument;
        this.redirectAllRequestsTo = $.redirectAllRequestsTo;
        this.routingRuleDetails = $.routingRuleDetails;
        this.routingRules = $.routingRules;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketWebsiteConfigurationV2Args defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketWebsiteConfigurationV2Args $;

        public Builder() {
            $ = new BucketWebsiteConfigurationV2Args();
        }

        public Builder(BucketWebsiteConfigurationV2Args defaults) {
            $ = new BucketWebsiteConfigurationV2Args(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucket Name of the bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket Name of the bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param errorDocument Name of the error document for the website. See below.
         * 
         * @return builder
         * 
         */
        public Builder errorDocument(@Nullable Output<BucketWebsiteConfigurationV2ErrorDocumentArgs> errorDocument) {
            $.errorDocument = errorDocument;
            return this;
        }

        /**
         * @param errorDocument Name of the error document for the website. See below.
         * 
         * @return builder
         * 
         */
        public Builder errorDocument(BucketWebsiteConfigurationV2ErrorDocumentArgs errorDocument) {
            return errorDocument(Output.of(errorDocument));
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(@Nullable Output<String> expectedBucketOwner) {
            $.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(String expectedBucketOwner) {
            return expectedBucketOwner(Output.of(expectedBucketOwner));
        }

        /**
         * @param indexDocument Name of the index document for the website. See below.
         * 
         * @return builder
         * 
         */
        public Builder indexDocument(@Nullable Output<BucketWebsiteConfigurationV2IndexDocumentArgs> indexDocument) {
            $.indexDocument = indexDocument;
            return this;
        }

        /**
         * @param indexDocument Name of the index document for the website. See below.
         * 
         * @return builder
         * 
         */
        public Builder indexDocument(BucketWebsiteConfigurationV2IndexDocumentArgs indexDocument) {
            return indexDocument(Output.of(indexDocument));
        }

        /**
         * @param redirectAllRequestsTo Redirect behavior for every request to this bucket&#39;s website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
         * 
         * @return builder
         * 
         */
        public Builder redirectAllRequestsTo(@Nullable Output<BucketWebsiteConfigurationV2RedirectAllRequestsToArgs> redirectAllRequestsTo) {
            $.redirectAllRequestsTo = redirectAllRequestsTo;
            return this;
        }

        /**
         * @param redirectAllRequestsTo Redirect behavior for every request to this bucket&#39;s website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
         * 
         * @return builder
         * 
         */
        public Builder redirectAllRequestsTo(BucketWebsiteConfigurationV2RedirectAllRequestsToArgs redirectAllRequestsTo) {
            return redirectAllRequestsTo(Output.of(redirectAllRequestsTo));
        }

        /**
         * @param routingRuleDetails JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
         * describing redirect behavior and when redirects are applied. Use this parameter when your routing rules contain empty String values (`&#34;&#34;`) as seen in the example above.
         * 
         * @return builder
         * 
         */
        public Builder routingRuleDetails(@Nullable Output<String> routingRuleDetails) {
            $.routingRuleDetails = routingRuleDetails;
            return this;
        }

        /**
         * @param routingRuleDetails JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
         * describing redirect behavior and when redirects are applied. Use this parameter when your routing rules contain empty String values (`&#34;&#34;`) as seen in the example above.
         * 
         * @return builder
         * 
         */
        public Builder routingRuleDetails(String routingRuleDetails) {
            return routingRuleDetails(Output.of(routingRuleDetails));
        }

        /**
         * @param routingRules List of rules that define when a redirect is applied and the redirect behavior. See below.
         * 
         * @return builder
         * 
         */
        public Builder routingRules(@Nullable Output<List<BucketWebsiteConfigurationV2RoutingRuleArgs>> routingRules) {
            $.routingRules = routingRules;
            return this;
        }

        /**
         * @param routingRules List of rules that define when a redirect is applied and the redirect behavior. See below.
         * 
         * @return builder
         * 
         */
        public Builder routingRules(List<BucketWebsiteConfigurationV2RoutingRuleArgs> routingRules) {
            return routingRules(Output.of(routingRules));
        }

        /**
         * @param routingRules List of rules that define when a redirect is applied and the redirect behavior. See below.
         * 
         * @return builder
         * 
         */
        public Builder routingRules(BucketWebsiteConfigurationV2RoutingRuleArgs... routingRules) {
            return routingRules(List.of(routingRules));
        }

        public BucketWebsiteConfigurationV2Args build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            return $;
        }
    }

}
