// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args;
import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2State;
import com.pulumi.aws.s3.outputs.BucketWebsiteConfigurationV2ErrorDocument;
import com.pulumi.aws.s3.outputs.BucketWebsiteConfigurationV2IndexDocument;
import com.pulumi.aws.s3.outputs.BucketWebsiteConfigurationV2RedirectAllRequestsTo;
import com.pulumi.aws.s3.outputs.BucketWebsiteConfigurationV2RoutingRule;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an S3 bucket website configuration resource. For more information, see [Hosting Websites on S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
 * 
 * ## Example Usage
 * ### With `routing_rule` configured
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleConditionArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleRedirectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new BucketWebsiteConfigurationV2(&#34;example&#34;, BucketWebsiteConfigurationV2Args.builder()        
 *             .bucket(aws_s3_bucket.example().id())
 *             .indexDocument(BucketWebsiteConfigurationV2IndexDocumentArgs.builder()
 *                 .suffix(&#34;index.html&#34;)
 *                 .build())
 *             .errorDocument(BucketWebsiteConfigurationV2ErrorDocumentArgs.builder()
 *                 .key(&#34;error.html&#34;)
 *                 .build())
 *             .routingRules(BucketWebsiteConfigurationV2RoutingRuleArgs.builder()
 *                 .condition(BucketWebsiteConfigurationV2RoutingRuleConditionArgs.builder()
 *                     .keyPrefixEquals(&#34;docs/&#34;)
 *                     .build())
 *                 .redirect(BucketWebsiteConfigurationV2RoutingRuleRedirectArgs.builder()
 *                     .replaceKeyPrefixWith(&#34;documents/&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### With `routing_rules` configured
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2;
 * import com.pulumi.aws.s3.BucketWebsiteConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2IndexDocumentArgs;
 * import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new BucketWebsiteConfigurationV2(&#34;example&#34;, BucketWebsiteConfigurationV2Args.builder()        
 *             .bucket(aws_s3_bucket.example().id())
 *             .indexDocument(BucketWebsiteConfigurationV2IndexDocumentArgs.builder()
 *                 .suffix(&#34;index.html&#34;)
 *                 .build())
 *             .errorDocument(BucketWebsiteConfigurationV2ErrorDocumentArgs.builder()
 *                 .key(&#34;error.html&#34;)
 *                 .build())
 *             .routingRuleDetails(&#34;&#34;&#34;
 * [{
 *     &#34;Condition&#34;: {
 *         &#34;KeyPrefixEquals&#34;: &#34;docs/&#34;
 *     },
 *     &#34;Redirect&#34;: {
 *         &#34;ReplaceKeyPrefixWith&#34;: &#34;&#34;
 *     }
 * }]
 *             &#34;&#34;&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * 
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * 
 * __Using `pulumi import` to import__ S3 bucket website configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * 
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * 
 * ```sh
 *  $ pulumi import aws:s3/bucketWebsiteConfigurationV2:BucketWebsiteConfigurationV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * 
 * ```sh
 *  $ pulumi import aws:s3/bucketWebsiteConfigurationV2:BucketWebsiteConfigurationV2 example bucket-name,123456789012
 * ```
 * 
 */
@ResourceType(type="aws:s3/bucketWebsiteConfigurationV2:BucketWebsiteConfigurationV2")
public class BucketWebsiteConfigurationV2 extends com.pulumi.resources.CustomResource {
    /**
     * Name of the bucket.
     * 
     */
    @Export(name="bucket", refs={String.class}, tree="[0]")
    private Output<String> bucket;

    /**
     * @return Name of the bucket.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }
    /**
     * Name of the error document for the website. See below.
     * 
     */
    @Export(name="errorDocument", refs={BucketWebsiteConfigurationV2ErrorDocument.class}, tree="[0]")
    private Output</* @Nullable */ BucketWebsiteConfigurationV2ErrorDocument> errorDocument;

    /**
     * @return Name of the error document for the website. See below.
     * 
     */
    public Output<Optional<BucketWebsiteConfigurationV2ErrorDocument>> errorDocument() {
        return Codegen.optional(this.errorDocument);
    }
    /**
     * Account ID of the expected bucket owner.
     * 
     */
    @Export(name="expectedBucketOwner", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> expectedBucketOwner;

    /**
     * @return Account ID of the expected bucket owner.
     * 
     */
    public Output<Optional<String>> expectedBucketOwner() {
        return Codegen.optional(this.expectedBucketOwner);
    }
    /**
     * Name of the index document for the website. See below.
     * 
     */
    @Export(name="indexDocument", refs={BucketWebsiteConfigurationV2IndexDocument.class}, tree="[0]")
    private Output</* @Nullable */ BucketWebsiteConfigurationV2IndexDocument> indexDocument;

    /**
     * @return Name of the index document for the website. See below.
     * 
     */
    public Output<Optional<BucketWebsiteConfigurationV2IndexDocument>> indexDocument() {
        return Codegen.optional(this.indexDocument);
    }
    /**
     * Redirect behavior for every request to this bucket&#39;s website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
     * 
     */
    @Export(name="redirectAllRequestsTo", refs={BucketWebsiteConfigurationV2RedirectAllRequestsTo.class}, tree="[0]")
    private Output</* @Nullable */ BucketWebsiteConfigurationV2RedirectAllRequestsTo> redirectAllRequestsTo;

    /**
     * @return Redirect behavior for every request to this bucket&#39;s website endpoint. See below. Conflicts with `error_document`, `index_document`, and `routing_rule`.
     * 
     */
    public Output<Optional<BucketWebsiteConfigurationV2RedirectAllRequestsTo>> redirectAllRequestsTo() {
        return Codegen.optional(this.redirectAllRequestsTo);
    }
    /**
     * JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied. Use this parameter when your routing rules contain empty String values (`&#34;&#34;`) as seen in the example above.
     * 
     */
    @Export(name="routingRuleDetails", refs={String.class}, tree="[0]")
    private Output<String> routingRuleDetails;

    /**
     * @return JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied. Use this parameter when your routing rules contain empty String values (`&#34;&#34;`) as seen in the example above.
     * 
     */
    public Output<String> routingRuleDetails() {
        return this.routingRuleDetails;
    }
    /**
     * List of rules that define when a redirect is applied and the redirect behavior. See below.
     * 
     */
    @Export(name="routingRules", refs={List.class,BucketWebsiteConfigurationV2RoutingRule.class}, tree="[0,1]")
    private Output<List<BucketWebsiteConfigurationV2RoutingRule>> routingRules;

    /**
     * @return List of rules that define when a redirect is applied and the redirect behavior. See below.
     * 
     */
    public Output<List<BucketWebsiteConfigurationV2RoutingRule>> routingRules() {
        return this.routingRules;
    }
    /**
     * Domain of the website endpoint. This is used to create Route 53 alias records.
     * 
     */
    @Export(name="websiteDomain", refs={String.class}, tree="[0]")
    private Output<String> websiteDomain;

    /**
     * @return Domain of the website endpoint. This is used to create Route 53 alias records.
     * 
     */
    public Output<String> websiteDomain() {
        return this.websiteDomain;
    }
    /**
     * Website endpoint.
     * 
     */
    @Export(name="websiteEndpoint", refs={String.class}, tree="[0]")
    private Output<String> websiteEndpoint;

    /**
     * @return Website endpoint.
     * 
     */
    public Output<String> websiteEndpoint() {
        return this.websiteEndpoint;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public BucketWebsiteConfigurationV2(String name) {
        this(name, BucketWebsiteConfigurationV2Args.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public BucketWebsiteConfigurationV2(String name, BucketWebsiteConfigurationV2Args args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public BucketWebsiteConfigurationV2(String name, BucketWebsiteConfigurationV2Args args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:s3/bucketWebsiteConfigurationV2:BucketWebsiteConfigurationV2", name, args == null ? BucketWebsiteConfigurationV2Args.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private BucketWebsiteConfigurationV2(String name, Output<String> id, @Nullable BucketWebsiteConfigurationV2State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:s3/bucketWebsiteConfigurationV2:BucketWebsiteConfigurationV2", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static BucketWebsiteConfigurationV2 get(String name, Output<String> id, @Nullable BucketWebsiteConfigurationV2State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new BucketWebsiteConfigurationV2(name, id, state, options);
    }
}
