// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketVersioningV2Args extends com.pulumi.resources.ResourceArgs {

    public static final BucketVersioningV2Args Empty = new BucketVersioningV2Args();

    /**
     * Name of the S3 bucket.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return Name of the S3 bucket.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * Account ID of the expected bucket owner.
     * 
     */
    @Import(name="expectedBucketOwner")
    private @Nullable Output<String> expectedBucketOwner;

    /**
     * @return Account ID of the expected bucket owner.
     * 
     */
    public Optional<Output<String>> expectedBucketOwner() {
        return Optional.ofNullable(this.expectedBucketOwner);
    }

    /**
     * Concatenation of the authentication device&#39;s serial number, a space, and the value that is displayed on your authentication device.
     * 
     */
    @Import(name="mfa")
    private @Nullable Output<String> mfa;

    /**
     * @return Concatenation of the authentication device&#39;s serial number, a space, and the value that is displayed on your authentication device.
     * 
     */
    public Optional<Output<String>> mfa() {
        return Optional.ofNullable(this.mfa);
    }

    /**
     * Configuration block for the versioning parameters. See below.
     * 
     */
    @Import(name="versioningConfiguration", required=true)
    private Output<BucketVersioningV2VersioningConfigurationArgs> versioningConfiguration;

    /**
     * @return Configuration block for the versioning parameters. See below.
     * 
     */
    public Output<BucketVersioningV2VersioningConfigurationArgs> versioningConfiguration() {
        return this.versioningConfiguration;
    }

    private BucketVersioningV2Args() {}

    private BucketVersioningV2Args(BucketVersioningV2Args $) {
        this.bucket = $.bucket;
        this.expectedBucketOwner = $.expectedBucketOwner;
        this.mfa = $.mfa;
        this.versioningConfiguration = $.versioningConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketVersioningV2Args defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketVersioningV2Args $;

        public Builder() {
            $ = new BucketVersioningV2Args();
        }

        public Builder(BucketVersioningV2Args defaults) {
            $ = new BucketVersioningV2Args(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucket Name of the S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket Name of the S3 bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(@Nullable Output<String> expectedBucketOwner) {
            $.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(String expectedBucketOwner) {
            return expectedBucketOwner(Output.of(expectedBucketOwner));
        }

        /**
         * @param mfa Concatenation of the authentication device&#39;s serial number, a space, and the value that is displayed on your authentication device.
         * 
         * @return builder
         * 
         */
        public Builder mfa(@Nullable Output<String> mfa) {
            $.mfa = mfa;
            return this;
        }

        /**
         * @param mfa Concatenation of the authentication device&#39;s serial number, a space, and the value that is displayed on your authentication device.
         * 
         * @return builder
         * 
         */
        public Builder mfa(String mfa) {
            return mfa(Output.of(mfa));
        }

        /**
         * @param versioningConfiguration Configuration block for the versioning parameters. See below.
         * 
         * @return builder
         * 
         */
        public Builder versioningConfiguration(Output<BucketVersioningV2VersioningConfigurationArgs> versioningConfiguration) {
            $.versioningConfiguration = versioningConfiguration;
            return this;
        }

        /**
         * @param versioningConfiguration Configuration block for the versioning parameters. See below.
         * 
         * @return builder
         * 
         */
        public Builder versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs versioningConfiguration) {
            return versioningConfiguration(Output.of(versioningConfiguration));
        }

        public BucketVersioningV2Args build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            $.versioningConfiguration = Objects.requireNonNull($.versioningConfiguration, "expected parameter 'versioningConfiguration' to be non-null");
            return $;
        }
    }

}
