// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.aws.s3.inputs.BucketServerSideEncryptionConfigurationV2RuleArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketServerSideEncryptionConfigurationV2Args extends com.pulumi.resources.ResourceArgs {

    public static final BucketServerSideEncryptionConfigurationV2Args Empty = new BucketServerSideEncryptionConfigurationV2Args();

    /**
     * ID (name) of the bucket.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return ID (name) of the bucket.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * Account ID of the expected bucket owner.
     * 
     */
    @Import(name="expectedBucketOwner")
    private @Nullable Output<String> expectedBucketOwner;

    /**
     * @return Account ID of the expected bucket owner.
     * 
     */
    public Optional<Output<String>> expectedBucketOwner() {
        return Optional.ofNullable(this.expectedBucketOwner);
    }

    /**
     * Set of server-side encryption configuration rules. See below. Currently, only a single rule is supported.
     * 
     */
    @Import(name="rules", required=true)
    private Output<List<BucketServerSideEncryptionConfigurationV2RuleArgs>> rules;

    /**
     * @return Set of server-side encryption configuration rules. See below. Currently, only a single rule is supported.
     * 
     */
    public Output<List<BucketServerSideEncryptionConfigurationV2RuleArgs>> rules() {
        return this.rules;
    }

    private BucketServerSideEncryptionConfigurationV2Args() {}

    private BucketServerSideEncryptionConfigurationV2Args(BucketServerSideEncryptionConfigurationV2Args $) {
        this.bucket = $.bucket;
        this.expectedBucketOwner = $.expectedBucketOwner;
        this.rules = $.rules;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketServerSideEncryptionConfigurationV2Args defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketServerSideEncryptionConfigurationV2Args $;

        public Builder() {
            $ = new BucketServerSideEncryptionConfigurationV2Args();
        }

        public Builder(BucketServerSideEncryptionConfigurationV2Args defaults) {
            $ = new BucketServerSideEncryptionConfigurationV2Args(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucket ID (name) of the bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket ID (name) of the bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(@Nullable Output<String> expectedBucketOwner) {
            $.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(String expectedBucketOwner) {
            return expectedBucketOwner(Output.of(expectedBucketOwner));
        }

        /**
         * @param rules Set of server-side encryption configuration rules. See below. Currently, only a single rule is supported.
         * 
         * @return builder
         * 
         */
        public Builder rules(Output<List<BucketServerSideEncryptionConfigurationV2RuleArgs>> rules) {
            $.rules = rules;
            return this;
        }

        /**
         * @param rules Set of server-side encryption configuration rules. See below. Currently, only a single rule is supported.
         * 
         * @return builder
         * 
         */
        public Builder rules(List<BucketServerSideEncryptionConfigurationV2RuleArgs> rules) {
            return rules(Output.of(rules));
        }

        /**
         * @param rules Set of server-side encryption configuration rules. See below. Currently, only a single rule is supported.
         * 
         * @return builder
         * 
         */
        public Builder rules(BucketServerSideEncryptionConfigurationV2RuleArgs... rules) {
            return rules(List.of(rules));
        }

        public BucketServerSideEncryptionConfigurationV2Args build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            $.rules = Objects.requireNonNull($.rules, "expected parameter 'rules' to be non-null");
            return $;
        }
    }

}
