// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketRequestPaymentConfigurationV2Args extends com.pulumi.resources.ResourceArgs {

    public static final BucketRequestPaymentConfigurationV2Args Empty = new BucketRequestPaymentConfigurationV2Args();

    /**
     * Name of the bucket.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return Name of the bucket.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * Account ID of the expected bucket owner.
     * 
     */
    @Import(name="expectedBucketOwner")
    private @Nullable Output<String> expectedBucketOwner;

    /**
     * @return Account ID of the expected bucket owner.
     * 
     */
    public Optional<Output<String>> expectedBucketOwner() {
        return Optional.ofNullable(this.expectedBucketOwner);
    }

    /**
     * Specifies who pays for the download and request fees. Valid values: `BucketOwner`, `Requester`.
     * 
     */
    @Import(name="payer", required=true)
    private Output<String> payer;

    /**
     * @return Specifies who pays for the download and request fees. Valid values: `BucketOwner`, `Requester`.
     * 
     */
    public Output<String> payer() {
        return this.payer;
    }

    private BucketRequestPaymentConfigurationV2Args() {}

    private BucketRequestPaymentConfigurationV2Args(BucketRequestPaymentConfigurationV2Args $) {
        this.bucket = $.bucket;
        this.expectedBucketOwner = $.expectedBucketOwner;
        this.payer = $.payer;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketRequestPaymentConfigurationV2Args defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketRequestPaymentConfigurationV2Args $;

        public Builder() {
            $ = new BucketRequestPaymentConfigurationV2Args();
        }

        public Builder(BucketRequestPaymentConfigurationV2Args defaults) {
            $ = new BucketRequestPaymentConfigurationV2Args(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucket Name of the bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket Name of the bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(@Nullable Output<String> expectedBucketOwner) {
            $.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(String expectedBucketOwner) {
            return expectedBucketOwner(Output.of(expectedBucketOwner));
        }

        /**
         * @param payer Specifies who pays for the download and request fees. Valid values: `BucketOwner`, `Requester`.
         * 
         * @return builder
         * 
         */
        public Builder payer(Output<String> payer) {
            $.payer = payer;
            return this;
        }

        /**
         * @param payer Specifies who pays for the download and request fees. Valid values: `BucketOwner`, `Requester`.
         * 
         * @return builder
         * 
         */
        public Builder payer(String payer) {
            return payer(Output.of(payer));
        }

        public BucketRequestPaymentConfigurationV2Args build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            $.payer = Objects.requireNonNull($.payer, "expected parameter 'payer' to be non-null");
            return $;
        }
    }

}
