// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketReplicationConfigArgs extends com.pulumi.resources.ResourceArgs {

    public static final BucketReplicationConfigArgs Empty = new BucketReplicationConfigArgs();

    /**
     * Name of the source S3 bucket you want Amazon S3 to monitor.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return Name of the source S3 bucket you want Amazon S3 to monitor.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     * 
     */
    @Import(name="role", required=true)
    private Output<String> role;

    /**
     * @return ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     * 
     */
    public Output<String> role() {
        return this.role;
    }

    /**
     * List of configuration blocks describing the rules managing the replication. See below.
     * 
     */
    @Import(name="rules", required=true)
    private Output<List<BucketReplicationConfigRuleArgs>> rules;

    /**
     * @return List of configuration blocks describing the rules managing the replication. See below.
     * 
     */
    public Output<List<BucketReplicationConfigRuleArgs>> rules() {
        return this.rules;
    }

    /**
     * Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket&#39;s &#34;Object Lock token&#34;.
     * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
     * 
     */
    @Import(name="token")
    private @Nullable Output<String> token;

    /**
     * @return Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket&#39;s &#34;Object Lock token&#34;.
     * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
     * 
     */
    public Optional<Output<String>> token() {
        return Optional.ofNullable(this.token);
    }

    private BucketReplicationConfigArgs() {}

    private BucketReplicationConfigArgs(BucketReplicationConfigArgs $) {
        this.bucket = $.bucket;
        this.role = $.role;
        this.rules = $.rules;
        this.token = $.token;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketReplicationConfigArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketReplicationConfigArgs $;

        public Builder() {
            $ = new BucketReplicationConfigArgs();
        }

        public Builder(BucketReplicationConfigArgs defaults) {
            $ = new BucketReplicationConfigArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucket Name of the source S3 bucket you want Amazon S3 to monitor.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket Name of the source S3 bucket you want Amazon S3 to monitor.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param role ARN of the IAM role for Amazon S3 to assume when replicating the objects.
         * 
         * @return builder
         * 
         */
        public Builder role(Output<String> role) {
            $.role = role;
            return this;
        }

        /**
         * @param role ARN of the IAM role for Amazon S3 to assume when replicating the objects.
         * 
         * @return builder
         * 
         */
        public Builder role(String role) {
            return role(Output.of(role));
        }

        /**
         * @param rules List of configuration blocks describing the rules managing the replication. See below.
         * 
         * @return builder
         * 
         */
        public Builder rules(Output<List<BucketReplicationConfigRuleArgs>> rules) {
            $.rules = rules;
            return this;
        }

        /**
         * @param rules List of configuration blocks describing the rules managing the replication. See below.
         * 
         * @return builder
         * 
         */
        public Builder rules(List<BucketReplicationConfigRuleArgs> rules) {
            return rules(Output.of(rules));
        }

        /**
         * @param rules List of configuration blocks describing the rules managing the replication. See below.
         * 
         * @return builder
         * 
         */
        public Builder rules(BucketReplicationConfigRuleArgs... rules) {
            return rules(List.of(rules));
        }

        /**
         * @param token Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket&#39;s &#34;Object Lock token&#34;.
         * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
         * 
         * @return builder
         * 
         */
        public Builder token(@Nullable Output<String> token) {
            $.token = token;
            return this;
        }

        /**
         * @param token Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket&#39;s &#34;Object Lock token&#34;.
         * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
         * 
         * @return builder
         * 
         */
        public Builder token(String token) {
            return token(Output.of(token));
        }

        public BucketReplicationConfigArgs build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            $.role = Objects.requireNonNull($.role, "expected parameter 'role' to be non-null");
            $.rules = Objects.requireNonNull($.rules, "expected parameter 'rules' to be non-null");
            return $;
        }
    }

}
