// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.s3.BucketReplicationConfigArgs;
import com.pulumi.aws.s3.inputs.BucketReplicationConfigState;
import com.pulumi.aws.s3.outputs.BucketReplicationConfigRule;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an independent configuration resource for S3 bucket [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html).
 * 
 * &gt; **NOTE:** S3 Buckets only support a single replication configuration. Declaring multiple `aws.s3.BucketReplicationConfig` resources to the same S3 Bucket will cause a perpetual difference in configuration.
 * 
 * ## Example Usage
 * ### Using replication configuration
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.s3.BucketReplicationConfig;
 * import com.pulumi.aws.s3.BucketReplicationConfigArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var central = new Provider(&#34;central&#34;, ProviderArgs.builder()        
 *             .region(&#34;eu-central-1&#34;)
 *             .build());
 * 
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect(&#34;Allow&#34;)
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type(&#34;Service&#34;)
 *                     .identifiers(&#34;s3.amazonaws.com&#34;)
 *                     .build())
 *                 .actions(&#34;sts:AssumeRole&#34;)
 *                 .build())
 *             .build());
 * 
 *         var replicationRole = new Role(&#34;replicationRole&#34;, RoleArgs.builder()        
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json()))
 *             .build());
 * 
 *         var destinationBucketV2 = new BucketV2(&#34;destinationBucketV2&#34;);
 * 
 *         var sourceBucketV2 = new BucketV2(&#34;sourceBucketV2&#34;, BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.central())
 *             .build());
 * 
 *         final var replicationPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(            
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect(&#34;Allow&#34;)
 *                     .actions(                    
 *                         &#34;s3:GetReplicationConfiguration&#34;,
 *                         &#34;s3:ListBucket&#34;)
 *                     .resources(sourceBucketV2.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect(&#34;Allow&#34;)
 *                     .actions(                    
 *                         &#34;s3:GetObjectVersionForReplication&#34;,
 *                         &#34;s3:GetObjectVersionAcl&#34;,
 *                         &#34;s3:GetObjectVersionTagging&#34;)
 *                     .resources(sourceBucketV2.arn().applyValue(arn -&gt; String.format(&#34;%s/*&#34;, arn)))
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect(&#34;Allow&#34;)
 *                     .actions(                    
 *                         &#34;s3:ReplicateObject&#34;,
 *                         &#34;s3:ReplicateDelete&#34;,
 *                         &#34;s3:ReplicateTags&#34;)
 *                     .resources(destinationBucketV2.arn().applyValue(arn -&gt; String.format(&#34;%s/*&#34;, arn)))
 *                     .build())
 *             .build());
 * 
 *         var replicationPolicy = new Policy(&#34;replicationPolicy&#34;, PolicyArgs.builder()        
 *             .policy(replicationPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult).applyValue(replicationPolicyDocument -&gt; replicationPolicyDocument.applyValue(getPolicyDocumentResult -&gt; getPolicyDocumentResult.json())))
 *             .build());
 * 
 *         var replicationRolePolicyAttachment = new RolePolicyAttachment(&#34;replicationRolePolicyAttachment&#34;, RolePolicyAttachmentArgs.builder()        
 *             .role(replicationRole.name())
 *             .policyArn(replicationPolicy.arn())
 *             .build());
 * 
 *         var destinationBucketVersioningV2 = new BucketVersioningV2(&#34;destinationBucketVersioningV2&#34;, BucketVersioningV2Args.builder()        
 *             .bucket(destinationBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status(&#34;Enabled&#34;)
 *                 .build())
 *             .build());
 * 
 *         var sourceBucketAcl = new BucketAclV2(&#34;sourceBucketAcl&#34;, BucketAclV2Args.builder()        
 *             .bucket(sourceBucketV2.id())
 *             .acl(&#34;private&#34;)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.central())
 *                 .build());
 * 
 *         var sourceBucketVersioningV2 = new BucketVersioningV2(&#34;sourceBucketVersioningV2&#34;, BucketVersioningV2Args.builder()        
 *             .bucket(sourceBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status(&#34;Enabled&#34;)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.central())
 *                 .build());
 * 
 *         var replicationBucketReplicationConfig = new BucketReplicationConfig(&#34;replicationBucketReplicationConfig&#34;, BucketReplicationConfigArgs.builder()        
 *             .role(replicationRole.arn())
 *             .bucket(sourceBucketV2.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id(&#34;foobar&#34;)
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix(&#34;foo&#34;)
 *                     .build())
 *                 .status(&#34;Enabled&#34;)
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(destinationBucketV2.arn())
 *                     .storageClass(&#34;STANDARD&#34;)
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.central())
 *                 .dependsOn(sourceBucketVersioningV2)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * ### Bi-Directional Replication
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketReplicationConfig;
 * import com.pulumi.aws.s3.BucketReplicationConfigArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleFilterArgs;
 * import com.pulumi.aws.s3.inputs.BucketReplicationConfigRuleDestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var eastBucketV2 = new BucketV2(&#34;eastBucketV2&#34;);
 * 
 *         var eastBucketVersioningV2 = new BucketVersioningV2(&#34;eastBucketVersioningV2&#34;, BucketVersioningV2Args.builder()        
 *             .bucket(eastBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status(&#34;Enabled&#34;)
 *                 .build())
 *             .build());
 * 
 *         var westBucketV2 = new BucketV2(&#34;westBucketV2&#34;, BucketV2Args.Empty, CustomResourceOptions.builder()
 *             .provider(aws.west())
 *             .build());
 * 
 *         var westBucketVersioningV2 = new BucketVersioningV2(&#34;westBucketVersioningV2&#34;, BucketVersioningV2Args.builder()        
 *             .bucket(westBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status(&#34;Enabled&#34;)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.west())
 *                 .build());
 * 
 *         var eastToWest = new BucketReplicationConfig(&#34;eastToWest&#34;, BucketReplicationConfigArgs.builder()        
 *             .role(aws_iam_role.east_replication().arn())
 *             .bucket(eastBucketV2.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id(&#34;foobar&#34;)
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix(&#34;foo&#34;)
 *                     .build())
 *                 .status(&#34;Enabled&#34;)
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(westBucketV2.arn())
 *                     .storageClass(&#34;STANDARD&#34;)
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(eastBucketVersioningV2)
 *                 .build());
 * 
 *         var westToEast = new BucketReplicationConfig(&#34;westToEast&#34;, BucketReplicationConfigArgs.builder()        
 *             .role(aws_iam_role.west_replication().arn())
 *             .bucket(westBucketV2.id())
 *             .rules(BucketReplicationConfigRuleArgs.builder()
 *                 .id(&#34;foobar&#34;)
 *                 .filter(BucketReplicationConfigRuleFilterArgs.builder()
 *                     .prefix(&#34;foo&#34;)
 *                     .build())
 *                 .status(&#34;Enabled&#34;)
 *                 .destination(BucketReplicationConfigRuleDestinationArgs.builder()
 *                     .bucket(eastBucketV2.arn())
 *                     .storageClass(&#34;STANDARD&#34;)
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.west())
 *                 .dependsOn(westBucketVersioningV2)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import S3 bucket replication configuration using the `bucket`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:s3/bucketReplicationConfig:BucketReplicationConfig replication bucket-name
 * ```
 * 
 */
@ResourceType(type="aws:s3/bucketReplicationConfig:BucketReplicationConfig")
public class BucketReplicationConfig extends com.pulumi.resources.CustomResource {
    /**
     * Name of the source S3 bucket you want Amazon S3 to monitor.
     * 
     */
    @Export(name="bucket", refs={String.class}, tree="[0]")
    private Output<String> bucket;

    /**
     * @return Name of the source S3 bucket you want Amazon S3 to monitor.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }
    /**
     * ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     * 
     */
    @Export(name="role", refs={String.class}, tree="[0]")
    private Output<String> role;

    /**
     * @return ARN of the IAM role for Amazon S3 to assume when replicating the objects.
     * 
     */
    public Output<String> role() {
        return this.role;
    }
    /**
     * List of configuration blocks describing the rules managing the replication. See below.
     * 
     */
    @Export(name="rules", refs={List.class,BucketReplicationConfigRule.class}, tree="[0,1]")
    private Output<List<BucketReplicationConfigRule>> rules;

    /**
     * @return List of configuration blocks describing the rules managing the replication. See below.
     * 
     */
    public Output<List<BucketReplicationConfigRule>> rules() {
        return this.rules;
    }
    /**
     * Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket&#39;s &#34;Object Lock token&#34;.
     * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
     * 
     */
    @Export(name="token", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> token;

    /**
     * @return Token to allow replication to be enabled on an Object Lock-enabled bucket. You must contact AWS support for the bucket&#39;s &#34;Object Lock token&#34;.
     * For more details, see [Using S3 Object Lock with replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-managing.html#object-lock-managing-replication).
     * 
     */
    public Output<Optional<String>> token() {
        return Codegen.optional(this.token);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public BucketReplicationConfig(String name) {
        this(name, BucketReplicationConfigArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public BucketReplicationConfig(String name, BucketReplicationConfigArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public BucketReplicationConfig(String name, BucketReplicationConfigArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:s3/bucketReplicationConfig:BucketReplicationConfig", name, args == null ? BucketReplicationConfigArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private BucketReplicationConfig(String name, Output<String> id, @Nullable BucketReplicationConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:s3/bucketReplicationConfig:BucketReplicationConfig", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "token"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static BucketReplicationConfig get(String name, Output<String> id, @Nullable BucketReplicationConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new BucketReplicationConfig(name, id, state, options);
    }
}
