// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketPublicAccessBlockArgs extends com.pulumi.resources.ResourceArgs {

    public static final BucketPublicAccessBlockArgs Empty = new BucketPublicAccessBlockArgs();

    /**
     * Whether Amazon S3 should block public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
     * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
     * * PUT Object calls will fail if the request includes an object ACL.
     * 
     */
    @Import(name="blockPublicAcls")
    private @Nullable Output<Boolean> blockPublicAcls;

    /**
     * @return Whether Amazon S3 should block public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
     * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
     * * PUT Object calls will fail if the request includes an object ACL.
     * 
     */
    public Optional<Output<Boolean>> blockPublicAcls() {
        return Optional.ofNullable(this.blockPublicAcls);
    }

    /**
     * Whether Amazon S3 should block public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the existing bucket policy. When set to `true` causes Amazon S3 to:
     * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
     * 
     */
    @Import(name="blockPublicPolicy")
    private @Nullable Output<Boolean> blockPublicPolicy;

    /**
     * @return Whether Amazon S3 should block public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the existing bucket policy. When set to `true` causes Amazon S3 to:
     * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
     * 
     */
    public Optional<Output<Boolean>> blockPublicPolicy() {
        return Optional.ofNullable(this.blockPublicPolicy);
    }

    /**
     * S3 Bucket to which this Public Access Block configuration should be applied.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return S3 Bucket to which this Public Access Block configuration should be applied.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * Whether Amazon S3 should ignore public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn&#39;t prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
     * * Ignore public ACLs on this bucket and any objects that it contains.
     * 
     */
    @Import(name="ignorePublicAcls")
    private @Nullable Output<Boolean> ignorePublicAcls;

    /**
     * @return Whether Amazon S3 should ignore public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn&#39;t prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
     * * Ignore public ACLs on this bucket and any objects that it contains.
     * 
     */
    public Optional<Output<Boolean>> ignorePublicAcls() {
        return Optional.ofNullable(this.ignorePublicAcls);
    }

    /**
     * Whether Amazon S3 should restrict public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the previously stored bucket policy, except that public and cross-account access within the public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
     * * Only the bucket owner and AWS Services can access this buckets if it has a public policy.
     * 
     */
    @Import(name="restrictPublicBuckets")
    private @Nullable Output<Boolean> restrictPublicBuckets;

    /**
     * @return Whether Amazon S3 should restrict public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the previously stored bucket policy, except that public and cross-account access within the public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
     * * Only the bucket owner and AWS Services can access this buckets if it has a public policy.
     * 
     */
    public Optional<Output<Boolean>> restrictPublicBuckets() {
        return Optional.ofNullable(this.restrictPublicBuckets);
    }

    private BucketPublicAccessBlockArgs() {}

    private BucketPublicAccessBlockArgs(BucketPublicAccessBlockArgs $) {
        this.blockPublicAcls = $.blockPublicAcls;
        this.blockPublicPolicy = $.blockPublicPolicy;
        this.bucket = $.bucket;
        this.ignorePublicAcls = $.ignorePublicAcls;
        this.restrictPublicBuckets = $.restrictPublicBuckets;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketPublicAccessBlockArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketPublicAccessBlockArgs $;

        public Builder() {
            $ = new BucketPublicAccessBlockArgs();
        }

        public Builder(BucketPublicAccessBlockArgs defaults) {
            $ = new BucketPublicAccessBlockArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param blockPublicAcls Whether Amazon S3 should block public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
         * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
         * * PUT Object calls will fail if the request includes an object ACL.
         * 
         * @return builder
         * 
         */
        public Builder blockPublicAcls(@Nullable Output<Boolean> blockPublicAcls) {
            $.blockPublicAcls = blockPublicAcls;
            return this;
        }

        /**
         * @param blockPublicAcls Whether Amazon S3 should block public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
         * * PUT Bucket acl and PUT Object acl calls will fail if the specified ACL allows public access.
         * * PUT Object calls will fail if the request includes an object ACL.
         * 
         * @return builder
         * 
         */
        public Builder blockPublicAcls(Boolean blockPublicAcls) {
            return blockPublicAcls(Output.of(blockPublicAcls));
        }

        /**
         * @param blockPublicPolicy Whether Amazon S3 should block public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the existing bucket policy. When set to `true` causes Amazon S3 to:
         * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
         * 
         * @return builder
         * 
         */
        public Builder blockPublicPolicy(@Nullable Output<Boolean> blockPublicPolicy) {
            $.blockPublicPolicy = blockPublicPolicy;
            return this;
        }

        /**
         * @param blockPublicPolicy Whether Amazon S3 should block public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the existing bucket policy. When set to `true` causes Amazon S3 to:
         * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
         * 
         * @return builder
         * 
         */
        public Builder blockPublicPolicy(Boolean blockPublicPolicy) {
            return blockPublicPolicy(Output.of(blockPublicPolicy));
        }

        /**
         * @param bucket S3 Bucket to which this Public Access Block configuration should be applied.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket S3 Bucket to which this Public Access Block configuration should be applied.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param ignorePublicAcls Whether Amazon S3 should ignore public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn&#39;t prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
         * * Ignore public ACLs on this bucket and any objects that it contains.
         * 
         * @return builder
         * 
         */
        public Builder ignorePublicAcls(@Nullable Output<Boolean> ignorePublicAcls) {
            $.ignorePublicAcls = ignorePublicAcls;
            return this;
        }

        /**
         * @param ignorePublicAcls Whether Amazon S3 should ignore public ACLs for this bucket. Defaults to `false`. Enabling this setting does not affect the persistence of any existing ACLs and doesn&#39;t prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
         * * Ignore public ACLs on this bucket and any objects that it contains.
         * 
         * @return builder
         * 
         */
        public Builder ignorePublicAcls(Boolean ignorePublicAcls) {
            return ignorePublicAcls(Output.of(ignorePublicAcls));
        }

        /**
         * @param restrictPublicBuckets Whether Amazon S3 should restrict public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the previously stored bucket policy, except that public and cross-account access within the public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
         * * Only the bucket owner and AWS Services can access this buckets if it has a public policy.
         * 
         * @return builder
         * 
         */
        public Builder restrictPublicBuckets(@Nullable Output<Boolean> restrictPublicBuckets) {
            $.restrictPublicBuckets = restrictPublicBuckets;
            return this;
        }

        /**
         * @param restrictPublicBuckets Whether Amazon S3 should restrict public bucket policies for this bucket. Defaults to `false`. Enabling this setting does not affect the previously stored bucket policy, except that public and cross-account access within the public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
         * * Only the bucket owner and AWS Services can access this buckets if it has a public policy.
         * 
         * @return builder
         * 
         */
        public Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
            return restrictPublicBuckets(Output.of(restrictPublicBuckets));
        }

        public BucketPublicAccessBlockArgs build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            return $;
        }
    }

}
