// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.s3.BucketObjectLockConfigurationV2Args;
import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2State;
import com.pulumi.aws.s3.outputs.BucketObjectLockConfigurationV2Rule;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides an S3 bucket Object Lock configuration resource. For more information about Object Locking, go to [Using S3 Object Lock](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html) in the Amazon S3 User Guide.
 * 
 * &gt; **NOTE:** This resource **does not enable** Object Lock for **new** buckets. It configures a default retention period for objects placed in the specified bucket.
 * Thus, to **enable** Object Lock for a **new** bucket, see the Using object lock configuration section in  the `aws.s3.BucketV2` resource or the Object Lock configuration for a new bucket example below.
 * If you want to **enable** Object Lock for an **existing** bucket, contact AWS Support and see the Object Lock configuration for an existing bucket example below.
 * 
 * ## Example Usage
 * ### Object Lock configuration for a new bucket
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectLockConfigurationV2;
 * import com.pulumi.aws.s3.BucketObjectLockConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleDefaultRetentionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2(&#34;exampleBucketV2&#34;, BucketV2Args.builder()        
 *             .objectLockEnabled(true)
 *             .build());
 * 
 *         var exampleBucketObjectLockConfigurationV2 = new BucketObjectLockConfigurationV2(&#34;exampleBucketObjectLockConfigurationV2&#34;, BucketObjectLockConfigurationV2Args.builder()        
 *             .bucket(exampleBucketV2.id())
 *             .rule(BucketObjectLockConfigurationV2RuleArgs.builder()
 *                 .defaultRetention(BucketObjectLockConfigurationV2RuleDefaultRetentionArgs.builder()
 *                     .mode(&#34;COMPLIANCE&#34;)
 *                     .days(5)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Object Lock configuration for an existing bucket
 * 
 * This is a multistep process that requires AWS Support intervention.
 * 
 * 1. Enable versioning on your S3 bucket, if you have not already done so.
 *    Doing so will generate an &#34;Object Lock token&#34; in the back-end.
 * 
 * &lt;!-- markdownlint-disable MD029 --&gt;
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketVersioningV2;
 * import com.pulumi.aws.s3.BucketVersioningV2Args;
 * import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2(&#34;exampleBucketV2&#34;);
 * 
 *         var exampleBucketVersioningV2 = new BucketVersioningV2(&#34;exampleBucketVersioningV2&#34;, BucketVersioningV2Args.builder()        
 *             .bucket(exampleBucketV2.id())
 *             .versioningConfiguration(BucketVersioningV2VersioningConfigurationArgs.builder()
 *                 .status(&#34;Enabled&#34;)
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * &lt;!-- markdownlint-disable MD029 --&gt;
 * 
 * 2. Contact AWS Support to provide you with the &#34;Object Lock token&#34; for the specified bucket and use the token (or token ID) within your new `aws.s3.BucketObjectLockConfigurationV2` resource.
 *    Notice the `object_lock_enabled` argument does not need to be specified as it defaults to `Enabled`.
 * 
 * &lt;!-- markdownlint-disable MD029 --&gt;
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketObjectLockConfigurationV2;
 * import com.pulumi.aws.s3.BucketObjectLockConfigurationV2Args;
 * import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleArgs;
 * import com.pulumi.aws.s3.inputs.BucketObjectLockConfigurationV2RuleDefaultRetentionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new BucketObjectLockConfigurationV2(&#34;example&#34;, BucketObjectLockConfigurationV2Args.builder()        
 *             .bucket(aws_s3_bucket.example().id())
 *             .rule(BucketObjectLockConfigurationV2RuleArgs.builder()
 *                 .defaultRetention(BucketObjectLockConfigurationV2RuleDefaultRetentionArgs.builder()
 *                     .mode(&#34;COMPLIANCE&#34;)
 *                     .days(5)
 *                     .build())
 *                 .build())
 *             .token(&#34;NG2MKsfoLqV3A+aquXneSG4LOu/ekrlXkRXwIPFVfERT7XOPos+/k444d7RIH0E3W3p5QU6ml2exS2F/eYCFmMWHJ3hFZGk6al1sIJkmNhUMYmsv0jYVQyTTZNLM+DnfooA6SATt39mM1VW1yJh4E+XljMlWzaBwHKbss3/EjlGDjOmVhaSs4Z6427mMCaFD0RLwsYY7zX49gEc31YfOMJGxbXCXSeyNwAhhM/A8UH7gQf38RmjHjjAFbbbLtl8arsxTPW8F1IYohqwmKIr9DnotLLj8Tg44U2SPwujVaqmlKKP9s41rfgb4UbIm7khSafDBng0LGfxC4pMlT9Ny2w==&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * &lt;!-- markdownlint-disable MD029 --&gt;
 * 
 * ## Import
 * 
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * 
 * If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * 
 * import {
 * 
 *  to = aws_s3_bucket_object_lock_configuration.example
 * 
 *  id = &#34;bucket-name,123456789012&#34; }
 * 
 * __Using `pulumi import` to import__ S3 bucket Object Lock configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:
 * 
 * If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:
 * 
 * ```sh
 *  $ pulumi import aws:s3/bucketObjectLockConfigurationV2:BucketObjectLockConfigurationV2 example bucket-name
 * ```
 *  If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):
 * 
 * ```sh
 *  $ pulumi import aws:s3/bucketObjectLockConfigurationV2:BucketObjectLockConfigurationV2 example bucket-name,123456789012
 * ```
 * 
 */
@ResourceType(type="aws:s3/bucketObjectLockConfigurationV2:BucketObjectLockConfigurationV2")
public class BucketObjectLockConfigurationV2 extends com.pulumi.resources.CustomResource {
    /**
     * Name of the bucket.
     * 
     */
    @Export(name="bucket", refs={String.class}, tree="[0]")
    private Output<String> bucket;

    /**
     * @return Name of the bucket.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }
    /**
     * Account ID of the expected bucket owner.
     * 
     */
    @Export(name="expectedBucketOwner", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> expectedBucketOwner;

    /**
     * @return Account ID of the expected bucket owner.
     * 
     */
    public Output<Optional<String>> expectedBucketOwner() {
        return Codegen.optional(this.expectedBucketOwner);
    }
    /**
     * Indicates whether this bucket has an Object Lock configuration enabled. Defaults to `Enabled`. Valid values: `Enabled`.
     * 
     */
    @Export(name="objectLockEnabled", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> objectLockEnabled;

    /**
     * @return Indicates whether this bucket has an Object Lock configuration enabled. Defaults to `Enabled`. Valid values: `Enabled`.
     * 
     */
    public Output<Optional<String>> objectLockEnabled() {
        return Codegen.optional(this.objectLockEnabled);
    }
    /**
     * Configuration block for specifying the Object Lock rule for the specified object. See below.
     * 
     */
    @Export(name="rule", refs={BucketObjectLockConfigurationV2Rule.class}, tree="[0]")
    private Output</* @Nullable */ BucketObjectLockConfigurationV2Rule> rule;

    /**
     * @return Configuration block for specifying the Object Lock rule for the specified object. See below.
     * 
     */
    public Output<Optional<BucketObjectLockConfigurationV2Rule>> rule() {
        return Codegen.optional(this.rule);
    }
    /**
     * Token to allow Object Lock to be enabled for an existing bucket. You must contact AWS support for the bucket&#39;s &#34;Object Lock token&#34;.
     * The token is generated in the back-end when [versioning](https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html) is enabled on a bucket. For more details on versioning, see the `aws.s3.BucketVersioningV2` resource.
     * 
     */
    @Export(name="token", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> token;

    /**
     * @return Token to allow Object Lock to be enabled for an existing bucket. You must contact AWS support for the bucket&#39;s &#34;Object Lock token&#34;.
     * The token is generated in the back-end when [versioning](https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html) is enabled on a bucket. For more details on versioning, see the `aws.s3.BucketVersioningV2` resource.
     * 
     */
    public Output<Optional<String>> token() {
        return Codegen.optional(this.token);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public BucketObjectLockConfigurationV2(String name) {
        this(name, BucketObjectLockConfigurationV2Args.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public BucketObjectLockConfigurationV2(String name, BucketObjectLockConfigurationV2Args args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public BucketObjectLockConfigurationV2(String name, BucketObjectLockConfigurationV2Args args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:s3/bucketObjectLockConfigurationV2:BucketObjectLockConfigurationV2", name, args == null ? BucketObjectLockConfigurationV2Args.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private BucketObjectLockConfigurationV2(String name, Output<String> id, @Nullable BucketObjectLockConfigurationV2State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:s3/bucketObjectLockConfigurationV2:BucketObjectLockConfigurationV2", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "token"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static BucketObjectLockConfigurationV2 get(String name, Output<String> id, @Nullable BucketObjectLockConfigurationV2State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new BucketObjectLockConfigurationV2(name, id, state, options);
    }
}
