// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.aws.s3.inputs.BucketLoggingV2TargetGrantArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketLoggingV2Args extends com.pulumi.resources.ResourceArgs {

    public static final BucketLoggingV2Args Empty = new BucketLoggingV2Args();

    /**
     * Name of the bucket.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return Name of the bucket.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * Account ID of the expected bucket owner.
     * 
     */
    @Import(name="expectedBucketOwner")
    private @Nullable Output<String> expectedBucketOwner;

    /**
     * @return Account ID of the expected bucket owner.
     * 
     */
    public Optional<Output<String>> expectedBucketOwner() {
        return Optional.ofNullable(this.expectedBucketOwner);
    }

    /**
     * Name of the bucket where you want Amazon S3 to store server access logs.
     * 
     */
    @Import(name="targetBucket", required=true)
    private Output<String> targetBucket;

    /**
     * @return Name of the bucket where you want Amazon S3 to store server access logs.
     * 
     */
    public Output<String> targetBucket() {
        return this.targetBucket;
    }

    /**
     * Set of configuration blocks with information for granting permissions. See below.
     * 
     */
    @Import(name="targetGrants")
    private @Nullable Output<List<BucketLoggingV2TargetGrantArgs>> targetGrants;

    /**
     * @return Set of configuration blocks with information for granting permissions. See below.
     * 
     */
    public Optional<Output<List<BucketLoggingV2TargetGrantArgs>>> targetGrants() {
        return Optional.ofNullable(this.targetGrants);
    }

    /**
     * Prefix for all log object keys.
     * 
     */
    @Import(name="targetPrefix", required=true)
    private Output<String> targetPrefix;

    /**
     * @return Prefix for all log object keys.
     * 
     */
    public Output<String> targetPrefix() {
        return this.targetPrefix;
    }

    private BucketLoggingV2Args() {}

    private BucketLoggingV2Args(BucketLoggingV2Args $) {
        this.bucket = $.bucket;
        this.expectedBucketOwner = $.expectedBucketOwner;
        this.targetBucket = $.targetBucket;
        this.targetGrants = $.targetGrants;
        this.targetPrefix = $.targetPrefix;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketLoggingV2Args defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketLoggingV2Args $;

        public Builder() {
            $ = new BucketLoggingV2Args();
        }

        public Builder(BucketLoggingV2Args defaults) {
            $ = new BucketLoggingV2Args(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucket Name of the bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket Name of the bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(@Nullable Output<String> expectedBucketOwner) {
            $.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(String expectedBucketOwner) {
            return expectedBucketOwner(Output.of(expectedBucketOwner));
        }

        /**
         * @param targetBucket Name of the bucket where you want Amazon S3 to store server access logs.
         * 
         * @return builder
         * 
         */
        public Builder targetBucket(Output<String> targetBucket) {
            $.targetBucket = targetBucket;
            return this;
        }

        /**
         * @param targetBucket Name of the bucket where you want Amazon S3 to store server access logs.
         * 
         * @return builder
         * 
         */
        public Builder targetBucket(String targetBucket) {
            return targetBucket(Output.of(targetBucket));
        }

        /**
         * @param targetGrants Set of configuration blocks with information for granting permissions. See below.
         * 
         * @return builder
         * 
         */
        public Builder targetGrants(@Nullable Output<List<BucketLoggingV2TargetGrantArgs>> targetGrants) {
            $.targetGrants = targetGrants;
            return this;
        }

        /**
         * @param targetGrants Set of configuration blocks with information for granting permissions. See below.
         * 
         * @return builder
         * 
         */
        public Builder targetGrants(List<BucketLoggingV2TargetGrantArgs> targetGrants) {
            return targetGrants(Output.of(targetGrants));
        }

        /**
         * @param targetGrants Set of configuration blocks with information for granting permissions. See below.
         * 
         * @return builder
         * 
         */
        public Builder targetGrants(BucketLoggingV2TargetGrantArgs... targetGrants) {
            return targetGrants(List.of(targetGrants));
        }

        /**
         * @param targetPrefix Prefix for all log object keys.
         * 
         * @return builder
         * 
         */
        public Builder targetPrefix(Output<String> targetPrefix) {
            $.targetPrefix = targetPrefix;
            return this;
        }

        /**
         * @param targetPrefix Prefix for all log object keys.
         * 
         * @return builder
         * 
         */
        public Builder targetPrefix(String targetPrefix) {
            return targetPrefix(Output.of(targetPrefix));
        }

        public BucketLoggingV2Args build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            $.targetBucket = Objects.requireNonNull($.targetBucket, "expected parameter 'targetBucket' to be non-null");
            $.targetPrefix = Objects.requireNonNull($.targetPrefix, "expected parameter 'targetPrefix' to be non-null");
            return $;
        }
    }

}
