// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.s3;

import com.pulumi.aws.s3.inputs.BucketCorsConfigurationV2CorsRuleArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class BucketCorsConfigurationV2Args extends com.pulumi.resources.ResourceArgs {

    public static final BucketCorsConfigurationV2Args Empty = new BucketCorsConfigurationV2Args();

    /**
     * Name of the bucket.
     * 
     */
    @Import(name="bucket", required=true)
    private Output<String> bucket;

    /**
     * @return Name of the bucket.
     * 
     */
    public Output<String> bucket() {
        return this.bucket;
    }

    /**
     * Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
     * 
     */
    @Import(name="corsRules", required=true)
    private Output<List<BucketCorsConfigurationV2CorsRuleArgs>> corsRules;

    /**
     * @return Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
     * 
     */
    public Output<List<BucketCorsConfigurationV2CorsRuleArgs>> corsRules() {
        return this.corsRules;
    }

    /**
     * Account ID of the expected bucket owner.
     * 
     */
    @Import(name="expectedBucketOwner")
    private @Nullable Output<String> expectedBucketOwner;

    /**
     * @return Account ID of the expected bucket owner.
     * 
     */
    public Optional<Output<String>> expectedBucketOwner() {
        return Optional.ofNullable(this.expectedBucketOwner);
    }

    private BucketCorsConfigurationV2Args() {}

    private BucketCorsConfigurationV2Args(BucketCorsConfigurationV2Args $) {
        this.bucket = $.bucket;
        this.corsRules = $.corsRules;
        this.expectedBucketOwner = $.expectedBucketOwner;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(BucketCorsConfigurationV2Args defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketCorsConfigurationV2Args $;

        public Builder() {
            $ = new BucketCorsConfigurationV2Args();
        }

        public Builder(BucketCorsConfigurationV2Args defaults) {
            $ = new BucketCorsConfigurationV2Args(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucket Name of the bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(Output<String> bucket) {
            $.bucket = bucket;
            return this;
        }

        /**
         * @param bucket Name of the bucket.
         * 
         * @return builder
         * 
         */
        public Builder bucket(String bucket) {
            return bucket(Output.of(bucket));
        }

        /**
         * @param corsRules Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
         * 
         * @return builder
         * 
         */
        public Builder corsRules(Output<List<BucketCorsConfigurationV2CorsRuleArgs>> corsRules) {
            $.corsRules = corsRules;
            return this;
        }

        /**
         * @param corsRules Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
         * 
         * @return builder
         * 
         */
        public Builder corsRules(List<BucketCorsConfigurationV2CorsRuleArgs> corsRules) {
            return corsRules(Output.of(corsRules));
        }

        /**
         * @param corsRules Set of origins and methods (cross-origin access that you want to allow). See below. You can configure up to 100 rules.
         * 
         * @return builder
         * 
         */
        public Builder corsRules(BucketCorsConfigurationV2CorsRuleArgs... corsRules) {
            return corsRules(List.of(corsRules));
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(@Nullable Output<String> expectedBucketOwner) {
            $.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        /**
         * @param expectedBucketOwner Account ID of the expected bucket owner.
         * 
         * @return builder
         * 
         */
        public Builder expectedBucketOwner(String expectedBucketOwner) {
            return expectedBucketOwner(Output.of(expectedBucketOwner));
        }

        public BucketCorsConfigurationV2Args build() {
            $.bucket = Objects.requireNonNull($.bucket, "expected parameter 'bucket' to be non-null");
            $.corsRules = Objects.requireNonNull($.corsRules, "expected parameter 'corsRules' to be non-null");
            return $;
        }
    }

}
