// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rum.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class AppMonitorAppMonitorConfiguration {
    /**
     * @return If you set this to `true`, RUM web client sets two cookies, a session cookie  and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
     * 
     */
    private @Nullable Boolean allowCookies;
    /**
     * @return If you set this to `true`, RUM enables X-Ray tracing for the user sessions  that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
     * 
     */
    private @Nullable Boolean enableXray;
    /**
     * @return A list of URLs in your website or application to exclude from RUM data collection.
     * 
     */
    private @Nullable List<String> excludedPages;
    /**
     * @return A list of pages in the CloudWatch RUM console that are to be displayed with a &#34;favorite&#34; icon.
     * 
     */
    private @Nullable List<String> favoritePages;
    /**
     * @return The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
     * 
     */
    private @Nullable String guestRoleArn;
    /**
     * @return The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
     * 
     */
    private @Nullable String identityPoolId;
    /**
     * @return If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
     * 
     */
    private @Nullable List<String> includedPages;
    /**
     * @return Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. Default value is `0.1`.
     * 
     */
    private @Nullable Double sessionSampleRate;
    /**
     * @return An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
     * 
     */
    private @Nullable List<String> telemetries;

    private AppMonitorAppMonitorConfiguration() {}
    /**
     * @return If you set this to `true`, RUM web client sets two cookies, a session cookie  and a user cookie. The cookies allow the RUM web client to collect data relating to the number of users an application has and the behavior of the application across a sequence of events. Cookies are stored in the top-level domain of the current page.
     * 
     */
    public Optional<Boolean> allowCookies() {
        return Optional.ofNullable(this.allowCookies);
    }
    /**
     * @return If you set this to `true`, RUM enables X-Ray tracing for the user sessions  that RUM samples. RUM adds an X-Ray trace header to allowed HTTP requests. It also records an X-Ray segment for allowed HTTP requests.
     * 
     */
    public Optional<Boolean> enableXray() {
        return Optional.ofNullable(this.enableXray);
    }
    /**
     * @return A list of URLs in your website or application to exclude from RUM data collection.
     * 
     */
    public List<String> excludedPages() {
        return this.excludedPages == null ? List.of() : this.excludedPages;
    }
    /**
     * @return A list of pages in the CloudWatch RUM console that are to be displayed with a &#34;favorite&#34; icon.
     * 
     */
    public List<String> favoritePages() {
        return this.favoritePages == null ? List.of() : this.favoritePages;
    }
    /**
     * @return The ARN of the guest IAM role that is attached to the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
     * 
     */
    public Optional<String> guestRoleArn() {
        return Optional.ofNullable(this.guestRoleArn);
    }
    /**
     * @return The ID of the Amazon Cognito identity pool that is used to authorize the sending of data to RUM.
     * 
     */
    public Optional<String> identityPoolId() {
        return Optional.ofNullable(this.identityPoolId);
    }
    /**
     * @return If this app monitor is to collect data from only certain pages in your application, this structure lists those pages.
     * 
     */
    public List<String> includedPages() {
        return this.includedPages == null ? List.of() : this.includedPages;
    }
    /**
     * @return Specifies the percentage of user sessions to use for RUM data collection. Choosing a higher percentage gives you more data but also incurs more costs. The number you specify is the percentage of user sessions that will be used. Default value is `0.1`.
     * 
     */
    public Optional<Double> sessionSampleRate() {
        return Optional.ofNullable(this.sessionSampleRate);
    }
    /**
     * @return An array that lists the types of telemetry data that this app monitor is to collect. Valid values are `errors`, `performance`, and `http`.
     * 
     */
    public List<String> telemetries() {
        return this.telemetries == null ? List.of() : this.telemetries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AppMonitorAppMonitorConfiguration defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Boolean allowCookies;
        private @Nullable Boolean enableXray;
        private @Nullable List<String> excludedPages;
        private @Nullable List<String> favoritePages;
        private @Nullable String guestRoleArn;
        private @Nullable String identityPoolId;
        private @Nullable List<String> includedPages;
        private @Nullable Double sessionSampleRate;
        private @Nullable List<String> telemetries;
        public Builder() {}
        public Builder(AppMonitorAppMonitorConfiguration defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.allowCookies = defaults.allowCookies;
    	      this.enableXray = defaults.enableXray;
    	      this.excludedPages = defaults.excludedPages;
    	      this.favoritePages = defaults.favoritePages;
    	      this.guestRoleArn = defaults.guestRoleArn;
    	      this.identityPoolId = defaults.identityPoolId;
    	      this.includedPages = defaults.includedPages;
    	      this.sessionSampleRate = defaults.sessionSampleRate;
    	      this.telemetries = defaults.telemetries;
        }

        @CustomType.Setter
        public Builder allowCookies(@Nullable Boolean allowCookies) {
            this.allowCookies = allowCookies;
            return this;
        }
        @CustomType.Setter
        public Builder enableXray(@Nullable Boolean enableXray) {
            this.enableXray = enableXray;
            return this;
        }
        @CustomType.Setter
        public Builder excludedPages(@Nullable List<String> excludedPages) {
            this.excludedPages = excludedPages;
            return this;
        }
        public Builder excludedPages(String... excludedPages) {
            return excludedPages(List.of(excludedPages));
        }
        @CustomType.Setter
        public Builder favoritePages(@Nullable List<String> favoritePages) {
            this.favoritePages = favoritePages;
            return this;
        }
        public Builder favoritePages(String... favoritePages) {
            return favoritePages(List.of(favoritePages));
        }
        @CustomType.Setter
        public Builder guestRoleArn(@Nullable String guestRoleArn) {
            this.guestRoleArn = guestRoleArn;
            return this;
        }
        @CustomType.Setter
        public Builder identityPoolId(@Nullable String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }
        @CustomType.Setter
        public Builder includedPages(@Nullable List<String> includedPages) {
            this.includedPages = includedPages;
            return this;
        }
        public Builder includedPages(String... includedPages) {
            return includedPages(List.of(includedPages));
        }
        @CustomType.Setter
        public Builder sessionSampleRate(@Nullable Double sessionSampleRate) {
            this.sessionSampleRate = sessionSampleRate;
            return this;
        }
        @CustomType.Setter
        public Builder telemetries(@Nullable List<String> telemetries) {
            this.telemetries = telemetries;
            return this;
        }
        public Builder telemetries(String... telemetries) {
            return telemetries(List.of(telemetries));
        }
        public AppMonitorAppMonitorConfiguration build() {
            final var o = new AppMonitorAppMonitorConfiguration();
            o.allowCookies = allowCookies;
            o.enableXray = enableXray;
            o.excludedPages = excludedPages;
            o.favoritePages = favoritePages;
            o.guestRoleArn = guestRoleArn;
            o.identityPoolId = identityPoolId;
            o.includedPages = includedPages;
            o.sessionSampleRate = sessionSampleRate;
            o.telemetries = telemetries;
            return o;
        }
    }
}
