// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rum.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class MetricsDestinationState extends com.pulumi.resources.ResourceArgs {

    public static final MetricsDestinationState Empty = new MetricsDestinationState();

    /**
     * The name of the CloudWatch RUM app monitor that will send the metrics.
     * 
     */
    @Import(name="appMonitorName")
    private @Nullable Output<String> appMonitorName;

    /**
     * @return The name of the CloudWatch RUM app monitor that will send the metrics.
     * 
     */
    public Optional<Output<String>> appMonitorName() {
        return Optional.ofNullable(this.appMonitorName);
    }

    /**
     * Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
     * 
     */
    @Import(name="destination")
    private @Nullable Output<String> destination;

    /**
     * @return Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
     * 
     */
    public Optional<Output<String>> destination() {
        return Optional.ofNullable(this.destination);
    }

    /**
     * Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
     * 
     */
    @Import(name="destinationArn")
    private @Nullable Output<String> destinationArn;

    /**
     * @return Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
     * 
     */
    public Optional<Output<String>> destinationArn() {
        return Optional.ofNullable(this.destinationArn);
    }

    /**
     * This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
     * 
     */
    @Import(name="iamRoleArn")
    private @Nullable Output<String> iamRoleArn;

    /**
     * @return This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
     * 
     */
    public Optional<Output<String>> iamRoleArn() {
        return Optional.ofNullable(this.iamRoleArn);
    }

    private MetricsDestinationState() {}

    private MetricsDestinationState(MetricsDestinationState $) {
        this.appMonitorName = $.appMonitorName;
        this.destination = $.destination;
        this.destinationArn = $.destinationArn;
        this.iamRoleArn = $.iamRoleArn;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(MetricsDestinationState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private MetricsDestinationState $;

        public Builder() {
            $ = new MetricsDestinationState();
        }

        public Builder(MetricsDestinationState defaults) {
            $ = new MetricsDestinationState(Objects.requireNonNull(defaults));
        }

        /**
         * @param appMonitorName The name of the CloudWatch RUM app monitor that will send the metrics.
         * 
         * @return builder
         * 
         */
        public Builder appMonitorName(@Nullable Output<String> appMonitorName) {
            $.appMonitorName = appMonitorName;
            return this;
        }

        /**
         * @param appMonitorName The name of the CloudWatch RUM app monitor that will send the metrics.
         * 
         * @return builder
         * 
         */
        public Builder appMonitorName(String appMonitorName) {
            return appMonitorName(Output.of(appMonitorName));
        }

        /**
         * @param destination Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
         * 
         * @return builder
         * 
         */
        public Builder destination(@Nullable Output<String> destination) {
            $.destination = destination;
            return this;
        }

        /**
         * @param destination Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
         * 
         * @return builder
         * 
         */
        public Builder destination(String destination) {
            return destination(Output.of(destination));
        }

        /**
         * @param destinationArn Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
         * 
         * @return builder
         * 
         */
        public Builder destinationArn(@Nullable Output<String> destinationArn) {
            $.destinationArn = destinationArn;
            return this;
        }

        /**
         * @param destinationArn Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
         * 
         * @return builder
         * 
         */
        public Builder destinationArn(String destinationArn) {
            return destinationArn(Output.of(destinationArn));
        }

        /**
         * @param iamRoleArn This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
         * 
         * @return builder
         * 
         */
        public Builder iamRoleArn(@Nullable Output<String> iamRoleArn) {
            $.iamRoleArn = iamRoleArn;
            return this;
        }

        /**
         * @param iamRoleArn This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
         * 
         * @return builder
         * 
         */
        public Builder iamRoleArn(String iamRoleArn) {
            return iamRoleArn(Output.of(iamRoleArn));
        }

        public MetricsDestinationState build() {
            return $;
        }
    }

}
