// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rum;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.rum.MetricsDestinationArgs;
import com.pulumi.aws.rum.inputs.MetricsDestinationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a CloudWatch RUM Metrics Destination resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rum.MetricsDestination;
 * import com.pulumi.aws.rum.MetricsDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new MetricsDestination(&#34;example&#34;, MetricsDestinationArgs.builder()        
 *             .appMonitorName(aws_rum_app_monitor.example().name())
 *             .destination(&#34;CloudWatch&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Cloudwatch RUM Metrics Destination using the `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:rum/metricsDestination:MetricsDestination example example
 * ```
 * 
 */
@ResourceType(type="aws:rum/metricsDestination:MetricsDestination")
public class MetricsDestination extends com.pulumi.resources.CustomResource {
    /**
     * The name of the CloudWatch RUM app monitor that will send the metrics.
     * 
     */
    @Export(name="appMonitorName", refs={String.class}, tree="[0]")
    private Output<String> appMonitorName;

    /**
     * @return The name of the CloudWatch RUM app monitor that will send the metrics.
     * 
     */
    public Output<String> appMonitorName() {
        return this.appMonitorName;
    }
    /**
     * Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
     * 
     */
    @Export(name="destination", refs={String.class}, tree="[0]")
    private Output<String> destination;

    /**
     * @return Defines the destination to send the metrics to. Valid values are `CloudWatch` and `Evidently`. If you specify `Evidently`, you must also specify the ARN of the CloudWatchEvidently experiment that is to be the destination and an IAM role that has permission to write to the experiment.
     * 
     */
    public Output<String> destination() {
        return this.destination;
    }
    /**
     * Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
     * 
     */
    @Export(name="destinationArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> destinationArn;

    /**
     * @return Use this parameter only if Destination is Evidently. This parameter specifies the ARN of the Evidently experiment that will receive the extended metrics.
     * 
     */
    public Output<Optional<String>> destinationArn() {
        return Codegen.optional(this.destinationArn);
    }
    /**
     * This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
     * 
     */
    @Export(name="iamRoleArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> iamRoleArn;

    /**
     * @return This parameter is required if Destination is Evidently. If Destination is CloudWatch, do not use this parameter.
     * 
     */
    public Output<Optional<String>> iamRoleArn() {
        return Codegen.optional(this.iamRoleArn);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public MetricsDestination(String name) {
        this(name, MetricsDestinationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public MetricsDestination(String name, MetricsDestinationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public MetricsDestination(String name, MetricsDestinationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:rum/metricsDestination:MetricsDestination", name, args == null ? MetricsDestinationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private MetricsDestination(String name, Output<String> id, @Nullable MetricsDestinationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:rum/metricsDestination:MetricsDestination", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static MetricsDestination get(String name, Output<String> id, @Nullable MetricsDestinationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new MetricsDestination(name, id, state, options);
    }
}
