// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.route53recoverycontrol;

import com.pulumi.aws.route53recoverycontrol.inputs.SafetyRuleRuleConfigArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SafetyRuleArgs extends com.pulumi.resources.ResourceArgs {

    public static final SafetyRuleArgs Empty = new SafetyRuleArgs();

    /**
     * Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
     * 
     */
    @Import(name="assertedControls")
    private @Nullable Output<List<String>> assertedControls;

    /**
     * @return Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
     * 
     */
    public Optional<Output<List<String>>> assertedControls() {
        return Optional.ofNullable(this.assertedControls);
    }

    /**
     * ARN of the control panel in which this safety rule will reside.
     * 
     */
    @Import(name="controlPanelArn", required=true)
    private Output<String> controlPanelArn;

    /**
     * @return ARN of the control panel in which this safety rule will reside.
     * 
     */
    public Output<String> controlPanelArn() {
        return this.controlPanelArn;
    }

    /**
     * Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
     * 
     */
    @Import(name="gatingControls")
    private @Nullable Output<List<String>> gatingControls;

    /**
     * @return Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
     * 
     */
    public Optional<Output<List<String>>> gatingControls() {
        return Optional.ofNullable(this.gatingControls);
    }

    /**
     * Name describing the safety rule.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name describing the safety rule.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Configuration block for safety rule criteria. See below.
     * 
     */
    @Import(name="ruleConfig", required=true)
    private Output<SafetyRuleRuleConfigArgs> ruleConfig;

    /**
     * @return Configuration block for safety rule criteria. See below.
     * 
     */
    public Output<SafetyRuleRuleConfigArgs> ruleConfig() {
        return this.ruleConfig;
    }

    /**
     * Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
     * 
     */
    @Import(name="targetControls")
    private @Nullable Output<List<String>> targetControls;

    /**
     * @return Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
     * 
     */
    public Optional<Output<List<String>>> targetControls() {
        return Optional.ofNullable(this.targetControls);
    }

    /**
     * Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="waitPeriodMs", required=true)
    private Output<Integer> waitPeriodMs;

    /**
     * @return Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
     * 
     * The following arguments are optional:
     * 
     */
    public Output<Integer> waitPeriodMs() {
        return this.waitPeriodMs;
    }

    private SafetyRuleArgs() {}

    private SafetyRuleArgs(SafetyRuleArgs $) {
        this.assertedControls = $.assertedControls;
        this.controlPanelArn = $.controlPanelArn;
        this.gatingControls = $.gatingControls;
        this.name = $.name;
        this.ruleConfig = $.ruleConfig;
        this.targetControls = $.targetControls;
        this.waitPeriodMs = $.waitPeriodMs;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SafetyRuleArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SafetyRuleArgs $;

        public Builder() {
            $ = new SafetyRuleArgs();
        }

        public Builder(SafetyRuleArgs defaults) {
            $ = new SafetyRuleArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param assertedControls Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
         * 
         * @return builder
         * 
         */
        public Builder assertedControls(@Nullable Output<List<String>> assertedControls) {
            $.assertedControls = assertedControls;
            return this;
        }

        /**
         * @param assertedControls Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
         * 
         * @return builder
         * 
         */
        public Builder assertedControls(List<String> assertedControls) {
            return assertedControls(Output.of(assertedControls));
        }

        /**
         * @param assertedControls Routing controls that are part of transactions that are evaluated to determine if a request to change a routing control state is allowed.
         * 
         * @return builder
         * 
         */
        public Builder assertedControls(String... assertedControls) {
            return assertedControls(List.of(assertedControls));
        }

        /**
         * @param controlPanelArn ARN of the control panel in which this safety rule will reside.
         * 
         * @return builder
         * 
         */
        public Builder controlPanelArn(Output<String> controlPanelArn) {
            $.controlPanelArn = controlPanelArn;
            return this;
        }

        /**
         * @param controlPanelArn ARN of the control panel in which this safety rule will reside.
         * 
         * @return builder
         * 
         */
        public Builder controlPanelArn(String controlPanelArn) {
            return controlPanelArn(Output.of(controlPanelArn));
        }

        /**
         * @param gatingControls Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
         * 
         * @return builder
         * 
         */
        public Builder gatingControls(@Nullable Output<List<String>> gatingControls) {
            $.gatingControls = gatingControls;
            return this;
        }

        /**
         * @param gatingControls Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
         * 
         * @return builder
         * 
         */
        public Builder gatingControls(List<String> gatingControls) {
            return gatingControls(Output.of(gatingControls));
        }

        /**
         * @param gatingControls Gating controls for the new gating rule. That is, routing controls that are evaluated by the rule configuration that you specify.
         * 
         * @return builder
         * 
         */
        public Builder gatingControls(String... gatingControls) {
            return gatingControls(List.of(gatingControls));
        }

        /**
         * @param name Name describing the safety rule.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name describing the safety rule.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param ruleConfig Configuration block for safety rule criteria. See below.
         * 
         * @return builder
         * 
         */
        public Builder ruleConfig(Output<SafetyRuleRuleConfigArgs> ruleConfig) {
            $.ruleConfig = ruleConfig;
            return this;
        }

        /**
         * @param ruleConfig Configuration block for safety rule criteria. See below.
         * 
         * @return builder
         * 
         */
        public Builder ruleConfig(SafetyRuleRuleConfigArgs ruleConfig) {
            return ruleConfig(Output.of(ruleConfig));
        }

        /**
         * @param targetControls Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
         * 
         * @return builder
         * 
         */
        public Builder targetControls(@Nullable Output<List<String>> targetControls) {
            $.targetControls = targetControls;
            return this;
        }

        /**
         * @param targetControls Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
         * 
         * @return builder
         * 
         */
        public Builder targetControls(List<String> targetControls) {
            return targetControls(Output.of(targetControls));
        }

        /**
         * @param targetControls Routing controls that can only be set or unset if the specified `rule_config` evaluates to true for the specified `gating_controls`.
         * 
         * @return builder
         * 
         */
        public Builder targetControls(String... targetControls) {
            return targetControls(List.of(targetControls));
        }

        /**
         * @param waitPeriodMs Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder waitPeriodMs(Output<Integer> waitPeriodMs) {
            $.waitPeriodMs = waitPeriodMs;
            return this;
        }

        /**
         * @param waitPeriodMs Evaluation period, in milliseconds (ms), during which any request against the target routing controls will fail.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder waitPeriodMs(Integer waitPeriodMs) {
            return waitPeriodMs(Output.of(waitPeriodMs));
        }

        public SafetyRuleArgs build() {
            $.controlPanelArn = Objects.requireNonNull($.controlPanelArn, "expected parameter 'controlPanelArn' to be non-null");
            $.ruleConfig = Objects.requireNonNull($.ruleConfig, "expected parameter 'ruleConfig' to be non-null");
            $.waitPeriodMs = Objects.requireNonNull($.waitPeriodMs, "expected parameter 'waitPeriodMs' to be non-null");
            return $;
        }
    }

}
