// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.route53recoverycontrol;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.route53recoverycontrol.ControlPanelArgs;
import com.pulumi.aws.route53recoverycontrol.inputs.ControlPanelState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides an AWS Route 53 Recovery Control Config Control Panel.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53recoverycontrol.ControlPanel;
 * import com.pulumi.aws.route53recoverycontrol.ControlPanelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ControlPanel(&#34;example&#34;, ControlPanelArgs.builder()        
 *             .clusterArn(&#34;arn:aws:route53-recovery-control::123456789012:cluster/8d47920e-d789-437d-803a-2dcc4b204393&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Route53 Recovery Control Config Control Panel using the control panel arn. For example:
 * 
 * ```sh
 *  $ pulumi import aws:route53recoverycontrol/controlPanel:ControlPanel mypanel arn:aws:route53-recovery-control::313517334327:controlpanel/1bfba17df8684f5dab0467b71424f7e8
 * ```
 * 
 */
@ResourceType(type="aws:route53recoverycontrol/controlPanel:ControlPanel")
public class ControlPanel extends com.pulumi.resources.CustomResource {
    /**
     * ARN of the control panel.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return ARN of the control panel.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * ARN of the cluster in which this control panel will reside.
     * 
     */
    @Export(name="clusterArn", refs={String.class}, tree="[0]")
    private Output<String> clusterArn;

    /**
     * @return ARN of the cluster in which this control panel will reside.
     * 
     */
    public Output<String> clusterArn() {
        return this.clusterArn;
    }
    /**
     * Whether a control panel is default.
     * 
     */
    @Export(name="defaultControlPanel", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> defaultControlPanel;

    /**
     * @return Whether a control panel is default.
     * 
     */
    public Output<Boolean> defaultControlPanel() {
        return this.defaultControlPanel;
    }
    /**
     * Name describing the control panel.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name describing the control panel.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Number routing controls in a control panel.
     * 
     */
    @Export(name="routingControlCount", refs={Integer.class}, tree="[0]")
    private Output<Integer> routingControlCount;

    /**
     * @return Number routing controls in a control panel.
     * 
     */
    public Output<Integer> routingControlCount() {
        return this.routingControlCount;
    }
    /**
     * Status of control panel: `PENDING` when it is being created/updated, `PENDING_DELETION` when it is being deleted, and `DEPLOYED` otherwise.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return Status of control panel: `PENDING` when it is being created/updated, `PENDING_DELETION` when it is being deleted, and `DEPLOYED` otherwise.
     * 
     */
    public Output<String> status() {
        return this.status;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ControlPanel(String name) {
        this(name, ControlPanelArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ControlPanel(String name, ControlPanelArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ControlPanel(String name, ControlPanelArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:route53recoverycontrol/controlPanel:ControlPanel", name, args == null ? ControlPanelArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ControlPanel(String name, Output<String> id, @Nullable ControlPanelState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:route53recoverycontrol/controlPanel:ControlPanel", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ControlPanel get(String name, Output<String> id, @Nullable ControlPanelState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ControlPanel(name, id, state, options);
    }
}
