// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.route53domains;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.route53domains.RegisteredDomainArgs;
import com.pulumi.aws.route53domains.inputs.RegisteredDomainState;
import com.pulumi.aws.route53domains.outputs.RegisteredDomainAdminContact;
import com.pulumi.aws.route53domains.outputs.RegisteredDomainNameServer;
import com.pulumi.aws.route53domains.outputs.RegisteredDomainRegistrantContact;
import com.pulumi.aws.route53domains.outputs.RegisteredDomainTechContact;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage a domain that has been [registered](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) and associated with the current AWS account.
 * 
 * **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.
 * 
 * The `aws.route53domains.RegisteredDomain` resource behaves differently from normal resources in that if a domain has been registered, the provider does not _register_ this domain, but instead &#34;adopts&#34; it into management. A destroy does not delete the domain but does remove the resource from state.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53domains.RegisteredDomain;
 * import com.pulumi.aws.route53domains.RegisteredDomainArgs;
 * import com.pulumi.aws.route53domains.inputs.RegisteredDomainNameServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new RegisteredDomain(&#34;example&#34;, RegisteredDomainArgs.builder()        
 *             .domainName(&#34;example.com&#34;)
 *             .nameServers(            
 *                 RegisteredDomainNameServerArgs.builder()
 *                     .name(&#34;ns-195.awsdns-24.com&#34;)
 *                     .build(),
 *                 RegisteredDomainNameServerArgs.builder()
 *                     .name(&#34;ns-874.awsdns-45.net&#34;)
 *                     .build())
 *             .tags(Map.of(&#34;Environment&#34;, &#34;test&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 */
@ResourceType(type="aws:route53domains/registeredDomain:RegisteredDomain")
public class RegisteredDomain extends com.pulumi.resources.CustomResource {
    /**
     * Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
     * 
     */
    @Export(name="abuseContactEmail", refs={String.class}, tree="[0]")
    private Output<String> abuseContactEmail;

    /**
     * @return Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
     * 
     */
    public Output<String> abuseContactEmail() {
        return this.abuseContactEmail;
    }
    /**
     * Phone number for reporting abuse.
     * 
     */
    @Export(name="abuseContactPhone", refs={String.class}, tree="[0]")
    private Output<String> abuseContactPhone;

    /**
     * @return Phone number for reporting abuse.
     * 
     */
    public Output<String> abuseContactPhone() {
        return this.abuseContactPhone;
    }
    /**
     * Details about the domain administrative contact.
     * 
     */
    @Export(name="adminContact", refs={RegisteredDomainAdminContact.class}, tree="[0]")
    private Output<RegisteredDomainAdminContact> adminContact;

    /**
     * @return Details about the domain administrative contact.
     * 
     */
    public Output<RegisteredDomainAdminContact> adminContact() {
        return this.adminContact;
    }
    /**
     * Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
     * 
     */
    @Export(name="adminPrivacy", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> adminPrivacy;

    /**
     * @return Whether domain administrative contact information is concealed from WHOIS queries. Default: `true`.
     * 
     */
    public Output<Optional<Boolean>> adminPrivacy() {
        return Codegen.optional(this.adminPrivacy);
    }
    /**
     * Whether the domain registration is set to renew automatically. Default: `true`.
     * 
     */
    @Export(name="autoRenew", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> autoRenew;

    /**
     * @return Whether the domain registration is set to renew automatically. Default: `true`.
     * 
     */
    public Output<Optional<Boolean>> autoRenew() {
        return Codegen.optional(this.autoRenew);
    }
    /**
     * The date when the domain was created as found in the response to a WHOIS query.
     * 
     */
    @Export(name="creationDate", refs={String.class}, tree="[0]")
    private Output<String> creationDate;

    /**
     * @return The date when the domain was created as found in the response to a WHOIS query.
     * 
     */
    public Output<String> creationDate() {
        return this.creationDate;
    }
    /**
     * The name of the registered domain.
     * 
     */
    @Export(name="domainName", refs={String.class}, tree="[0]")
    private Output<String> domainName;

    /**
     * @return The name of the registered domain.
     * 
     */
    public Output<String> domainName() {
        return this.domainName;
    }
    /**
     * The date when the registration for the domain is set to expire.
     * 
     */
    @Export(name="expirationDate", refs={String.class}, tree="[0]")
    private Output<String> expirationDate;

    /**
     * @return The date when the registration for the domain is set to expire.
     * 
     */
    public Output<String> expirationDate() {
        return this.expirationDate;
    }
    /**
     * The list of nameservers for the domain.
     * 
     */
    @Export(name="nameServers", refs={List.class,RegisteredDomainNameServer.class}, tree="[0,1]")
    private Output<List<RegisteredDomainNameServer>> nameServers;

    /**
     * @return The list of nameservers for the domain.
     * 
     */
    public Output<List<RegisteredDomainNameServer>> nameServers() {
        return this.nameServers;
    }
    /**
     * Details about the domain registrant.
     * 
     */
    @Export(name="registrantContact", refs={RegisteredDomainRegistrantContact.class}, tree="[0]")
    private Output<RegisteredDomainRegistrantContact> registrantContact;

    /**
     * @return Details about the domain registrant.
     * 
     */
    public Output<RegisteredDomainRegistrantContact> registrantContact() {
        return this.registrantContact;
    }
    /**
     * Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
     * 
     */
    @Export(name="registrantPrivacy", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> registrantPrivacy;

    /**
     * @return Whether domain registrant contact information is concealed from WHOIS queries. Default: `true`.
     * 
     */
    public Output<Optional<Boolean>> registrantPrivacy() {
        return Codegen.optional(this.registrantPrivacy);
    }
    /**
     * Name of the registrar of the domain as identified in the registry.
     * 
     */
    @Export(name="registrarName", refs={String.class}, tree="[0]")
    private Output<String> registrarName;

    /**
     * @return Name of the registrar of the domain as identified in the registry.
     * 
     */
    public Output<String> registrarName() {
        return this.registrarName;
    }
    /**
     * Web address of the registrar.
     * 
     */
    @Export(name="registrarUrl", refs={String.class}, tree="[0]")
    private Output<String> registrarUrl;

    /**
     * @return Web address of the registrar.
     * 
     */
    public Output<String> registrarUrl() {
        return this.registrarUrl;
    }
    /**
     * Reseller of the domain.
     * 
     */
    @Export(name="reseller", refs={String.class}, tree="[0]")
    private Output<String> reseller;

    /**
     * @return Reseller of the domain.
     * 
     */
    public Output<String> reseller() {
        return this.reseller;
    }
    /**
     * List of [domain name status codes](https://www.icann.org/resources/pages/epp-status-codes-2014-06-16-en).
     * 
     */
    @Export(name="statusLists", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> statusLists;

    /**
     * @return List of [domain name status codes](https://www.icann.org/resources/pages/epp-status-codes-2014-06-16-en).
     * 
     */
    public Output<List<String>> statusLists() {
        return this.statusLists;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * Details about the domain technical contact.
     * 
     */
    @Export(name="techContact", refs={RegisteredDomainTechContact.class}, tree="[0]")
    private Output<RegisteredDomainTechContact> techContact;

    /**
     * @return Details about the domain technical contact.
     * 
     */
    public Output<RegisteredDomainTechContact> techContact() {
        return this.techContact;
    }
    /**
     * Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
     * 
     */
    @Export(name="techPrivacy", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> techPrivacy;

    /**
     * @return Whether domain technical contact information is concealed from WHOIS queries. Default: `true`.
     * 
     */
    public Output<Optional<Boolean>> techPrivacy() {
        return Codegen.optional(this.techPrivacy);
    }
    /**
     * Whether the domain is locked for transfer. Default: `true`.
     * 
     */
    @Export(name="transferLock", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> transferLock;

    /**
     * @return Whether the domain is locked for transfer. Default: `true`.
     * 
     */
    public Output<Optional<Boolean>> transferLock() {
        return Codegen.optional(this.transferLock);
    }
    /**
     * The last updated date of the domain as found in the response to a WHOIS query.
     * 
     */
    @Export(name="updatedDate", refs={String.class}, tree="[0]")
    private Output<String> updatedDate;

    /**
     * @return The last updated date of the domain as found in the response to a WHOIS query.
     * 
     */
    public Output<String> updatedDate() {
        return this.updatedDate;
    }
    /**
     * The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
     * 
     */
    @Export(name="whoisServer", refs={String.class}, tree="[0]")
    private Output<String> whoisServer;

    /**
     * @return The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
     * 
     */
    public Output<String> whoisServer() {
        return this.whoisServer;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public RegisteredDomain(String name) {
        this(name, RegisteredDomainArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public RegisteredDomain(String name, RegisteredDomainArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public RegisteredDomain(String name, RegisteredDomainArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:route53domains/registeredDomain:RegisteredDomain", name, args == null ? RegisteredDomainArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private RegisteredDomain(String name, Output<String> id, @Nullable RegisteredDomainState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:route53domains/registeredDomain:RegisteredDomain", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static RegisteredDomain get(String name, Output<String> id, @Nullable RegisteredDomainState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new RegisteredDomain(name, id, state, options);
    }
}
