// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.route53.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class KeySigningKeyState extends com.pulumi.resources.ResourceArgs {

    public static final KeySigningKeyState Empty = new KeySigningKeyState();

    /**
     * A string used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
     * 
     */
    @Import(name="digestAlgorithmMnemonic")
    private @Nullable Output<String> digestAlgorithmMnemonic;

    /**
     * @return A string used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
     * 
     */
    public Optional<Output<String>> digestAlgorithmMnemonic() {
        return Optional.ofNullable(this.digestAlgorithmMnemonic);
    }

    /**
     * An integer used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
     * 
     */
    @Import(name="digestAlgorithmType")
    private @Nullable Output<Integer> digestAlgorithmType;

    /**
     * @return An integer used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
     * 
     */
    public Optional<Output<Integer>> digestAlgorithmType() {
        return Optional.ofNullable(this.digestAlgorithmType);
    }

    /**
     * A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public key that resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of information provided by the DNS system.
     * 
     */
    @Import(name="digestValue")
    private @Nullable Output<String> digestValue;

    /**
     * @return A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public key that resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of information provided by the DNS system.
     * 
     */
    public Optional<Output<String>> digestValue() {
        return Optional.ofNullable(this.digestValue);
    }

    /**
     * A string that represents a DNSKEY record.
     * 
     */
    @Import(name="dnskeyRecord")
    private @Nullable Output<String> dnskeyRecord;

    /**
     * @return A string that represents a DNSKEY record.
     * 
     */
    public Optional<Output<String>> dnskeyRecord() {
        return Optional.ofNullable(this.dnskeyRecord);
    }

    /**
     * A string that represents a delegation signer (DS) record.
     * 
     */
    @Import(name="dsRecord")
    private @Nullable Output<String> dsRecord;

    /**
     * @return A string that represents a delegation signer (DS) record.
     * 
     */
    public Optional<Output<String>> dsRecord() {
        return Optional.ofNullable(this.dsRecord);
    }

    /**
     * An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
     * 
     */
    @Import(name="flag")
    private @Nullable Output<Integer> flag;

    /**
     * @return An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
     * 
     */
    public Optional<Output<Integer>> flag() {
        return Optional.ofNullable(this.flag);
    }

    /**
     * Identifier of the Route 53 Hosted Zone.
     * 
     */
    @Import(name="hostedZoneId")
    private @Nullable Output<String> hostedZoneId;

    /**
     * @return Identifier of the Route 53 Hosted Zone.
     * 
     */
    public Optional<Output<String>> hostedZoneId() {
        return Optional.ofNullable(this.hostedZoneId);
    }

    /**
     * Amazon Resource Name (ARN) of the Key Management Service (KMS) Key. This must be unique for each key-signing key (KSK) in a single hosted zone. This key must be in the `us-east-1` Region and meet certain requirements, which are described in the [Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements.html) and [Route 53 API Reference](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateKeySigningKey.html).
     * 
     */
    @Import(name="keyManagementServiceArn")
    private @Nullable Output<String> keyManagementServiceArn;

    /**
     * @return Amazon Resource Name (ARN) of the Key Management Service (KMS) Key. This must be unique for each key-signing key (KSK) in a single hosted zone. This key must be in the `us-east-1` Region and meet certain requirements, which are described in the [Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements.html) and [Route 53 API Reference](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateKeySigningKey.html).
     * 
     */
    public Optional<Output<String>> keyManagementServiceArn() {
        return Optional.ofNullable(this.keyManagementServiceArn);
    }

    /**
     * An integer used to identify the DNSSEC record for the domain name. The process used to calculate the value is described in [RFC-4034 Appendix B](https://tools.ietf.org/rfc/rfc4034.txt).
     * 
     */
    @Import(name="keyTag")
    private @Nullable Output<Integer> keyTag;

    /**
     * @return An integer used to identify the DNSSEC record for the domain name. The process used to calculate the value is described in [RFC-4034 Appendix B](https://tools.ietf.org/rfc/rfc4034.txt).
     * 
     */
    public Optional<Output<Integer>> keyTag() {
        return Optional.ofNullable(this.keyTag);
    }

    /**
     * Name of the key-signing key (KSK). Must be unique for each key-singing key in the same hosted zone.
     * 
     * The following arguments are optional:
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the key-signing key (KSK). Must be unique for each key-singing key in the same hosted zone.
     * 
     * The following arguments are optional:
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The public key, represented as a Base64 encoding, as required by [RFC-4034 Page 5](https://tools.ietf.org/rfc/rfc4034.txt).
     * 
     */
    @Import(name="publicKey")
    private @Nullable Output<String> publicKey;

    /**
     * @return The public key, represented as a Base64 encoding, as required by [RFC-4034 Page 5](https://tools.ietf.org/rfc/rfc4034.txt).
     * 
     */
    public Optional<Output<String>> publicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    /**
     * A string used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
     * 
     */
    @Import(name="signingAlgorithmMnemonic")
    private @Nullable Output<String> signingAlgorithmMnemonic;

    /**
     * @return A string used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
     * 
     */
    public Optional<Output<String>> signingAlgorithmMnemonic() {
        return Optional.ofNullable(this.signingAlgorithmMnemonic);
    }

    /**
     * An integer used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
     * 
     */
    @Import(name="signingAlgorithmType")
    private @Nullable Output<Integer> signingAlgorithmType;

    /**
     * @return An integer used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
     * 
     */
    public Optional<Output<Integer>> signingAlgorithmType() {
        return Optional.ofNullable(this.signingAlgorithmType);
    }

    /**
     * Status of the key-signing key (KSK). Valid values: `ACTIVE`, `INACTIVE`. Defaults to `ACTIVE`.
     * 
     */
    @Import(name="status")
    private @Nullable Output<String> status;

    /**
     * @return Status of the key-signing key (KSK). Valid values: `ACTIVE`, `INACTIVE`. Defaults to `ACTIVE`.
     * 
     */
    public Optional<Output<String>> status() {
        return Optional.ofNullable(this.status);
    }

    private KeySigningKeyState() {}

    private KeySigningKeyState(KeySigningKeyState $) {
        this.digestAlgorithmMnemonic = $.digestAlgorithmMnemonic;
        this.digestAlgorithmType = $.digestAlgorithmType;
        this.digestValue = $.digestValue;
        this.dnskeyRecord = $.dnskeyRecord;
        this.dsRecord = $.dsRecord;
        this.flag = $.flag;
        this.hostedZoneId = $.hostedZoneId;
        this.keyManagementServiceArn = $.keyManagementServiceArn;
        this.keyTag = $.keyTag;
        this.name = $.name;
        this.publicKey = $.publicKey;
        this.signingAlgorithmMnemonic = $.signingAlgorithmMnemonic;
        this.signingAlgorithmType = $.signingAlgorithmType;
        this.status = $.status;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(KeySigningKeyState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private KeySigningKeyState $;

        public Builder() {
            $ = new KeySigningKeyState();
        }

        public Builder(KeySigningKeyState defaults) {
            $ = new KeySigningKeyState(Objects.requireNonNull(defaults));
        }

        /**
         * @param digestAlgorithmMnemonic A string used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
         * 
         * @return builder
         * 
         */
        public Builder digestAlgorithmMnemonic(@Nullable Output<String> digestAlgorithmMnemonic) {
            $.digestAlgorithmMnemonic = digestAlgorithmMnemonic;
            return this;
        }

        /**
         * @param digestAlgorithmMnemonic A string used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
         * 
         * @return builder
         * 
         */
        public Builder digestAlgorithmMnemonic(String digestAlgorithmMnemonic) {
            return digestAlgorithmMnemonic(Output.of(digestAlgorithmMnemonic));
        }

        /**
         * @param digestAlgorithmType An integer used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
         * 
         * @return builder
         * 
         */
        public Builder digestAlgorithmType(@Nullable Output<Integer> digestAlgorithmType) {
            $.digestAlgorithmType = digestAlgorithmType;
            return this;
        }

        /**
         * @param digestAlgorithmType An integer used to represent the delegation signer digest algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.3](https://tools.ietf.org/html/rfc8624#section-3.3).
         * 
         * @return builder
         * 
         */
        public Builder digestAlgorithmType(Integer digestAlgorithmType) {
            return digestAlgorithmType(Output.of(digestAlgorithmType));
        }

        /**
         * @param digestValue A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public key that resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of information provided by the DNS system.
         * 
         * @return builder
         * 
         */
        public Builder digestValue(@Nullable Output<String> digestValue) {
            $.digestValue = digestValue;
            return this;
        }

        /**
         * @param digestValue A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public key that resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of information provided by the DNS system.
         * 
         * @return builder
         * 
         */
        public Builder digestValue(String digestValue) {
            return digestValue(Output.of(digestValue));
        }

        /**
         * @param dnskeyRecord A string that represents a DNSKEY record.
         * 
         * @return builder
         * 
         */
        public Builder dnskeyRecord(@Nullable Output<String> dnskeyRecord) {
            $.dnskeyRecord = dnskeyRecord;
            return this;
        }

        /**
         * @param dnskeyRecord A string that represents a DNSKEY record.
         * 
         * @return builder
         * 
         */
        public Builder dnskeyRecord(String dnskeyRecord) {
            return dnskeyRecord(Output.of(dnskeyRecord));
        }

        /**
         * @param dsRecord A string that represents a delegation signer (DS) record.
         * 
         * @return builder
         * 
         */
        public Builder dsRecord(@Nullable Output<String> dsRecord) {
            $.dsRecord = dsRecord;
            return this;
        }

        /**
         * @param dsRecord A string that represents a delegation signer (DS) record.
         * 
         * @return builder
         * 
         */
        public Builder dsRecord(String dsRecord) {
            return dsRecord(Output.of(dsRecord));
        }

        /**
         * @param flag An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
         * 
         * @return builder
         * 
         */
        public Builder flag(@Nullable Output<Integer> flag) {
            $.flag = flag;
            return this;
        }

        /**
         * @param flag An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
         * 
         * @return builder
         * 
         */
        public Builder flag(Integer flag) {
            return flag(Output.of(flag));
        }

        /**
         * @param hostedZoneId Identifier of the Route 53 Hosted Zone.
         * 
         * @return builder
         * 
         */
        public Builder hostedZoneId(@Nullable Output<String> hostedZoneId) {
            $.hostedZoneId = hostedZoneId;
            return this;
        }

        /**
         * @param hostedZoneId Identifier of the Route 53 Hosted Zone.
         * 
         * @return builder
         * 
         */
        public Builder hostedZoneId(String hostedZoneId) {
            return hostedZoneId(Output.of(hostedZoneId));
        }

        /**
         * @param keyManagementServiceArn Amazon Resource Name (ARN) of the Key Management Service (KMS) Key. This must be unique for each key-signing key (KSK) in a single hosted zone. This key must be in the `us-east-1` Region and meet certain requirements, which are described in the [Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements.html) and [Route 53 API Reference](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateKeySigningKey.html).
         * 
         * @return builder
         * 
         */
        public Builder keyManagementServiceArn(@Nullable Output<String> keyManagementServiceArn) {
            $.keyManagementServiceArn = keyManagementServiceArn;
            return this;
        }

        /**
         * @param keyManagementServiceArn Amazon Resource Name (ARN) of the Key Management Service (KMS) Key. This must be unique for each key-signing key (KSK) in a single hosted zone. This key must be in the `us-east-1` Region and meet certain requirements, which are described in the [Route 53 Developer Guide](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements.html) and [Route 53 API Reference](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateKeySigningKey.html).
         * 
         * @return builder
         * 
         */
        public Builder keyManagementServiceArn(String keyManagementServiceArn) {
            return keyManagementServiceArn(Output.of(keyManagementServiceArn));
        }

        /**
         * @param keyTag An integer used to identify the DNSSEC record for the domain name. The process used to calculate the value is described in [RFC-4034 Appendix B](https://tools.ietf.org/rfc/rfc4034.txt).
         * 
         * @return builder
         * 
         */
        public Builder keyTag(@Nullable Output<Integer> keyTag) {
            $.keyTag = keyTag;
            return this;
        }

        /**
         * @param keyTag An integer used to identify the DNSSEC record for the domain name. The process used to calculate the value is described in [RFC-4034 Appendix B](https://tools.ietf.org/rfc/rfc4034.txt).
         * 
         * @return builder
         * 
         */
        public Builder keyTag(Integer keyTag) {
            return keyTag(Output.of(keyTag));
        }

        /**
         * @param name Name of the key-signing key (KSK). Must be unique for each key-singing key in the same hosted zone.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the key-signing key (KSK). Must be unique for each key-singing key in the same hosted zone.
         * 
         * The following arguments are optional:
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param publicKey The public key, represented as a Base64 encoding, as required by [RFC-4034 Page 5](https://tools.ietf.org/rfc/rfc4034.txt).
         * 
         * @return builder
         * 
         */
        public Builder publicKey(@Nullable Output<String> publicKey) {
            $.publicKey = publicKey;
            return this;
        }

        /**
         * @param publicKey The public key, represented as a Base64 encoding, as required by [RFC-4034 Page 5](https://tools.ietf.org/rfc/rfc4034.txt).
         * 
         * @return builder
         * 
         */
        public Builder publicKey(String publicKey) {
            return publicKey(Output.of(publicKey));
        }

        /**
         * @param signingAlgorithmMnemonic A string used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
         * 
         * @return builder
         * 
         */
        public Builder signingAlgorithmMnemonic(@Nullable Output<String> signingAlgorithmMnemonic) {
            $.signingAlgorithmMnemonic = signingAlgorithmMnemonic;
            return this;
        }

        /**
         * @param signingAlgorithmMnemonic A string used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
         * 
         * @return builder
         * 
         */
        public Builder signingAlgorithmMnemonic(String signingAlgorithmMnemonic) {
            return signingAlgorithmMnemonic(Output.of(signingAlgorithmMnemonic));
        }

        /**
         * @param signingAlgorithmType An integer used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
         * 
         * @return builder
         * 
         */
        public Builder signingAlgorithmType(@Nullable Output<Integer> signingAlgorithmType) {
            $.signingAlgorithmType = signingAlgorithmType;
            return this;
        }

        /**
         * @param signingAlgorithmType An integer used to represent the signing algorithm. This value must follow the guidelines provided by [RFC-8624 Section 3.1](https://tools.ietf.org/html/rfc8624#section-3.1).
         * 
         * @return builder
         * 
         */
        public Builder signingAlgorithmType(Integer signingAlgorithmType) {
            return signingAlgorithmType(Output.of(signingAlgorithmType));
        }

        /**
         * @param status Status of the key-signing key (KSK). Valid values: `ACTIVE`, `INACTIVE`. Defaults to `ACTIVE`.
         * 
         * @return builder
         * 
         */
        public Builder status(@Nullable Output<String> status) {
            $.status = status;
            return this;
        }

        /**
         * @param status Status of the key-signing key (KSK). Valid values: `ACTIVE`, `INACTIVE`. Defaults to `ACTIVE`.
         * 
         * @return builder
         * 
         */
        public Builder status(String status) {
            return status(Output.of(status));
        }

        public KeySigningKeyState build() {
            return $;
        }
    }

}
