// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.route53;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class TrafficPolicyInstanceArgs extends com.pulumi.resources.ResourceArgs {

    public static final TrafficPolicyInstanceArgs Empty = new TrafficPolicyInstanceArgs();

    /**
     * ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
     * 
     */
    @Import(name="hostedZoneId", required=true)
    private Output<String> hostedZoneId;

    /**
     * @return ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
     * 
     */
    public Output<String> hostedZoneId() {
        return this.hostedZoneId;
    }

    /**
     * Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
     * 
     */
    @Import(name="trafficPolicyId", required=true)
    private Output<String> trafficPolicyId;

    /**
     * @return ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
     * 
     */
    public Output<String> trafficPolicyId() {
        return this.trafficPolicyId;
    }

    /**
     * Version of the traffic policy
     * 
     */
    @Import(name="trafficPolicyVersion", required=true)
    private Output<Integer> trafficPolicyVersion;

    /**
     * @return Version of the traffic policy
     * 
     */
    public Output<Integer> trafficPolicyVersion() {
        return this.trafficPolicyVersion;
    }

    /**
     * TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
     * 
     */
    @Import(name="ttl", required=true)
    private Output<Integer> ttl;

    /**
     * @return TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
     * 
     */
    public Output<Integer> ttl() {
        return this.ttl;
    }

    private TrafficPolicyInstanceArgs() {}

    private TrafficPolicyInstanceArgs(TrafficPolicyInstanceArgs $) {
        this.hostedZoneId = $.hostedZoneId;
        this.name = $.name;
        this.trafficPolicyId = $.trafficPolicyId;
        this.trafficPolicyVersion = $.trafficPolicyVersion;
        this.ttl = $.ttl;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TrafficPolicyInstanceArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private TrafficPolicyInstanceArgs $;

        public Builder() {
            $ = new TrafficPolicyInstanceArgs();
        }

        public Builder(TrafficPolicyInstanceArgs defaults) {
            $ = new TrafficPolicyInstanceArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param hostedZoneId ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
         * 
         * @return builder
         * 
         */
        public Builder hostedZoneId(Output<String> hostedZoneId) {
            $.hostedZoneId = hostedZoneId;
            return this;
        }

        /**
         * @param hostedZoneId ID of the hosted zone that you want Amazon Route 53 to create resource record sets in by using the configuration in a traffic policy.
         * 
         * @return builder
         * 
         */
        public Builder hostedZoneId(String hostedZoneId) {
            return hostedZoneId(Output.of(hostedZoneId));
        }

        /**
         * @param name Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Domain name for which Amazon Route 53 responds to DNS queries by using the resource record sets that Route 53 creates for this traffic policy instance.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param trafficPolicyId ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
         * 
         * @return builder
         * 
         */
        public Builder trafficPolicyId(Output<String> trafficPolicyId) {
            $.trafficPolicyId = trafficPolicyId;
            return this;
        }

        /**
         * @param trafficPolicyId ID of the traffic policy that you want to use to create resource record sets in the specified hosted zone.
         * 
         * @return builder
         * 
         */
        public Builder trafficPolicyId(String trafficPolicyId) {
            return trafficPolicyId(Output.of(trafficPolicyId));
        }

        /**
         * @param trafficPolicyVersion Version of the traffic policy
         * 
         * @return builder
         * 
         */
        public Builder trafficPolicyVersion(Output<Integer> trafficPolicyVersion) {
            $.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        /**
         * @param trafficPolicyVersion Version of the traffic policy
         * 
         * @return builder
         * 
         */
        public Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            return trafficPolicyVersion(Output.of(trafficPolicyVersion));
        }

        /**
         * @param ttl TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
         * 
         * @return builder
         * 
         */
        public Builder ttl(Output<Integer> ttl) {
            $.ttl = ttl;
            return this;
        }

        /**
         * @param ttl TTL that you want Amazon Route 53 to assign to all the resource record sets that it creates in the specified hosted zone.
         * 
         * @return builder
         * 
         */
        public Builder ttl(Integer ttl) {
            return ttl(Output.of(ttl));
        }

        public TrafficPolicyInstanceArgs build() {
            $.hostedZoneId = Objects.requireNonNull($.hostedZoneId, "expected parameter 'hostedZoneId' to be non-null");
            $.trafficPolicyId = Objects.requireNonNull($.trafficPolicyId, "expected parameter 'trafficPolicyId' to be non-null");
            $.trafficPolicyVersion = Objects.requireNonNull($.trafficPolicyVersion, "expected parameter 'trafficPolicyVersion' to be non-null");
            $.ttl = Objects.requireNonNull($.ttl, "expected parameter 'ttl' to be non-null");
            return $;
        }
    }

}
