// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.route53;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ResolverFirewallRuleArgs extends com.pulumi.resources.ResourceArgs {

    public static final ResolverFirewallRuleArgs Empty = new ResolverFirewallRuleArgs();

    /**
     * The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule&#39;s domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
     * 
     */
    @Import(name="action", required=true)
    private Output<String> action;

    /**
     * @return The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule&#39;s domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
     * 
     */
    public Output<String> action() {
        return this.action;
    }

    /**
     * The DNS record&#39;s type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
     * 
     */
    @Import(name="blockOverrideDnsType")
    private @Nullable Output<String> blockOverrideDnsType;

    /**
     * @return The DNS record&#39;s type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
     * 
     */
    public Optional<Output<String>> blockOverrideDnsType() {
        return Optional.ofNullable(this.blockOverrideDnsType);
    }

    /**
     * The custom DNS record to send back in response to the query.
     * 
     */
    @Import(name="blockOverrideDomain")
    private @Nullable Output<String> blockOverrideDomain;

    /**
     * @return The custom DNS record to send back in response to the query.
     * 
     */
    public Optional<Output<String>> blockOverrideDomain() {
        return Optional.ofNullable(this.blockOverrideDomain);
    }

    /**
     * The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
     * 
     */
    @Import(name="blockOverrideTtl")
    private @Nullable Output<Integer> blockOverrideTtl;

    /**
     * @return The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
     * 
     */
    public Optional<Output<Integer>> blockOverrideTtl() {
        return Optional.ofNullable(this.blockOverrideTtl);
    }

    /**
     * The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
     * 
     */
    @Import(name="blockResponse")
    private @Nullable Output<String> blockResponse;

    /**
     * @return The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
     * 
     */
    public Optional<Output<String>> blockResponse() {
        return Optional.ofNullable(this.blockResponse);
    }

    /**
     * The ID of the domain list that you want to use in the rule.
     * 
     */
    @Import(name="firewallDomainListId", required=true)
    private Output<String> firewallDomainListId;

    /**
     * @return The ID of the domain list that you want to use in the rule.
     * 
     */
    public Output<String> firewallDomainListId() {
        return this.firewallDomainListId;
    }

    /**
     * The unique identifier of the firewall rule group where you want to create the rule.
     * 
     */
    @Import(name="firewallRuleGroupId", required=true)
    private Output<String> firewallRuleGroupId;

    /**
     * @return The unique identifier of the firewall rule group where you want to create the rule.
     * 
     */
    public Output<String> firewallRuleGroupId() {
        return this.firewallRuleGroupId;
    }

    /**
     * A name that lets you identify the rule, to manage and use it.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return A name that lets you identify the rule, to manage and use it.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     * 
     */
    @Import(name="priority", required=true)
    private Output<Integer> priority;

    /**
     * @return The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
     * 
     */
    public Output<Integer> priority() {
        return this.priority;
    }

    private ResolverFirewallRuleArgs() {}

    private ResolverFirewallRuleArgs(ResolverFirewallRuleArgs $) {
        this.action = $.action;
        this.blockOverrideDnsType = $.blockOverrideDnsType;
        this.blockOverrideDomain = $.blockOverrideDomain;
        this.blockOverrideTtl = $.blockOverrideTtl;
        this.blockResponse = $.blockResponse;
        this.firewallDomainListId = $.firewallDomainListId;
        this.firewallRuleGroupId = $.firewallRuleGroupId;
        this.name = $.name;
        this.priority = $.priority;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ResolverFirewallRuleArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ResolverFirewallRuleArgs $;

        public Builder() {
            $ = new ResolverFirewallRuleArgs();
        }

        public Builder(ResolverFirewallRuleArgs defaults) {
            $ = new ResolverFirewallRuleArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param action The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule&#39;s domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
         * 
         * @return builder
         * 
         */
        public Builder action(Output<String> action) {
            $.action = action;
            return this;
        }

        /**
         * @param action The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule&#39;s domain list. Valid values: `ALLOW`, `BLOCK`, `ALERT`.
         * 
         * @return builder
         * 
         */
        public Builder action(String action) {
            return action(Output.of(action));
        }

        /**
         * @param blockOverrideDnsType The DNS record&#39;s type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
         * 
         * @return builder
         * 
         */
        public Builder blockOverrideDnsType(@Nullable Output<String> blockOverrideDnsType) {
            $.blockOverrideDnsType = blockOverrideDnsType;
            return this;
        }

        /**
         * @param blockOverrideDnsType The DNS record&#39;s type. This determines the format of the record value that you provided in BlockOverrideDomain. Value values: `CNAME`.
         * 
         * @return builder
         * 
         */
        public Builder blockOverrideDnsType(String blockOverrideDnsType) {
            return blockOverrideDnsType(Output.of(blockOverrideDnsType));
        }

        /**
         * @param blockOverrideDomain The custom DNS record to send back in response to the query.
         * 
         * @return builder
         * 
         */
        public Builder blockOverrideDomain(@Nullable Output<String> blockOverrideDomain) {
            $.blockOverrideDomain = blockOverrideDomain;
            return this;
        }

        /**
         * @param blockOverrideDomain The custom DNS record to send back in response to the query.
         * 
         * @return builder
         * 
         */
        public Builder blockOverrideDomain(String blockOverrideDomain) {
            return blockOverrideDomain(Output.of(blockOverrideDomain));
        }

        /**
         * @param blockOverrideTtl The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
         * 
         * @return builder
         * 
         */
        public Builder blockOverrideTtl(@Nullable Output<Integer> blockOverrideTtl) {
            $.blockOverrideTtl = blockOverrideTtl;
            return this;
        }

        /**
         * @param blockOverrideTtl The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Minimum value of 0. Maximum value of 604800.
         * 
         * @return builder
         * 
         */
        public Builder blockOverrideTtl(Integer blockOverrideTtl) {
            return blockOverrideTtl(Output.of(blockOverrideTtl));
        }

        /**
         * @param blockResponse The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
         * 
         * @return builder
         * 
         */
        public Builder blockResponse(@Nullable Output<String> blockResponse) {
            $.blockResponse = blockResponse;
            return this;
        }

        /**
         * @param blockResponse The way that you want DNS Firewall to block the request. Valid values: `NODATA`, `NXDOMAIN`, `OVERRIDE`.
         * 
         * @return builder
         * 
         */
        public Builder blockResponse(String blockResponse) {
            return blockResponse(Output.of(blockResponse));
        }

        /**
         * @param firewallDomainListId The ID of the domain list that you want to use in the rule.
         * 
         * @return builder
         * 
         */
        public Builder firewallDomainListId(Output<String> firewallDomainListId) {
            $.firewallDomainListId = firewallDomainListId;
            return this;
        }

        /**
         * @param firewallDomainListId The ID of the domain list that you want to use in the rule.
         * 
         * @return builder
         * 
         */
        public Builder firewallDomainListId(String firewallDomainListId) {
            return firewallDomainListId(Output.of(firewallDomainListId));
        }

        /**
         * @param firewallRuleGroupId The unique identifier of the firewall rule group where you want to create the rule.
         * 
         * @return builder
         * 
         */
        public Builder firewallRuleGroupId(Output<String> firewallRuleGroupId) {
            $.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        /**
         * @param firewallRuleGroupId The unique identifier of the firewall rule group where you want to create the rule.
         * 
         * @return builder
         * 
         */
        public Builder firewallRuleGroupId(String firewallRuleGroupId) {
            return firewallRuleGroupId(Output.of(firewallRuleGroupId));
        }

        /**
         * @param name A name that lets you identify the rule, to manage and use it.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name A name that lets you identify the rule, to manage and use it.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param priority The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
         * 
         * @return builder
         * 
         */
        public Builder priority(Output<Integer> priority) {
            $.priority = priority;
            return this;
        }

        /**
         * @param priority The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting.
         * 
         * @return builder
         * 
         */
        public Builder priority(Integer priority) {
            return priority(Output.of(priority));
        }

        public ResolverFirewallRuleArgs build() {
            $.action = Objects.requireNonNull($.action, "expected parameter 'action' to be non-null");
            $.firewallDomainListId = Objects.requireNonNull($.firewallDomainListId, "expected parameter 'firewallDomainListId' to be non-null");
            $.firewallRuleGroupId = Objects.requireNonNull($.firewallRuleGroupId, "expected parameter 'firewallRuleGroupId' to be non-null");
            $.priority = Objects.requireNonNull($.priority, "expected parameter 'priority' to be non-null");
            return $;
        }
    }

}
