// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.route53;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.route53.ResolverConfigArgs;
import com.pulumi.aws.route53.inputs.ResolverConfigState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Provides a Route 53 Resolver config resource.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.route53.ResolverConfig;
 * import com.pulumi.aws.route53.ResolverConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc(&#34;exampleVpc&#34;, VpcArgs.builder()        
 *             .cidrBlock(&#34;10.0.0.0/16&#34;)
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build());
 * 
 *         var exampleResolverConfig = new ResolverConfig(&#34;exampleResolverConfig&#34;, ResolverConfigArgs.builder()        
 *             .resourceId(exampleVpc.id())
 *             .autodefinedReverseFlag(&#34;DISABLE&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Route 53 Resolver configs using the Route 53 Resolver config ID. For example:
 * 
 * ```sh
 *  $ pulumi import aws:route53/resolverConfig:ResolverConfig example rslvr-rc-715aa20c73a23da7
 * ```
 * 
 */
@ResourceType(type="aws:route53/resolverConfig:ResolverConfig")
public class ResolverConfig extends com.pulumi.resources.CustomResource {
    /**
     * Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. Valid values: `ENABLE`, `DISABLE`.
     * 
     */
    @Export(name="autodefinedReverseFlag", refs={String.class}, tree="[0]")
    private Output<String> autodefinedReverseFlag;

    /**
     * @return Indicates whether or not the Resolver will create autodefined rules for reverse DNS lookups. Valid values: `ENABLE`, `DISABLE`.
     * 
     */
    public Output<String> autodefinedReverseFlag() {
        return this.autodefinedReverseFlag;
    }
    /**
     * The AWS account ID of the owner of the VPC that this resolver configuration applies to.
     * 
     */
    @Export(name="ownerId", refs={String.class}, tree="[0]")
    private Output<String> ownerId;

    /**
     * @return The AWS account ID of the owner of the VPC that this resolver configuration applies to.
     * 
     */
    public Output<String> ownerId() {
        return this.ownerId;
    }
    /**
     * The ID of the VPC that the configuration is for.
     * 
     */
    @Export(name="resourceId", refs={String.class}, tree="[0]")
    private Output<String> resourceId;

    /**
     * @return The ID of the VPC that the configuration is for.
     * 
     */
    public Output<String> resourceId() {
        return this.resourceId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ResolverConfig(String name) {
        this(name, ResolverConfigArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ResolverConfig(String name, ResolverConfigArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ResolverConfig(String name, ResolverConfigArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:route53/resolverConfig:ResolverConfig", name, args == null ? ResolverConfigArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ResolverConfig(String name, Output<String> id, @Nullable ResolverConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:route53/resolverConfig:ResolverConfig", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ResolverConfig get(String name, Output<String> id, @Nullable ResolverConfigState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ResolverConfig(name, id, state, options);
    }
}
