// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.route53;

import com.pulumi.aws.route53.enums.RecordType;
import com.pulumi.aws.route53.inputs.RecordAliasArgs;
import com.pulumi.aws.route53.inputs.RecordCidrRoutingPolicyArgs;
import com.pulumi.aws.route53.inputs.RecordFailoverRoutingPolicyArgs;
import com.pulumi.aws.route53.inputs.RecordGeolocationRoutingPolicyArgs;
import com.pulumi.aws.route53.inputs.RecordLatencyRoutingPolicyArgs;
import com.pulumi.aws.route53.inputs.RecordWeightedRoutingPolicyArgs;
import com.pulumi.core.Either;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class RecordArgs extends com.pulumi.resources.ResourceArgs {

    public static final RecordArgs Empty = new RecordArgs();

    /**
     * An alias block. Conflicts with `ttl` &amp; `records`.
     * Documented below.
     * 
     */
    @Import(name="aliases")
    private @Nullable Output<List<RecordAliasArgs>> aliases;

    /**
     * @return An alias block. Conflicts with `ttl` &amp; `records`.
     * Documented below.
     * 
     */
    public Optional<Output<List<RecordAliasArgs>>> aliases() {
        return Optional.ofNullable(this.aliases);
    }

    /**
     * Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
     * 
     * Exactly one of `records` or `alias` must be specified: this determines whether it&#39;s an alias record.
     * 
     */
    @Import(name="allowOverwrite")
    private @Nullable Output<Boolean> allowOverwrite;

    /**
     * @return Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
     * 
     * Exactly one of `records` or `alias` must be specified: this determines whether it&#39;s an alias record.
     * 
     */
    public Optional<Output<Boolean>> allowOverwrite() {
        return Optional.ofNullable(this.allowOverwrite);
    }

    /**
     * A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
     * 
     */
    @Import(name="cidrRoutingPolicy")
    private @Nullable Output<RecordCidrRoutingPolicyArgs> cidrRoutingPolicy;

    /**
     * @return A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
     * 
     */
    public Optional<Output<RecordCidrRoutingPolicyArgs>> cidrRoutingPolicy() {
        return Optional.ofNullable(this.cidrRoutingPolicy);
    }

    /**
     * A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     * 
     */
    @Import(name="failoverRoutingPolicies")
    private @Nullable Output<List<RecordFailoverRoutingPolicyArgs>> failoverRoutingPolicies;

    /**
     * @return A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
     * 
     */
    public Optional<Output<List<RecordFailoverRoutingPolicyArgs>>> failoverRoutingPolicies() {
        return Optional.ofNullable(this.failoverRoutingPolicies);
    }

    /**
     * A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     * 
     */
    @Import(name="geolocationRoutingPolicies")
    private @Nullable Output<List<RecordGeolocationRoutingPolicyArgs>> geolocationRoutingPolicies;

    /**
     * @return A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
     * 
     */
    public Optional<Output<List<RecordGeolocationRoutingPolicyArgs>>> geolocationRoutingPolicies() {
        return Optional.ofNullable(this.geolocationRoutingPolicies);
    }

    /**
     * The health check the record should be associated with.
     * 
     */
    @Import(name="healthCheckId")
    private @Nullable Output<String> healthCheckId;

    /**
     * @return The health check the record should be associated with.
     * 
     */
    public Optional<Output<String>> healthCheckId() {
        return Optional.ofNullable(this.healthCheckId);
    }

    /**
     * A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     * 
     */
    @Import(name="latencyRoutingPolicies")
    private @Nullable Output<List<RecordLatencyRoutingPolicyArgs>> latencyRoutingPolicies;

    /**
     * @return A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
     * 
     */
    public Optional<Output<List<RecordLatencyRoutingPolicyArgs>>> latencyRoutingPolicies() {
        return Optional.ofNullable(this.latencyRoutingPolicies);
    }

    /**
     * Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
     * 
     */
    @Import(name="multivalueAnswerRoutingPolicy")
    private @Nullable Output<Boolean> multivalueAnswerRoutingPolicy;

    /**
     * @return Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
     * 
     */
    public Optional<Output<Boolean>> multivalueAnswerRoutingPolicy() {
        return Optional.ofNullable(this.multivalueAnswerRoutingPolicy);
    }

    /**
     * The name of the record.
     * 
     */
    @Import(name="name", required=true)
    private Output<String> name;

    /**
     * @return The name of the record.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     * A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\&#34;\&#34;` inside the provider configuration string (e.g., `&#34;first255characters\&#34;\&#34;morecharacters&#34;`).
     * 
     */
    @Import(name="records")
    private @Nullable Output<List<String>> records;

    /**
     * @return A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\&#34;\&#34;` inside the provider configuration string (e.g., `&#34;first255characters\&#34;\&#34;morecharacters&#34;`).
     * 
     */
    public Optional<Output<List<String>>> records() {
        return Optional.ofNullable(this.records);
    }

    /**
     * Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
     * 
     */
    @Import(name="setIdentifier")
    private @Nullable Output<String> setIdentifier;

    /**
     * @return Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
     * 
     */
    public Optional<Output<String>> setIdentifier() {
        return Optional.ofNullable(this.setIdentifier);
    }

    /**
     * The TTL of the record.
     * 
     */
    @Import(name="ttl")
    private @Nullable Output<Integer> ttl;

    /**
     * @return The TTL of the record.
     * 
     */
    public Optional<Output<Integer>> ttl() {
        return Optional.ofNullable(this.ttl);
    }

    /**
     * The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     * 
     */
    @Import(name="type", required=true)
    private Output<Either<String,RecordType>> type;

    /**
     * @return The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
     * 
     */
    public Output<Either<String,RecordType>> type() {
        return this.type;
    }

    /**
     * A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     * 
     */
    @Import(name="weightedRoutingPolicies")
    private @Nullable Output<List<RecordWeightedRoutingPolicyArgs>> weightedRoutingPolicies;

    /**
     * @return A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
     * 
     */
    public Optional<Output<List<RecordWeightedRoutingPolicyArgs>>> weightedRoutingPolicies() {
        return Optional.ofNullable(this.weightedRoutingPolicies);
    }

    /**
     * The ID of the hosted zone to contain this record.
     * 
     */
    @Import(name="zoneId", required=true)
    private Output<String> zoneId;

    /**
     * @return The ID of the hosted zone to contain this record.
     * 
     */
    public Output<String> zoneId() {
        return this.zoneId;
    }

    private RecordArgs() {}

    private RecordArgs(RecordArgs $) {
        this.aliases = $.aliases;
        this.allowOverwrite = $.allowOverwrite;
        this.cidrRoutingPolicy = $.cidrRoutingPolicy;
        this.failoverRoutingPolicies = $.failoverRoutingPolicies;
        this.geolocationRoutingPolicies = $.geolocationRoutingPolicies;
        this.healthCheckId = $.healthCheckId;
        this.latencyRoutingPolicies = $.latencyRoutingPolicies;
        this.multivalueAnswerRoutingPolicy = $.multivalueAnswerRoutingPolicy;
        this.name = $.name;
        this.records = $.records;
        this.setIdentifier = $.setIdentifier;
        this.ttl = $.ttl;
        this.type = $.type;
        this.weightedRoutingPolicies = $.weightedRoutingPolicies;
        this.zoneId = $.zoneId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(RecordArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private RecordArgs $;

        public Builder() {
            $ = new RecordArgs();
        }

        public Builder(RecordArgs defaults) {
            $ = new RecordArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param aliases An alias block. Conflicts with `ttl` &amp; `records`.
         * Documented below.
         * 
         * @return builder
         * 
         */
        public Builder aliases(@Nullable Output<List<RecordAliasArgs>> aliases) {
            $.aliases = aliases;
            return this;
        }

        /**
         * @param aliases An alias block. Conflicts with `ttl` &amp; `records`.
         * Documented below.
         * 
         * @return builder
         * 
         */
        public Builder aliases(List<RecordAliasArgs> aliases) {
            return aliases(Output.of(aliases));
        }

        /**
         * @param aliases An alias block. Conflicts with `ttl` &amp; `records`.
         * Documented below.
         * 
         * @return builder
         * 
         */
        public Builder aliases(RecordAliasArgs... aliases) {
            return aliases(List.of(aliases));
        }

        /**
         * @param allowOverwrite Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
         * 
         * Exactly one of `records` or `alias` must be specified: this determines whether it&#39;s an alias record.
         * 
         * @return builder
         * 
         */
        public Builder allowOverwrite(@Nullable Output<Boolean> allowOverwrite) {
            $.allowOverwrite = allowOverwrite;
            return this;
        }

        /**
         * @param allowOverwrite Allow creation of this record to overwrite an existing record, if any. This does not affect the ability to update the record using this provider and does not prevent other resources within this provider or manual Route 53 changes outside this provider from overwriting this record. `false` by default. This configuration is not recommended for most environments.
         * 
         * Exactly one of `records` or `alias` must be specified: this determines whether it&#39;s an alias record.
         * 
         * @return builder
         * 
         */
        public Builder allowOverwrite(Boolean allowOverwrite) {
            return allowOverwrite(Output.of(allowOverwrite));
        }

        /**
         * @param cidrRoutingPolicy A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder cidrRoutingPolicy(@Nullable Output<RecordCidrRoutingPolicyArgs> cidrRoutingPolicy) {
            $.cidrRoutingPolicy = cidrRoutingPolicy;
            return this;
        }

        /**
         * @param cidrRoutingPolicy A block indicating a routing policy based on the IP network ranges of requestors. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder cidrRoutingPolicy(RecordCidrRoutingPolicyArgs cidrRoutingPolicy) {
            return cidrRoutingPolicy(Output.of(cidrRoutingPolicy));
        }

        /**
         * @param failoverRoutingPolicies A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder failoverRoutingPolicies(@Nullable Output<List<RecordFailoverRoutingPolicyArgs>> failoverRoutingPolicies) {
            $.failoverRoutingPolicies = failoverRoutingPolicies;
            return this;
        }

        /**
         * @param failoverRoutingPolicies A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder failoverRoutingPolicies(List<RecordFailoverRoutingPolicyArgs> failoverRoutingPolicies) {
            return failoverRoutingPolicies(Output.of(failoverRoutingPolicies));
        }

        /**
         * @param failoverRoutingPolicies A block indicating the routing behavior when associated health check fails. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder failoverRoutingPolicies(RecordFailoverRoutingPolicyArgs... failoverRoutingPolicies) {
            return failoverRoutingPolicies(List.of(failoverRoutingPolicies));
        }

        /**
         * @param geolocationRoutingPolicies A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder geolocationRoutingPolicies(@Nullable Output<List<RecordGeolocationRoutingPolicyArgs>> geolocationRoutingPolicies) {
            $.geolocationRoutingPolicies = geolocationRoutingPolicies;
            return this;
        }

        /**
         * @param geolocationRoutingPolicies A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder geolocationRoutingPolicies(List<RecordGeolocationRoutingPolicyArgs> geolocationRoutingPolicies) {
            return geolocationRoutingPolicies(Output.of(geolocationRoutingPolicies));
        }

        /**
         * @param geolocationRoutingPolicies A block indicating a routing policy based on the geolocation of the requestor. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder geolocationRoutingPolicies(RecordGeolocationRoutingPolicyArgs... geolocationRoutingPolicies) {
            return geolocationRoutingPolicies(List.of(geolocationRoutingPolicies));
        }

        /**
         * @param healthCheckId The health check the record should be associated with.
         * 
         * @return builder
         * 
         */
        public Builder healthCheckId(@Nullable Output<String> healthCheckId) {
            $.healthCheckId = healthCheckId;
            return this;
        }

        /**
         * @param healthCheckId The health check the record should be associated with.
         * 
         * @return builder
         * 
         */
        public Builder healthCheckId(String healthCheckId) {
            return healthCheckId(Output.of(healthCheckId));
        }

        /**
         * @param latencyRoutingPolicies A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder latencyRoutingPolicies(@Nullable Output<List<RecordLatencyRoutingPolicyArgs>> latencyRoutingPolicies) {
            $.latencyRoutingPolicies = latencyRoutingPolicies;
            return this;
        }

        /**
         * @param latencyRoutingPolicies A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder latencyRoutingPolicies(List<RecordLatencyRoutingPolicyArgs> latencyRoutingPolicies) {
            return latencyRoutingPolicies(Output.of(latencyRoutingPolicies));
        }

        /**
         * @param latencyRoutingPolicies A block indicating a routing policy based on the latency between the requestor and an AWS region. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder latencyRoutingPolicies(RecordLatencyRoutingPolicyArgs... latencyRoutingPolicies) {
            return latencyRoutingPolicies(List.of(latencyRoutingPolicies));
        }

        /**
         * @param multivalueAnswerRoutingPolicy Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
         * 
         * @return builder
         * 
         */
        public Builder multivalueAnswerRoutingPolicy(@Nullable Output<Boolean> multivalueAnswerRoutingPolicy) {
            $.multivalueAnswerRoutingPolicy = multivalueAnswerRoutingPolicy;
            return this;
        }

        /**
         * @param multivalueAnswerRoutingPolicy Set to `true` to indicate a multivalue answer routing policy. Conflicts with any other routing policy.
         * 
         * @return builder
         * 
         */
        public Builder multivalueAnswerRoutingPolicy(Boolean multivalueAnswerRoutingPolicy) {
            return multivalueAnswerRoutingPolicy(Output.of(multivalueAnswerRoutingPolicy));
        }

        /**
         * @param name The name of the record.
         * 
         * @return builder
         * 
         */
        public Builder name(Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the record.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param records A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\&#34;\&#34;` inside the provider configuration string (e.g., `&#34;first255characters\&#34;\&#34;morecharacters&#34;`).
         * 
         * @return builder
         * 
         */
        public Builder records(@Nullable Output<List<String>> records) {
            $.records = records;
            return this;
        }

        /**
         * @param records A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\&#34;\&#34;` inside the provider configuration string (e.g., `&#34;first255characters\&#34;\&#34;morecharacters&#34;`).
         * 
         * @return builder
         * 
         */
        public Builder records(List<String> records) {
            return records(Output.of(records));
        }

        /**
         * @param records A string list of records. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add `\&#34;\&#34;` inside the provider configuration string (e.g., `&#34;first255characters\&#34;\&#34;morecharacters&#34;`).
         * 
         * @return builder
         * 
         */
        public Builder records(String... records) {
            return records(List.of(records));
        }

        /**
         * @param setIdentifier Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
         * 
         * @return builder
         * 
         */
        public Builder setIdentifier(@Nullable Output<String> setIdentifier) {
            $.setIdentifier = setIdentifier;
            return this;
        }

        /**
         * @param setIdentifier Unique identifier to differentiate records with routing policies from one another. Required if using `cidr_routing_policy`, `failover_routing_policy`, `geolocation_routing_policy`, `latency_routing_policy`, `multivalue_answer_routing_policy`, or `weighted_routing_policy`.
         * 
         * @return builder
         * 
         */
        public Builder setIdentifier(String setIdentifier) {
            return setIdentifier(Output.of(setIdentifier));
        }

        /**
         * @param ttl The TTL of the record.
         * 
         * @return builder
         * 
         */
        public Builder ttl(@Nullable Output<Integer> ttl) {
            $.ttl = ttl;
            return this;
        }

        /**
         * @param ttl The TTL of the record.
         * 
         * @return builder
         * 
         */
        public Builder ttl(Integer ttl) {
            return ttl(Output.of(ttl));
        }

        /**
         * @param type The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
         * 
         * @return builder
         * 
         */
        public Builder type(Output<Either<String,RecordType>> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
         * 
         * @return builder
         * 
         */
        public Builder type(Either<String,RecordType> type) {
            return type(Output.of(type));
        }

        /**
         * @param type The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Either.ofLeft(type));
        }

        /**
         * @param type The record type. Valid values are `A`, `AAAA`, `CAA`, `CNAME`, `DS`, `MX`, `NAPTR`, `NS`, `PTR`, `SOA`, `SPF`, `SRV` and `TXT`.
         * 
         * @return builder
         * 
         */
        public Builder type(RecordType type) {
            return type(Either.ofRight(type));
        }

        /**
         * @param weightedRoutingPolicies A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder weightedRoutingPolicies(@Nullable Output<List<RecordWeightedRoutingPolicyArgs>> weightedRoutingPolicies) {
            $.weightedRoutingPolicies = weightedRoutingPolicies;
            return this;
        }

        /**
         * @param weightedRoutingPolicies A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder weightedRoutingPolicies(List<RecordWeightedRoutingPolicyArgs> weightedRoutingPolicies) {
            return weightedRoutingPolicies(Output.of(weightedRoutingPolicies));
        }

        /**
         * @param weightedRoutingPolicies A block indicating a weighted routing policy. Conflicts with any other routing policy. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder weightedRoutingPolicies(RecordWeightedRoutingPolicyArgs... weightedRoutingPolicies) {
            return weightedRoutingPolicies(List.of(weightedRoutingPolicies));
        }

        /**
         * @param zoneId The ID of the hosted zone to contain this record.
         * 
         * @return builder
         * 
         */
        public Builder zoneId(Output<String> zoneId) {
            $.zoneId = zoneId;
            return this;
        }

        /**
         * @param zoneId The ID of the hosted zone to contain this record.
         * 
         * @return builder
         * 
         */
        public Builder zoneId(String zoneId) {
            return zoneId(Output.of(zoneId));
        }

        public RecordArgs build() {
            $.name = Objects.requireNonNull($.name, "expected parameter 'name' to be non-null");
            $.type = Objects.requireNonNull($.type, "expected parameter 'type' to be non-null");
            $.zoneId = Objects.requireNonNull($.zoneId, "expected parameter 'zoneId' to be non-null");
            return $;
        }
    }

}
