// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.route53;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.route53.HealthCheckArgs;
import com.pulumi.aws.route53.inputs.HealthCheckState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a Route53 health check.
 * 
 * ## Example Usage
 * ### Connectivity and HTTP Status Code Check
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new HealthCheck(&#34;example&#34;, HealthCheckArgs.builder()        
 *             .failureThreshold(&#34;5&#34;)
 *             .fqdn(&#34;example.com&#34;)
 *             .port(80)
 *             .requestInterval(&#34;30&#34;)
 *             .resourcePath(&#34;/&#34;)
 *             .tags(Map.of(&#34;Name&#34;, &#34;tf-test-health-check&#34;))
 *             .type(&#34;HTTP&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Connectivity and String Matching Check
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new HealthCheck(&#34;example&#34;, HealthCheckArgs.builder()        
 *             .failureThreshold(&#34;5&#34;)
 *             .fqdn(&#34;example.com&#34;)
 *             .port(443)
 *             .requestInterval(&#34;30&#34;)
 *             .resourcePath(&#34;/&#34;)
 *             .searchString(&#34;example&#34;)
 *             .type(&#34;HTTPS_STR_MATCH&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Aggregate Check
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var parent = new HealthCheck(&#34;parent&#34;, HealthCheckArgs.builder()        
 *             .type(&#34;CALCULATED&#34;)
 *             .childHealthThreshold(1)
 *             .childHealthchecks(aws_route53_health_check.child().id())
 *             .tags(Map.of(&#34;Name&#34;, &#34;tf-test-calculated-health-check&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### CloudWatch Alarm Check
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.MetricAlarm;
 * import com.pulumi.aws.cloudwatch.MetricAlarmArgs;
 * import com.pulumi.aws.route53.HealthCheck;
 * import com.pulumi.aws.route53.HealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var foobar = new MetricAlarm(&#34;foobar&#34;, MetricAlarmArgs.builder()        
 *             .comparisonOperator(&#34;GreaterThanOrEqualToThreshold&#34;)
 *             .evaluationPeriods(&#34;2&#34;)
 *             .metricName(&#34;CPUUtilization&#34;)
 *             .namespace(&#34;AWS/EC2&#34;)
 *             .period(&#34;120&#34;)
 *             .statistic(&#34;Average&#34;)
 *             .threshold(&#34;80&#34;)
 *             .alarmDescription(&#34;This metric monitors ec2 cpu utilization&#34;)
 *             .build());
 * 
 *         var foo = new HealthCheck(&#34;foo&#34;, HealthCheckArgs.builder()        
 *             .type(&#34;CLOUDWATCH_METRIC&#34;)
 *             .cloudwatchAlarmName(foobar.name())
 *             .cloudwatchAlarmRegion(&#34;us-west-2&#34;)
 *             .insufficientDataHealthStatus(&#34;Healthy&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Route53 Health Checks using the health check `id`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:route53/healthCheck:HealthCheck http_check abcdef11-2222-3333-4444-555555fedcba
 * ```
 * 
 */
@ResourceType(type="aws:route53/healthCheck:HealthCheck")
public class HealthCheck extends com.pulumi.resources.CustomResource {
    /**
     * The Amazon Resource Name (ARN) of the Health Check.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of the Health Check.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
     * 
     */
    @Export(name="childHealthThreshold", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> childHealthThreshold;

    /**
     * @return The minimum number of child health checks that must be healthy for Route 53 to consider the parent health check to be healthy. Valid values are integers between 0 and 256, inclusive
     * 
     */
    public Output<Optional<Integer>> childHealthThreshold() {
        return Codegen.optional(this.childHealthThreshold);
    }
    /**
     * For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
     * 
     */
    @Export(name="childHealthchecks", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> childHealthchecks;

    /**
     * @return For a specified parent health check, a list of HealthCheckId values for the associated child health checks.
     * 
     */
    public Output<Optional<List<String>>> childHealthchecks() {
        return Codegen.optional(this.childHealthchecks);
    }
    /**
     * The name of the CloudWatch alarm.
     * 
     */
    @Export(name="cloudwatchAlarmName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> cloudwatchAlarmName;

    /**
     * @return The name of the CloudWatch alarm.
     * 
     */
    public Output<Optional<String>> cloudwatchAlarmName() {
        return Codegen.optional(this.cloudwatchAlarmName);
    }
    /**
     * The CloudWatchRegion that the CloudWatch alarm was created in.
     * 
     */
    @Export(name="cloudwatchAlarmRegion", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> cloudwatchAlarmRegion;

    /**
     * @return The CloudWatchRegion that the CloudWatch alarm was created in.
     * 
     */
    public Output<Optional<String>> cloudwatchAlarmRegion() {
        return Codegen.optional(this.cloudwatchAlarmRegion);
    }
    /**
     * A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
     * * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
     * * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
     * * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.
     * 
     * &gt; **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
     * 
     */
    @Export(name="disabled", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> disabled;

    /**
     * @return A boolean value that stops Route 53 from performing health checks. When set to true, Route 53 will do the following depending on the type of health check:
     * * For health checks that check the health of endpoints, Route5 53 stops submitting requests to your application, server, or other resource.
     * * For calculated health checks, Route 53 stops aggregating the status of the referenced health checks.
     * * For health checks that monitor CloudWatch alarms, Route 53 stops monitoring the corresponding CloudWatch metrics.
     * 
     * &gt; **Note:** After you disable a health check, Route 53 considers the status of the health check to always be healthy. If you configured DNS failover, Route 53 continues to route traffic to the corresponding resources. If you want to stop routing traffic to a resource, change the value of `invert_healthcheck`.
     * 
     */
    public Output<Optional<Boolean>> disabled() {
        return Codegen.optional(this.disabled);
    }
    /**
     * A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS&#39; defaults: when the `type` is &#34;HTTPS&#34; `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
     * 
     */
    @Export(name="enableSni", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> enableSni;

    /**
     * @return A boolean value that indicates whether Route53 should send the `fqdn` to the endpoint when performing the health check. This defaults to AWS&#39; defaults: when the `type` is &#34;HTTPS&#34; `enable_sni` defaults to `true`, when `type` is anything else `enable_sni` defaults to `false`.
     * 
     */
    public Output<Boolean> enableSni() {
        return this.enableSni;
    }
    /**
     * The number of consecutive health checks that an endpoint must pass or fail.
     * 
     */
    @Export(name="failureThreshold", refs={Integer.class}, tree="[0]")
    private Output<Integer> failureThreshold;

    /**
     * @return The number of consecutive health checks that an endpoint must pass or fail.
     * 
     */
    public Output<Integer> failureThreshold() {
        return this.failureThreshold;
    }
    /**
     * The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
     * 
     */
    @Export(name="fqdn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> fqdn;

    /**
     * @return The fully qualified domain name of the endpoint to be checked. If a value is set for `ip_address`, the value set for `fqdn` will be passed in the `Host` header.
     * 
     */
    public Output<Optional<String>> fqdn() {
        return Codegen.optional(this.fqdn);
    }
    /**
     * The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
     * 
     */
    @Export(name="insufficientDataHealthStatus", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> insufficientDataHealthStatus;

    /**
     * @return The status of the health check when CloudWatch has insufficient data about the state of associated alarm. Valid values are `Healthy` , `Unhealthy` and `LastKnownStatus`.
     * 
     */
    public Output<Optional<String>> insufficientDataHealthStatus() {
        return Codegen.optional(this.insufficientDataHealthStatus);
    }
    /**
     * A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
     * 
     */
    @Export(name="invertHealthcheck", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> invertHealthcheck;

    /**
     * @return A boolean value that indicates whether the status of health check should be inverted. For example, if a health check is healthy but Inverted is True , then Route 53 considers the health check to be unhealthy.
     * 
     */
    public Output<Optional<Boolean>> invertHealthcheck() {
        return Codegen.optional(this.invertHealthcheck);
    }
    /**
     * The IP address of the endpoint to be checked.
     * 
     */
    @Export(name="ipAddress", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> ipAddress;

    /**
     * @return The IP address of the endpoint to be checked.
     * 
     */
    public Output<Optional<String>> ipAddress() {
        return Codegen.optional(this.ipAddress);
    }
    /**
     * A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
     * 
     */
    @Export(name="measureLatency", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> measureLatency;

    /**
     * @return A Boolean value that indicates whether you want Route 53 to measure the latency between health checkers in multiple AWS regions and your endpoint and to display CloudWatch latency graphs in the Route 53 console.
     * 
     */
    public Output<Optional<Boolean>> measureLatency() {
        return Codegen.optional(this.measureLatency);
    }
    /**
     * The port of the endpoint to be checked.
     * 
     */
    @Export(name="port", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> port;

    /**
     * @return The port of the endpoint to be checked.
     * 
     */
    public Output<Optional<Integer>> port() {
        return Codegen.optional(this.port);
    }
    /**
     * This is a reference name used in Caller Reference
     * (helpful for identifying single health_check set amongst others)
     * 
     */
    @Export(name="referenceName", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> referenceName;

    /**
     * @return This is a reference name used in Caller Reference
     * (helpful for identifying single health_check set amongst others)
     * 
     */
    public Output<Optional<String>> referenceName() {
        return Codegen.optional(this.referenceName);
    }
    /**
     * A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
     * 
     */
    @Export(name="regions", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> regions;

    /**
     * @return A list of AWS regions that you want Amazon Route 53 health checkers to check the specified endpoint from.
     * 
     */
    public Output<Optional<List<String>>> regions() {
        return Codegen.optional(this.regions);
    }
    /**
     * The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
     * 
     */
    @Export(name="requestInterval", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> requestInterval;

    /**
     * @return The number of seconds between the time that Amazon Route 53 gets a response from your endpoint and the time that it sends the next health-check request.
     * 
     */
    public Output<Optional<Integer>> requestInterval() {
        return Codegen.optional(this.requestInterval);
    }
    /**
     * The path that you want Amazon Route 53 to request when performing health checks.
     * 
     */
    @Export(name="resourcePath", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> resourcePath;

    /**
     * @return The path that you want Amazon Route 53 to request when performing health checks.
     * 
     */
    public Output<Optional<String>> resourcePath() {
        return Codegen.optional(this.resourcePath);
    }
    /**
     * The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
     * 
     */
    @Export(name="routingControlArn", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> routingControlArn;

    /**
     * @return The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller routing control. This is used when health check type is `RECOVERY_CONTROL`
     * 
     */
    public Output<Optional<String>> routingControlArn() {
        return Codegen.optional(this.routingControlArn);
    }
    /**
     * String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
     * 
     */
    @Export(name="searchString", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> searchString;

    /**
     * @return String searched in the first 5120 bytes of the response body for check to be considered healthy. Only valid with `HTTP_STR_MATCH` and `HTTPS_STR_MATCH`.
     * 
     */
    public Output<Optional<String>> searchString() {
        return Codegen.optional(this.searchString);
    }
    /**
     * A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the health check. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }
    /**
     * The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
     * 
     */
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output<String> type;

    /**
     * @return The protocol to use when performing health checks. Valid values are `HTTP`, `HTTPS`, `HTTP_STR_MATCH`, `HTTPS_STR_MATCH`, `TCP`, `CALCULATED`, `CLOUDWATCH_METRIC` and `RECOVERY_CONTROL`.
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public HealthCheck(String name) {
        this(name, HealthCheckArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public HealthCheck(String name, HealthCheckArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public HealthCheck(String name, HealthCheckArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:route53/healthCheck:HealthCheck", name, args == null ? HealthCheckArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private HealthCheck(String name, Output<String> id, @Nullable HealthCheckState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:route53/healthCheck:HealthCheck", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static HealthCheck get(String name, Output<String> id, @Nullable HealthCheckState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new HealthCheck(name, id, state, options);
    }
}
