// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.resourceexplorer;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.resourceexplorer.ViewArgs;
import com.pulumi.aws.resourceexplorer.inputs.ViewState;
import com.pulumi.aws.resourceexplorer.outputs.ViewFilters;
import com.pulumi.aws.resourceexplorer.outputs.ViewIncludedProperty;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Provides a resource to manage a Resource Explorer view.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.resourceexplorer.Index;
 * import com.pulumi.aws.resourceexplorer.IndexArgs;
 * import com.pulumi.aws.resourceexplorer.View;
 * import com.pulumi.aws.resourceexplorer.ViewArgs;
 * import com.pulumi.aws.resourceexplorer.inputs.ViewFiltersArgs;
 * import com.pulumi.aws.resourceexplorer.inputs.ViewIncludedPropertyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleIndex = new Index(&#34;exampleIndex&#34;, IndexArgs.builder()        
 *             .type(&#34;LOCAL&#34;)
 *             .build());
 * 
 *         var exampleView = new View(&#34;exampleView&#34;, ViewArgs.builder()        
 *             .filters(ViewFiltersArgs.builder()
 *                 .filterString(&#34;resourcetype:ec2:instance&#34;)
 *                 .build())
 *             .includedProperties(ViewIncludedPropertyArgs.builder()
 *                 .name(&#34;tags&#34;)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleIndex)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Resource Explorer views using the `arn`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:resourceexplorer/view:View example arn:aws:resource-explorer-2:us-west-2:123456789012:view/exampleview/e0914f6c-6c27-4b47-b5d4-6b28381a2421
 * ```
 * 
 */
@ResourceType(type="aws:resourceexplorer/view:View")
public class View extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of the Resource Explorer view.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the Resource Explorer view.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * Specifies whether the view is the [_default view_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-about.html#manage-views-about-default) for the AWS Region. Default: `false`.
     * 
     */
    @Export(name="defaultView", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> defaultView;

    /**
     * @return Specifies whether the view is the [_default view_](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views-about.html#manage-views-about-default) for the AWS Region. Default: `false`.
     * 
     */
    public Output<Boolean> defaultView() {
        return this.defaultView;
    }
    /**
     * Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
     * 
     */
    @Export(name="filters", refs={ViewFilters.class}, tree="[0]")
    private Output</* @Nullable */ ViewFilters> filters;

    /**
     * @return Specifies which resources are included in the results of queries made using this view. See Filters below for more details.
     * 
     */
    public Output<Optional<ViewFilters>> filters() {
        return Codegen.optional(this.filters);
    }
    /**
     * Optional fields to be included in search results from this view. See Included Properties below for more details.
     * 
     */
    @Export(name="includedProperties", refs={List.class,ViewIncludedProperty.class}, tree="[0,1]")
    private Output</* @Nullable */ List<ViewIncludedProperty>> includedProperties;

    /**
     * @return Optional fields to be included in search results from this view. See Included Properties below for more details.
     * 
     */
    public Output<Optional<List<ViewIncludedProperty>>> includedProperties() {
        return Codegen.optional(this.includedProperties);
    }
    /**
     * The name of the view. The name must be no more than 64 characters long, and can include letters, digits, and the dash (-) character. The name must be unique within its AWS Region.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the view. The name must be no more than 64 characters long, and can include letters, digits, and the dash (-) character. The name must be unique within its AWS Region.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public View(String name) {
        this(name, ViewArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public View(String name, @Nullable ViewArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public View(String name, @Nullable ViewArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:resourceexplorer/view:View", name, args == null ? ViewArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private View(String name, Output<String> id, @Nullable ViewState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:resourceexplorer/view:View", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static View get(String name, Output<String> id, @Nullable ViewState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new View(name, id, state, options);
    }
}
