// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshiftserverless.inputs;

import com.pulumi.aws.redshiftserverless.inputs.EndpointAccessVpcEndpointArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class EndpointAccessState extends com.pulumi.resources.ResourceArgs {

    public static final EndpointAccessState Empty = new EndpointAccessState();

    /**
     * The DNS address of the VPC endpoint.
     * 
     */
    @Import(name="address")
    private @Nullable Output<String> address;

    /**
     * @return The DNS address of the VPC endpoint.
     * 
     */
    public Optional<Output<String>> address() {
        return Optional.ofNullable(this.address);
    }

    /**
     * Amazon Resource Name (ARN) of the Redshift Serverless Endpoint Access.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the Redshift Serverless Endpoint Access.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The name of the endpoint.
     * 
     */
    @Import(name="endpointName")
    private @Nullable Output<String> endpointName;

    /**
     * @return The name of the endpoint.
     * 
     */
    public Optional<Output<String>> endpointName() {
        return Optional.ofNullable(this.endpointName);
    }

    /**
     * The port that Amazon Redshift Serverless listens on.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return The port that Amazon Redshift Serverless listens on.
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * An array of VPC subnet IDs to associate with the endpoint.
     * 
     */
    @Import(name="subnetIds")
    private @Nullable Output<List<String>> subnetIds;

    /**
     * @return An array of VPC subnet IDs to associate with the endpoint.
     * 
     */
    public Optional<Output<List<String>>> subnetIds() {
        return Optional.ofNullable(this.subnetIds);
    }

    /**
     * The VPC endpoint or the Redshift Serverless workgroup. See `VPC Endpoint` below.
     * 
     */
    @Import(name="vpcEndpoints")
    private @Nullable Output<List<EndpointAccessVpcEndpointArgs>> vpcEndpoints;

    /**
     * @return The VPC endpoint or the Redshift Serverless workgroup. See `VPC Endpoint` below.
     * 
     */
    public Optional<Output<List<EndpointAccessVpcEndpointArgs>>> vpcEndpoints() {
        return Optional.ofNullable(this.vpcEndpoints);
    }

    /**
     * An array of security group IDs to associate with the workgroup.
     * 
     */
    @Import(name="vpcSecurityGroupIds")
    private @Nullable Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return An array of security group IDs to associate with the workgroup.
     * 
     */
    public Optional<Output<List<String>>> vpcSecurityGroupIds() {
        return Optional.ofNullable(this.vpcSecurityGroupIds);
    }

    /**
     * The name of the workgroup.
     * 
     */
    @Import(name="workgroupName")
    private @Nullable Output<String> workgroupName;

    /**
     * @return The name of the workgroup.
     * 
     */
    public Optional<Output<String>> workgroupName() {
        return Optional.ofNullable(this.workgroupName);
    }

    private EndpointAccessState() {}

    private EndpointAccessState(EndpointAccessState $) {
        this.address = $.address;
        this.arn = $.arn;
        this.endpointName = $.endpointName;
        this.port = $.port;
        this.subnetIds = $.subnetIds;
        this.vpcEndpoints = $.vpcEndpoints;
        this.vpcSecurityGroupIds = $.vpcSecurityGroupIds;
        this.workgroupName = $.workgroupName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EndpointAccessState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointAccessState $;

        public Builder() {
            $ = new EndpointAccessState();
        }

        public Builder(EndpointAccessState defaults) {
            $ = new EndpointAccessState(Objects.requireNonNull(defaults));
        }

        /**
         * @param address The DNS address of the VPC endpoint.
         * 
         * @return builder
         * 
         */
        public Builder address(@Nullable Output<String> address) {
            $.address = address;
            return this;
        }

        /**
         * @param address The DNS address of the VPC endpoint.
         * 
         * @return builder
         * 
         */
        public Builder address(String address) {
            return address(Output.of(address));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the Redshift Serverless Endpoint Access.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of the Redshift Serverless Endpoint Access.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param endpointName The name of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder endpointName(@Nullable Output<String> endpointName) {
            $.endpointName = endpointName;
            return this;
        }

        /**
         * @param endpointName The name of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder endpointName(String endpointName) {
            return endpointName(Output.of(endpointName));
        }

        /**
         * @param port The port that Amazon Redshift Serverless listens on.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port The port that Amazon Redshift Serverless listens on.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param subnetIds An array of VPC subnet IDs to associate with the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(@Nullable Output<List<String>> subnetIds) {
            $.subnetIds = subnetIds;
            return this;
        }

        /**
         * @param subnetIds An array of VPC subnet IDs to associate with the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(List<String> subnetIds) {
            return subnetIds(Output.of(subnetIds));
        }

        /**
         * @param subnetIds An array of VPC subnet IDs to associate with the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder subnetIds(String... subnetIds) {
            return subnetIds(List.of(subnetIds));
        }

        /**
         * @param vpcEndpoints The VPC endpoint or the Redshift Serverless workgroup. See `VPC Endpoint` below.
         * 
         * @return builder
         * 
         */
        public Builder vpcEndpoints(@Nullable Output<List<EndpointAccessVpcEndpointArgs>> vpcEndpoints) {
            $.vpcEndpoints = vpcEndpoints;
            return this;
        }

        /**
         * @param vpcEndpoints The VPC endpoint or the Redshift Serverless workgroup. See `VPC Endpoint` below.
         * 
         * @return builder
         * 
         */
        public Builder vpcEndpoints(List<EndpointAccessVpcEndpointArgs> vpcEndpoints) {
            return vpcEndpoints(Output.of(vpcEndpoints));
        }

        /**
         * @param vpcEndpoints The VPC endpoint or the Redshift Serverless workgroup. See `VPC Endpoint` below.
         * 
         * @return builder
         * 
         */
        public Builder vpcEndpoints(EndpointAccessVpcEndpointArgs... vpcEndpoints) {
            return vpcEndpoints(List.of(vpcEndpoints));
        }

        /**
         * @param vpcSecurityGroupIds An array of security group IDs to associate with the workgroup.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(@Nullable Output<List<String>> vpcSecurityGroupIds) {
            $.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * @param vpcSecurityGroupIds An array of security group IDs to associate with the workgroup.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(Output.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSecurityGroupIds An array of security group IDs to associate with the workgroup.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        /**
         * @param workgroupName The name of the workgroup.
         * 
         * @return builder
         * 
         */
        public Builder workgroupName(@Nullable Output<String> workgroupName) {
            $.workgroupName = workgroupName;
            return this;
        }

        /**
         * @param workgroupName The name of the workgroup.
         * 
         * @return builder
         * 
         */
        public Builder workgroupName(String workgroupName) {
            return workgroupName(Output.of(workgroupName));
        }

        public EndpointAccessState build() {
            return $;
        }
    }

}
