// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshiftserverless;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.redshiftserverless.SnapshotArgs;
import com.pulumi.aws.redshiftserverless.inputs.SnapshotState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Creates a new Amazon Redshift Serverless Snapshot.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Snapshot;
 * import com.pulumi.aws.redshiftserverless.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new Snapshot(&#34;example&#34;, SnapshotArgs.builder()        
 *             .namespaceName(aws_redshiftserverless_workgroup.example().namespace_name())
 *             .snapshotName(&#34;example&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Redshift Serverless Snapshots using the `snapshot_name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:redshiftserverless/snapshot:Snapshot example example
 * ```
 * 
 */
@ResourceType(type="aws:redshiftserverless/snapshot:Snapshot")
public class Snapshot extends com.pulumi.resources.CustomResource {
    /**
     * All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
     * 
     */
    @Export(name="accountsWithProvisionedRestoreAccesses", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> accountsWithProvisionedRestoreAccesses;

    /**
     * @return All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
     * 
     */
    public Output<List<String>> accountsWithProvisionedRestoreAccesses() {
        return this.accountsWithProvisionedRestoreAccesses;
    }
    /**
     * All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
     * 
     */
    @Export(name="accountsWithRestoreAccesses", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> accountsWithRestoreAccesses;

    /**
     * @return All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
     * 
     */
    public Output<List<String>> accountsWithRestoreAccesses() {
        return this.accountsWithRestoreAccesses;
    }
    /**
     * The username of the database within a snapshot.
     * 
     */
    @Export(name="adminUsername", refs={String.class}, tree="[0]")
    private Output<String> adminUsername;

    /**
     * @return The username of the database within a snapshot.
     * 
     */
    public Output<String> adminUsername() {
        return this.adminUsername;
    }
    /**
     * The Amazon Resource Name (ARN) of the snapshot.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) of the snapshot.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The unique identifier of the KMS key used to encrypt the snapshot.
     * 
     */
    @Export(name="kmsKeyId", refs={String.class}, tree="[0]")
    private Output<String> kmsKeyId;

    /**
     * @return The unique identifier of the KMS key used to encrypt the snapshot.
     * 
     */
    public Output<String> kmsKeyId() {
        return this.kmsKeyId;
    }
    /**
     * The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
     * 
     */
    @Export(name="namespaceArn", refs={String.class}, tree="[0]")
    private Output<String> namespaceArn;

    /**
     * @return The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
     * 
     */
    public Output<String> namespaceArn() {
        return this.namespaceArn;
    }
    /**
     * The namespace to create a snapshot for.
     * 
     */
    @Export(name="namespaceName", refs={String.class}, tree="[0]")
    private Output<String> namespaceName;

    /**
     * @return The namespace to create a snapshot for.
     * 
     */
    public Output<String> namespaceName() {
        return this.namespaceName;
    }
    /**
     * The owner Amazon Web Services; account of the snapshot.
     * 
     */
    @Export(name="ownerAccount", refs={String.class}, tree="[0]")
    private Output<String> ownerAccount;

    /**
     * @return The owner Amazon Web Services; account of the snapshot.
     * 
     */
    public Output<String> ownerAccount() {
        return this.ownerAccount;
    }
    /**
     * How long to retain the created snapshot. Default value is `-1`.
     * 
     */
    @Export(name="retentionPeriod", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> retentionPeriod;

    /**
     * @return How long to retain the created snapshot. Default value is `-1`.
     * 
     */
    public Output<Optional<Integer>> retentionPeriod() {
        return Codegen.optional(this.retentionPeriod);
    }
    /**
     * The name of the snapshot.
     * 
     */
    @Export(name="snapshotName", refs={String.class}, tree="[0]")
    private Output<String> snapshotName;

    /**
     * @return The name of the snapshot.
     * 
     */
    public Output<String> snapshotName() {
        return this.snapshotName;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Snapshot(String name) {
        this(name, SnapshotArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Snapshot(String name, SnapshotArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Snapshot(String name, SnapshotArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:redshiftserverless/snapshot:Snapshot", name, args == null ? SnapshotArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Snapshot(String name, Output<String> id, @Nullable SnapshotState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:redshiftserverless/snapshot:Snapshot", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Snapshot get(String name, Output<String> id, @Nullable SnapshotState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Snapshot(name, id, state, options);
    }
}
