// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class GetClusterCredentialsArgs extends com.pulumi.resources.InvokeArgs {

    public static final GetClusterCredentialsArgs Empty = new GetClusterCredentialsArgs();

    /**
     * Create a database user with the name specified for the user named in `db_user` if one does not exist.
     * 
     */
    @Import(name="autoCreate")
    private @Nullable Output<Boolean> autoCreate;

    /**
     * @return Create a database user with the name specified for the user named in `db_user` if one does not exist.
     * 
     */
    public Optional<Output<Boolean>> autoCreate() {
        return Optional.ofNullable(this.autoCreate);
    }

    /**
     * Unique identifier of the cluster that contains the database for which your are requesting credentials.
     * 
     */
    @Import(name="clusterIdentifier", required=true)
    private Output<String> clusterIdentifier;

    /**
     * @return Unique identifier of the cluster that contains the database for which your are requesting credentials.
     * 
     */
    public Output<String> clusterIdentifier() {
        return this.clusterIdentifier;
    }

    /**
     * List of the names of existing database groups that the user named in `db_user` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to `PUBLIC`.
     * 
     */
    @Import(name="dbGroups")
    private @Nullable Output<List<String>> dbGroups;

    /**
     * @return List of the names of existing database groups that the user named in `db_user` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to `PUBLIC`.
     * 
     */
    public Optional<Output<List<String>>> dbGroups() {
        return Optional.ofNullable(this.dbGroups);
    }

    /**
     * Name of a database that DbUser is authorized to log on to. If `db_name` is not specified, `db_user` can log on to any existing database.
     * 
     */
    @Import(name="dbName")
    private @Nullable Output<String> dbName;

    /**
     * @return Name of a database that DbUser is authorized to log on to. If `db_name` is not specified, `db_user` can log on to any existing database.
     * 
     */
    public Optional<Output<String>> dbName() {
        return Optional.ofNullable(this.dbName);
    }

    /**
     * Name of a database user. If a user name matching `db_user` exists in the database, the temporary user credentials have the same permissions as the  existing user. If `db_user` doesn&#39;t exist in the database and `auto_create` is `True`, a new user is created using the value for `db_user` with `PUBLIC` permissions.  If a database user matching the value for `db_user` doesn&#39;t exist and `not` is `False`, then the command succeeds but the connection attempt will fail because the user doesn&#39;t exist in the database.
     * 
     */
    @Import(name="dbUser", required=true)
    private Output<String> dbUser;

    /**
     * @return Name of a database user. If a user name matching `db_user` exists in the database, the temporary user credentials have the same permissions as the  existing user. If `db_user` doesn&#39;t exist in the database and `auto_create` is `True`, a new user is created using the value for `db_user` with `PUBLIC` permissions.  If a database user matching the value for `db_user` doesn&#39;t exist and `not` is `False`, then the command succeeds but the connection attempt will fail because the user doesn&#39;t exist in the database.
     * 
     */
    public Output<String> dbUser() {
        return this.dbUser;
    }

    /**
     * The number of seconds until the returned temporary password expires. Valid values are between `900` and `3600`. Default value is `900`.
     * 
     */
    @Import(name="durationSeconds")
    private @Nullable Output<Integer> durationSeconds;

    /**
     * @return The number of seconds until the returned temporary password expires. Valid values are between `900` and `3600`. Default value is `900`.
     * 
     */
    public Optional<Output<Integer>> durationSeconds() {
        return Optional.ofNullable(this.durationSeconds);
    }

    private GetClusterCredentialsArgs() {}

    private GetClusterCredentialsArgs(GetClusterCredentialsArgs $) {
        this.autoCreate = $.autoCreate;
        this.clusterIdentifier = $.clusterIdentifier;
        this.dbGroups = $.dbGroups;
        this.dbName = $.dbName;
        this.dbUser = $.dbUser;
        this.durationSeconds = $.durationSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GetClusterCredentialsArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private GetClusterCredentialsArgs $;

        public Builder() {
            $ = new GetClusterCredentialsArgs();
        }

        public Builder(GetClusterCredentialsArgs defaults) {
            $ = new GetClusterCredentialsArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param autoCreate Create a database user with the name specified for the user named in `db_user` if one does not exist.
         * 
         * @return builder
         * 
         */
        public Builder autoCreate(@Nullable Output<Boolean> autoCreate) {
            $.autoCreate = autoCreate;
            return this;
        }

        /**
         * @param autoCreate Create a database user with the name specified for the user named in `db_user` if one does not exist.
         * 
         * @return builder
         * 
         */
        public Builder autoCreate(Boolean autoCreate) {
            return autoCreate(Output.of(autoCreate));
        }

        /**
         * @param clusterIdentifier Unique identifier of the cluster that contains the database for which your are requesting credentials.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier Unique identifier of the cluster that contains the database for which your are requesting credentials.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param dbGroups List of the names of existing database groups that the user named in `db_user` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to `PUBLIC`.
         * 
         * @return builder
         * 
         */
        public Builder dbGroups(@Nullable Output<List<String>> dbGroups) {
            $.dbGroups = dbGroups;
            return this;
        }

        /**
         * @param dbGroups List of the names of existing database groups that the user named in `db_user` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to `PUBLIC`.
         * 
         * @return builder
         * 
         */
        public Builder dbGroups(List<String> dbGroups) {
            return dbGroups(Output.of(dbGroups));
        }

        /**
         * @param dbGroups List of the names of existing database groups that the user named in `db_user` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to `PUBLIC`.
         * 
         * @return builder
         * 
         */
        public Builder dbGroups(String... dbGroups) {
            return dbGroups(List.of(dbGroups));
        }

        /**
         * @param dbName Name of a database that DbUser is authorized to log on to. If `db_name` is not specified, `db_user` can log on to any existing database.
         * 
         * @return builder
         * 
         */
        public Builder dbName(@Nullable Output<String> dbName) {
            $.dbName = dbName;
            return this;
        }

        /**
         * @param dbName Name of a database that DbUser is authorized to log on to. If `db_name` is not specified, `db_user` can log on to any existing database.
         * 
         * @return builder
         * 
         */
        public Builder dbName(String dbName) {
            return dbName(Output.of(dbName));
        }

        /**
         * @param dbUser Name of a database user. If a user name matching `db_user` exists in the database, the temporary user credentials have the same permissions as the  existing user. If `db_user` doesn&#39;t exist in the database and `auto_create` is `True`, a new user is created using the value for `db_user` with `PUBLIC` permissions.  If a database user matching the value for `db_user` doesn&#39;t exist and `not` is `False`, then the command succeeds but the connection attempt will fail because the user doesn&#39;t exist in the database.
         * 
         * @return builder
         * 
         */
        public Builder dbUser(Output<String> dbUser) {
            $.dbUser = dbUser;
            return this;
        }

        /**
         * @param dbUser Name of a database user. If a user name matching `db_user` exists in the database, the temporary user credentials have the same permissions as the  existing user. If `db_user` doesn&#39;t exist in the database and `auto_create` is `True`, a new user is created using the value for `db_user` with `PUBLIC` permissions.  If a database user matching the value for `db_user` doesn&#39;t exist and `not` is `False`, then the command succeeds but the connection attempt will fail because the user doesn&#39;t exist in the database.
         * 
         * @return builder
         * 
         */
        public Builder dbUser(String dbUser) {
            return dbUser(Output.of(dbUser));
        }

        /**
         * @param durationSeconds The number of seconds until the returned temporary password expires. Valid values are between `900` and `3600`. Default value is `900`.
         * 
         * @return builder
         * 
         */
        public Builder durationSeconds(@Nullable Output<Integer> durationSeconds) {
            $.durationSeconds = durationSeconds;
            return this;
        }

        /**
         * @param durationSeconds The number of seconds until the returned temporary password expires. Valid values are between `900` and `3600`. Default value is `900`.
         * 
         * @return builder
         * 
         */
        public Builder durationSeconds(Integer durationSeconds) {
            return durationSeconds(Output.of(durationSeconds));
        }

        public GetClusterCredentialsArgs build() {
            $.clusterIdentifier = Objects.requireNonNull($.clusterIdentifier, "expected parameter 'clusterIdentifier' to be non-null");
            $.dbUser = Objects.requireNonNull($.dbUser, "expected parameter 'dbUser' to be non-null");
            return $;
        }
    }

}
