// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class EndpointAuthorizationState extends com.pulumi.resources.ResourceArgs {

    public static final EndpointAuthorizationState Empty = new EndpointAuthorizationState();

    /**
     * The Amazon Web Services account ID to grant access to.
     * 
     */
    @Import(name="account")
    private @Nullable Output<String> account;

    /**
     * @return The Amazon Web Services account ID to grant access to.
     * 
     */
    public Optional<Output<String>> account() {
        return Optional.ofNullable(this.account);
    }

    /**
     * Indicates whether all VPCs in the grantee account are allowed access to the cluster.
     * 
     */
    @Import(name="allowedAllVpcs")
    private @Nullable Output<Boolean> allowedAllVpcs;

    /**
     * @return Indicates whether all VPCs in the grantee account are allowed access to the cluster.
     * 
     */
    public Optional<Output<Boolean>> allowedAllVpcs() {
        return Optional.ofNullable(this.allowedAllVpcs);
    }

    /**
     * The cluster identifier of the cluster to grant access to.
     * 
     */
    @Import(name="clusterIdentifier")
    private @Nullable Output<String> clusterIdentifier;

    /**
     * @return The cluster identifier of the cluster to grant access to.
     * 
     */
    public Optional<Output<String>> clusterIdentifier() {
        return Optional.ofNullable(this.clusterIdentifier);
    }

    /**
     * The number of Redshift-managed VPC endpoints created for the authorization.
     * 
     */
    @Import(name="endpointCount")
    private @Nullable Output<Integer> endpointCount;

    /**
     * @return The number of Redshift-managed VPC endpoints created for the authorization.
     * 
     */
    public Optional<Output<Integer>> endpointCount() {
        return Optional.ofNullable(this.endpointCount);
    }

    /**
     * Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
     * 
     */
    @Import(name="forceDelete")
    private @Nullable Output<Boolean> forceDelete;

    /**
     * @return Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
     * 
     */
    public Optional<Output<Boolean>> forceDelete() {
        return Optional.ofNullable(this.forceDelete);
    }

    /**
     * The Amazon Web Services account ID of the grantee of the cluster.
     * 
     */
    @Import(name="grantee")
    private @Nullable Output<String> grantee;

    /**
     * @return The Amazon Web Services account ID of the grantee of the cluster.
     * 
     */
    public Optional<Output<String>> grantee() {
        return Optional.ofNullable(this.grantee);
    }

    /**
     * The Amazon Web Services account ID of the cluster owner.
     * 
     */
    @Import(name="grantor")
    private @Nullable Output<String> grantor;

    /**
     * @return The Amazon Web Services account ID of the cluster owner.
     * 
     */
    public Optional<Output<String>> grantor() {
        return Optional.ofNullable(this.grantor);
    }

    /**
     * The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
     * 
     */
    @Import(name="vpcIds")
    private @Nullable Output<List<String>> vpcIds;

    /**
     * @return The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
     * 
     */
    public Optional<Output<List<String>>> vpcIds() {
        return Optional.ofNullable(this.vpcIds);
    }

    private EndpointAuthorizationState() {}

    private EndpointAuthorizationState(EndpointAuthorizationState $) {
        this.account = $.account;
        this.allowedAllVpcs = $.allowedAllVpcs;
        this.clusterIdentifier = $.clusterIdentifier;
        this.endpointCount = $.endpointCount;
        this.forceDelete = $.forceDelete;
        this.grantee = $.grantee;
        this.grantor = $.grantor;
        this.vpcIds = $.vpcIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EndpointAuthorizationState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointAuthorizationState $;

        public Builder() {
            $ = new EndpointAuthorizationState();
        }

        public Builder(EndpointAuthorizationState defaults) {
            $ = new EndpointAuthorizationState(Objects.requireNonNull(defaults));
        }

        /**
         * @param account The Amazon Web Services account ID to grant access to.
         * 
         * @return builder
         * 
         */
        public Builder account(@Nullable Output<String> account) {
            $.account = account;
            return this;
        }

        /**
         * @param account The Amazon Web Services account ID to grant access to.
         * 
         * @return builder
         * 
         */
        public Builder account(String account) {
            return account(Output.of(account));
        }

        /**
         * @param allowedAllVpcs Indicates whether all VPCs in the grantee account are allowed access to the cluster.
         * 
         * @return builder
         * 
         */
        public Builder allowedAllVpcs(@Nullable Output<Boolean> allowedAllVpcs) {
            $.allowedAllVpcs = allowedAllVpcs;
            return this;
        }

        /**
         * @param allowedAllVpcs Indicates whether all VPCs in the grantee account are allowed access to the cluster.
         * 
         * @return builder
         * 
         */
        public Builder allowedAllVpcs(Boolean allowedAllVpcs) {
            return allowedAllVpcs(Output.of(allowedAllVpcs));
        }

        /**
         * @param clusterIdentifier The cluster identifier of the cluster to grant access to.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(@Nullable Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier The cluster identifier of the cluster to grant access to.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param endpointCount The number of Redshift-managed VPC endpoints created for the authorization.
         * 
         * @return builder
         * 
         */
        public Builder endpointCount(@Nullable Output<Integer> endpointCount) {
            $.endpointCount = endpointCount;
            return this;
        }

        /**
         * @param endpointCount The number of Redshift-managed VPC endpoints created for the authorization.
         * 
         * @return builder
         * 
         */
        public Builder endpointCount(Integer endpointCount) {
            return endpointCount(Output.of(endpointCount));
        }

        /**
         * @param forceDelete Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
         * 
         * @return builder
         * 
         */
        public Builder forceDelete(@Nullable Output<Boolean> forceDelete) {
            $.forceDelete = forceDelete;
            return this;
        }

        /**
         * @param forceDelete Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Default value is `false`.
         * 
         * @return builder
         * 
         */
        public Builder forceDelete(Boolean forceDelete) {
            return forceDelete(Output.of(forceDelete));
        }

        /**
         * @param grantee The Amazon Web Services account ID of the grantee of the cluster.
         * 
         * @return builder
         * 
         */
        public Builder grantee(@Nullable Output<String> grantee) {
            $.grantee = grantee;
            return this;
        }

        /**
         * @param grantee The Amazon Web Services account ID of the grantee of the cluster.
         * 
         * @return builder
         * 
         */
        public Builder grantee(String grantee) {
            return grantee(Output.of(grantee));
        }

        /**
         * @param grantor The Amazon Web Services account ID of the cluster owner.
         * 
         * @return builder
         * 
         */
        public Builder grantor(@Nullable Output<String> grantor) {
            $.grantor = grantor;
            return this;
        }

        /**
         * @param grantor The Amazon Web Services account ID of the cluster owner.
         * 
         * @return builder
         * 
         */
        public Builder grantor(String grantor) {
            return grantor(Output.of(grantor));
        }

        /**
         * @param vpcIds The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
         * 
         * @return builder
         * 
         */
        public Builder vpcIds(@Nullable Output<List<String>> vpcIds) {
            $.vpcIds = vpcIds;
            return this;
        }

        /**
         * @param vpcIds The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
         * 
         * @return builder
         * 
         */
        public Builder vpcIds(List<String> vpcIds) {
            return vpcIds(Output.of(vpcIds));
        }

        /**
         * @param vpcIds The virtual private cloud (VPC) identifiers to grant access to. If none are specified all VPCs in shared account are allowed.
         * 
         * @return builder
         * 
         */
        public Builder vpcIds(String... vpcIds) {
            return vpcIds(List.of(vpcIds));
        }

        public EndpointAuthorizationState build() {
            return $;
        }
    }

}
