// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift.inputs;

import com.pulumi.aws.redshift.inputs.EndpointAccessVpcEndpointArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class EndpointAccessState extends com.pulumi.resources.ResourceArgs {

    public static final EndpointAccessState Empty = new EndpointAccessState();

    /**
     * The DNS address of the endpoint.
     * 
     */
    @Import(name="address")
    private @Nullable Output<String> address;

    /**
     * @return The DNS address of the endpoint.
     * 
     */
    public Optional<Output<String>> address() {
        return Optional.ofNullable(this.address);
    }

    /**
     * The cluster identifier of the cluster to access.
     * 
     */
    @Import(name="clusterIdentifier")
    private @Nullable Output<String> clusterIdentifier;

    /**
     * @return The cluster identifier of the cluster to access.
     * 
     */
    public Optional<Output<String>> clusterIdentifier() {
        return Optional.ofNullable(this.clusterIdentifier);
    }

    /**
     * The Redshift-managed VPC endpoint name.
     * 
     */
    @Import(name="endpointName")
    private @Nullable Output<String> endpointName;

    /**
     * @return The Redshift-managed VPC endpoint name.
     * 
     */
    public Optional<Output<String>> endpointName() {
        return Optional.ofNullable(this.endpointName);
    }

    /**
     * The port number on which the cluster accepts incoming connections.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return The port number on which the cluster accepts incoming connections.
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
     * 
     */
    @Import(name="resourceOwner")
    private @Nullable Output<String> resourceOwner;

    /**
     * @return The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
     * 
     */
    public Optional<Output<String>> resourceOwner() {
        return Optional.ofNullable(this.resourceOwner);
    }

    /**
     * The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
     * 
     */
    @Import(name="subnetGroupName")
    private @Nullable Output<String> subnetGroupName;

    /**
     * @return The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
     * 
     */
    public Optional<Output<String>> subnetGroupName() {
        return Optional.ofNullable(this.subnetGroupName);
    }

    /**
     * The connection endpoint for connecting to an Amazon Redshift cluster through the proxy. See details below.
     * 
     */
    @Import(name="vpcEndpoints")
    private @Nullable Output<List<EndpointAccessVpcEndpointArgs>> vpcEndpoints;

    /**
     * @return The connection endpoint for connecting to an Amazon Redshift cluster through the proxy. See details below.
     * 
     */
    public Optional<Output<List<EndpointAccessVpcEndpointArgs>>> vpcEndpoints() {
        return Optional.ofNullable(this.vpcEndpoints);
    }

    /**
     * The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     * 
     */
    @Import(name="vpcSecurityGroupIds")
    private @Nullable Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     * 
     */
    public Optional<Output<List<String>>> vpcSecurityGroupIds() {
        return Optional.ofNullable(this.vpcSecurityGroupIds);
    }

    private EndpointAccessState() {}

    private EndpointAccessState(EndpointAccessState $) {
        this.address = $.address;
        this.clusterIdentifier = $.clusterIdentifier;
        this.endpointName = $.endpointName;
        this.port = $.port;
        this.resourceOwner = $.resourceOwner;
        this.subnetGroupName = $.subnetGroupName;
        this.vpcEndpoints = $.vpcEndpoints;
        this.vpcSecurityGroupIds = $.vpcSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EndpointAccessState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointAccessState $;

        public Builder() {
            $ = new EndpointAccessState();
        }

        public Builder(EndpointAccessState defaults) {
            $ = new EndpointAccessState(Objects.requireNonNull(defaults));
        }

        /**
         * @param address The DNS address of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder address(@Nullable Output<String> address) {
            $.address = address;
            return this;
        }

        /**
         * @param address The DNS address of the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder address(String address) {
            return address(Output.of(address));
        }

        /**
         * @param clusterIdentifier The cluster identifier of the cluster to access.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(@Nullable Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier The cluster identifier of the cluster to access.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param endpointName The Redshift-managed VPC endpoint name.
         * 
         * @return builder
         * 
         */
        public Builder endpointName(@Nullable Output<String> endpointName) {
            $.endpointName = endpointName;
            return this;
        }

        /**
         * @param endpointName The Redshift-managed VPC endpoint name.
         * 
         * @return builder
         * 
         */
        public Builder endpointName(String endpointName) {
            return endpointName(Output.of(endpointName));
        }

        /**
         * @param port The port number on which the cluster accepts incoming connections.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port The port number on which the cluster accepts incoming connections.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param resourceOwner The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
         * 
         * @return builder
         * 
         */
        public Builder resourceOwner(@Nullable Output<String> resourceOwner) {
            $.resourceOwner = resourceOwner;
            return this;
        }

        /**
         * @param resourceOwner The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
         * 
         * @return builder
         * 
         */
        public Builder resourceOwner(String resourceOwner) {
            return resourceOwner(Output.of(resourceOwner));
        }

        /**
         * @param subnetGroupName The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder subnetGroupName(@Nullable Output<String> subnetGroupName) {
            $.subnetGroupName = subnetGroupName;
            return this;
        }

        /**
         * @param subnetGroupName The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
         * 
         * @return builder
         * 
         */
        public Builder subnetGroupName(String subnetGroupName) {
            return subnetGroupName(Output.of(subnetGroupName));
        }

        /**
         * @param vpcEndpoints The connection endpoint for connecting to an Amazon Redshift cluster through the proxy. See details below.
         * 
         * @return builder
         * 
         */
        public Builder vpcEndpoints(@Nullable Output<List<EndpointAccessVpcEndpointArgs>> vpcEndpoints) {
            $.vpcEndpoints = vpcEndpoints;
            return this;
        }

        /**
         * @param vpcEndpoints The connection endpoint for connecting to an Amazon Redshift cluster through the proxy. See details below.
         * 
         * @return builder
         * 
         */
        public Builder vpcEndpoints(List<EndpointAccessVpcEndpointArgs> vpcEndpoints) {
            return vpcEndpoints(Output.of(vpcEndpoints));
        }

        /**
         * @param vpcEndpoints The connection endpoint for connecting to an Amazon Redshift cluster through the proxy. See details below.
         * 
         * @return builder
         * 
         */
        public Builder vpcEndpoints(EndpointAccessVpcEndpointArgs... vpcEndpoints) {
            return vpcEndpoints(List.of(vpcEndpoints));
        }

        /**
         * @param vpcSecurityGroupIds The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(@Nullable Output<List<String>> vpcSecurityGroupIds) {
            $.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * @param vpcSecurityGroupIds The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(Output.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSecurityGroupIds The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        public EndpointAccessState build() {
            return $;
        }
    }

}
