// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift.inputs;

import com.pulumi.aws.redshift.inputs.ClusterClusterNodeArgs;
import com.pulumi.aws.redshift.inputs.ClusterLoggingArgs;
import com.pulumi.aws.redshift.inputs.ClusterSnapshotCopyArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterState extends com.pulumi.resources.ResourceArgs {

    public static final ClusterState Empty = new ClusterState();

    /**
     * If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
     * 
     */
    @Import(name="allowVersionUpgrade")
    private @Nullable Output<Boolean> allowVersionUpgrade;

    /**
     * @return If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> allowVersionUpgrade() {
        return Optional.ofNullable(this.allowVersionUpgrade);
    }

    /**
     * Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
     * 
     */
    @Import(name="applyImmediately")
    private @Nullable Output<Boolean> applyImmediately;

    /**
     * @return Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> applyImmediately() {
        return Optional.ofNullable(this.applyImmediately);
    }

    /**
     * The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
     * No longer supported by the AWS API.
     * Always returns `auto`.
     * 
     * @deprecated
     * This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.
     * 
     */
    @Deprecated /* This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider. */
    @Import(name="aquaConfigurationStatus")
    private @Nullable Output<String> aquaConfigurationStatus;

    /**
     * @return The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
     * No longer supported by the AWS API.
     * Always returns `auto`.
     * 
     * @deprecated
     * This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.
     * 
     */
    @Deprecated /* This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider. */
    public Optional<Output<String>> aquaConfigurationStatus() {
        return Optional.ofNullable(this.aquaConfigurationStatus);
    }

    /**
     * Amazon Resource Name (ARN) of cluster
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of cluster
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
     * 
     */
    @Import(name="automatedSnapshotRetentionPeriod")
    private @Nullable Output<Integer> automatedSnapshotRetentionPeriod;

    /**
     * @return The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
     * 
     */
    public Optional<Output<Integer>> automatedSnapshotRetentionPeriod() {
        return Optional.ofNullable(this.automatedSnapshotRetentionPeriod);
    }

    /**
     * The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    /**
     * If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
     * 
     */
    @Import(name="availabilityZoneRelocationEnabled")
    private @Nullable Output<Boolean> availabilityZoneRelocationEnabled;

    /**
     * @return If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
     * 
     */
    public Optional<Output<Boolean>> availabilityZoneRelocationEnabled() {
        return Optional.ofNullable(this.availabilityZoneRelocationEnabled);
    }

    /**
     * The Cluster Identifier. Must be a lower case string.
     * 
     */
    @Import(name="clusterIdentifier")
    private @Nullable Output<String> clusterIdentifier;

    /**
     * @return The Cluster Identifier. Must be a lower case string.
     * 
     */
    public Optional<Output<String>> clusterIdentifier() {
        return Optional.ofNullable(this.clusterIdentifier);
    }

    /**
     * The namespace Amazon Resource Name (ARN) of the cluster
     * 
     */
    @Import(name="clusterNamespaceArn")
    private @Nullable Output<String> clusterNamespaceArn;

    /**
     * @return The namespace Amazon Resource Name (ARN) of the cluster
     * 
     */
    public Optional<Output<String>> clusterNamespaceArn() {
        return Optional.ofNullable(this.clusterNamespaceArn);
    }

    /**
     * The nodes in the cluster. Cluster node blocks are documented below
     * 
     */
    @Import(name="clusterNodes")
    private @Nullable Output<List<ClusterClusterNodeArgs>> clusterNodes;

    /**
     * @return The nodes in the cluster. Cluster node blocks are documented below
     * 
     */
    public Optional<Output<List<ClusterClusterNodeArgs>>> clusterNodes() {
        return Optional.ofNullable(this.clusterNodes);
    }

    /**
     * The name of the parameter group to be associated with this cluster.
     * 
     */
    @Import(name="clusterParameterGroupName")
    private @Nullable Output<String> clusterParameterGroupName;

    /**
     * @return The name of the parameter group to be associated with this cluster.
     * 
     */
    public Optional<Output<String>> clusterParameterGroupName() {
        return Optional.ofNullable(this.clusterParameterGroupName);
    }

    /**
     * The public key for the cluster
     * 
     */
    @Import(name="clusterPublicKey")
    private @Nullable Output<String> clusterPublicKey;

    /**
     * @return The public key for the cluster
     * 
     */
    public Optional<Output<String>> clusterPublicKey() {
        return Optional.ofNullable(this.clusterPublicKey);
    }

    /**
     * The specific revision number of the database in the cluster
     * 
     */
    @Import(name="clusterRevisionNumber")
    private @Nullable Output<String> clusterRevisionNumber;

    /**
     * @return The specific revision number of the database in the cluster
     * 
     */
    public Optional<Output<String>> clusterRevisionNumber() {
        return Optional.ofNullable(this.clusterRevisionNumber);
    }

    /**
     * The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
     * 
     */
    @Import(name="clusterSubnetGroupName")
    private @Nullable Output<String> clusterSubnetGroupName;

    /**
     * @return The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
     * 
     */
    public Optional<Output<String>> clusterSubnetGroupName() {
        return Optional.ofNullable(this.clusterSubnetGroupName);
    }

    /**
     * The cluster type to use. Either `single-node` or `multi-node`.
     * 
     */
    @Import(name="clusterType")
    private @Nullable Output<String> clusterType;

    /**
     * @return The cluster type to use. Either `single-node` or `multi-node`.
     * 
     */
    public Optional<Output<String>> clusterType() {
        return Optional.ofNullable(this.clusterType);
    }

    /**
     * The version of the Amazon Redshift engine software that you want to deploy on the cluster.
     * The version selected runs on all the nodes in the cluster.
     * 
     */
    @Import(name="clusterVersion")
    private @Nullable Output<String> clusterVersion;

    /**
     * @return The version of the Amazon Redshift engine software that you want to deploy on the cluster.
     * The version selected runs on all the nodes in the cluster.
     * 
     */
    public Optional<Output<String>> clusterVersion() {
        return Optional.ofNullable(this.clusterVersion);
    }

    /**
     * The name of the first database to be created when the cluster is created.
     * If you do not provide a name, Amazon Redshift will create a default database called `dev`.
     * 
     */
    @Import(name="databaseName")
    private @Nullable Output<String> databaseName;

    /**
     * @return The name of the first database to be created when the cluster is created.
     * If you do not provide a name, Amazon Redshift will create a default database called `dev`.
     * 
     */
    public Optional<Output<String>> databaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    /**
     * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
     * 
     */
    @Import(name="defaultIamRoleArn")
    private @Nullable Output<String> defaultIamRoleArn;

    /**
     * @return The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
     * 
     */
    public Optional<Output<String>> defaultIamRoleArn() {
        return Optional.ofNullable(this.defaultIamRoleArn);
    }

    /**
     * The DNS name of the cluster
     * 
     */
    @Import(name="dnsName")
    private @Nullable Output<String> dnsName;

    /**
     * @return The DNS name of the cluster
     * 
     */
    public Optional<Output<String>> dnsName() {
        return Optional.ofNullable(this.dnsName);
    }

    /**
     * The Elastic IP (EIP) address for the cluster.
     * 
     */
    @Import(name="elasticIp")
    private @Nullable Output<String> elasticIp;

    /**
     * @return The Elastic IP (EIP) address for the cluster.
     * 
     */
    public Optional<Output<String>> elasticIp() {
        return Optional.ofNullable(this.elasticIp);
    }

    /**
     * If true , the data in the cluster is encrypted at rest.
     * 
     */
    @Import(name="encrypted")
    private @Nullable Output<Boolean> encrypted;

    /**
     * @return If true , the data in the cluster is encrypted at rest.
     * 
     */
    public Optional<Output<Boolean>> encrypted() {
        return Optional.ofNullable(this.encrypted);
    }

    /**
     * The connection endpoint
     * 
     */
    @Import(name="endpoint")
    private @Nullable Output<String> endpoint;

    /**
     * @return The connection endpoint
     * 
     */
    public Optional<Output<String>> endpoint() {
        return Optional.ofNullable(this.endpoint);
    }

    /**
     * If true , enhanced VPC routing is enabled.
     * 
     */
    @Import(name="enhancedVpcRouting")
    private @Nullable Output<Boolean> enhancedVpcRouting;

    /**
     * @return If true , enhanced VPC routing is enabled.
     * 
     */
    public Optional<Output<Boolean>> enhancedVpcRouting() {
        return Optional.ofNullable(this.enhancedVpcRouting);
    }

    /**
     * The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
     * 
     */
    @Import(name="finalSnapshotIdentifier")
    private @Nullable Output<String> finalSnapshotIdentifier;

    /**
     * @return The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
     * 
     */
    public Optional<Output<String>> finalSnapshotIdentifier() {
        return Optional.ofNullable(this.finalSnapshotIdentifier);
    }

    /**
     * A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     * 
     */
    @Import(name="iamRoles")
    private @Nullable Output<List<String>> iamRoles;

    /**
     * @return A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
     * 
     */
    public Optional<Output<List<String>>> iamRoles() {
        return Optional.ofNullable(this.iamRoles);
    }

    /**
     * The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * Logging, documented below.
     * 
     */
    @Import(name="logging")
    private @Nullable Output<ClusterLoggingArgs> logging;

    /**
     * @return Logging, documented below.
     * 
     */
    public Optional<Output<ClusterLoggingArgs>> logging() {
        return Optional.ofNullable(this.logging);
    }

    /**
     * The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
     * 
     */
    @Import(name="maintenanceTrackName")
    private @Nullable Output<String> maintenanceTrackName;

    /**
     * @return The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
     * 
     */
    public Optional<Output<String>> maintenanceTrackName() {
        return Optional.ofNullable(this.maintenanceTrackName);
    }

    /**
     * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn&#39;t change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
     * 
     */
    @Import(name="manualSnapshotRetentionPeriod")
    private @Nullable Output<Integer> manualSnapshotRetentionPeriod;

    /**
     * @return The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn&#39;t change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
     * 
     */
    public Optional<Output<Integer>> manualSnapshotRetentionPeriod() {
        return Optional.ofNullable(this.manualSnapshotRetentionPeriod);
    }

    /**
     * Password for the master DB user.
     * Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
     * contain at least one uppercase letter, one lowercase letter, and one number.
     * 
     */
    @Import(name="masterPassword")
    private @Nullable Output<String> masterPassword;

    /**
     * @return Password for the master DB user.
     * Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
     * contain at least one uppercase letter, one lowercase letter, and one number.
     * 
     */
    public Optional<Output<String>> masterPassword() {
        return Optional.ofNullable(this.masterPassword);
    }

    /**
     * Username for the master DB user.
     * 
     */
    @Import(name="masterUsername")
    private @Nullable Output<String> masterUsername;

    /**
     * @return Username for the master DB user.
     * 
     */
    public Optional<Output<String>> masterUsername() {
        return Optional.ofNullable(this.masterUsername);
    }

    /**
     * The node type to be provisioned for the cluster.
     * 
     */
    @Import(name="nodeType")
    private @Nullable Output<String> nodeType;

    /**
     * @return The node type to be provisioned for the cluster.
     * 
     */
    public Optional<Output<String>> nodeType() {
        return Optional.ofNullable(this.nodeType);
    }

    /**
     * The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
     * 
     */
    @Import(name="numberOfNodes")
    private @Nullable Output<Integer> numberOfNodes;

    /**
     * @return The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
     * 
     */
    public Optional<Output<Integer>> numberOfNodes() {
        return Optional.ofNullable(this.numberOfNodes);
    }

    /**
     * The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
     * 
     */
    @Import(name="ownerAccount")
    private @Nullable Output<String> ownerAccount;

    /**
     * @return The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
     * 
     */
    public Optional<Output<String>> ownerAccount() {
        return Optional.ofNullable(this.ownerAccount);
    }

    /**
     * The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
     * The cluster is accessible only via the JDBC and ODBC connection strings.
     * Part of the connection string requires the port on which the cluster will listen for incoming connections.
     * Default port is `5439`.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
     * The cluster is accessible only via the JDBC and ODBC connection strings.
     * Part of the connection string requires the port on which the cluster will listen for incoming connections.
     * Default port is `5439`.
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * The weekly time range (in UTC) during which automated cluster maintenance can occur.
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * 
     */
    @Import(name="preferredMaintenanceWindow")
    private @Nullable Output<String> preferredMaintenanceWindow;

    /**
     * @return The weekly time range (in UTC) during which automated cluster maintenance can occur.
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * 
     */
    public Optional<Output<String>> preferredMaintenanceWindow() {
        return Optional.ofNullable(this.preferredMaintenanceWindow);
    }

    /**
     * If true, the cluster can be accessed from a public network. Default is `true`.
     * 
     */
    @Import(name="publiclyAccessible")
    private @Nullable Output<Boolean> publiclyAccessible;

    /**
     * @return If true, the cluster can be accessed from a public network. Default is `true`.
     * 
     */
    public Optional<Output<Boolean>> publiclyAccessible() {
        return Optional.ofNullable(this.publiclyAccessible);
    }

    /**
     * Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
     * 
     */
    @Import(name="skipFinalSnapshot")
    private @Nullable Output<Boolean> skipFinalSnapshot;

    /**
     * @return Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
     * 
     */
    public Optional<Output<Boolean>> skipFinalSnapshot() {
        return Optional.ofNullable(this.skipFinalSnapshot);
    }

    /**
     * The name of the cluster the source snapshot was created from.
     * 
     */
    @Import(name="snapshotClusterIdentifier")
    private @Nullable Output<String> snapshotClusterIdentifier;

    /**
     * @return The name of the cluster the source snapshot was created from.
     * 
     */
    public Optional<Output<String>> snapshotClusterIdentifier() {
        return Optional.ofNullable(this.snapshotClusterIdentifier);
    }

    /**
     * Configuration of automatic copy of snapshots from one region to another. Documented below.
     * 
     */
    @Import(name="snapshotCopy")
    private @Nullable Output<ClusterSnapshotCopyArgs> snapshotCopy;

    /**
     * @return Configuration of automatic copy of snapshots from one region to another. Documented below.
     * 
     */
    public Optional<Output<ClusterSnapshotCopyArgs>> snapshotCopy() {
        return Optional.ofNullable(this.snapshotCopy);
    }

    /**
     * The name of the snapshot from which to create the new cluster.
     * 
     */
    @Import(name="snapshotIdentifier")
    private @Nullable Output<String> snapshotIdentifier;

    /**
     * @return The name of the snapshot from which to create the new cluster.
     * 
     */
    public Optional<Output<String>> snapshotIdentifier() {
        return Optional.ofNullable(this.snapshotIdentifier);
    }

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     * 
     */
    @Import(name="vpcSecurityGroupIds")
    private @Nullable Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     * 
     */
    public Optional<Output<List<String>>> vpcSecurityGroupIds() {
        return Optional.ofNullable(this.vpcSecurityGroupIds);
    }

    private ClusterState() {}

    private ClusterState(ClusterState $) {
        this.allowVersionUpgrade = $.allowVersionUpgrade;
        this.applyImmediately = $.applyImmediately;
        this.aquaConfigurationStatus = $.aquaConfigurationStatus;
        this.arn = $.arn;
        this.automatedSnapshotRetentionPeriod = $.automatedSnapshotRetentionPeriod;
        this.availabilityZone = $.availabilityZone;
        this.availabilityZoneRelocationEnabled = $.availabilityZoneRelocationEnabled;
        this.clusterIdentifier = $.clusterIdentifier;
        this.clusterNamespaceArn = $.clusterNamespaceArn;
        this.clusterNodes = $.clusterNodes;
        this.clusterParameterGroupName = $.clusterParameterGroupName;
        this.clusterPublicKey = $.clusterPublicKey;
        this.clusterRevisionNumber = $.clusterRevisionNumber;
        this.clusterSubnetGroupName = $.clusterSubnetGroupName;
        this.clusterType = $.clusterType;
        this.clusterVersion = $.clusterVersion;
        this.databaseName = $.databaseName;
        this.defaultIamRoleArn = $.defaultIamRoleArn;
        this.dnsName = $.dnsName;
        this.elasticIp = $.elasticIp;
        this.encrypted = $.encrypted;
        this.endpoint = $.endpoint;
        this.enhancedVpcRouting = $.enhancedVpcRouting;
        this.finalSnapshotIdentifier = $.finalSnapshotIdentifier;
        this.iamRoles = $.iamRoles;
        this.kmsKeyId = $.kmsKeyId;
        this.logging = $.logging;
        this.maintenanceTrackName = $.maintenanceTrackName;
        this.manualSnapshotRetentionPeriod = $.manualSnapshotRetentionPeriod;
        this.masterPassword = $.masterPassword;
        this.masterUsername = $.masterUsername;
        this.nodeType = $.nodeType;
        this.numberOfNodes = $.numberOfNodes;
        this.ownerAccount = $.ownerAccount;
        this.port = $.port;
        this.preferredMaintenanceWindow = $.preferredMaintenanceWindow;
        this.publiclyAccessible = $.publiclyAccessible;
        this.skipFinalSnapshot = $.skipFinalSnapshot;
        this.snapshotClusterIdentifier = $.snapshotClusterIdentifier;
        this.snapshotCopy = $.snapshotCopy;
        this.snapshotIdentifier = $.snapshotIdentifier;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.vpcSecurityGroupIds = $.vpcSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterState $;

        public Builder() {
            $ = new ClusterState();
        }

        public Builder(ClusterState defaults) {
            $ = new ClusterState(Objects.requireNonNull(defaults));
        }

        /**
         * @param allowVersionUpgrade If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder allowVersionUpgrade(@Nullable Output<Boolean> allowVersionUpgrade) {
            $.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        /**
         * @param allowVersionUpgrade If true , major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            return allowVersionUpgrade(Output.of(allowVersionUpgrade));
        }

        /**
         * @param applyImmediately Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(@Nullable Output<Boolean> applyImmediately) {
            $.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * @param applyImmediately Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(Boolean applyImmediately) {
            return applyImmediately(Output.of(applyImmediately));
        }

        /**
         * @param aquaConfigurationStatus The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
         * No longer supported by the AWS API.
         * Always returns `auto`.
         * 
         * @return builder
         * 
         * @deprecated
         * This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.
         * 
         */
        @Deprecated /* This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider. */
        public Builder aquaConfigurationStatus(@Nullable Output<String> aquaConfigurationStatus) {
            $.aquaConfigurationStatus = aquaConfigurationStatus;
            return this;
        }

        /**
         * @param aquaConfigurationStatus The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored.
         * No longer supported by the AWS API.
         * Always returns `auto`.
         * 
         * @return builder
         * 
         * @deprecated
         * This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider.
         * 
         */
        @Deprecated /* This parameter is no longer supported by the AWS API. It will be removed in the next major version of the provider. */
        public Builder aquaConfigurationStatus(String aquaConfigurationStatus) {
            return aquaConfigurationStatus(Output.of(aquaConfigurationStatus));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of cluster
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of cluster
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param automatedSnapshotRetentionPeriod The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
         * 
         * @return builder
         * 
         */
        public Builder automatedSnapshotRetentionPeriod(@Nullable Output<Integer> automatedSnapshotRetentionPeriod) {
            $.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        /**
         * @param automatedSnapshotRetentionPeriod The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with create-cluster-snapshot. Default is 1.
         * 
         * @return builder
         * 
         */
        public Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            return automatedSnapshotRetentionPeriod(Output.of(automatedSnapshotRetentionPeriod));
        }

        /**
         * @param availabilityZone The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency. Can only be changed if `availability_zone_relocation_enabled` is `true`.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        /**
         * @param availabilityZoneRelocationEnabled If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZoneRelocationEnabled(@Nullable Output<Boolean> availabilityZoneRelocationEnabled) {
            $.availabilityZoneRelocationEnabled = availabilityZoneRelocationEnabled;
            return this;
        }

        /**
         * @param availabilityZoneRelocationEnabled If true, the cluster can be relocated to another availabity zone, either automatically by AWS or when requested. Default is `false`. Available for use on clusters from the RA3 instance family.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZoneRelocationEnabled(Boolean availabilityZoneRelocationEnabled) {
            return availabilityZoneRelocationEnabled(Output.of(availabilityZoneRelocationEnabled));
        }

        /**
         * @param clusterIdentifier The Cluster Identifier. Must be a lower case string.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(@Nullable Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier The Cluster Identifier. Must be a lower case string.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param clusterNamespaceArn The namespace Amazon Resource Name (ARN) of the cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterNamespaceArn(@Nullable Output<String> clusterNamespaceArn) {
            $.clusterNamespaceArn = clusterNamespaceArn;
            return this;
        }

        /**
         * @param clusterNamespaceArn The namespace Amazon Resource Name (ARN) of the cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterNamespaceArn(String clusterNamespaceArn) {
            return clusterNamespaceArn(Output.of(clusterNamespaceArn));
        }

        /**
         * @param clusterNodes The nodes in the cluster. Cluster node blocks are documented below
         * 
         * @return builder
         * 
         */
        public Builder clusterNodes(@Nullable Output<List<ClusterClusterNodeArgs>> clusterNodes) {
            $.clusterNodes = clusterNodes;
            return this;
        }

        /**
         * @param clusterNodes The nodes in the cluster. Cluster node blocks are documented below
         * 
         * @return builder
         * 
         */
        public Builder clusterNodes(List<ClusterClusterNodeArgs> clusterNodes) {
            return clusterNodes(Output.of(clusterNodes));
        }

        /**
         * @param clusterNodes The nodes in the cluster. Cluster node blocks are documented below
         * 
         * @return builder
         * 
         */
        public Builder clusterNodes(ClusterClusterNodeArgs... clusterNodes) {
            return clusterNodes(List.of(clusterNodes));
        }

        /**
         * @param clusterParameterGroupName The name of the parameter group to be associated with this cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterParameterGroupName(@Nullable Output<String> clusterParameterGroupName) {
            $.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        /**
         * @param clusterParameterGroupName The name of the parameter group to be associated with this cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterParameterGroupName(String clusterParameterGroupName) {
            return clusterParameterGroupName(Output.of(clusterParameterGroupName));
        }

        /**
         * @param clusterPublicKey The public key for the cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterPublicKey(@Nullable Output<String> clusterPublicKey) {
            $.clusterPublicKey = clusterPublicKey;
            return this;
        }

        /**
         * @param clusterPublicKey The public key for the cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterPublicKey(String clusterPublicKey) {
            return clusterPublicKey(Output.of(clusterPublicKey));
        }

        /**
         * @param clusterRevisionNumber The specific revision number of the database in the cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterRevisionNumber(@Nullable Output<String> clusterRevisionNumber) {
            $.clusterRevisionNumber = clusterRevisionNumber;
            return this;
        }

        /**
         * @param clusterRevisionNumber The specific revision number of the database in the cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterRevisionNumber(String clusterRevisionNumber) {
            return clusterRevisionNumber(Output.of(clusterRevisionNumber));
        }

        /**
         * @param clusterSubnetGroupName The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
         * 
         * @return builder
         * 
         */
        public Builder clusterSubnetGroupName(@Nullable Output<String> clusterSubnetGroupName) {
            $.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        /**
         * @param clusterSubnetGroupName The name of a cluster subnet group to be associated with this cluster. If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).
         * 
         * @return builder
         * 
         */
        public Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            return clusterSubnetGroupName(Output.of(clusterSubnetGroupName));
        }

        /**
         * @param clusterType The cluster type to use. Either `single-node` or `multi-node`.
         * 
         * @return builder
         * 
         */
        public Builder clusterType(@Nullable Output<String> clusterType) {
            $.clusterType = clusterType;
            return this;
        }

        /**
         * @param clusterType The cluster type to use. Either `single-node` or `multi-node`.
         * 
         * @return builder
         * 
         */
        public Builder clusterType(String clusterType) {
            return clusterType(Output.of(clusterType));
        }

        /**
         * @param clusterVersion The version of the Amazon Redshift engine software that you want to deploy on the cluster.
         * The version selected runs on all the nodes in the cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterVersion(@Nullable Output<String> clusterVersion) {
            $.clusterVersion = clusterVersion;
            return this;
        }

        /**
         * @param clusterVersion The version of the Amazon Redshift engine software that you want to deploy on the cluster.
         * The version selected runs on all the nodes in the cluster.
         * 
         * @return builder
         * 
         */
        public Builder clusterVersion(String clusterVersion) {
            return clusterVersion(Output.of(clusterVersion));
        }

        /**
         * @param databaseName The name of the first database to be created when the cluster is created.
         * If you do not provide a name, Amazon Redshift will create a default database called `dev`.
         * 
         * @return builder
         * 
         */
        public Builder databaseName(@Nullable Output<String> databaseName) {
            $.databaseName = databaseName;
            return this;
        }

        /**
         * @param databaseName The name of the first database to be created when the cluster is created.
         * If you do not provide a name, Amazon Redshift will create a default database called `dev`.
         * 
         * @return builder
         * 
         */
        public Builder databaseName(String databaseName) {
            return databaseName(Output.of(databaseName));
        }

        /**
         * @param defaultIamRoleArn The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
         * 
         * @return builder
         * 
         */
        public Builder defaultIamRoleArn(@Nullable Output<String> defaultIamRoleArn) {
            $.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        /**
         * @param defaultIamRoleArn The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created.
         * 
         * @return builder
         * 
         */
        public Builder defaultIamRoleArn(String defaultIamRoleArn) {
            return defaultIamRoleArn(Output.of(defaultIamRoleArn));
        }

        /**
         * @param dnsName The DNS name of the cluster
         * 
         * @return builder
         * 
         */
        public Builder dnsName(@Nullable Output<String> dnsName) {
            $.dnsName = dnsName;
            return this;
        }

        /**
         * @param dnsName The DNS name of the cluster
         * 
         * @return builder
         * 
         */
        public Builder dnsName(String dnsName) {
            return dnsName(Output.of(dnsName));
        }

        /**
         * @param elasticIp The Elastic IP (EIP) address for the cluster.
         * 
         * @return builder
         * 
         */
        public Builder elasticIp(@Nullable Output<String> elasticIp) {
            $.elasticIp = elasticIp;
            return this;
        }

        /**
         * @param elasticIp The Elastic IP (EIP) address for the cluster.
         * 
         * @return builder
         * 
         */
        public Builder elasticIp(String elasticIp) {
            return elasticIp(Output.of(elasticIp));
        }

        /**
         * @param encrypted If true , the data in the cluster is encrypted at rest.
         * 
         * @return builder
         * 
         */
        public Builder encrypted(@Nullable Output<Boolean> encrypted) {
            $.encrypted = encrypted;
            return this;
        }

        /**
         * @param encrypted If true , the data in the cluster is encrypted at rest.
         * 
         * @return builder
         * 
         */
        public Builder encrypted(Boolean encrypted) {
            return encrypted(Output.of(encrypted));
        }

        /**
         * @param endpoint The connection endpoint
         * 
         * @return builder
         * 
         */
        public Builder endpoint(@Nullable Output<String> endpoint) {
            $.endpoint = endpoint;
            return this;
        }

        /**
         * @param endpoint The connection endpoint
         * 
         * @return builder
         * 
         */
        public Builder endpoint(String endpoint) {
            return endpoint(Output.of(endpoint));
        }

        /**
         * @param enhancedVpcRouting If true , enhanced VPC routing is enabled.
         * 
         * @return builder
         * 
         */
        public Builder enhancedVpcRouting(@Nullable Output<Boolean> enhancedVpcRouting) {
            $.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        /**
         * @param enhancedVpcRouting If true , enhanced VPC routing is enabled.
         * 
         * @return builder
         * 
         */
        public Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            return enhancedVpcRouting(Output.of(enhancedVpcRouting));
        }

        /**
         * @param finalSnapshotIdentifier The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotIdentifier(@Nullable Output<String> finalSnapshotIdentifier) {
            $.finalSnapshotIdentifier = finalSnapshotIdentifier;
            return this;
        }

        /**
         * @param finalSnapshotIdentifier The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, `skip_final_snapshot` must be false.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotIdentifier(String finalSnapshotIdentifier) {
            return finalSnapshotIdentifier(Output.of(finalSnapshotIdentifier));
        }

        /**
         * @param iamRoles A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
         * 
         * @return builder
         * 
         */
        public Builder iamRoles(@Nullable Output<List<String>> iamRoles) {
            $.iamRoles = iamRoles;
            return this;
        }

        /**
         * @param iamRoles A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
         * 
         * @return builder
         * 
         */
        public Builder iamRoles(List<String> iamRoles) {
            return iamRoles(Output.of(iamRoles));
        }

        /**
         * @param iamRoles A list of IAM Role ARNs to associate with the cluster. A Maximum of 10 can be associated to the cluster at any time.
         * 
         * @return builder
         * 
         */
        public Builder iamRoles(String... iamRoles) {
            return iamRoles(List.of(iamRoles));
        }

        /**
         * @param kmsKeyId The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param logging Logging, documented below.
         * 
         * @return builder
         * 
         */
        public Builder logging(@Nullable Output<ClusterLoggingArgs> logging) {
            $.logging = logging;
            return this;
        }

        /**
         * @param logging Logging, documented below.
         * 
         * @return builder
         * 
         */
        public Builder logging(ClusterLoggingArgs logging) {
            return logging(Output.of(logging));
        }

        /**
         * @param maintenanceTrackName The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
         * 
         * @return builder
         * 
         */
        public Builder maintenanceTrackName(@Nullable Output<String> maintenanceTrackName) {
            $.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        /**
         * @param maintenanceTrackName The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of  a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Default value is `current`.
         * 
         * @return builder
         * 
         */
        public Builder maintenanceTrackName(String maintenanceTrackName) {
            return maintenanceTrackName(Output.of(maintenanceTrackName));
        }

        /**
         * @param manualSnapshotRetentionPeriod The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn&#39;t change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
         * 
         * @return builder
         * 
         */
        public Builder manualSnapshotRetentionPeriod(@Nullable Output<Integer> manualSnapshotRetentionPeriod) {
            $.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        /**
         * @param manualSnapshotRetentionPeriod The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn&#39;t change the retention period of existing snapshots. Valid values are between `-1` and `3653`. Default value is `-1`.
         * 
         * @return builder
         * 
         */
        public Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            return manualSnapshotRetentionPeriod(Output.of(manualSnapshotRetentionPeriod));
        }

        /**
         * @param masterPassword Password for the master DB user.
         * Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
         * contain at least one uppercase letter, one lowercase letter, and one number.
         * 
         * @return builder
         * 
         */
        public Builder masterPassword(@Nullable Output<String> masterPassword) {
            $.masterPassword = masterPassword;
            return this;
        }

        /**
         * @param masterPassword Password for the master DB user.
         * Note that this may show up in logs, and it will be stored in the state file. Password must contain at least 8 chars and
         * contain at least one uppercase letter, one lowercase letter, and one number.
         * 
         * @return builder
         * 
         */
        public Builder masterPassword(String masterPassword) {
            return masterPassword(Output.of(masterPassword));
        }

        /**
         * @param masterUsername Username for the master DB user.
         * 
         * @return builder
         * 
         */
        public Builder masterUsername(@Nullable Output<String> masterUsername) {
            $.masterUsername = masterUsername;
            return this;
        }

        /**
         * @param masterUsername Username for the master DB user.
         * 
         * @return builder
         * 
         */
        public Builder masterUsername(String masterUsername) {
            return masterUsername(Output.of(masterUsername));
        }

        /**
         * @param nodeType The node type to be provisioned for the cluster.
         * 
         * @return builder
         * 
         */
        public Builder nodeType(@Nullable Output<String> nodeType) {
            $.nodeType = nodeType;
            return this;
        }

        /**
         * @param nodeType The node type to be provisioned for the cluster.
         * 
         * @return builder
         * 
         */
        public Builder nodeType(String nodeType) {
            return nodeType(Output.of(nodeType));
        }

        /**
         * @param numberOfNodes The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
         * 
         * @return builder
         * 
         */
        public Builder numberOfNodes(@Nullable Output<Integer> numberOfNodes) {
            $.numberOfNodes = numberOfNodes;
            return this;
        }

        /**
         * @param numberOfNodes The number of compute nodes in the cluster. This parameter is required when the ClusterType parameter is specified as multi-node. Default is 1.
         * 
         * @return builder
         * 
         */
        public Builder numberOfNodes(Integer numberOfNodes) {
            return numberOfNodes(Output.of(numberOfNodes));
        }

        /**
         * @param ownerAccount The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
         * 
         * @return builder
         * 
         */
        public Builder ownerAccount(@Nullable Output<String> ownerAccount) {
            $.ownerAccount = ownerAccount;
            return this;
        }

        /**
         * @param ownerAccount The AWS customer account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
         * 
         * @return builder
         * 
         */
        public Builder ownerAccount(String ownerAccount) {
            return ownerAccount(Output.of(ownerAccount));
        }

        /**
         * @param port The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
         * The cluster is accessible only via the JDBC and ODBC connection strings.
         * Part of the connection string requires the port on which the cluster will listen for incoming connections.
         * Default port is `5439`.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port The port number on which the cluster accepts incoming connections. Valid values are between `1115` and `65535`.
         * The cluster is accessible only via the JDBC and ODBC connection strings.
         * Part of the connection string requires the port on which the cluster will listen for incoming connections.
         * Default port is `5439`.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param preferredMaintenanceWindow The weekly time range (in UTC) during which automated cluster maintenance can occur.
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(@Nullable Output<String> preferredMaintenanceWindow) {
            $.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * @param preferredMaintenanceWindow The weekly time range (in UTC) during which automated cluster maintenance can occur.
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            return preferredMaintenanceWindow(Output.of(preferredMaintenanceWindow));
        }

        /**
         * @param publiclyAccessible If true, the cluster can be accessed from a public network. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(@Nullable Output<Boolean> publiclyAccessible) {
            $.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * @param publiclyAccessible If true, the cluster can be accessed from a public network. Default is `true`.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            return publiclyAccessible(Output.of(publiclyAccessible));
        }

        /**
         * @param skipFinalSnapshot Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalSnapshot(@Nullable Output<Boolean> skipFinalSnapshot) {
            $.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        /**
         * @param skipFinalSnapshot Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If true , a final cluster snapshot is not created. If false , a final cluster snapshot is created before the cluster is deleted. Default is false.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            return skipFinalSnapshot(Output.of(skipFinalSnapshot));
        }

        /**
         * @param snapshotClusterIdentifier The name of the cluster the source snapshot was created from.
         * 
         * @return builder
         * 
         */
        public Builder snapshotClusterIdentifier(@Nullable Output<String> snapshotClusterIdentifier) {
            $.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        /**
         * @param snapshotClusterIdentifier The name of the cluster the source snapshot was created from.
         * 
         * @return builder
         * 
         */
        public Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            return snapshotClusterIdentifier(Output.of(snapshotClusterIdentifier));
        }

        /**
         * @param snapshotCopy Configuration of automatic copy of snapshots from one region to another. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder snapshotCopy(@Nullable Output<ClusterSnapshotCopyArgs> snapshotCopy) {
            $.snapshotCopy = snapshotCopy;
            return this;
        }

        /**
         * @param snapshotCopy Configuration of automatic copy of snapshots from one region to another. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder snapshotCopy(ClusterSnapshotCopyArgs snapshotCopy) {
            return snapshotCopy(Output.of(snapshotCopy));
        }

        /**
         * @param snapshotIdentifier The name of the snapshot from which to create the new cluster.
         * 
         * @return builder
         * 
         */
        public Builder snapshotIdentifier(@Nullable Output<String> snapshotIdentifier) {
            $.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        /**
         * @param snapshotIdentifier The name of the snapshot from which to create the new cluster.
         * 
         * @return builder
         * 
         */
        public Builder snapshotIdentifier(String snapshotIdentifier) {
            return snapshotIdentifier(Output.of(snapshotIdentifier));
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param vpcSecurityGroupIds A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(@Nullable Output<List<String>> vpcSecurityGroupIds) {
            $.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * @param vpcSecurityGroupIds A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(Output.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSecurityGroupIds A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        public ClusterState build() {
            return $;
        }
    }

}
