// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterSnapshotCopyArgs extends com.pulumi.resources.ResourceArgs {

    public static final ClusterSnapshotCopyArgs Empty = new ClusterSnapshotCopyArgs();

    /**
     * The destination region that you want to copy snapshots to.
     * 
     */
    @Import(name="destinationRegion", required=true)
    private Output<String> destinationRegion;

    /**
     * @return The destination region that you want to copy snapshots to.
     * 
     */
    public Output<String> destinationRegion() {
        return this.destinationRegion;
    }

    /**
     * The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
     * 
     */
    @Import(name="grantName")
    private @Nullable Output<String> grantName;

    /**
     * @return The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
     * 
     */
    public Optional<Output<String>> grantName() {
        return Optional.ofNullable(this.grantName);
    }

    /**
     * The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
     * 
     */
    @Import(name="retentionPeriod")
    private @Nullable Output<Integer> retentionPeriod;

    /**
     * @return The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
     * 
     */
    public Optional<Output<Integer>> retentionPeriod() {
        return Optional.ofNullable(this.retentionPeriod);
    }

    private ClusterSnapshotCopyArgs() {}

    private ClusterSnapshotCopyArgs(ClusterSnapshotCopyArgs $) {
        this.destinationRegion = $.destinationRegion;
        this.grantName = $.grantName;
        this.retentionPeriod = $.retentionPeriod;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterSnapshotCopyArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterSnapshotCopyArgs $;

        public Builder() {
            $ = new ClusterSnapshotCopyArgs();
        }

        public Builder(ClusterSnapshotCopyArgs defaults) {
            $ = new ClusterSnapshotCopyArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param destinationRegion The destination region that you want to copy snapshots to.
         * 
         * @return builder
         * 
         */
        public Builder destinationRegion(Output<String> destinationRegion) {
            $.destinationRegion = destinationRegion;
            return this;
        }

        /**
         * @param destinationRegion The destination region that you want to copy snapshots to.
         * 
         * @return builder
         * 
         */
        public Builder destinationRegion(String destinationRegion) {
            return destinationRegion(Output.of(destinationRegion));
        }

        /**
         * @param grantName The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
         * 
         * @return builder
         * 
         */
        public Builder grantName(@Nullable Output<String> grantName) {
            $.grantName = grantName;
            return this;
        }

        /**
         * @param grantName The name of the snapshot copy grant to use when snapshots of an AWS KMS-encrypted cluster are copied to the destination region.
         * 
         * @return builder
         * 
         */
        public Builder grantName(String grantName) {
            return grantName(Output.of(grantName));
        }

        /**
         * @param retentionPeriod The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
         * 
         * @return builder
         * 
         */
        public Builder retentionPeriod(@Nullable Output<Integer> retentionPeriod) {
            $.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * @param retentionPeriod The number of days to retain automated snapshots in the destination region after they are copied from the source region. Defaults to `7`.
         * 
         * @return builder
         * 
         */
        public Builder retentionPeriod(Integer retentionPeriod) {
            return retentionPeriod(Output.of(retentionPeriod));
        }

        public ClusterSnapshotCopyArgs build() {
            $.destinationRegion = Objects.requireNonNull($.destinationRegion, "expected parameter 'destinationRegion' to be non-null");
            return $;
        }
    }

}
