// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterLoggingArgs extends com.pulumi.resources.ResourceArgs {

    public static final ClusterLoggingArgs Empty = new ClusterLoggingArgs();

    /**
     * The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
     * For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     * 
     */
    @Import(name="bucketName")
    private @Nullable Output<String> bucketName;

    /**
     * @return The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
     * For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     * 
     */
    public Optional<Output<String>> bucketName() {
        return Optional.ofNullable(this.bucketName);
    }

    /**
     * Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * 
     */
    @Import(name="enable", required=true)
    private Output<Boolean> enable;

    /**
     * @return Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * 
     */
    public Output<Boolean> enable() {
        return this.enable;
    }

    /**
     * The log destination type. An enum with possible values of `s3` and `cloudwatch`.
     * 
     */
    @Import(name="logDestinationType")
    private @Nullable Output<String> logDestinationType;

    /**
     * @return The log destination type. An enum with possible values of `s3` and `cloudwatch`.
     * 
     */
    public Optional<Output<String>> logDestinationType() {
        return Optional.ofNullable(this.logDestinationType);
    }

    /**
     * The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
     * 
     */
    @Import(name="logExports")
    private @Nullable Output<List<String>> logExports;

    /**
     * @return The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
     * 
     */
    public Optional<Output<List<String>>> logExports() {
        return Optional.ofNullable(this.logExports);
    }

    /**
     * The prefix applied to the log file names.
     * 
     */
    @Import(name="s3KeyPrefix")
    private @Nullable Output<String> s3KeyPrefix;

    /**
     * @return The prefix applied to the log file names.
     * 
     */
    public Optional<Output<String>> s3KeyPrefix() {
        return Optional.ofNullable(this.s3KeyPrefix);
    }

    private ClusterLoggingArgs() {}

    private ClusterLoggingArgs(ClusterLoggingArgs $) {
        this.bucketName = $.bucketName;
        this.enable = $.enable;
        this.logDestinationType = $.logDestinationType;
        this.logExports = $.logExports;
        this.s3KeyPrefix = $.s3KeyPrefix;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterLoggingArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterLoggingArgs $;

        public Builder() {
            $ = new ClusterLoggingArgs();
        }

        public Builder(ClusterLoggingArgs defaults) {
            $ = new ClusterLoggingArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param bucketName The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
         * For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
         * 
         * @return builder
         * 
         */
        public Builder bucketName(@Nullable Output<String> bucketName) {
            $.bucketName = bucketName;
            return this;
        }

        /**
         * @param bucketName The name of an existing S3 bucket where the log files are to be stored. Must be in the same region as the cluster and the cluster must have read bucket and put object permissions.
         * For more information on the permissions required for the bucket, please read the AWS [documentation](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
         * 
         * @return builder
         * 
         */
        public Builder bucketName(String bucketName) {
            return bucketName(Output.of(bucketName));
        }

        /**
         * @param enable Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
         * 
         * @return builder
         * 
         */
        public Builder enable(Output<Boolean> enable) {
            $.enable = enable;
            return this;
        }

        /**
         * @param enable Enables logging information such as queries and connection attempts, for the specified Amazon Redshift cluster.
         * 
         * @return builder
         * 
         */
        public Builder enable(Boolean enable) {
            return enable(Output.of(enable));
        }

        /**
         * @param logDestinationType The log destination type. An enum with possible values of `s3` and `cloudwatch`.
         * 
         * @return builder
         * 
         */
        public Builder logDestinationType(@Nullable Output<String> logDestinationType) {
            $.logDestinationType = logDestinationType;
            return this;
        }

        /**
         * @param logDestinationType The log destination type. An enum with possible values of `s3` and `cloudwatch`.
         * 
         * @return builder
         * 
         */
        public Builder logDestinationType(String logDestinationType) {
            return logDestinationType(Output.of(logDestinationType));
        }

        /**
         * @param logExports The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
         * 
         * @return builder
         * 
         */
        public Builder logExports(@Nullable Output<List<String>> logExports) {
            $.logExports = logExports;
            return this;
        }

        /**
         * @param logExports The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
         * 
         * @return builder
         * 
         */
        public Builder logExports(List<String> logExports) {
            return logExports(Output.of(logExports));
        }

        /**
         * @param logExports The collection of exported log types. Log types include the connection log, user log and user activity log. Required when `log_destination_type` is `cloudwatch`. Valid log types are `connectionlog`, `userlog`, and `useractivitylog`.
         * 
         * @return builder
         * 
         */
        public Builder logExports(String... logExports) {
            return logExports(List.of(logExports));
        }

        /**
         * @param s3KeyPrefix The prefix applied to the log file names.
         * 
         * @return builder
         * 
         */
        public Builder s3KeyPrefix(@Nullable Output<String> s3KeyPrefix) {
            $.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        /**
         * @param s3KeyPrefix The prefix applied to the log file names.
         * 
         * @return builder
         * 
         */
        public Builder s3KeyPrefix(String s3KeyPrefix) {
            return s3KeyPrefix(Output.of(s3KeyPrefix));
        }

        public ClusterLoggingArgs build() {
            $.enable = Objects.requireNonNull($.enable, "expected parameter 'enable' to be non-null");
            return $;
        }
    }

}
