// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class UsageLimitArgs extends com.pulumi.resources.ResourceArgs {

    public static final UsageLimitArgs Empty = new UsageLimitArgs();

    /**
     * The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number.
     * 
     */
    @Import(name="amount", required=true)
    private Output<Integer> amount;

    /**
     * @return The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number.
     * 
     */
    public Output<Integer> amount() {
        return this.amount;
    }

    /**
     * The action that Amazon Redshift takes when the limit is reached. The default is `log`. Valid values are `log`, `emit-metric`, and `disable`.
     * 
     */
    @Import(name="breachAction")
    private @Nullable Output<String> breachAction;

    /**
     * @return The action that Amazon Redshift takes when the limit is reached. The default is `log`. Valid values are `log`, `emit-metric`, and `disable`.
     * 
     */
    public Optional<Output<String>> breachAction() {
        return Optional.ofNullable(this.breachAction);
    }

    /**
     * The identifier of the cluster that you want to limit usage.
     * 
     */
    @Import(name="clusterIdentifier", required=true)
    private Output<String> clusterIdentifier;

    /**
     * @return The identifier of the cluster that you want to limit usage.
     * 
     */
    public Output<String> clusterIdentifier() {
        return this.clusterIdentifier;
    }

    /**
     * The Amazon Redshift feature that you want to limit. Valid values are `spectrum`, `concurrency-scaling`, and `cross-region-datasharing`.
     * 
     */
    @Import(name="featureType", required=true)
    private Output<String> featureType;

    /**
     * @return The Amazon Redshift feature that you want to limit. Valid values are `spectrum`, `concurrency-scaling`, and `cross-region-datasharing`.
     * 
     */
    public Output<String> featureType() {
        return this.featureType;
    }

    /**
     * The type of limit. Depending on the feature type, this can be based on a time duration or data size. If FeatureType is `spectrum`, then LimitType must be `data-scanned`. If FeatureType is `concurrency-scaling`, then LimitType must be `time`. If FeatureType is `cross-region-datasharing`, then LimitType must be `data-scanned`. Valid values are `data-scanned`, and `time`.
     * 
     */
    @Import(name="limitType", required=true)
    private Output<String> limitType;

    /**
     * @return The type of limit. Depending on the feature type, this can be based on a time duration or data size. If FeatureType is `spectrum`, then LimitType must be `data-scanned`. If FeatureType is `concurrency-scaling`, then LimitType must be `time`. If FeatureType is `cross-region-datasharing`, then LimitType must be `data-scanned`. Valid values are `data-scanned`, and `time`.
     * 
     */
    public Output<String> limitType() {
        return this.limitType;
    }

    /**
     * The time period that the amount applies to. A weekly period begins on Sunday. The default is `monthly`. Valid values are `daily`, `weekly`, and `monthly`.
     * 
     */
    @Import(name="period")
    private @Nullable Output<String> period;

    /**
     * @return The time period that the amount applies to. A weekly period begins on Sunday. The default is `monthly`. Valid values are `daily`, `weekly`, and `monthly`.
     * 
     */
    public Optional<Output<String>> period() {
        return Optional.ofNullable(this.period);
    }

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private UsageLimitArgs() {}

    private UsageLimitArgs(UsageLimitArgs $) {
        this.amount = $.amount;
        this.breachAction = $.breachAction;
        this.clusterIdentifier = $.clusterIdentifier;
        this.featureType = $.featureType;
        this.limitType = $.limitType;
        this.period = $.period;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(UsageLimitArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private UsageLimitArgs $;

        public Builder() {
            $ = new UsageLimitArgs();
        }

        public Builder(UsageLimitArgs defaults) {
            $ = new UsageLimitArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param amount The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number.
         * 
         * @return builder
         * 
         */
        public Builder amount(Output<Integer> amount) {
            $.amount = amount;
            return this;
        }

        /**
         * @param amount The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number.
         * 
         * @return builder
         * 
         */
        public Builder amount(Integer amount) {
            return amount(Output.of(amount));
        }

        /**
         * @param breachAction The action that Amazon Redshift takes when the limit is reached. The default is `log`. Valid values are `log`, `emit-metric`, and `disable`.
         * 
         * @return builder
         * 
         */
        public Builder breachAction(@Nullable Output<String> breachAction) {
            $.breachAction = breachAction;
            return this;
        }

        /**
         * @param breachAction The action that Amazon Redshift takes when the limit is reached. The default is `log`. Valid values are `log`, `emit-metric`, and `disable`.
         * 
         * @return builder
         * 
         */
        public Builder breachAction(String breachAction) {
            return breachAction(Output.of(breachAction));
        }

        /**
         * @param clusterIdentifier The identifier of the cluster that you want to limit usage.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier The identifier of the cluster that you want to limit usage.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param featureType The Amazon Redshift feature that you want to limit. Valid values are `spectrum`, `concurrency-scaling`, and `cross-region-datasharing`.
         * 
         * @return builder
         * 
         */
        public Builder featureType(Output<String> featureType) {
            $.featureType = featureType;
            return this;
        }

        /**
         * @param featureType The Amazon Redshift feature that you want to limit. Valid values are `spectrum`, `concurrency-scaling`, and `cross-region-datasharing`.
         * 
         * @return builder
         * 
         */
        public Builder featureType(String featureType) {
            return featureType(Output.of(featureType));
        }

        /**
         * @param limitType The type of limit. Depending on the feature type, this can be based on a time duration or data size. If FeatureType is `spectrum`, then LimitType must be `data-scanned`. If FeatureType is `concurrency-scaling`, then LimitType must be `time`. If FeatureType is `cross-region-datasharing`, then LimitType must be `data-scanned`. Valid values are `data-scanned`, and `time`.
         * 
         * @return builder
         * 
         */
        public Builder limitType(Output<String> limitType) {
            $.limitType = limitType;
            return this;
        }

        /**
         * @param limitType The type of limit. Depending on the feature type, this can be based on a time duration or data size. If FeatureType is `spectrum`, then LimitType must be `data-scanned`. If FeatureType is `concurrency-scaling`, then LimitType must be `time`. If FeatureType is `cross-region-datasharing`, then LimitType must be `data-scanned`. Valid values are `data-scanned`, and `time`.
         * 
         * @return builder
         * 
         */
        public Builder limitType(String limitType) {
            return limitType(Output.of(limitType));
        }

        /**
         * @param period The time period that the amount applies to. A weekly period begins on Sunday. The default is `monthly`. Valid values are `daily`, `weekly`, and `monthly`.
         * 
         * @return builder
         * 
         */
        public Builder period(@Nullable Output<String> period) {
            $.period = period;
            return this;
        }

        /**
         * @param period The time period that the amount applies to. A weekly period begins on Sunday. The default is `monthly`. Valid values are `daily`, `weekly`, and `monthly`.
         * 
         * @return builder
         * 
         */
        public Builder period(String period) {
            return period(Output.of(period));
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public UsageLimitArgs build() {
            $.amount = Objects.requireNonNull($.amount, "expected parameter 'amount' to be non-null");
            $.clusterIdentifier = Objects.requireNonNull($.clusterIdentifier, "expected parameter 'clusterIdentifier' to be non-null");
            $.featureType = Objects.requireNonNull($.featureType, "expected parameter 'featureType' to be non-null");
            $.limitType = Objects.requireNonNull($.limitType, "expected parameter 'limitType' to be non-null");
            return $;
        }
    }

}
