// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift;

import com.pulumi.aws.redshift.inputs.ScheduledActionTargetActionArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ScheduledActionArgs extends com.pulumi.resources.ResourceArgs {

    public static final ScheduledActionArgs Empty = new ScheduledActionArgs();

    /**
     * The description of the scheduled action.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return The description of the scheduled action.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Whether to enable the scheduled action. Default is `true` .
     * 
     */
    @Import(name="enable")
    private @Nullable Output<Boolean> enable;

    /**
     * @return Whether to enable the scheduled action. Default is `true` .
     * 
     */
    public Optional<Output<Boolean>> enable() {
        return Optional.ofNullable(this.enable);
    }

    /**
     * The end time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
     * 
     */
    @Import(name="endTime")
    private @Nullable Output<String> endTime;

    /**
     * @return The end time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
     * 
     */
    public Optional<Output<String>> endTime() {
        return Optional.ofNullable(this.endTime);
    }

    /**
     * The IAM role to assume to run the scheduled action.
     * 
     */
    @Import(name="iamRole", required=true)
    private Output<String> iamRole;

    /**
     * @return The IAM role to assume to run the scheduled action.
     * 
     */
    public Output<String> iamRole() {
        return this.iamRole;
    }

    /**
     * The scheduled action name.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The scheduled action name.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The schedule of action. The schedule is defined format of &#34;at expression&#34; or &#34;cron expression&#34;, for example `at(2016-03-04T17:27:00)` or `cron(0 10 ? * MON *)`. See [Scheduled Action](https://docs.aws.amazon.com/redshift/latest/APIReference/API_ScheduledAction.html) for more information.
     * 
     */
    @Import(name="schedule", required=true)
    private Output<String> schedule;

    /**
     * @return The schedule of action. The schedule is defined format of &#34;at expression&#34; or &#34;cron expression&#34;, for example `at(2016-03-04T17:27:00)` or `cron(0 10 ? * MON *)`. See [Scheduled Action](https://docs.aws.amazon.com/redshift/latest/APIReference/API_ScheduledAction.html) for more information.
     * 
     */
    public Output<String> schedule() {
        return this.schedule;
    }

    /**
     * The start time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
     * 
     */
    @Import(name="startTime")
    private @Nullable Output<String> startTime;

    /**
     * @return The start time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
     * 
     */
    public Optional<Output<String>> startTime() {
        return Optional.ofNullable(this.startTime);
    }

    /**
     * Target action. Documented below.
     * 
     */
    @Import(name="targetAction", required=true)
    private Output<ScheduledActionTargetActionArgs> targetAction;

    /**
     * @return Target action. Documented below.
     * 
     */
    public Output<ScheduledActionTargetActionArgs> targetAction() {
        return this.targetAction;
    }

    private ScheduledActionArgs() {}

    private ScheduledActionArgs(ScheduledActionArgs $) {
        this.description = $.description;
        this.enable = $.enable;
        this.endTime = $.endTime;
        this.iamRole = $.iamRole;
        this.name = $.name;
        this.schedule = $.schedule;
        this.startTime = $.startTime;
        this.targetAction = $.targetAction;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ScheduledActionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ScheduledActionArgs $;

        public Builder() {
            $ = new ScheduledActionArgs();
        }

        public Builder(ScheduledActionArgs defaults) {
            $ = new ScheduledActionArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description The description of the scheduled action.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description The description of the scheduled action.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param enable Whether to enable the scheduled action. Default is `true` .
         * 
         * @return builder
         * 
         */
        public Builder enable(@Nullable Output<Boolean> enable) {
            $.enable = enable;
            return this;
        }

        /**
         * @param enable Whether to enable the scheduled action. Default is `true` .
         * 
         * @return builder
         * 
         */
        public Builder enable(Boolean enable) {
            return enable(Output.of(enable));
        }

        /**
         * @param endTime The end time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
         * 
         * @return builder
         * 
         */
        public Builder endTime(@Nullable Output<String> endTime) {
            $.endTime = endTime;
            return this;
        }

        /**
         * @param endTime The end time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
         * 
         * @return builder
         * 
         */
        public Builder endTime(String endTime) {
            return endTime(Output.of(endTime));
        }

        /**
         * @param iamRole The IAM role to assume to run the scheduled action.
         * 
         * @return builder
         * 
         */
        public Builder iamRole(Output<String> iamRole) {
            $.iamRole = iamRole;
            return this;
        }

        /**
         * @param iamRole The IAM role to assume to run the scheduled action.
         * 
         * @return builder
         * 
         */
        public Builder iamRole(String iamRole) {
            return iamRole(Output.of(iamRole));
        }

        /**
         * @param name The scheduled action name.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The scheduled action name.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param schedule The schedule of action. The schedule is defined format of &#34;at expression&#34; or &#34;cron expression&#34;, for example `at(2016-03-04T17:27:00)` or `cron(0 10 ? * MON *)`. See [Scheduled Action](https://docs.aws.amazon.com/redshift/latest/APIReference/API_ScheduledAction.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder schedule(Output<String> schedule) {
            $.schedule = schedule;
            return this;
        }

        /**
         * @param schedule The schedule of action. The schedule is defined format of &#34;at expression&#34; or &#34;cron expression&#34;, for example `at(2016-03-04T17:27:00)` or `cron(0 10 ? * MON *)`. See [Scheduled Action](https://docs.aws.amazon.com/redshift/latest/APIReference/API_ScheduledAction.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder schedule(String schedule) {
            return schedule(Output.of(schedule));
        }

        /**
         * @param startTime The start time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
         * 
         * @return builder
         * 
         */
        public Builder startTime(@Nullable Output<String> startTime) {
            $.startTime = startTime;
            return this;
        }

        /**
         * @param startTime The start time in UTC when the schedule is active, in UTC RFC3339 format(for example, YYYY-MM-DDTHH:MM:SSZ).
         * 
         * @return builder
         * 
         */
        public Builder startTime(String startTime) {
            return startTime(Output.of(startTime));
        }

        /**
         * @param targetAction Target action. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder targetAction(Output<ScheduledActionTargetActionArgs> targetAction) {
            $.targetAction = targetAction;
            return this;
        }

        /**
         * @param targetAction Target action. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder targetAction(ScheduledActionTargetActionArgs targetAction) {
            return targetAction(Output.of(targetAction));
        }

        public ScheduledActionArgs build() {
            $.iamRole = Objects.requireNonNull($.iamRole, "expected parameter 'iamRole' to be non-null");
            $.schedule = Objects.requireNonNull($.schedule, "expected parameter 'schedule' to be non-null");
            $.targetAction = Objects.requireNonNull($.targetAction, "expected parameter 'targetAction' to be non-null");
            return $;
        }
    }

}
