// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.redshift.inputs.GetClusterArgs;
import com.pulumi.aws.redshift.inputs.GetClusterCredentialsArgs;
import com.pulumi.aws.redshift.inputs.GetClusterCredentialsPlainArgs;
import com.pulumi.aws.redshift.inputs.GetClusterPlainArgs;
import com.pulumi.aws.redshift.inputs.GetOrderableClusterArgs;
import com.pulumi.aws.redshift.inputs.GetOrderableClusterPlainArgs;
import com.pulumi.aws.redshift.inputs.GetServiceAccountArgs;
import com.pulumi.aws.redshift.inputs.GetServiceAccountPlainArgs;
import com.pulumi.aws.redshift.inputs.GetSubnetGroupArgs;
import com.pulumi.aws.redshift.inputs.GetSubnetGroupPlainArgs;
import com.pulumi.aws.redshift.outputs.GetClusterCredentialsResult;
import com.pulumi.aws.redshift.outputs.GetClusterResult;
import com.pulumi.aws.redshift.outputs.GetOrderableClusterResult;
import com.pulumi.aws.redshift.outputs.GetServiceAccountResult;
import com.pulumi.aws.redshift.outputs.GetSubnetGroupResult;
import com.pulumi.core.Output;
import com.pulumi.core.TypeShape;
import com.pulumi.deployment.Deployment;
import com.pulumi.deployment.InvokeOptions;
import java.util.concurrent.CompletableFuture;

public final class RedshiftFunctions {
    /**
     * Provides details about a specific redshift cluster.
     * 
     * ## Example Usage
     * 
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterArgs;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterIdentifier(&#34;example-cluster&#34;)
     *             .build());
     * 
     *         var exampleStream = new FirehoseDeliveryStream(&#34;exampleStream&#34;, FirehoseDeliveryStreamArgs.builder()        
     *             .destination(&#34;redshift&#34;)
     *             .redshiftConfiguration(FirehoseDeliveryStreamRedshiftConfigurationArgs.builder()
     *                 .roleArn(aws_iam_role.firehose_role().arn())
     *                 .clusterJdbcurl(String.format(&#34;jdbc:redshift://%s/%s&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.endpoint()),example.applyValue(getClusterResult -&gt; getClusterResult.databaseName())))
     *                 .username(&#34;exampleuser&#34;)
     *                 .password(&#34;Exampl3Pass&#34;)
     *                 .dataTableName(&#34;example-table&#34;)
     *                 .copyOptions(&#34;delimiter &#39;|&#39;&#34;)
     *                 .dataTableColumns(&#34;example-col&#34;)
     *                 .s3Configuration(FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs.builder()
     *                     .roleArn(aws_iam_role.firehose_role().arn())
     *                     .bucketArn(aws_s3_bucket.bucket().arn())
     *                     .bufferSize(10)
     *                     .bufferInterval(400)
     *                     .compressionFormat(&#34;GZIP&#34;)
     *                     .build())
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetClusterResult> getCluster(GetClusterArgs args) {
        return getCluster(args, InvokeOptions.Empty);
    }
    /**
     * Provides details about a specific redshift cluster.
     * 
     * ## Example Usage
     * 
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterArgs;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterIdentifier(&#34;example-cluster&#34;)
     *             .build());
     * 
     *         var exampleStream = new FirehoseDeliveryStream(&#34;exampleStream&#34;, FirehoseDeliveryStreamArgs.builder()        
     *             .destination(&#34;redshift&#34;)
     *             .redshiftConfiguration(FirehoseDeliveryStreamRedshiftConfigurationArgs.builder()
     *                 .roleArn(aws_iam_role.firehose_role().arn())
     *                 .clusterJdbcurl(String.format(&#34;jdbc:redshift://%s/%s&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.endpoint()),example.applyValue(getClusterResult -&gt; getClusterResult.databaseName())))
     *                 .username(&#34;exampleuser&#34;)
     *                 .password(&#34;Exampl3Pass&#34;)
     *                 .dataTableName(&#34;example-table&#34;)
     *                 .copyOptions(&#34;delimiter &#39;|&#39;&#34;)
     *                 .dataTableColumns(&#34;example-col&#34;)
     *                 .s3Configuration(FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs.builder()
     *                     .roleArn(aws_iam_role.firehose_role().arn())
     *                     .bucketArn(aws_s3_bucket.bucket().arn())
     *                     .bufferSize(10)
     *                     .bufferInterval(400)
     *                     .compressionFormat(&#34;GZIP&#34;)
     *                     .build())
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetClusterResult> getClusterPlain(GetClusterPlainArgs args) {
        return getClusterPlain(args, InvokeOptions.Empty);
    }
    /**
     * Provides details about a specific redshift cluster.
     * 
     * ## Example Usage
     * 
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterArgs;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterIdentifier(&#34;example-cluster&#34;)
     *             .build());
     * 
     *         var exampleStream = new FirehoseDeliveryStream(&#34;exampleStream&#34;, FirehoseDeliveryStreamArgs.builder()        
     *             .destination(&#34;redshift&#34;)
     *             .redshiftConfiguration(FirehoseDeliveryStreamRedshiftConfigurationArgs.builder()
     *                 .roleArn(aws_iam_role.firehose_role().arn())
     *                 .clusterJdbcurl(String.format(&#34;jdbc:redshift://%s/%s&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.endpoint()),example.applyValue(getClusterResult -&gt; getClusterResult.databaseName())))
     *                 .username(&#34;exampleuser&#34;)
     *                 .password(&#34;Exampl3Pass&#34;)
     *                 .dataTableName(&#34;example-table&#34;)
     *                 .copyOptions(&#34;delimiter &#39;|&#39;&#34;)
     *                 .dataTableColumns(&#34;example-col&#34;)
     *                 .s3Configuration(FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs.builder()
     *                     .roleArn(aws_iam_role.firehose_role().arn())
     *                     .bucketArn(aws_s3_bucket.bucket().arn())
     *                     .bufferSize(10)
     *                     .bufferInterval(400)
     *                     .compressionFormat(&#34;GZIP&#34;)
     *                     .build())
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetClusterResult> getCluster(GetClusterArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:redshift/getCluster:getCluster", TypeShape.of(GetClusterResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Provides details about a specific redshift cluster.
     * 
     * ## Example Usage
     * 
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterArgs;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
     * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationArgs;
     * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterIdentifier(&#34;example-cluster&#34;)
     *             .build());
     * 
     *         var exampleStream = new FirehoseDeliveryStream(&#34;exampleStream&#34;, FirehoseDeliveryStreamArgs.builder()        
     *             .destination(&#34;redshift&#34;)
     *             .redshiftConfiguration(FirehoseDeliveryStreamRedshiftConfigurationArgs.builder()
     *                 .roleArn(aws_iam_role.firehose_role().arn())
     *                 .clusterJdbcurl(String.format(&#34;jdbc:redshift://%s/%s&#34;, example.applyValue(getClusterResult -&gt; getClusterResult.endpoint()),example.applyValue(getClusterResult -&gt; getClusterResult.databaseName())))
     *                 .username(&#34;exampleuser&#34;)
     *                 .password(&#34;Exampl3Pass&#34;)
     *                 .dataTableName(&#34;example-table&#34;)
     *                 .copyOptions(&#34;delimiter &#39;|&#39;&#34;)
     *                 .dataTableColumns(&#34;example-col&#34;)
     *                 .s3Configuration(FirehoseDeliveryStreamRedshiftConfigurationS3ConfigurationArgs.builder()
     *                     .roleArn(aws_iam_role.firehose_role().arn())
     *                     .bucketArn(aws_s3_bucket.bucket().arn())
     *                     .bufferSize(10)
     *                     .bufferInterval(400)
     *                     .compressionFormat(&#34;GZIP&#34;)
     *                     .build())
     *                 .build())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetClusterResult> getClusterPlain(GetClusterPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:redshift/getCluster:getCluster", TypeShape.of(GetClusterResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Provides redshift cluster temporary credentials.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterCredentialsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getClusterCredentials(GetClusterCredentialsArgs.builder()
     *             .clusterIdentifier(aws_redshift_cluster.example().cluster_identifier())
     *             .dbUser(aws_redshift_cluster.example().master_username())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetClusterCredentialsResult> getClusterCredentials(GetClusterCredentialsArgs args) {
        return getClusterCredentials(args, InvokeOptions.Empty);
    }
    /**
     * Provides redshift cluster temporary credentials.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterCredentialsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getClusterCredentials(GetClusterCredentialsArgs.builder()
     *             .clusterIdentifier(aws_redshift_cluster.example().cluster_identifier())
     *             .dbUser(aws_redshift_cluster.example().master_username())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetClusterCredentialsResult> getClusterCredentialsPlain(GetClusterCredentialsPlainArgs args) {
        return getClusterCredentialsPlain(args, InvokeOptions.Empty);
    }
    /**
     * Provides redshift cluster temporary credentials.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterCredentialsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getClusterCredentials(GetClusterCredentialsArgs.builder()
     *             .clusterIdentifier(aws_redshift_cluster.example().cluster_identifier())
     *             .dbUser(aws_redshift_cluster.example().master_username())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetClusterCredentialsResult> getClusterCredentials(GetClusterCredentialsArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:redshift/getClusterCredentials:getClusterCredentials", TypeShape.of(GetClusterCredentialsResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Provides redshift cluster temporary credentials.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetClusterCredentialsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getClusterCredentials(GetClusterCredentialsArgs.builder()
     *             .clusterIdentifier(aws_redshift_cluster.example().cluster_identifier())
     *             .dbUser(aws_redshift_cluster.example().master_username())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetClusterCredentialsResult> getClusterCredentialsPlain(GetClusterCredentialsPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:redshift/getClusterCredentials:getClusterCredentials", TypeShape.of(GetClusterCredentialsResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Information about Redshift Orderable Clusters and valid parameter combinations.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetOrderableClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var test = RedshiftFunctions.getOrderableCluster(GetOrderableClusterArgs.builder()
     *             .clusterType(&#34;multi-node&#34;)
     *             .preferredNodeTypes(            
     *                 &#34;dc2.large&#34;,
     *                 &#34;ds2.xlarge&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetOrderableClusterResult> getOrderableCluster() {
        return getOrderableCluster(GetOrderableClusterArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Information about Redshift Orderable Clusters and valid parameter combinations.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetOrderableClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var test = RedshiftFunctions.getOrderableCluster(GetOrderableClusterArgs.builder()
     *             .clusterType(&#34;multi-node&#34;)
     *             .preferredNodeTypes(            
     *                 &#34;dc2.large&#34;,
     *                 &#34;ds2.xlarge&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetOrderableClusterResult> getOrderableClusterPlain() {
        return getOrderableClusterPlain(GetOrderableClusterPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Information about Redshift Orderable Clusters and valid parameter combinations.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetOrderableClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var test = RedshiftFunctions.getOrderableCluster(GetOrderableClusterArgs.builder()
     *             .clusterType(&#34;multi-node&#34;)
     *             .preferredNodeTypes(            
     *                 &#34;dc2.large&#34;,
     *                 &#34;ds2.xlarge&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetOrderableClusterResult> getOrderableCluster(GetOrderableClusterArgs args) {
        return getOrderableCluster(args, InvokeOptions.Empty);
    }
    /**
     * Information about Redshift Orderable Clusters and valid parameter combinations.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetOrderableClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var test = RedshiftFunctions.getOrderableCluster(GetOrderableClusterArgs.builder()
     *             .clusterType(&#34;multi-node&#34;)
     *             .preferredNodeTypes(            
     *                 &#34;dc2.large&#34;,
     *                 &#34;ds2.xlarge&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetOrderableClusterResult> getOrderableClusterPlain(GetOrderableClusterPlainArgs args) {
        return getOrderableClusterPlain(args, InvokeOptions.Empty);
    }
    /**
     * Information about Redshift Orderable Clusters and valid parameter combinations.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetOrderableClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var test = RedshiftFunctions.getOrderableCluster(GetOrderableClusterArgs.builder()
     *             .clusterType(&#34;multi-node&#34;)
     *             .preferredNodeTypes(            
     *                 &#34;dc2.large&#34;,
     *                 &#34;ds2.xlarge&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetOrderableClusterResult> getOrderableCluster(GetOrderableClusterArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:redshift/getOrderableCluster:getOrderableCluster", TypeShape.of(GetOrderableClusterResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Information about Redshift Orderable Clusters and valid parameter combinations.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetOrderableClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var test = RedshiftFunctions.getOrderableCluster(GetOrderableClusterArgs.builder()
     *             .clusterType(&#34;multi-node&#34;)
     *             .preferredNodeTypes(            
     *                 &#34;dc2.large&#34;,
     *                 &#34;ds2.xlarge&#34;)
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetOrderableClusterResult> getOrderableClusterPlain(GetOrderableClusterPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:redshift/getOrderableCluster:getOrderableCluster", TypeShape.of(GetOrderableClusterResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the Account ID of the [AWS Redshift Service Account](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     * in a given region for the purpose of allowing Redshift to store audit data in S3.
     * 
     * &gt; **Note:** AWS documentation [states that](https://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-bucket-permissions) a [service principal name](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services) should be used instead of an AWS account ID in any relevant IAM policy.
     * The `aws.redshift.getServiceAccount` data source has been deprecated and will be removed in a future version.
     * 
     */
    public static Output<GetServiceAccountResult> getServiceAccount() {
        return getServiceAccount(GetServiceAccountArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the Account ID of the [AWS Redshift Service Account](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     * in a given region for the purpose of allowing Redshift to store audit data in S3.
     * 
     * &gt; **Note:** AWS documentation [states that](https://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-bucket-permissions) a [service principal name](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services) should be used instead of an AWS account ID in any relevant IAM policy.
     * The `aws.redshift.getServiceAccount` data source has been deprecated and will be removed in a future version.
     * 
     */
    public static CompletableFuture<GetServiceAccountResult> getServiceAccountPlain() {
        return getServiceAccountPlain(GetServiceAccountPlainArgs.Empty, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the Account ID of the [AWS Redshift Service Account](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     * in a given region for the purpose of allowing Redshift to store audit data in S3.
     * 
     * &gt; **Note:** AWS documentation [states that](https://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-bucket-permissions) a [service principal name](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services) should be used instead of an AWS account ID in any relevant IAM policy.
     * The `aws.redshift.getServiceAccount` data source has been deprecated and will be removed in a future version.
     * 
     */
    public static Output<GetServiceAccountResult> getServiceAccount(GetServiceAccountArgs args) {
        return getServiceAccount(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the Account ID of the [AWS Redshift Service Account](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     * in a given region for the purpose of allowing Redshift to store audit data in S3.
     * 
     * &gt; **Note:** AWS documentation [states that](https://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-bucket-permissions) a [service principal name](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services) should be used instead of an AWS account ID in any relevant IAM policy.
     * The `aws.redshift.getServiceAccount` data source has been deprecated and will be removed in a future version.
     * 
     */
    public static CompletableFuture<GetServiceAccountResult> getServiceAccountPlain(GetServiceAccountPlainArgs args) {
        return getServiceAccountPlain(args, InvokeOptions.Empty);
    }
    /**
     * Use this data source to get the Account ID of the [AWS Redshift Service Account](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     * in a given region for the purpose of allowing Redshift to store audit data in S3.
     * 
     * &gt; **Note:** AWS documentation [states that](https://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-bucket-permissions) a [service principal name](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services) should be used instead of an AWS account ID in any relevant IAM policy.
     * The `aws.redshift.getServiceAccount` data source has been deprecated and will be removed in a future version.
     * 
     */
    public static Output<GetServiceAccountResult> getServiceAccount(GetServiceAccountArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:redshift/getServiceAccount:getServiceAccount", TypeShape.of(GetServiceAccountResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Use this data source to get the Account ID of the [AWS Redshift Service Account](http://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-enable-logging)
     * in a given region for the purpose of allowing Redshift to store audit data in S3.
     * 
     * &gt; **Note:** AWS documentation [states that](https://docs.aws.amazon.com/redshift/latest/mgmt/db-auditing.html#db-auditing-bucket-permissions) a [service principal name](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services) should be used instead of an AWS account ID in any relevant IAM policy.
     * The `aws.redshift.getServiceAccount` data source has been deprecated and will be removed in a future version.
     * 
     */
    public static CompletableFuture<GetServiceAccountResult> getServiceAccountPlain(GetServiceAccountPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:redshift/getServiceAccount:getServiceAccount", TypeShape.of(GetServiceAccountResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Provides details about a specific redshift subnet group.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getSubnetGroup(GetSubnetGroupArgs.builder()
     *             .name(aws_redshift_subnet_group.example().name())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetSubnetGroupResult> getSubnetGroup(GetSubnetGroupArgs args) {
        return getSubnetGroup(args, InvokeOptions.Empty);
    }
    /**
     * Provides details about a specific redshift subnet group.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getSubnetGroup(GetSubnetGroupArgs.builder()
     *             .name(aws_redshift_subnet_group.example().name())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetSubnetGroupResult> getSubnetGroupPlain(GetSubnetGroupPlainArgs args) {
        return getSubnetGroupPlain(args, InvokeOptions.Empty);
    }
    /**
     * Provides details about a specific redshift subnet group.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getSubnetGroup(GetSubnetGroupArgs.builder()
     *             .name(aws_redshift_subnet_group.example().name())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static Output<GetSubnetGroupResult> getSubnetGroup(GetSubnetGroupArgs args, InvokeOptions options) {
        return Deployment.getInstance().invoke("aws:redshift/getSubnetGroup:getSubnetGroup", TypeShape.of(GetSubnetGroupResult.class), args, Utilities.withVersion(options));
    }
    /**
     * Provides details about a specific redshift subnet group.
     * 
     * ## Example Usage
     * ```java
     * package generated_program;
     * 
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.redshift.RedshiftFunctions;
     * import com.pulumi.aws.redshift.inputs.GetSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * 
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     * 
     *     public static void stack(Context ctx) {
     *         final var example = RedshiftFunctions.getSubnetGroup(GetSubnetGroupArgs.builder()
     *             .name(aws_redshift_subnet_group.example().name())
     *             .build());
     * 
     *     }
     * }
     * ```
     * 
     */
    public static CompletableFuture<GetSubnetGroupResult> getSubnetGroupPlain(GetSubnetGroupPlainArgs args, InvokeOptions options) {
        return Deployment.getInstance().invokeAsync("aws:redshift/getSubnetGroup:getSubnetGroup", TypeShape.of(GetSubnetGroupResult.class), args, Utilities.withVersion(options));
    }
}
