// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.redshift.EndpointAccessArgs;
import com.pulumi.aws.redshift.inputs.EndpointAccessState;
import com.pulumi.aws.redshift.outputs.EndpointAccessVpcEndpoint;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import javax.annotation.Nullable;

/**
 * Creates a new Amazon Redshift endpoint access.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.EndpointAccess;
 * import com.pulumi.aws.redshift.EndpointAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new EndpointAccess(&#34;example&#34;, EndpointAccessArgs.builder()        
 *             .endpointName(&#34;example&#34;)
 *             .subnetGroupName(aws_redshift_subnet_group.example().id())
 *             .clusterIdentifier(aws_redshift_cluster.example().cluster_identifier())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Redshift endpoint access using the `name`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:redshift/endpointAccess:EndpointAccess example example
 * ```
 * 
 */
@ResourceType(type="aws:redshift/endpointAccess:EndpointAccess")
public class EndpointAccess extends com.pulumi.resources.CustomResource {
    /**
     * The DNS address of the endpoint.
     * 
     */
    @Export(name="address", refs={String.class}, tree="[0]")
    private Output<String> address;

    /**
     * @return The DNS address of the endpoint.
     * 
     */
    public Output<String> address() {
        return this.address;
    }
    /**
     * The cluster identifier of the cluster to access.
     * 
     */
    @Export(name="clusterIdentifier", refs={String.class}, tree="[0]")
    private Output<String> clusterIdentifier;

    /**
     * @return The cluster identifier of the cluster to access.
     * 
     */
    public Output<String> clusterIdentifier() {
        return this.clusterIdentifier;
    }
    /**
     * The Redshift-managed VPC endpoint name.
     * 
     */
    @Export(name="endpointName", refs={String.class}, tree="[0]")
    private Output<String> endpointName;

    /**
     * @return The Redshift-managed VPC endpoint name.
     * 
     */
    public Output<String> endpointName() {
        return this.endpointName;
    }
    /**
     * The port number on which the cluster accepts incoming connections.
     * 
     */
    @Export(name="port", refs={Integer.class}, tree="[0]")
    private Output<Integer> port;

    /**
     * @return The port number on which the cluster accepts incoming connections.
     * 
     */
    public Output<Integer> port() {
        return this.port;
    }
    /**
     * The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
     * 
     */
    @Export(name="resourceOwner", refs={String.class}, tree="[0]")
    private Output<String> resourceOwner;

    /**
     * @return The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
     * 
     */
    public Output<String> resourceOwner() {
        return this.resourceOwner;
    }
    /**
     * The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
     * 
     */
    @Export(name="subnetGroupName", refs={String.class}, tree="[0]")
    private Output<String> subnetGroupName;

    /**
     * @return The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
     * 
     */
    public Output<String> subnetGroupName() {
        return this.subnetGroupName;
    }
    /**
     * The connection endpoint for connecting to an Amazon Redshift cluster through the proxy. See details below.
     * 
     */
    @Export(name="vpcEndpoints", refs={List.class,EndpointAccessVpcEndpoint.class}, tree="[0,1]")
    private Output<List<EndpointAccessVpcEndpoint>> vpcEndpoints;

    /**
     * @return The connection endpoint for connecting to an Amazon Redshift cluster through the proxy. See details below.
     * 
     */
    public Output<List<EndpointAccessVpcEndpoint>> vpcEndpoints() {
        return this.vpcEndpoints;
    }
    /**
     * The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     * 
     */
    @Export(name="vpcSecurityGroupIds", refs={List.class,String.class}, tree="[0,1]")
    private Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     * 
     */
    public Output<List<String>> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public EndpointAccess(String name) {
        this(name, EndpointAccessArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public EndpointAccess(String name, EndpointAccessArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public EndpointAccess(String name, EndpointAccessArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:redshift/endpointAccess:EndpointAccess", name, args == null ? EndpointAccessArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private EndpointAccess(String name, Output<String> id, @Nullable EndpointAccessState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:redshift/endpointAccess:EndpointAccess", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static EndpointAccess get(String name, Output<String> id, @Nullable EndpointAccessState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new EndpointAccess(name, id, state, options);
    }
}
