// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.redshift;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.redshift.ClusterSnapshotArgs;
import com.pulumi.aws.redshift.inputs.ClusterSnapshotState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Creates a Redshift cluster snapshot
 * 
 * ## Example Usage
 * 
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshift.ClusterSnapshot;
 * import com.pulumi.aws.redshift.ClusterSnapshotArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var example = new ClusterSnapshot(&#34;example&#34;, ClusterSnapshotArgs.builder()        
 *             .clusterSnapshotName(&#34;example&#34;)
 *             .clusterSnapshotContent(serializeJson(
 *                 jsonObject(
 *                     jsonProperty(&#34;AllowDBUserOverride&#34;, &#34;1&#34;),
 *                     jsonProperty(&#34;Client_ID&#34;, &#34;ExampleClientID&#34;),
 *                     jsonProperty(&#34;App_ID&#34;, &#34;example&#34;)
 *                 )))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Using `pulumi import`, import Redshift Cluster Snapshots using `snapshot_identifier`. For example:
 * 
 * ```sh
 *  $ pulumi import aws:redshift/clusterSnapshot:ClusterSnapshot test example
 * ```
 * 
 */
@ResourceType(type="aws:redshift/clusterSnapshot:ClusterSnapshot")
public class ClusterSnapshot extends com.pulumi.resources.CustomResource {
    /**
     * Amazon Resource Name (ARN) of the snapshot.
     * 
     */
    @Export(name="arn", refs={String.class}, tree="[0]")
    private Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of the snapshot.
     * 
     */
    public Output<String> arn() {
        return this.arn;
    }
    /**
     * The cluster identifier for which you want a snapshot.
     * 
     */
    @Export(name="clusterIdentifier", refs={String.class}, tree="[0]")
    private Output<String> clusterIdentifier;

    /**
     * @return The cluster identifier for which you want a snapshot.
     * 
     */
    public Output<String> clusterIdentifier() {
        return this.clusterIdentifier;
    }
    /**
     * The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.
     * 
     */
    @Export(name="kmsKeyId", refs={String.class}, tree="[0]")
    private Output<String> kmsKeyId;

    /**
     * @return The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.
     * 
     */
    public Output<String> kmsKeyId() {
        return this.kmsKeyId;
    }
    /**
     * The number of days that a manual snapshot is retained. If the value is `-1`, the manual snapshot is retained indefinitely. Valid values are -1 and between `1` and `3653`.
     * 
     */
    @Export(name="manualSnapshotRetentionPeriod", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> manualSnapshotRetentionPeriod;

    /**
     * @return The number of days that a manual snapshot is retained. If the value is `-1`, the manual snapshot is retained indefinitely. Valid values are -1 and between `1` and `3653`.
     * 
     */
    public Output<Optional<Integer>> manualSnapshotRetentionPeriod() {
        return Codegen.optional(this.manualSnapshotRetentionPeriod);
    }
    /**
     * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.
     * 
     */
    @Export(name="ownerAccount", refs={String.class}, tree="[0]")
    private Output<String> ownerAccount;

    /**
     * @return For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.
     * 
     */
    public Output<String> ownerAccount() {
        return this.ownerAccount;
    }
    /**
     * A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.
     * 
     */
    @Export(name="snapshotIdentifier", refs={String.class}, tree="[0]")
    private Output<String> snapshotIdentifier;

    /**
     * @return A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.
     * 
     */
    public Output<String> snapshotIdentifier() {
        return this.snapshotIdentifier;
    }
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Export(name="tags", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Output<Optional<Map<String,String>>> tags() {
        return Codegen.optional(this.tags);
    }
    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Export(name="tagsAll", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output<Map<String,String>> tagsAll;

    /**
     * @return A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Output<Map<String,String>> tagsAll() {
        return this.tagsAll;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ClusterSnapshot(String name) {
        this(name, ClusterSnapshotArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ClusterSnapshot(String name, ClusterSnapshotArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ClusterSnapshot(String name, ClusterSnapshotArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:redshift/clusterSnapshot:ClusterSnapshot", name, args == null ? ClusterSnapshotArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ClusterSnapshot(String name, Output<String> id, @Nullable ClusterSnapshotState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("aws:redshift/clusterSnapshot:ClusterSnapshot", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ClusterSnapshot get(String name, Output<String> id, @Nullable ClusterSnapshotState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ClusterSnapshot(name, id, state, options);
    }
}
