// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterScalingConfiguration {
    /**
     * @return Whether to enable automatic pause. A DB cluster can be paused only when it&#39;s idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
     * 
     */
    private @Nullable Boolean autoPause;
    /**
     * @return Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
     * 
     */
    private @Nullable Integer maxCapacity;
    /**
     * @return Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
     * 
     */
    private @Nullable Integer minCapacity;
    /**
     * @return Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
     * 
     */
    private @Nullable Integer secondsUntilAutoPause;
    /**
     * @return Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
     * 
     */
    private @Nullable String timeoutAction;

    private ClusterScalingConfiguration() {}
    /**
     * @return Whether to enable automatic pause. A DB cluster can be paused only when it&#39;s idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
     * 
     */
    public Optional<Boolean> autoPause() {
        return Optional.ofNullable(this.autoPause);
    }
    /**
     * @return Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
     * 
     */
    public Optional<Integer> maxCapacity() {
        return Optional.ofNullable(this.maxCapacity);
    }
    /**
     * @return Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
     * 
     */
    public Optional<Integer> minCapacity() {
        return Optional.ofNullable(this.minCapacity);
    }
    /**
     * @return Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
     * 
     */
    public Optional<Integer> secondsUntilAutoPause() {
        return Optional.ofNullable(this.secondsUntilAutoPause);
    }
    /**
     * @return Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
     * 
     */
    public Optional<String> timeoutAction() {
        return Optional.ofNullable(this.timeoutAction);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterScalingConfiguration defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Boolean autoPause;
        private @Nullable Integer maxCapacity;
        private @Nullable Integer minCapacity;
        private @Nullable Integer secondsUntilAutoPause;
        private @Nullable String timeoutAction;
        public Builder() {}
        public Builder(ClusterScalingConfiguration defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.autoPause = defaults.autoPause;
    	      this.maxCapacity = defaults.maxCapacity;
    	      this.minCapacity = defaults.minCapacity;
    	      this.secondsUntilAutoPause = defaults.secondsUntilAutoPause;
    	      this.timeoutAction = defaults.timeoutAction;
        }

        @CustomType.Setter
        public Builder autoPause(@Nullable Boolean autoPause) {
            this.autoPause = autoPause;
            return this;
        }
        @CustomType.Setter
        public Builder maxCapacity(@Nullable Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }
        @CustomType.Setter
        public Builder minCapacity(@Nullable Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }
        @CustomType.Setter
        public Builder secondsUntilAutoPause(@Nullable Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
            return this;
        }
        @CustomType.Setter
        public Builder timeoutAction(@Nullable String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }
        public ClusterScalingConfiguration build() {
            final var o = new ClusterScalingConfiguration();
            o.autoPause = autoPause;
            o.maxCapacity = maxCapacity;
            o.minCapacity = minCapacity;
            o.secondsUntilAutoPause = secondsUntilAutoPause;
            o.timeoutAction = timeoutAction;
            return o;
        }
    }
}
