// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterRestoreToPointInTime {
    /**
     * @return Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
     * 
     */
    private @Nullable String restoreToTime;
    /**
     * @return Type of restore to be performed.
     * Valid options are `full-copy` (default) and `copy-on-write`.
     * 
     */
    private @Nullable String restoreType;
    /**
     * @return Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
     * 
     */
    private String sourceClusterIdentifier;
    /**
     * @return Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
     * 
     */
    private @Nullable Boolean useLatestRestorableTime;

    private ClusterRestoreToPointInTime() {}
    /**
     * @return Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
     * 
     */
    public Optional<String> restoreToTime() {
        return Optional.ofNullable(this.restoreToTime);
    }
    /**
     * @return Type of restore to be performed.
     * Valid options are `full-copy` (default) and `copy-on-write`.
     * 
     */
    public Optional<String> restoreType() {
        return Optional.ofNullable(this.restoreType);
    }
    /**
     * @return Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
     * 
     */
    public String sourceClusterIdentifier() {
        return this.sourceClusterIdentifier;
    }
    /**
     * @return Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
     * 
     */
    public Optional<Boolean> useLatestRestorableTime() {
        return Optional.ofNullable(this.useLatestRestorableTime);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterRestoreToPointInTime defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable String restoreToTime;
        private @Nullable String restoreType;
        private String sourceClusterIdentifier;
        private @Nullable Boolean useLatestRestorableTime;
        public Builder() {}
        public Builder(ClusterRestoreToPointInTime defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.restoreToTime = defaults.restoreToTime;
    	      this.restoreType = defaults.restoreType;
    	      this.sourceClusterIdentifier = defaults.sourceClusterIdentifier;
    	      this.useLatestRestorableTime = defaults.useLatestRestorableTime;
        }

        @CustomType.Setter
        public Builder restoreToTime(@Nullable String restoreToTime) {
            this.restoreToTime = restoreToTime;
            return this;
        }
        @CustomType.Setter
        public Builder restoreType(@Nullable String restoreType) {
            this.restoreType = restoreType;
            return this;
        }
        @CustomType.Setter
        public Builder sourceClusterIdentifier(String sourceClusterIdentifier) {
            this.sourceClusterIdentifier = Objects.requireNonNull(sourceClusterIdentifier);
            return this;
        }
        @CustomType.Setter
        public Builder useLatestRestorableTime(@Nullable Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }
        public ClusterRestoreToPointInTime build() {
            final var o = new ClusterRestoreToPointInTime();
            o.restoreToTime = restoreToTime;
            o.restoreType = restoreType;
            o.sourceClusterIdentifier = sourceClusterIdentifier;
            o.useLatestRestorableTime = useLatestRestorableTime;
            return o;
        }
    }
}
