// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ProxyTargetState extends com.pulumi.resources.ResourceArgs {

    public static final ProxyTargetState Empty = new ProxyTargetState();

    /**
     * DB cluster identifier.
     * 
     * **NOTE:** Either `db_instance_identifier` or `db_cluster_identifier` should be specified and both should not be specified together
     * 
     */
    @Import(name="dbClusterIdentifier")
    private @Nullable Output<String> dbClusterIdentifier;

    /**
     * @return DB cluster identifier.
     * 
     * **NOTE:** Either `db_instance_identifier` or `db_cluster_identifier` should be specified and both should not be specified together
     * 
     */
    public Optional<Output<String>> dbClusterIdentifier() {
        return Optional.ofNullable(this.dbClusterIdentifier);
    }

    /**
     * DB instance identifier.
     * 
     */
    @Import(name="dbInstanceIdentifier")
    private @Nullable Output<String> dbInstanceIdentifier;

    /**
     * @return DB instance identifier.
     * 
     */
    public Optional<Output<String>> dbInstanceIdentifier() {
        return Optional.ofNullable(this.dbInstanceIdentifier);
    }

    /**
     * The name of the DB proxy.
     * 
     */
    @Import(name="dbProxyName")
    private @Nullable Output<String> dbProxyName;

    /**
     * @return The name of the DB proxy.
     * 
     */
    public Optional<Output<String>> dbProxyName() {
        return Optional.ofNullable(this.dbProxyName);
    }

    /**
     * Hostname for the target RDS DB Instance. Only returned for `RDS_INSTANCE` type.
     * 
     */
    @Import(name="endpoint")
    private @Nullable Output<String> endpoint;

    /**
     * @return Hostname for the target RDS DB Instance. Only returned for `RDS_INSTANCE` type.
     * 
     */
    public Optional<Output<String>> endpoint() {
        return Optional.ofNullable(this.endpoint);
    }

    /**
     * Port for the target RDS DB Instance or Aurora DB Cluster.
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return Port for the target RDS DB Instance or Aurora DB Cluster.
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * Identifier representing the DB Instance or DB Cluster target.
     * 
     */
    @Import(name="rdsResourceId")
    private @Nullable Output<String> rdsResourceId;

    /**
     * @return Identifier representing the DB Instance or DB Cluster target.
     * 
     */
    public Optional<Output<String>> rdsResourceId() {
        return Optional.ofNullable(this.rdsResourceId);
    }

    /**
     * Amazon Resource Name (ARN) for the DB instance or DB cluster. Currently not returned by the RDS API.
     * 
     */
    @Import(name="targetArn")
    private @Nullable Output<String> targetArn;

    /**
     * @return Amazon Resource Name (ARN) for the DB instance or DB cluster. Currently not returned by the RDS API.
     * 
     */
    public Optional<Output<String>> targetArn() {
        return Optional.ofNullable(this.targetArn);
    }

    /**
     * The name of the target group.
     * 
     */
    @Import(name="targetGroupName")
    private @Nullable Output<String> targetGroupName;

    /**
     * @return The name of the target group.
     * 
     */
    public Optional<Output<String>> targetGroupName() {
        return Optional.ofNullable(this.targetGroupName);
    }

    /**
     * DB Cluster identifier for the DB Instance target. Not returned unless manually importing an `RDS_INSTANCE` target that is part of a DB Cluster.
     * 
     */
    @Import(name="trackedClusterId")
    private @Nullable Output<String> trackedClusterId;

    /**
     * @return DB Cluster identifier for the DB Instance target. Not returned unless manually importing an `RDS_INSTANCE` target that is part of a DB Cluster.
     * 
     */
    public Optional<Output<String>> trackedClusterId() {
        return Optional.ofNullable(this.trackedClusterId);
    }

    /**
     * Type of targetE.g., `RDS_INSTANCE` or `TRACKED_CLUSTER`
     * 
     */
    @Import(name="type")
    private @Nullable Output<String> type;

    /**
     * @return Type of targetE.g., `RDS_INSTANCE` or `TRACKED_CLUSTER`
     * 
     */
    public Optional<Output<String>> type() {
        return Optional.ofNullable(this.type);
    }

    private ProxyTargetState() {}

    private ProxyTargetState(ProxyTargetState $) {
        this.dbClusterIdentifier = $.dbClusterIdentifier;
        this.dbInstanceIdentifier = $.dbInstanceIdentifier;
        this.dbProxyName = $.dbProxyName;
        this.endpoint = $.endpoint;
        this.port = $.port;
        this.rdsResourceId = $.rdsResourceId;
        this.targetArn = $.targetArn;
        this.targetGroupName = $.targetGroupName;
        this.trackedClusterId = $.trackedClusterId;
        this.type = $.type;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ProxyTargetState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ProxyTargetState $;

        public Builder() {
            $ = new ProxyTargetState();
        }

        public Builder(ProxyTargetState defaults) {
            $ = new ProxyTargetState(Objects.requireNonNull(defaults));
        }

        /**
         * @param dbClusterIdentifier DB cluster identifier.
         * 
         * **NOTE:** Either `db_instance_identifier` or `db_cluster_identifier` should be specified and both should not be specified together
         * 
         * @return builder
         * 
         */
        public Builder dbClusterIdentifier(@Nullable Output<String> dbClusterIdentifier) {
            $.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        /**
         * @param dbClusterIdentifier DB cluster identifier.
         * 
         * **NOTE:** Either `db_instance_identifier` or `db_cluster_identifier` should be specified and both should not be specified together
         * 
         * @return builder
         * 
         */
        public Builder dbClusterIdentifier(String dbClusterIdentifier) {
            return dbClusterIdentifier(Output.of(dbClusterIdentifier));
        }

        /**
         * @param dbInstanceIdentifier DB instance identifier.
         * 
         * @return builder
         * 
         */
        public Builder dbInstanceIdentifier(@Nullable Output<String> dbInstanceIdentifier) {
            $.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        /**
         * @param dbInstanceIdentifier DB instance identifier.
         * 
         * @return builder
         * 
         */
        public Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            return dbInstanceIdentifier(Output.of(dbInstanceIdentifier));
        }

        /**
         * @param dbProxyName The name of the DB proxy.
         * 
         * @return builder
         * 
         */
        public Builder dbProxyName(@Nullable Output<String> dbProxyName) {
            $.dbProxyName = dbProxyName;
            return this;
        }

        /**
         * @param dbProxyName The name of the DB proxy.
         * 
         * @return builder
         * 
         */
        public Builder dbProxyName(String dbProxyName) {
            return dbProxyName(Output.of(dbProxyName));
        }

        /**
         * @param endpoint Hostname for the target RDS DB Instance. Only returned for `RDS_INSTANCE` type.
         * 
         * @return builder
         * 
         */
        public Builder endpoint(@Nullable Output<String> endpoint) {
            $.endpoint = endpoint;
            return this;
        }

        /**
         * @param endpoint Hostname for the target RDS DB Instance. Only returned for `RDS_INSTANCE` type.
         * 
         * @return builder
         * 
         */
        public Builder endpoint(String endpoint) {
            return endpoint(Output.of(endpoint));
        }

        /**
         * @param port Port for the target RDS DB Instance or Aurora DB Cluster.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port Port for the target RDS DB Instance or Aurora DB Cluster.
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param rdsResourceId Identifier representing the DB Instance or DB Cluster target.
         * 
         * @return builder
         * 
         */
        public Builder rdsResourceId(@Nullable Output<String> rdsResourceId) {
            $.rdsResourceId = rdsResourceId;
            return this;
        }

        /**
         * @param rdsResourceId Identifier representing the DB Instance or DB Cluster target.
         * 
         * @return builder
         * 
         */
        public Builder rdsResourceId(String rdsResourceId) {
            return rdsResourceId(Output.of(rdsResourceId));
        }

        /**
         * @param targetArn Amazon Resource Name (ARN) for the DB instance or DB cluster. Currently not returned by the RDS API.
         * 
         * @return builder
         * 
         */
        public Builder targetArn(@Nullable Output<String> targetArn) {
            $.targetArn = targetArn;
            return this;
        }

        /**
         * @param targetArn Amazon Resource Name (ARN) for the DB instance or DB cluster. Currently not returned by the RDS API.
         * 
         * @return builder
         * 
         */
        public Builder targetArn(String targetArn) {
            return targetArn(Output.of(targetArn));
        }

        /**
         * @param targetGroupName The name of the target group.
         * 
         * @return builder
         * 
         */
        public Builder targetGroupName(@Nullable Output<String> targetGroupName) {
            $.targetGroupName = targetGroupName;
            return this;
        }

        /**
         * @param targetGroupName The name of the target group.
         * 
         * @return builder
         * 
         */
        public Builder targetGroupName(String targetGroupName) {
            return targetGroupName(Output.of(targetGroupName));
        }

        /**
         * @param trackedClusterId DB Cluster identifier for the DB Instance target. Not returned unless manually importing an `RDS_INSTANCE` target that is part of a DB Cluster.
         * 
         * @return builder
         * 
         */
        public Builder trackedClusterId(@Nullable Output<String> trackedClusterId) {
            $.trackedClusterId = trackedClusterId;
            return this;
        }

        /**
         * @param trackedClusterId DB Cluster identifier for the DB Instance target. Not returned unless manually importing an `RDS_INSTANCE` target that is part of a DB Cluster.
         * 
         * @return builder
         * 
         */
        public Builder trackedClusterId(String trackedClusterId) {
            return trackedClusterId(Output.of(trackedClusterId));
        }

        /**
         * @param type Type of targetE.g., `RDS_INSTANCE` or `TRACKED_CLUSTER`
         * 
         * @return builder
         * 
         */
        public Builder type(@Nullable Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type Type of targetE.g., `RDS_INSTANCE` or `TRACKED_CLUSTER`
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        public ProxyTargetState build() {
            return $;
        }
    }

}
