// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ProxyEndpointState extends com.pulumi.resources.ResourceArgs {

    public static final ProxyEndpointState Empty = new ProxyEndpointState();

    /**
     * The Amazon Resource Name (ARN) for the proxy endpoint.
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return The Amazon Resource Name (ARN) for the proxy endpoint.
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can&#39;t end with a hyphen or contain two consecutive hyphens.
     * 
     */
    @Import(name="dbProxyEndpointName")
    private @Nullable Output<String> dbProxyEndpointName;

    /**
     * @return The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can&#39;t end with a hyphen or contain two consecutive hyphens.
     * 
     */
    public Optional<Output<String>> dbProxyEndpointName() {
        return Optional.ofNullable(this.dbProxyEndpointName);
    }

    /**
     * The name of the DB proxy associated with the DB proxy endpoint that you create.
     * 
     */
    @Import(name="dbProxyName")
    private @Nullable Output<String> dbProxyName;

    /**
     * @return The name of the DB proxy associated with the DB proxy endpoint that you create.
     * 
     */
    public Optional<Output<String>> dbProxyName() {
        return Optional.ofNullable(this.dbProxyName);
    }

    /**
     * The endpoint that you can use to connect to the proxy. You include the endpoint value in the connection string for a database client application.
     * 
     */
    @Import(name="endpoint")
    private @Nullable Output<String> endpoint;

    /**
     * @return The endpoint that you can use to connect to the proxy. You include the endpoint value in the connection string for a database client application.
     * 
     */
    public Optional<Output<String>> endpoint() {
        return Optional.ofNullable(this.endpoint);
    }

    /**
     * Indicates whether this endpoint is the default endpoint for the associated DB proxy.
     * 
     */
    @Import(name="isDefault")
    private @Nullable Output<Boolean> isDefault;

    /**
     * @return Indicates whether this endpoint is the default endpoint for the associated DB proxy.
     * 
     */
    public Optional<Output<Boolean>> isDefault() {
        return Optional.ofNullable(this.isDefault);
    }

    /**
     * A mapping of tags to assign to the resource.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A mapping of tags to assign to the resource.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
     * 
     */
    @Import(name="targetRole")
    private @Nullable Output<String> targetRole;

    /**
     * @return Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
     * 
     */
    public Optional<Output<String>> targetRole() {
        return Optional.ofNullable(this.targetRole);
    }

    /**
     * The VPC ID of the DB proxy endpoint.
     * 
     */
    @Import(name="vpcId")
    private @Nullable Output<String> vpcId;

    /**
     * @return The VPC ID of the DB proxy endpoint.
     * 
     */
    public Optional<Output<String>> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    /**
     * One or more VPC security group IDs to associate with the new proxy.
     * 
     */
    @Import(name="vpcSecurityGroupIds")
    private @Nullable Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return One or more VPC security group IDs to associate with the new proxy.
     * 
     */
    public Optional<Output<List<String>>> vpcSecurityGroupIds() {
        return Optional.ofNullable(this.vpcSecurityGroupIds);
    }

    /**
     * One or more VPC subnet IDs to associate with the new proxy.
     * 
     */
    @Import(name="vpcSubnetIds")
    private @Nullable Output<List<String>> vpcSubnetIds;

    /**
     * @return One or more VPC subnet IDs to associate with the new proxy.
     * 
     */
    public Optional<Output<List<String>>> vpcSubnetIds() {
        return Optional.ofNullable(this.vpcSubnetIds);
    }

    private ProxyEndpointState() {}

    private ProxyEndpointState(ProxyEndpointState $) {
        this.arn = $.arn;
        this.dbProxyEndpointName = $.dbProxyEndpointName;
        this.dbProxyName = $.dbProxyName;
        this.endpoint = $.endpoint;
        this.isDefault = $.isDefault;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.targetRole = $.targetRole;
        this.vpcId = $.vpcId;
        this.vpcSecurityGroupIds = $.vpcSecurityGroupIds;
        this.vpcSubnetIds = $.vpcSubnetIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ProxyEndpointState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ProxyEndpointState $;

        public Builder() {
            $ = new ProxyEndpointState();
        }

        public Builder(ProxyEndpointState defaults) {
            $ = new ProxyEndpointState(Objects.requireNonNull(defaults));
        }

        /**
         * @param arn The Amazon Resource Name (ARN) for the proxy endpoint.
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn The Amazon Resource Name (ARN) for the proxy endpoint.
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param dbProxyEndpointName The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can&#39;t end with a hyphen or contain two consecutive hyphens.
         * 
         * @return builder
         * 
         */
        public Builder dbProxyEndpointName(@Nullable Output<String> dbProxyEndpointName) {
            $.dbProxyEndpointName = dbProxyEndpointName;
            return this;
        }

        /**
         * @param dbProxyEndpointName The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can&#39;t end with a hyphen or contain two consecutive hyphens.
         * 
         * @return builder
         * 
         */
        public Builder dbProxyEndpointName(String dbProxyEndpointName) {
            return dbProxyEndpointName(Output.of(dbProxyEndpointName));
        }

        /**
         * @param dbProxyName The name of the DB proxy associated with the DB proxy endpoint that you create.
         * 
         * @return builder
         * 
         */
        public Builder dbProxyName(@Nullable Output<String> dbProxyName) {
            $.dbProxyName = dbProxyName;
            return this;
        }

        /**
         * @param dbProxyName The name of the DB proxy associated with the DB proxy endpoint that you create.
         * 
         * @return builder
         * 
         */
        public Builder dbProxyName(String dbProxyName) {
            return dbProxyName(Output.of(dbProxyName));
        }

        /**
         * @param endpoint The endpoint that you can use to connect to the proxy. You include the endpoint value in the connection string for a database client application.
         * 
         * @return builder
         * 
         */
        public Builder endpoint(@Nullable Output<String> endpoint) {
            $.endpoint = endpoint;
            return this;
        }

        /**
         * @param endpoint The endpoint that you can use to connect to the proxy. You include the endpoint value in the connection string for a database client application.
         * 
         * @return builder
         * 
         */
        public Builder endpoint(String endpoint) {
            return endpoint(Output.of(endpoint));
        }

        /**
         * @param isDefault Indicates whether this endpoint is the default endpoint for the associated DB proxy.
         * 
         * @return builder
         * 
         */
        public Builder isDefault(@Nullable Output<Boolean> isDefault) {
            $.isDefault = isDefault;
            return this;
        }

        /**
         * @param isDefault Indicates whether this endpoint is the default endpoint for the associated DB proxy.
         * 
         * @return builder
         * 
         */
        public Builder isDefault(Boolean isDefault) {
            return isDefault(Output.of(isDefault));
        }

        /**
         * @param tags A mapping of tags to assign to the resource.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A mapping of tags to assign to the resource.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param targetRole Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
         * 
         * @return builder
         * 
         */
        public Builder targetRole(@Nullable Output<String> targetRole) {
            $.targetRole = targetRole;
            return this;
        }

        /**
         * @param targetRole Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
         * 
         * @return builder
         * 
         */
        public Builder targetRole(String targetRole) {
            return targetRole(Output.of(targetRole));
        }

        /**
         * @param vpcId The VPC ID of the DB proxy endpoint.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(@Nullable Output<String> vpcId) {
            $.vpcId = vpcId;
            return this;
        }

        /**
         * @param vpcId The VPC ID of the DB proxy endpoint.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(String vpcId) {
            return vpcId(Output.of(vpcId));
        }

        /**
         * @param vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(@Nullable Output<List<String>> vpcSecurityGroupIds) {
            $.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * @param vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(Output.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSubnetIds(@Nullable Output<List<String>> vpcSubnetIds) {
            $.vpcSubnetIds = vpcSubnetIds;
            return this;
        }

        /**
         * @param vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSubnetIds(List<String> vpcSubnetIds) {
            return vpcSubnetIds(Output.of(vpcSubnetIds));
        }

        /**
         * @param vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy.
         * 
         * @return builder
         * 
         */
        public Builder vpcSubnetIds(String... vpcSubnetIds) {
            return vpcSubnetIds(List.of(vpcSubnetIds));
        }

        public ProxyEndpointState build() {
            return $;
        }
    }

}
