// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds.inputs;

import com.pulumi.aws.rds.enums.EngineMode;
import com.pulumi.aws.rds.enums.EngineType;
import com.pulumi.aws.rds.inputs.ClusterMasterUserSecretArgs;
import com.pulumi.aws.rds.inputs.ClusterRestoreToPointInTimeArgs;
import com.pulumi.aws.rds.inputs.ClusterS3ImportArgs;
import com.pulumi.aws.rds.inputs.ClusterScalingConfigurationArgs;
import com.pulumi.aws.rds.inputs.ClusterServerlessv2ScalingConfigurationArgs;
import com.pulumi.core.Either;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterState extends com.pulumi.resources.ResourceArgs {

    public static final ClusterState Empty = new ClusterState();

    /**
     * (Required for Multi-AZ DB cluster) The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     * 
     */
    @Import(name="allocatedStorage")
    private @Nullable Output<Integer> allocatedStorage;

    /**
     * @return (Required for Multi-AZ DB cluster) The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     * 
     */
    public Optional<Output<Integer>> allocatedStorage() {
        return Optional.ofNullable(this.allocatedStorage);
    }

    /**
     * Enable to allow major engine version upgrades when changing engine versions. Defaults to `false`.
     * 
     */
    @Import(name="allowMajorVersionUpgrade")
    private @Nullable Output<Boolean> allowMajorVersionUpgrade;

    /**
     * @return Enable to allow major engine version upgrades when changing engine versions. Defaults to `false`.
     * 
     */
    public Optional<Output<Boolean>> allowMajorVersionUpgrade() {
        return Optional.ofNullable(this.allowMajorVersionUpgrade);
    }

    /**
     * Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon RDS Documentation for more information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
     * 
     */
    @Import(name="applyImmediately")
    private @Nullable Output<Boolean> applyImmediately;

    /**
     * @return Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon RDS Documentation for more information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
     * 
     */
    public Optional<Output<Boolean>> applyImmediately() {
        return Optional.ofNullable(this.applyImmediately);
    }

    /**
     * Amazon Resource Name (ARN) of cluster
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of cluster
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * List of EC2 Availability Zones for the DB cluster storage where DB cluster instances can be created. RDS automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next apply. We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary. A maximum of 3 AZs can be configured.
     * 
     */
    @Import(name="availabilityZones")
    private @Nullable Output<List<String>> availabilityZones;

    /**
     * @return List of EC2 Availability Zones for the DB cluster storage where DB cluster instances can be created. RDS automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next apply. We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary. A maximum of 3 AZs can be configured.
     * 
     */
    public Optional<Output<List<String>>> availabilityZones() {
        return Optional.ofNullable(this.availabilityZones);
    }

    /**
     * Target backtrack window, in seconds. Only available for `aurora` and `aurora-mysql` engines currently. To disable backtracking, set this value to `0`. Defaults to `0`. Must be between `0` and `259200` (72 hours)
     * 
     */
    @Import(name="backtrackWindow")
    private @Nullable Output<Integer> backtrackWindow;

    /**
     * @return Target backtrack window, in seconds. Only available for `aurora` and `aurora-mysql` engines currently. To disable backtracking, set this value to `0`. Defaults to `0`. Must be between `0` and `259200` (72 hours)
     * 
     */
    public Optional<Output<Integer>> backtrackWindow() {
        return Optional.ofNullable(this.backtrackWindow);
    }

    /**
     * Days to retain backups for. Default `1`
     * 
     */
    @Import(name="backupRetentionPeriod")
    private @Nullable Output<Integer> backupRetentionPeriod;

    /**
     * @return Days to retain backups for. Default `1`
     * 
     */
    public Optional<Output<Integer>> backupRetentionPeriod() {
        return Optional.ofNullable(this.backupRetentionPeriod);
    }

    /**
     * The cluster identifier. If omitted, this provider will assign a random, unique identifier.
     * 
     */
    @Import(name="clusterIdentifier")
    private @Nullable Output<String> clusterIdentifier;

    /**
     * @return The cluster identifier. If omitted, this provider will assign a random, unique identifier.
     * 
     */
    public Optional<Output<String>> clusterIdentifier() {
        return Optional.ofNullable(this.clusterIdentifier);
    }

    /**
     * Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     * 
     */
    @Import(name="clusterIdentifierPrefix")
    private @Nullable Output<String> clusterIdentifierPrefix;

    /**
     * @return Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
     * 
     */
    public Optional<Output<String>> clusterIdentifierPrefix() {
        return Optional.ofNullable(this.clusterIdentifierPrefix);
    }

    /**
     * List of RDS Instances that are a part of this cluster
     * 
     */
    @Import(name="clusterMembers")
    private @Nullable Output<List<String>> clusterMembers;

    /**
     * @return List of RDS Instances that are a part of this cluster
     * 
     */
    public Optional<Output<List<String>>> clusterMembers() {
        return Optional.ofNullable(this.clusterMembers);
    }

    /**
     * RDS Cluster Resource ID
     * 
     */
    @Import(name="clusterResourceId")
    private @Nullable Output<String> clusterResourceId;

    /**
     * @return RDS Cluster Resource ID
     * 
     */
    public Optional<Output<String>> clusterResourceId() {
        return Optional.ofNullable(this.clusterResourceId);
    }

    /**
     * Copy all Cluster `tags` to snapshots. Default is `false`.
     * 
     */
    @Import(name="copyTagsToSnapshot")
    private @Nullable Output<Boolean> copyTagsToSnapshot;

    /**
     * @return Copy all Cluster `tags` to snapshots. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> copyTagsToSnapshot() {
        return Optional.ofNullable(this.copyTagsToSnapshot);
    }

    /**
     * Name for an automatically created database on cluster creation. There are different naming restrictions per database engine: [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints)
     * 
     */
    @Import(name="databaseName")
    private @Nullable Output<String> databaseName;

    /**
     * @return Name for an automatically created database on cluster creation. There are different naming restrictions per database engine: [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints)
     * 
     */
    public Optional<Output<String>> databaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    /**
     * (Required for Multi-AZ DB cluster) The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all AWS Regions, or for all database engines. For the full list of DB instance classes and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the Amazon RDS User Guide.
     * 
     */
    @Import(name="dbClusterInstanceClass")
    private @Nullable Output<String> dbClusterInstanceClass;

    /**
     * @return (Required for Multi-AZ DB cluster) The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all AWS Regions, or for all database engines. For the full list of DB instance classes and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the Amazon RDS User Guide.
     * 
     */
    public Optional<Output<String>> dbClusterInstanceClass() {
        return Optional.ofNullable(this.dbClusterInstanceClass);
    }

    /**
     * A cluster parameter group to associate with the cluster.
     * 
     */
    @Import(name="dbClusterParameterGroupName")
    private @Nullable Output<String> dbClusterParameterGroupName;

    /**
     * @return A cluster parameter group to associate with the cluster.
     * 
     */
    public Optional<Output<String>> dbClusterParameterGroupName() {
        return Optional.ofNullable(this.dbClusterParameterGroupName);
    }

    /**
     * Instance parameter group to associate with all instances of the DB cluster. The `db_instance_parameter_group_name` parameter is only valid in combination with the `allow_major_version_upgrade` parameter.
     * 
     */
    @Import(name="dbInstanceParameterGroupName")
    private @Nullable Output<String> dbInstanceParameterGroupName;

    /**
     * @return Instance parameter group to associate with all instances of the DB cluster. The `db_instance_parameter_group_name` parameter is only valid in combination with the `allow_major_version_upgrade` parameter.
     * 
     */
    public Optional<Output<String>> dbInstanceParameterGroupName() {
        return Optional.ofNullable(this.dbInstanceParameterGroupName);
    }

    /**
     * DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` specified on every `aws.rds.ClusterInstance` in the cluster.
     * 
     */
    @Import(name="dbSubnetGroupName")
    private @Nullable Output<String> dbSubnetGroupName;

    /**
     * @return DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` specified on every `aws.rds.ClusterInstance` in the cluster.
     * 
     */
    public Optional<Output<String>> dbSubnetGroupName() {
        return Optional.ofNullable(this.dbSubnetGroupName);
    }

    /**
     * For use with RDS Custom.
     * 
     */
    @Import(name="dbSystemId")
    private @Nullable Output<String> dbSystemId;

    /**
     * @return For use with RDS Custom.
     * 
     */
    public Optional<Output<String>> dbSystemId() {
        return Optional.ofNullable(this.dbSystemId);
    }

    /**
     * If the DB instance should have deletion protection enabled. The database can&#39;t be deleted when this value is set to `true`. The default is `false`.
     * 
     */
    @Import(name="deletionProtection")
    private @Nullable Output<Boolean> deletionProtection;

    /**
     * @return If the DB instance should have deletion protection enabled. The database can&#39;t be deleted when this value is set to `true`. The default is `false`.
     * 
     */
    public Optional<Output<Boolean>> deletionProtection() {
        return Optional.ofNullable(this.deletionProtection);
    }

    /**
     * Whether cluster should forward writes to an associated global cluster. Applied to secondary clusters to enable them to forward writes to an `aws.rds.GlobalCluster`&#39;s primary cluster. See the [Aurora Userguide documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-write-forwarding.html) for more information.
     * 
     */
    @Import(name="enableGlobalWriteForwarding")
    private @Nullable Output<Boolean> enableGlobalWriteForwarding;

    /**
     * @return Whether cluster should forward writes to an associated global cluster. Applied to secondary clusters to enable them to forward writes to an `aws.rds.GlobalCluster`&#39;s primary cluster. See the [Aurora Userguide documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-write-forwarding.html) for more information.
     * 
     */
    public Optional<Output<Boolean>> enableGlobalWriteForwarding() {
        return Optional.ofNullable(this.enableGlobalWriteForwarding);
    }

    /**
     * Enable HTTP endpoint (data API). Only valid when `engine_mode` is set to `serverless`.
     * 
     */
    @Import(name="enableHttpEndpoint")
    private @Nullable Output<Boolean> enableHttpEndpoint;

    /**
     * @return Enable HTTP endpoint (data API). Only valid when `engine_mode` is set to `serverless`.
     * 
     */
    public Optional<Output<Boolean>> enableHttpEndpoint() {
        return Optional.ofNullable(this.enableHttpEndpoint);
    }

    /**
     * Set of log types to export to cloudwatch. If omitted, no logs will be exported. The following log types are supported: `audit`, `error`, `general`, `slowquery`, `postgresql` (PostgreSQL).
     * 
     */
    @Import(name="enabledCloudwatchLogsExports")
    private @Nullable Output<List<String>> enabledCloudwatchLogsExports;

    /**
     * @return Set of log types to export to cloudwatch. If omitted, no logs will be exported. The following log types are supported: `audit`, `error`, `general`, `slowquery`, `postgresql` (PostgreSQL).
     * 
     */
    public Optional<Output<List<String>>> enabledCloudwatchLogsExports() {
        return Optional.ofNullable(this.enabledCloudwatchLogsExports);
    }

    /**
     * DNS address of the RDS instance
     * 
     */
    @Import(name="endpoint")
    private @Nullable Output<String> endpoint;

    /**
     * @return DNS address of the RDS instance
     * 
     */
    public Optional<Output<String>> endpoint() {
        return Optional.ofNullable(this.endpoint);
    }

    /**
     * Name of the database engine to be used for this DB cluster. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`. (Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
     * 
     */
    @Import(name="engine")
    private @Nullable Output<Either<String,EngineType>> engine;

    /**
     * @return Name of the database engine to be used for this DB cluster. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`. (Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
     * 
     */
    public Optional<Output<Either<String,EngineType>>> engine() {
        return Optional.ofNullable(this.engine);
    }

    /**
     * Database engine mode. Valid values: `global` (only valid for Aurora MySQL 1.21 and earlier), `multimaster`, `parallelquery`, `provisioned`, `serverless`. Defaults to: `provisioned`. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/aurora-serverless.html) for limitations when using `serverless`.
     * 
     */
    @Import(name="engineMode")
    private @Nullable Output<Either<String,EngineMode>> engineMode;

    /**
     * @return Database engine mode. Valid values: `global` (only valid for Aurora MySQL 1.21 and earlier), `multimaster`, `parallelquery`, `provisioned`, `serverless`. Defaults to: `provisioned`. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/aurora-serverless.html) for limitations when using `serverless`.
     * 
     */
    public Optional<Output<Either<String,EngineMode>>> engineMode() {
        return Optional.ofNullable(this.engineMode);
    }

    /**
     * Database engine version. Updating this argument results in an outage. See the [Aurora MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) and [Aurora Postgres](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.html) documentation for your configured engine to determine this value, or by running `aws rds describe-db-engine-versions`. For example with Aurora MySQL 2, a potential value for this argument is `5.7.mysql_aurora.2.03.2`. The value can contain a partial version where supported by the API. The actual engine version used is returned in the attribute `engine_version_actual`, , see Attribute Reference below.
     * 
     */
    @Import(name="engineVersion")
    private @Nullable Output<String> engineVersion;

    /**
     * @return Database engine version. Updating this argument results in an outage. See the [Aurora MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) and [Aurora Postgres](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.html) documentation for your configured engine to determine this value, or by running `aws rds describe-db-engine-versions`. For example with Aurora MySQL 2, a potential value for this argument is `5.7.mysql_aurora.2.03.2`. The value can contain a partial version where supported by the API. The actual engine version used is returned in the attribute `engine_version_actual`, , see Attribute Reference below.
     * 
     */
    public Optional<Output<String>> engineVersion() {
        return Optional.ofNullable(this.engineVersion);
    }

    /**
     * Running version of the database.
     * 
     */
    @Import(name="engineVersionActual")
    private @Nullable Output<String> engineVersionActual;

    /**
     * @return Running version of the database.
     * 
     */
    public Optional<Output<String>> engineVersionActual() {
        return Optional.ofNullable(this.engineVersionActual);
    }

    /**
     * Name of your final DB snapshot when this DB cluster is deleted. If omitted, no final snapshot will be made.
     * 
     */
    @Import(name="finalSnapshotIdentifier")
    private @Nullable Output<String> finalSnapshotIdentifier;

    /**
     * @return Name of your final DB snapshot when this DB cluster is deleted. If omitted, no final snapshot will be made.
     * 
     */
    public Optional<Output<String>> finalSnapshotIdentifier() {
        return Optional.ofNullable(this.finalSnapshotIdentifier);
    }

    /**
     * Global cluster identifier specified on `aws.rds.GlobalCluster`.
     * 
     */
    @Import(name="globalClusterIdentifier")
    private @Nullable Output<String> globalClusterIdentifier;

    /**
     * @return Global cluster identifier specified on `aws.rds.GlobalCluster`.
     * 
     */
    public Optional<Output<String>> globalClusterIdentifier() {
        return Optional.ofNullable(this.globalClusterIdentifier);
    }

    /**
     * Route53 Hosted Zone ID of the endpoint
     * 
     */
    @Import(name="hostedZoneId")
    private @Nullable Output<String> hostedZoneId;

    /**
     * @return Route53 Hosted Zone ID of the endpoint
     * 
     */
    public Optional<Output<String>> hostedZoneId() {
        return Optional.ofNullable(this.hostedZoneId);
    }

    /**
     * Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) for availability and limitations.
     * 
     */
    @Import(name="iamDatabaseAuthenticationEnabled")
    private @Nullable Output<Boolean> iamDatabaseAuthenticationEnabled;

    /**
     * @return Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) for availability and limitations.
     * 
     */
    public Optional<Output<Boolean>> iamDatabaseAuthenticationEnabled() {
        return Optional.ofNullable(this.iamDatabaseAuthenticationEnabled);
    }

    /**
     * List of ARNs for the IAM roles to associate to the RDS Cluster.
     * 
     */
    @Import(name="iamRoles")
    private @Nullable Output<List<String>> iamRoles;

    /**
     * @return List of ARNs for the IAM roles to associate to the RDS Cluster.
     * 
     */
    public Optional<Output<List<String>>> iamRoles() {
        return Optional.ofNullable(this.iamRoles);
    }

    /**
     * Amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster. For information about valid Iops values, see [Amazon RDS Provisioned IOPS storage to improve performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the Amazon RDS User Guide. (This setting is required to create a Multi-AZ DB cluster). Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     * 
     */
    @Import(name="iops")
    private @Nullable Output<Integer> iops;

    /**
     * @return Amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster. For information about valid Iops values, see [Amazon RDS Provisioned IOPS storage to improve performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the Amazon RDS User Guide. (This setting is required to create a Multi-AZ DB cluster). Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     * 
     */
    public Optional<Output<Integer>> iops() {
        return Optional.ofNullable(this.iops);
    }

    /**
     * ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `master_password` is provided.
     * 
     */
    @Import(name="manageMasterUserPassword")
    private @Nullable Output<Boolean> manageMasterUserPassword;

    /**
     * @return Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `master_password` is provided.
     * 
     */
    public Optional<Output<Boolean>> manageMasterUserPassword() {
        return Optional.ofNullable(this.manageMasterUserPassword);
    }

    /**
     * Password for the master DB user. Note that this may show up in logs, and it will be stored in the state file. Please refer to the [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints). Cannot be set if `manage_master_user_password` is set to `true`.
     * 
     */
    @Import(name="masterPassword")
    private @Nullable Output<String> masterPassword;

    /**
     * @return Password for the master DB user. Note that this may show up in logs, and it will be stored in the state file. Please refer to the [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints). Cannot be set if `manage_master_user_password` is set to `true`.
     * 
     */
    public Optional<Output<String>> masterPassword() {
        return Optional.ofNullable(this.masterPassword);
    }

    /**
     * Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
     * 
     */
    @Import(name="masterUserSecretKmsKeyId")
    private @Nullable Output<String> masterUserSecretKmsKeyId;

    /**
     * @return Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
     * 
     */
    public Optional<Output<String>> masterUserSecretKmsKeyId() {
        return Optional.ofNullable(this.masterUserSecretKmsKeyId);
    }

    /**
     * Block that specifies the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
     * 
     */
    @Import(name="masterUserSecrets")
    private @Nullable Output<List<ClusterMasterUserSecretArgs>> masterUserSecrets;

    /**
     * @return Block that specifies the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
     * 
     */
    public Optional<Output<List<ClusterMasterUserSecretArgs>>> masterUserSecrets() {
        return Optional.ofNullable(this.masterUserSecrets);
    }

    /**
     * Username for the master DB user. Please refer to the [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints). This argument does not support in-place updates and cannot be changed during a restore from snapshot.
     * 
     */
    @Import(name="masterUsername")
    private @Nullable Output<String> masterUsername;

    /**
     * @return Username for the master DB user. Please refer to the [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints). This argument does not support in-place updates and cannot be changed during a restore from snapshot.
     * 
     */
    public Optional<Output<String>> masterUsername() {
        return Optional.ofNullable(this.masterUsername);
    }

    /**
     * Network type of the cluster. Valid values: `IPV4`, `DUAL`.
     * 
     */
    @Import(name="networkType")
    private @Nullable Output<String> networkType;

    /**
     * @return Network type of the cluster. Valid values: `IPV4`, `DUAL`.
     * 
     */
    public Optional<Output<String>> networkType() {
        return Optional.ofNullable(this.networkType);
    }

    /**
     * Port on which the DB accepts connections
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return Port on which the DB accepts connections
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * Daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     * 
     */
    @Import(name="preferredBackupWindow")
    private @Nullable Output<String> preferredBackupWindow;

    /**
     * @return Daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
     * 
     */
    public Optional<Output<String>> preferredBackupWindow() {
        return Optional.ofNullable(this.preferredBackupWindow);
    }

    /**
     * Weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     * 
     */
    @Import(name="preferredMaintenanceWindow")
    private @Nullable Output<String> preferredMaintenanceWindow;

    /**
     * @return Weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
     * 
     */
    public Optional<Output<String>> preferredMaintenanceWindow() {
        return Optional.ofNullable(this.preferredMaintenanceWindow);
    }

    /**
     * Read-only endpoint for the Aurora cluster, automatically
     * load-balanced across replicas
     * 
     */
    @Import(name="readerEndpoint")
    private @Nullable Output<String> readerEndpoint;

    /**
     * @return Read-only endpoint for the Aurora cluster, automatically
     * load-balanced across replicas
     * 
     */
    public Optional<Output<String>> readerEndpoint() {
        return Optional.ofNullable(this.readerEndpoint);
    }

    /**
     * ARN of a source DB cluster or DB instance if this DB cluster is to be created as a Read Replica. If DB Cluster is part of a Global Cluster, use the `lifecycle` configuration block `ignore_changes` argument to prevent this provider from showing differences for this argument instead of configuring this value.
     * 
     */
    @Import(name="replicationSourceIdentifier")
    private @Nullable Output<String> replicationSourceIdentifier;

    /**
     * @return ARN of a source DB cluster or DB instance if this DB cluster is to be created as a Read Replica. If DB Cluster is part of a Global Cluster, use the `lifecycle` configuration block `ignore_changes` argument to prevent this provider from showing differences for this argument instead of configuring this value.
     * 
     */
    public Optional<Output<String>> replicationSourceIdentifier() {
        return Optional.ofNullable(this.replicationSourceIdentifier);
    }

    /**
     * Nested attribute for [point in time restore](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PIT.html). More details below.
     * 
     */
    @Import(name="restoreToPointInTime")
    private @Nullable Output<ClusterRestoreToPointInTimeArgs> restoreToPointInTime;

    /**
     * @return Nested attribute for [point in time restore](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PIT.html). More details below.
     * 
     */
    public Optional<Output<ClusterRestoreToPointInTimeArgs>> restoreToPointInTime() {
        return Optional.ofNullable(this.restoreToPointInTime);
    }

    @Import(name="s3Import")
    private @Nullable Output<ClusterS3ImportArgs> s3Import;

    public Optional<Output<ClusterS3ImportArgs>> s3Import() {
        return Optional.ofNullable(this.s3Import);
    }

    /**
     * Nested attribute with scaling properties. Only valid when `engine_mode` is set to `serverless`. More details below.
     * 
     */
    @Import(name="scalingConfiguration")
    private @Nullable Output<ClusterScalingConfigurationArgs> scalingConfiguration;

    /**
     * @return Nested attribute with scaling properties. Only valid when `engine_mode` is set to `serverless`. More details below.
     * 
     */
    public Optional<Output<ClusterScalingConfigurationArgs>> scalingConfiguration() {
        return Optional.ofNullable(this.scalingConfiguration);
    }

    /**
     * Nested attribute with scaling properties for ServerlessV2. Only valid when `engine_mode` is set to `provisioned`. More details below.
     * 
     */
    @Import(name="serverlessv2ScalingConfiguration")
    private @Nullable Output<ClusterServerlessv2ScalingConfigurationArgs> serverlessv2ScalingConfiguration;

    /**
     * @return Nested attribute with scaling properties for ServerlessV2. Only valid when `engine_mode` is set to `provisioned`. More details below.
     * 
     */
    public Optional<Output<ClusterServerlessv2ScalingConfigurationArgs>> serverlessv2ScalingConfiguration() {
        return Optional.ofNullable(this.serverlessv2ScalingConfiguration);
    }

    /**
     * Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     * 
     */
    @Import(name="skipFinalSnapshot")
    private @Nullable Output<Boolean> skipFinalSnapshot;

    /**
     * @return Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
     * 
     */
    public Optional<Output<Boolean>> skipFinalSnapshot() {
        return Optional.ofNullable(this.skipFinalSnapshot);
    }

    /**
     * Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Conflicts with `global_cluster_identifier`. Clusters cannot be restored from snapshot **and** joined to an existing global cluster in a single operation. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-getting-started.html#aurora-global-database.use-snapshot) or the Global Cluster Restored From Snapshot example for instructions on building a global cluster starting with a snapshot.
     * 
     */
    @Import(name="snapshotIdentifier")
    private @Nullable Output<String> snapshotIdentifier;

    /**
     * @return Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Conflicts with `global_cluster_identifier`. Clusters cannot be restored from snapshot **and** joined to an existing global cluster in a single operation. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-getting-started.html#aurora-global-database.use-snapshot) or the Global Cluster Restored From Snapshot example for instructions on building a global cluster starting with a snapshot.
     * 
     */
    public Optional<Output<String>> snapshotIdentifier() {
        return Optional.ofNullable(this.snapshotIdentifier);
    }

    /**
     * The source region for an encrypted replica DB cluster.
     * 
     */
    @Import(name="sourceRegion")
    private @Nullable Output<String> sourceRegion;

    /**
     * @return The source region for an encrypted replica DB cluster.
     * 
     */
    public Optional<Output<String>> sourceRegion() {
        return Optional.ofNullable(this.sourceRegion);
    }

    /**
     * Specifies whether the DB cluster is encrypted. The default is `false` for `provisioned` `engine_mode` and `true` for `serverless` `engine_mode`. When restoring an unencrypted `snapshot_identifier`, the `kms_key_id` argument must be provided to encrypt the restored cluster. The provider will only perform drift detection if a configuration value is provided.
     * 
     */
    @Import(name="storageEncrypted")
    private @Nullable Output<Boolean> storageEncrypted;

    /**
     * @return Specifies whether the DB cluster is encrypted. The default is `false` for `provisioned` `engine_mode` and `true` for `serverless` `engine_mode`. When restoring an unencrypted `snapshot_identifier`, the `kms_key_id` argument must be provided to encrypt the restored cluster. The provider will only perform drift detection if a configuration value is provided.
     * 
     */
    public Optional<Output<Boolean>> storageEncrypted() {
        return Optional.ofNullable(this.storageEncrypted);
    }

    /**
     * (Required for Multi-AZ DB clusters) (Forces new for Multi-AZ DB clusters) Specifies the storage type to be associated with the DB cluster. For Aurora DB clusters, `storage_type` modifications can be done in-place. For Multi-AZ DB Clusters, the `iops` argument must also be set. Valid values are: `&#34;&#34;`, `aurora-iopt1` (Aurora DB Clusters); `io1` (Multi-AZ DB Clusters). Default: `&#34;&#34;` (Aurora DB Clusters); `io1` (Multi-AZ DB Clusters).
     * 
     */
    @Import(name="storageType")
    private @Nullable Output<String> storageType;

    /**
     * @return (Required for Multi-AZ DB clusters) (Forces new for Multi-AZ DB clusters) Specifies the storage type to be associated with the DB cluster. For Aurora DB clusters, `storage_type` modifications can be done in-place. For Multi-AZ DB Clusters, the `iops` argument must also be set. Valid values are: `&#34;&#34;`, `aurora-iopt1` (Aurora DB Clusters); `io1` (Multi-AZ DB Clusters). Default: `&#34;&#34;` (Aurora DB Clusters); `io1` (Multi-AZ DB Clusters).
     * 
     */
    public Optional<Output<String>> storageType() {
        return Optional.ofNullable(this.storageType);
    }

    /**
     * A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * List of VPC security groups to associate with the Cluster
     * 
     */
    @Import(name="vpcSecurityGroupIds")
    private @Nullable Output<List<String>> vpcSecurityGroupIds;

    /**
     * @return List of VPC security groups to associate with the Cluster
     * 
     */
    public Optional<Output<List<String>>> vpcSecurityGroupIds() {
        return Optional.ofNullable(this.vpcSecurityGroupIds);
    }

    private ClusterState() {}

    private ClusterState(ClusterState $) {
        this.allocatedStorage = $.allocatedStorage;
        this.allowMajorVersionUpgrade = $.allowMajorVersionUpgrade;
        this.applyImmediately = $.applyImmediately;
        this.arn = $.arn;
        this.availabilityZones = $.availabilityZones;
        this.backtrackWindow = $.backtrackWindow;
        this.backupRetentionPeriod = $.backupRetentionPeriod;
        this.clusterIdentifier = $.clusterIdentifier;
        this.clusterIdentifierPrefix = $.clusterIdentifierPrefix;
        this.clusterMembers = $.clusterMembers;
        this.clusterResourceId = $.clusterResourceId;
        this.copyTagsToSnapshot = $.copyTagsToSnapshot;
        this.databaseName = $.databaseName;
        this.dbClusterInstanceClass = $.dbClusterInstanceClass;
        this.dbClusterParameterGroupName = $.dbClusterParameterGroupName;
        this.dbInstanceParameterGroupName = $.dbInstanceParameterGroupName;
        this.dbSubnetGroupName = $.dbSubnetGroupName;
        this.dbSystemId = $.dbSystemId;
        this.deletionProtection = $.deletionProtection;
        this.enableGlobalWriteForwarding = $.enableGlobalWriteForwarding;
        this.enableHttpEndpoint = $.enableHttpEndpoint;
        this.enabledCloudwatchLogsExports = $.enabledCloudwatchLogsExports;
        this.endpoint = $.endpoint;
        this.engine = $.engine;
        this.engineMode = $.engineMode;
        this.engineVersion = $.engineVersion;
        this.engineVersionActual = $.engineVersionActual;
        this.finalSnapshotIdentifier = $.finalSnapshotIdentifier;
        this.globalClusterIdentifier = $.globalClusterIdentifier;
        this.hostedZoneId = $.hostedZoneId;
        this.iamDatabaseAuthenticationEnabled = $.iamDatabaseAuthenticationEnabled;
        this.iamRoles = $.iamRoles;
        this.iops = $.iops;
        this.kmsKeyId = $.kmsKeyId;
        this.manageMasterUserPassword = $.manageMasterUserPassword;
        this.masterPassword = $.masterPassword;
        this.masterUserSecretKmsKeyId = $.masterUserSecretKmsKeyId;
        this.masterUserSecrets = $.masterUserSecrets;
        this.masterUsername = $.masterUsername;
        this.networkType = $.networkType;
        this.port = $.port;
        this.preferredBackupWindow = $.preferredBackupWindow;
        this.preferredMaintenanceWindow = $.preferredMaintenanceWindow;
        this.readerEndpoint = $.readerEndpoint;
        this.replicationSourceIdentifier = $.replicationSourceIdentifier;
        this.restoreToPointInTime = $.restoreToPointInTime;
        this.s3Import = $.s3Import;
        this.scalingConfiguration = $.scalingConfiguration;
        this.serverlessv2ScalingConfiguration = $.serverlessv2ScalingConfiguration;
        this.skipFinalSnapshot = $.skipFinalSnapshot;
        this.snapshotIdentifier = $.snapshotIdentifier;
        this.sourceRegion = $.sourceRegion;
        this.storageEncrypted = $.storageEncrypted;
        this.storageType = $.storageType;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.vpcSecurityGroupIds = $.vpcSecurityGroupIds;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterState $;

        public Builder() {
            $ = new ClusterState();
        }

        public Builder(ClusterState defaults) {
            $ = new ClusterState(Objects.requireNonNull(defaults));
        }

        /**
         * @param allocatedStorage (Required for Multi-AZ DB cluster) The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         * 
         * @return builder
         * 
         */
        public Builder allocatedStorage(@Nullable Output<Integer> allocatedStorage) {
            $.allocatedStorage = allocatedStorage;
            return this;
        }

        /**
         * @param allocatedStorage (Required for Multi-AZ DB cluster) The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         * 
         * @return builder
         * 
         */
        public Builder allocatedStorage(Integer allocatedStorage) {
            return allocatedStorage(Output.of(allocatedStorage));
        }

        /**
         * @param allowMajorVersionUpgrade Enable to allow major engine version upgrades when changing engine versions. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder allowMajorVersionUpgrade(@Nullable Output<Boolean> allowMajorVersionUpgrade) {
            $.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        /**
         * @param allowMajorVersionUpgrade Enable to allow major engine version upgrades when changing engine versions. Defaults to `false`.
         * 
         * @return builder
         * 
         */
        public Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            return allowMajorVersionUpgrade(Output.of(allowMajorVersionUpgrade));
        }

        /**
         * @param applyImmediately Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon RDS Documentation for more information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(@Nullable Output<Boolean> applyImmediately) {
            $.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * @param applyImmediately Specifies whether any cluster modifications are applied immediately, or during the next maintenance window. Default is `false`. See [Amazon RDS Documentation for more information.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(Boolean applyImmediately) {
            return applyImmediately(Output.of(applyImmediately));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of cluster
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of cluster
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param availabilityZones List of EC2 Availability Zones for the DB cluster storage where DB cluster instances can be created. RDS automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next apply. We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary. A maximum of 3 AZs can be configured.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(@Nullable Output<List<String>> availabilityZones) {
            $.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * @param availabilityZones List of EC2 Availability Zones for the DB cluster storage where DB cluster instances can be created. RDS automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next apply. We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary. A maximum of 3 AZs can be configured.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(List<String> availabilityZones) {
            return availabilityZones(Output.of(availabilityZones));
        }

        /**
         * @param availabilityZones List of EC2 Availability Zones for the DB cluster storage where DB cluster instances can be created. RDS automatically assigns 3 AZs if less than 3 AZs are configured, which will show as a difference requiring resource recreation next apply. We recommend specifying 3 AZs or using the `lifecycle` configuration block `ignore_changes` argument if necessary. A maximum of 3 AZs can be configured.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZones(String... availabilityZones) {
            return availabilityZones(List.of(availabilityZones));
        }

        /**
         * @param backtrackWindow Target backtrack window, in seconds. Only available for `aurora` and `aurora-mysql` engines currently. To disable backtracking, set this value to `0`. Defaults to `0`. Must be between `0` and `259200` (72 hours)
         * 
         * @return builder
         * 
         */
        public Builder backtrackWindow(@Nullable Output<Integer> backtrackWindow) {
            $.backtrackWindow = backtrackWindow;
            return this;
        }

        /**
         * @param backtrackWindow Target backtrack window, in seconds. Only available for `aurora` and `aurora-mysql` engines currently. To disable backtracking, set this value to `0`. Defaults to `0`. Must be between `0` and `259200` (72 hours)
         * 
         * @return builder
         * 
         */
        public Builder backtrackWindow(Integer backtrackWindow) {
            return backtrackWindow(Output.of(backtrackWindow));
        }

        /**
         * @param backupRetentionPeriod Days to retain backups for. Default `1`
         * 
         * @return builder
         * 
         */
        public Builder backupRetentionPeriod(@Nullable Output<Integer> backupRetentionPeriod) {
            $.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        /**
         * @param backupRetentionPeriod Days to retain backups for. Default `1`
         * 
         * @return builder
         * 
         */
        public Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            return backupRetentionPeriod(Output.of(backupRetentionPeriod));
        }

        /**
         * @param clusterIdentifier The cluster identifier. If omitted, this provider will assign a random, unique identifier.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(@Nullable Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier The cluster identifier. If omitted, this provider will assign a random, unique identifier.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param clusterIdentifierPrefix Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifierPrefix(@Nullable Output<String> clusterIdentifierPrefix) {
            $.clusterIdentifierPrefix = clusterIdentifierPrefix;
            return this;
        }

        /**
         * @param clusterIdentifierPrefix Creates a unique cluster identifier beginning with the specified prefix. Conflicts with `cluster_identifier`.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifierPrefix(String clusterIdentifierPrefix) {
            return clusterIdentifierPrefix(Output.of(clusterIdentifierPrefix));
        }

        /**
         * @param clusterMembers List of RDS Instances that are a part of this cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterMembers(@Nullable Output<List<String>> clusterMembers) {
            $.clusterMembers = clusterMembers;
            return this;
        }

        /**
         * @param clusterMembers List of RDS Instances that are a part of this cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterMembers(List<String> clusterMembers) {
            return clusterMembers(Output.of(clusterMembers));
        }

        /**
         * @param clusterMembers List of RDS Instances that are a part of this cluster
         * 
         * @return builder
         * 
         */
        public Builder clusterMembers(String... clusterMembers) {
            return clusterMembers(List.of(clusterMembers));
        }

        /**
         * @param clusterResourceId RDS Cluster Resource ID
         * 
         * @return builder
         * 
         */
        public Builder clusterResourceId(@Nullable Output<String> clusterResourceId) {
            $.clusterResourceId = clusterResourceId;
            return this;
        }

        /**
         * @param clusterResourceId RDS Cluster Resource ID
         * 
         * @return builder
         * 
         */
        public Builder clusterResourceId(String clusterResourceId) {
            return clusterResourceId(Output.of(clusterResourceId));
        }

        /**
         * @param copyTagsToSnapshot Copy all Cluster `tags` to snapshots. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToSnapshot(@Nullable Output<Boolean> copyTagsToSnapshot) {
            $.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * @param copyTagsToSnapshot Copy all Cluster `tags` to snapshots. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            return copyTagsToSnapshot(Output.of(copyTagsToSnapshot));
        }

        /**
         * @param databaseName Name for an automatically created database on cluster creation. There are different naming restrictions per database engine: [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints)
         * 
         * @return builder
         * 
         */
        public Builder databaseName(@Nullable Output<String> databaseName) {
            $.databaseName = databaseName;
            return this;
        }

        /**
         * @param databaseName Name for an automatically created database on cluster creation. There are different naming restrictions per database engine: [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints)
         * 
         * @return builder
         * 
         */
        public Builder databaseName(String databaseName) {
            return databaseName(Output.of(databaseName));
        }

        /**
         * @param dbClusterInstanceClass (Required for Multi-AZ DB cluster) The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all AWS Regions, or for all database engines. For the full list of DB instance classes and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the Amazon RDS User Guide.
         * 
         * @return builder
         * 
         */
        public Builder dbClusterInstanceClass(@Nullable Output<String> dbClusterInstanceClass) {
            $.dbClusterInstanceClass = dbClusterInstanceClass;
            return this;
        }

        /**
         * @param dbClusterInstanceClass (Required for Multi-AZ DB cluster) The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all AWS Regions, or for all database engines. For the full list of DB instance classes and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the Amazon RDS User Guide.
         * 
         * @return builder
         * 
         */
        public Builder dbClusterInstanceClass(String dbClusterInstanceClass) {
            return dbClusterInstanceClass(Output.of(dbClusterInstanceClass));
        }

        /**
         * @param dbClusterParameterGroupName A cluster parameter group to associate with the cluster.
         * 
         * @return builder
         * 
         */
        public Builder dbClusterParameterGroupName(@Nullable Output<String> dbClusterParameterGroupName) {
            $.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        /**
         * @param dbClusterParameterGroupName A cluster parameter group to associate with the cluster.
         * 
         * @return builder
         * 
         */
        public Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            return dbClusterParameterGroupName(Output.of(dbClusterParameterGroupName));
        }

        /**
         * @param dbInstanceParameterGroupName Instance parameter group to associate with all instances of the DB cluster. The `db_instance_parameter_group_name` parameter is only valid in combination with the `allow_major_version_upgrade` parameter.
         * 
         * @return builder
         * 
         */
        public Builder dbInstanceParameterGroupName(@Nullable Output<String> dbInstanceParameterGroupName) {
            $.dbInstanceParameterGroupName = dbInstanceParameterGroupName;
            return this;
        }

        /**
         * @param dbInstanceParameterGroupName Instance parameter group to associate with all instances of the DB cluster. The `db_instance_parameter_group_name` parameter is only valid in combination with the `allow_major_version_upgrade` parameter.
         * 
         * @return builder
         * 
         */
        public Builder dbInstanceParameterGroupName(String dbInstanceParameterGroupName) {
            return dbInstanceParameterGroupName(Output.of(dbInstanceParameterGroupName));
        }

        /**
         * @param dbSubnetGroupName DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` specified on every `aws.rds.ClusterInstance` in the cluster.
         * 
         * @return builder
         * 
         */
        public Builder dbSubnetGroupName(@Nullable Output<String> dbSubnetGroupName) {
            $.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        /**
         * @param dbSubnetGroupName DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` specified on every `aws.rds.ClusterInstance` in the cluster.
         * 
         * @return builder
         * 
         */
        public Builder dbSubnetGroupName(String dbSubnetGroupName) {
            return dbSubnetGroupName(Output.of(dbSubnetGroupName));
        }

        /**
         * @param dbSystemId For use with RDS Custom.
         * 
         * @return builder
         * 
         */
        public Builder dbSystemId(@Nullable Output<String> dbSystemId) {
            $.dbSystemId = dbSystemId;
            return this;
        }

        /**
         * @param dbSystemId For use with RDS Custom.
         * 
         * @return builder
         * 
         */
        public Builder dbSystemId(String dbSystemId) {
            return dbSystemId(Output.of(dbSystemId));
        }

        /**
         * @param deletionProtection If the DB instance should have deletion protection enabled. The database can&#39;t be deleted when this value is set to `true`. The default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder deletionProtection(@Nullable Output<Boolean> deletionProtection) {
            $.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * @param deletionProtection If the DB instance should have deletion protection enabled. The database can&#39;t be deleted when this value is set to `true`. The default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder deletionProtection(Boolean deletionProtection) {
            return deletionProtection(Output.of(deletionProtection));
        }

        /**
         * @param enableGlobalWriteForwarding Whether cluster should forward writes to an associated global cluster. Applied to secondary clusters to enable them to forward writes to an `aws.rds.GlobalCluster`&#39;s primary cluster. See the [Aurora Userguide documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-write-forwarding.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder enableGlobalWriteForwarding(@Nullable Output<Boolean> enableGlobalWriteForwarding) {
            $.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
            return this;
        }

        /**
         * @param enableGlobalWriteForwarding Whether cluster should forward writes to an associated global cluster. Applied to secondary clusters to enable them to forward writes to an `aws.rds.GlobalCluster`&#39;s primary cluster. See the [Aurora Userguide documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-write-forwarding.html) for more information.
         * 
         * @return builder
         * 
         */
        public Builder enableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
            return enableGlobalWriteForwarding(Output.of(enableGlobalWriteForwarding));
        }

        /**
         * @param enableHttpEndpoint Enable HTTP endpoint (data API). Only valid when `engine_mode` is set to `serverless`.
         * 
         * @return builder
         * 
         */
        public Builder enableHttpEndpoint(@Nullable Output<Boolean> enableHttpEndpoint) {
            $.enableHttpEndpoint = enableHttpEndpoint;
            return this;
        }

        /**
         * @param enableHttpEndpoint Enable HTTP endpoint (data API). Only valid when `engine_mode` is set to `serverless`.
         * 
         * @return builder
         * 
         */
        public Builder enableHttpEndpoint(Boolean enableHttpEndpoint) {
            return enableHttpEndpoint(Output.of(enableHttpEndpoint));
        }

        /**
         * @param enabledCloudwatchLogsExports Set of log types to export to cloudwatch. If omitted, no logs will be exported. The following log types are supported: `audit`, `error`, `general`, `slowquery`, `postgresql` (PostgreSQL).
         * 
         * @return builder
         * 
         */
        public Builder enabledCloudwatchLogsExports(@Nullable Output<List<String>> enabledCloudwatchLogsExports) {
            $.enabledCloudwatchLogsExports = enabledCloudwatchLogsExports;
            return this;
        }

        /**
         * @param enabledCloudwatchLogsExports Set of log types to export to cloudwatch. If omitted, no logs will be exported. The following log types are supported: `audit`, `error`, `general`, `slowquery`, `postgresql` (PostgreSQL).
         * 
         * @return builder
         * 
         */
        public Builder enabledCloudwatchLogsExports(List<String> enabledCloudwatchLogsExports) {
            return enabledCloudwatchLogsExports(Output.of(enabledCloudwatchLogsExports));
        }

        /**
         * @param enabledCloudwatchLogsExports Set of log types to export to cloudwatch. If omitted, no logs will be exported. The following log types are supported: `audit`, `error`, `general`, `slowquery`, `postgresql` (PostgreSQL).
         * 
         * @return builder
         * 
         */
        public Builder enabledCloudwatchLogsExports(String... enabledCloudwatchLogsExports) {
            return enabledCloudwatchLogsExports(List.of(enabledCloudwatchLogsExports));
        }

        /**
         * @param endpoint DNS address of the RDS instance
         * 
         * @return builder
         * 
         */
        public Builder endpoint(@Nullable Output<String> endpoint) {
            $.endpoint = endpoint;
            return this;
        }

        /**
         * @param endpoint DNS address of the RDS instance
         * 
         * @return builder
         * 
         */
        public Builder endpoint(String endpoint) {
            return endpoint(Output.of(endpoint));
        }

        /**
         * @param engine Name of the database engine to be used for this DB cluster. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`. (Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
         * 
         * @return builder
         * 
         */
        public Builder engine(@Nullable Output<Either<String,EngineType>> engine) {
            $.engine = engine;
            return this;
        }

        /**
         * @param engine Name of the database engine to be used for this DB cluster. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`. (Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
         * 
         * @return builder
         * 
         */
        public Builder engine(Either<String,EngineType> engine) {
            return engine(Output.of(engine));
        }

        /**
         * @param engine Name of the database engine to be used for this DB cluster. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`. (Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
         * 
         * @return builder
         * 
         */
        public Builder engine(String engine) {
            return engine(Either.ofLeft(engine));
        }

        /**
         * @param engine Name of the database engine to be used for this DB cluster. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`. (Note that `mysql` and `postgres` are Multi-AZ RDS clusters).
         * 
         * @return builder
         * 
         */
        public Builder engine(EngineType engine) {
            return engine(Either.ofRight(engine));
        }

        /**
         * @param engineMode Database engine mode. Valid values: `global` (only valid for Aurora MySQL 1.21 and earlier), `multimaster`, `parallelquery`, `provisioned`, `serverless`. Defaults to: `provisioned`. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/aurora-serverless.html) for limitations when using `serverless`.
         * 
         * @return builder
         * 
         */
        public Builder engineMode(@Nullable Output<Either<String,EngineMode>> engineMode) {
            $.engineMode = engineMode;
            return this;
        }

        /**
         * @param engineMode Database engine mode. Valid values: `global` (only valid for Aurora MySQL 1.21 and earlier), `multimaster`, `parallelquery`, `provisioned`, `serverless`. Defaults to: `provisioned`. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/aurora-serverless.html) for limitations when using `serverless`.
         * 
         * @return builder
         * 
         */
        public Builder engineMode(Either<String,EngineMode> engineMode) {
            return engineMode(Output.of(engineMode));
        }

        /**
         * @param engineMode Database engine mode. Valid values: `global` (only valid for Aurora MySQL 1.21 and earlier), `multimaster`, `parallelquery`, `provisioned`, `serverless`. Defaults to: `provisioned`. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/aurora-serverless.html) for limitations when using `serverless`.
         * 
         * @return builder
         * 
         */
        public Builder engineMode(String engineMode) {
            return engineMode(Either.ofLeft(engineMode));
        }

        /**
         * @param engineMode Database engine mode. Valid values: `global` (only valid for Aurora MySQL 1.21 and earlier), `multimaster`, `parallelquery`, `provisioned`, `serverless`. Defaults to: `provisioned`. See the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/aurora-serverless.html) for limitations when using `serverless`.
         * 
         * @return builder
         * 
         */
        public Builder engineMode(EngineMode engineMode) {
            return engineMode(Either.ofRight(engineMode));
        }

        /**
         * @param engineVersion Database engine version. Updating this argument results in an outage. See the [Aurora MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) and [Aurora Postgres](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.html) documentation for your configured engine to determine this value, or by running `aws rds describe-db-engine-versions`. For example with Aurora MySQL 2, a potential value for this argument is `5.7.mysql_aurora.2.03.2`. The value can contain a partial version where supported by the API. The actual engine version used is returned in the attribute `engine_version_actual`, , see Attribute Reference below.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(@Nullable Output<String> engineVersion) {
            $.engineVersion = engineVersion;
            return this;
        }

        /**
         * @param engineVersion Database engine version. Updating this argument results in an outage. See the [Aurora MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) and [Aurora Postgres](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.html) documentation for your configured engine to determine this value, or by running `aws rds describe-db-engine-versions`. For example with Aurora MySQL 2, a potential value for this argument is `5.7.mysql_aurora.2.03.2`. The value can contain a partial version where supported by the API. The actual engine version used is returned in the attribute `engine_version_actual`, , see Attribute Reference below.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(String engineVersion) {
            return engineVersion(Output.of(engineVersion));
        }

        /**
         * @param engineVersionActual Running version of the database.
         * 
         * @return builder
         * 
         */
        public Builder engineVersionActual(@Nullable Output<String> engineVersionActual) {
            $.engineVersionActual = engineVersionActual;
            return this;
        }

        /**
         * @param engineVersionActual Running version of the database.
         * 
         * @return builder
         * 
         */
        public Builder engineVersionActual(String engineVersionActual) {
            return engineVersionActual(Output.of(engineVersionActual));
        }

        /**
         * @param finalSnapshotIdentifier Name of your final DB snapshot when this DB cluster is deleted. If omitted, no final snapshot will be made.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotIdentifier(@Nullable Output<String> finalSnapshotIdentifier) {
            $.finalSnapshotIdentifier = finalSnapshotIdentifier;
            return this;
        }

        /**
         * @param finalSnapshotIdentifier Name of your final DB snapshot when this DB cluster is deleted. If omitted, no final snapshot will be made.
         * 
         * @return builder
         * 
         */
        public Builder finalSnapshotIdentifier(String finalSnapshotIdentifier) {
            return finalSnapshotIdentifier(Output.of(finalSnapshotIdentifier));
        }

        /**
         * @param globalClusterIdentifier Global cluster identifier specified on `aws.rds.GlobalCluster`.
         * 
         * @return builder
         * 
         */
        public Builder globalClusterIdentifier(@Nullable Output<String> globalClusterIdentifier) {
            $.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        /**
         * @param globalClusterIdentifier Global cluster identifier specified on `aws.rds.GlobalCluster`.
         * 
         * @return builder
         * 
         */
        public Builder globalClusterIdentifier(String globalClusterIdentifier) {
            return globalClusterIdentifier(Output.of(globalClusterIdentifier));
        }

        /**
         * @param hostedZoneId Route53 Hosted Zone ID of the endpoint
         * 
         * @return builder
         * 
         */
        public Builder hostedZoneId(@Nullable Output<String> hostedZoneId) {
            $.hostedZoneId = hostedZoneId;
            return this;
        }

        /**
         * @param hostedZoneId Route53 Hosted Zone ID of the endpoint
         * 
         * @return builder
         * 
         */
        public Builder hostedZoneId(String hostedZoneId) {
            return hostedZoneId(Output.of(hostedZoneId));
        }

        /**
         * @param iamDatabaseAuthenticationEnabled Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) for availability and limitations.
         * 
         * @return builder
         * 
         */
        public Builder iamDatabaseAuthenticationEnabled(@Nullable Output<Boolean> iamDatabaseAuthenticationEnabled) {
            $.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        /**
         * @param iamDatabaseAuthenticationEnabled Specifies whether or not mappings of AWS Identity and Access Management (IAM) accounts to database accounts is enabled. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) for availability and limitations.
         * 
         * @return builder
         * 
         */
        public Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            return iamDatabaseAuthenticationEnabled(Output.of(iamDatabaseAuthenticationEnabled));
        }

        /**
         * @param iamRoles List of ARNs for the IAM roles to associate to the RDS Cluster.
         * 
         * @return builder
         * 
         */
        public Builder iamRoles(@Nullable Output<List<String>> iamRoles) {
            $.iamRoles = iamRoles;
            return this;
        }

        /**
         * @param iamRoles List of ARNs for the IAM roles to associate to the RDS Cluster.
         * 
         * @return builder
         * 
         */
        public Builder iamRoles(List<String> iamRoles) {
            return iamRoles(Output.of(iamRoles));
        }

        /**
         * @param iamRoles List of ARNs for the IAM roles to associate to the RDS Cluster.
         * 
         * @return builder
         * 
         */
        public Builder iamRoles(String... iamRoles) {
            return iamRoles(List.of(iamRoles));
        }

        /**
         * @param iops Amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster. For information about valid Iops values, see [Amazon RDS Provisioned IOPS storage to improve performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the Amazon RDS User Guide. (This setting is required to create a Multi-AZ DB cluster). Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         * 
         * @return builder
         * 
         */
        public Builder iops(@Nullable Output<Integer> iops) {
            $.iops = iops;
            return this;
        }

        /**
         * @param iops Amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster. For information about valid Iops values, see [Amazon RDS Provisioned IOPS storage to improve performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the Amazon RDS User Guide. (This setting is required to create a Multi-AZ DB cluster). Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         * 
         * @return builder
         * 
         */
        public Builder iops(Integer iops) {
            return iops(Output.of(iops));
        }

        /**
         * @param kmsKeyId ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param manageMasterUserPassword Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `master_password` is provided.
         * 
         * @return builder
         * 
         */
        public Builder manageMasterUserPassword(@Nullable Output<Boolean> manageMasterUserPassword) {
            $.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        /**
         * @param manageMasterUserPassword Set to true to allow RDS to manage the master user password in Secrets Manager. Cannot be set if `master_password` is provided.
         * 
         * @return builder
         * 
         */
        public Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            return manageMasterUserPassword(Output.of(manageMasterUserPassword));
        }

        /**
         * @param masterPassword Password for the master DB user. Note that this may show up in logs, and it will be stored in the state file. Please refer to the [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints). Cannot be set if `manage_master_user_password` is set to `true`.
         * 
         * @return builder
         * 
         */
        public Builder masterPassword(@Nullable Output<String> masterPassword) {
            $.masterPassword = masterPassword;
            return this;
        }

        /**
         * @param masterPassword Password for the master DB user. Note that this may show up in logs, and it will be stored in the state file. Please refer to the [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints). Cannot be set if `manage_master_user_password` is set to `true`.
         * 
         * @return builder
         * 
         */
        public Builder masterPassword(String masterPassword) {
            return masterPassword(Output.of(masterPassword));
        }

        /**
         * @param masterUserSecretKmsKeyId Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
         * 
         * @return builder
         * 
         */
        public Builder masterUserSecretKmsKeyId(@Nullable Output<String> masterUserSecretKmsKeyId) {
            $.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
            return this;
        }

        /**
         * @param masterUserSecretKmsKeyId Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. If not specified, the default KMS key for your Amazon Web Services account is used.
         * 
         * @return builder
         * 
         */
        public Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            return masterUserSecretKmsKeyId(Output.of(masterUserSecretKmsKeyId));
        }

        /**
         * @param masterUserSecrets Block that specifies the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder masterUserSecrets(@Nullable Output<List<ClusterMasterUserSecretArgs>> masterUserSecrets) {
            $.masterUserSecrets = masterUserSecrets;
            return this;
        }

        /**
         * @param masterUserSecrets Block that specifies the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder masterUserSecrets(List<ClusterMasterUserSecretArgs> masterUserSecrets) {
            return masterUserSecrets(Output.of(masterUserSecrets));
        }

        /**
         * @param masterUserSecrets Block that specifies the master user secret. Only available when `manage_master_user_password` is set to true. Documented below.
         * 
         * @return builder
         * 
         */
        public Builder masterUserSecrets(ClusterMasterUserSecretArgs... masterUserSecrets) {
            return masterUserSecrets(List.of(masterUserSecrets));
        }

        /**
         * @param masterUsername Username for the master DB user. Please refer to the [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints). This argument does not support in-place updates and cannot be changed during a restore from snapshot.
         * 
         * @return builder
         * 
         */
        public Builder masterUsername(@Nullable Output<String> masterUsername) {
            $.masterUsername = masterUsername;
            return this;
        }

        /**
         * @param masterUsername Username for the master DB user. Please refer to the [RDS Naming Constraints](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html#RDS_Limits.Constraints). This argument does not support in-place updates and cannot be changed during a restore from snapshot.
         * 
         * @return builder
         * 
         */
        public Builder masterUsername(String masterUsername) {
            return masterUsername(Output.of(masterUsername));
        }

        /**
         * @param networkType Network type of the cluster. Valid values: `IPV4`, `DUAL`.
         * 
         * @return builder
         * 
         */
        public Builder networkType(@Nullable Output<String> networkType) {
            $.networkType = networkType;
            return this;
        }

        /**
         * @param networkType Network type of the cluster. Valid values: `IPV4`, `DUAL`.
         * 
         * @return builder
         * 
         */
        public Builder networkType(String networkType) {
            return networkType(Output.of(networkType));
        }

        /**
         * @param port Port on which the DB accepts connections
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port Port on which the DB accepts connections
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param preferredBackupWindow Daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(@Nullable Output<String> preferredBackupWindow) {
            $.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * @param preferredBackupWindow Daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.Time in UTC. Default: A 30-minute window selected at random from an 8-hour block of time per regionE.g., 04:00-09:00
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(String preferredBackupWindow) {
            return preferredBackupWindow(Output.of(preferredBackupWindow));
        }

        /**
         * @param preferredMaintenanceWindow Weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(@Nullable Output<String> preferredMaintenanceWindow) {
            $.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * @param preferredMaintenanceWindow Weekly time range during which system maintenance can occur, in (UTC) e.g., wed:04:00-wed:04:30
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            return preferredMaintenanceWindow(Output.of(preferredMaintenanceWindow));
        }

        /**
         * @param readerEndpoint Read-only endpoint for the Aurora cluster, automatically
         * load-balanced across replicas
         * 
         * @return builder
         * 
         */
        public Builder readerEndpoint(@Nullable Output<String> readerEndpoint) {
            $.readerEndpoint = readerEndpoint;
            return this;
        }

        /**
         * @param readerEndpoint Read-only endpoint for the Aurora cluster, automatically
         * load-balanced across replicas
         * 
         * @return builder
         * 
         */
        public Builder readerEndpoint(String readerEndpoint) {
            return readerEndpoint(Output.of(readerEndpoint));
        }

        /**
         * @param replicationSourceIdentifier ARN of a source DB cluster or DB instance if this DB cluster is to be created as a Read Replica. If DB Cluster is part of a Global Cluster, use the `lifecycle` configuration block `ignore_changes` argument to prevent this provider from showing differences for this argument instead of configuring this value.
         * 
         * @return builder
         * 
         */
        public Builder replicationSourceIdentifier(@Nullable Output<String> replicationSourceIdentifier) {
            $.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        /**
         * @param replicationSourceIdentifier ARN of a source DB cluster or DB instance if this DB cluster is to be created as a Read Replica. If DB Cluster is part of a Global Cluster, use the `lifecycle` configuration block `ignore_changes` argument to prevent this provider from showing differences for this argument instead of configuring this value.
         * 
         * @return builder
         * 
         */
        public Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            return replicationSourceIdentifier(Output.of(replicationSourceIdentifier));
        }

        /**
         * @param restoreToPointInTime Nested attribute for [point in time restore](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PIT.html). More details below.
         * 
         * @return builder
         * 
         */
        public Builder restoreToPointInTime(@Nullable Output<ClusterRestoreToPointInTimeArgs> restoreToPointInTime) {
            $.restoreToPointInTime = restoreToPointInTime;
            return this;
        }

        /**
         * @param restoreToPointInTime Nested attribute for [point in time restore](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PIT.html). More details below.
         * 
         * @return builder
         * 
         */
        public Builder restoreToPointInTime(ClusterRestoreToPointInTimeArgs restoreToPointInTime) {
            return restoreToPointInTime(Output.of(restoreToPointInTime));
        }

        public Builder s3Import(@Nullable Output<ClusterS3ImportArgs> s3Import) {
            $.s3Import = s3Import;
            return this;
        }

        public Builder s3Import(ClusterS3ImportArgs s3Import) {
            return s3Import(Output.of(s3Import));
        }

        /**
         * @param scalingConfiguration Nested attribute with scaling properties. Only valid when `engine_mode` is set to `serverless`. More details below.
         * 
         * @return builder
         * 
         */
        public Builder scalingConfiguration(@Nullable Output<ClusterScalingConfigurationArgs> scalingConfiguration) {
            $.scalingConfiguration = scalingConfiguration;
            return this;
        }

        /**
         * @param scalingConfiguration Nested attribute with scaling properties. Only valid when `engine_mode` is set to `serverless`. More details below.
         * 
         * @return builder
         * 
         */
        public Builder scalingConfiguration(ClusterScalingConfigurationArgs scalingConfiguration) {
            return scalingConfiguration(Output.of(scalingConfiguration));
        }

        /**
         * @param serverlessv2ScalingConfiguration Nested attribute with scaling properties for ServerlessV2. Only valid when `engine_mode` is set to `provisioned`. More details below.
         * 
         * @return builder
         * 
         */
        public Builder serverlessv2ScalingConfiguration(@Nullable Output<ClusterServerlessv2ScalingConfigurationArgs> serverlessv2ScalingConfiguration) {
            $.serverlessv2ScalingConfiguration = serverlessv2ScalingConfiguration;
            return this;
        }

        /**
         * @param serverlessv2ScalingConfiguration Nested attribute with scaling properties for ServerlessV2. Only valid when `engine_mode` is set to `provisioned`. More details below.
         * 
         * @return builder
         * 
         */
        public Builder serverlessv2ScalingConfiguration(ClusterServerlessv2ScalingConfigurationArgs serverlessv2ScalingConfiguration) {
            return serverlessv2ScalingConfiguration(Output.of(serverlessv2ScalingConfiguration));
        }

        /**
         * @param skipFinalSnapshot Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalSnapshot(@Nullable Output<Boolean> skipFinalSnapshot) {
            $.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        /**
         * @param skipFinalSnapshot Determines whether a final DB snapshot is created before the DB cluster is deleted. If true is specified, no DB snapshot is created. If false is specified, a DB snapshot is created before the DB cluster is deleted, using the value from `final_snapshot_identifier`. Default is `false`.
         * 
         * @return builder
         * 
         */
        public Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            return skipFinalSnapshot(Output.of(skipFinalSnapshot));
        }

        /**
         * @param snapshotIdentifier Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Conflicts with `global_cluster_identifier`. Clusters cannot be restored from snapshot **and** joined to an existing global cluster in a single operation. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-getting-started.html#aurora-global-database.use-snapshot) or the Global Cluster Restored From Snapshot example for instructions on building a global cluster starting with a snapshot.
         * 
         * @return builder
         * 
         */
        public Builder snapshotIdentifier(@Nullable Output<String> snapshotIdentifier) {
            $.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        /**
         * @param snapshotIdentifier Specifies whether or not to create this cluster from a snapshot. You can use either the name or ARN when specifying a DB cluster snapshot, or the ARN when specifying a DB snapshot. Conflicts with `global_cluster_identifier`. Clusters cannot be restored from snapshot **and** joined to an existing global cluster in a single operation. See the [AWS documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-getting-started.html#aurora-global-database.use-snapshot) or the Global Cluster Restored From Snapshot example for instructions on building a global cluster starting with a snapshot.
         * 
         * @return builder
         * 
         */
        public Builder snapshotIdentifier(String snapshotIdentifier) {
            return snapshotIdentifier(Output.of(snapshotIdentifier));
        }

        /**
         * @param sourceRegion The source region for an encrypted replica DB cluster.
         * 
         * @return builder
         * 
         */
        public Builder sourceRegion(@Nullable Output<String> sourceRegion) {
            $.sourceRegion = sourceRegion;
            return this;
        }

        /**
         * @param sourceRegion The source region for an encrypted replica DB cluster.
         * 
         * @return builder
         * 
         */
        public Builder sourceRegion(String sourceRegion) {
            return sourceRegion(Output.of(sourceRegion));
        }

        /**
         * @param storageEncrypted Specifies whether the DB cluster is encrypted. The default is `false` for `provisioned` `engine_mode` and `true` for `serverless` `engine_mode`. When restoring an unencrypted `snapshot_identifier`, the `kms_key_id` argument must be provided to encrypt the restored cluster. The provider will only perform drift detection if a configuration value is provided.
         * 
         * @return builder
         * 
         */
        public Builder storageEncrypted(@Nullable Output<Boolean> storageEncrypted) {
            $.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * @param storageEncrypted Specifies whether the DB cluster is encrypted. The default is `false` for `provisioned` `engine_mode` and `true` for `serverless` `engine_mode`. When restoring an unencrypted `snapshot_identifier`, the `kms_key_id` argument must be provided to encrypt the restored cluster. The provider will only perform drift detection if a configuration value is provided.
         * 
         * @return builder
         * 
         */
        public Builder storageEncrypted(Boolean storageEncrypted) {
            return storageEncrypted(Output.of(storageEncrypted));
        }

        /**
         * @param storageType (Required for Multi-AZ DB clusters) (Forces new for Multi-AZ DB clusters) Specifies the storage type to be associated with the DB cluster. For Aurora DB clusters, `storage_type` modifications can be done in-place. For Multi-AZ DB Clusters, the `iops` argument must also be set. Valid values are: `&#34;&#34;`, `aurora-iopt1` (Aurora DB Clusters); `io1` (Multi-AZ DB Clusters). Default: `&#34;&#34;` (Aurora DB Clusters); `io1` (Multi-AZ DB Clusters).
         * 
         * @return builder
         * 
         */
        public Builder storageType(@Nullable Output<String> storageType) {
            $.storageType = storageType;
            return this;
        }

        /**
         * @param storageType (Required for Multi-AZ DB clusters) (Forces new for Multi-AZ DB clusters) Specifies the storage type to be associated with the DB cluster. For Aurora DB clusters, `storage_type` modifications can be done in-place. For Multi-AZ DB Clusters, the `iops` argument must also be set. Valid values are: `&#34;&#34;`, `aurora-iopt1` (Aurora DB Clusters); `io1` (Multi-AZ DB Clusters). Default: `&#34;&#34;` (Aurora DB Clusters); `io1` (Multi-AZ DB Clusters).
         * 
         * @return builder
         * 
         */
        public Builder storageType(String storageType) {
            return storageType(Output.of(storageType));
        }

        /**
         * @param tags A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param vpcSecurityGroupIds List of VPC security groups to associate with the Cluster
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(@Nullable Output<List<String>> vpcSecurityGroupIds) {
            $.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * @param vpcSecurityGroupIds List of VPC security groups to associate with the Cluster
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(List<String> vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(Output.of(vpcSecurityGroupIds));
        }

        /**
         * @param vpcSecurityGroupIds List of VPC security groups to associate with the Cluster
         * 
         * @return builder
         * 
         */
        public Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            return vpcSecurityGroupIds(List.of(vpcSecurityGroupIds));
        }

        public ClusterState build() {
            return $;
        }
    }

}
