// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterRestoreToPointInTimeArgs extends com.pulumi.resources.ResourceArgs {

    public static final ClusterRestoreToPointInTimeArgs Empty = new ClusterRestoreToPointInTimeArgs();

    /**
     * Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
     * 
     */
    @Import(name="restoreToTime")
    private @Nullable Output<String> restoreToTime;

    /**
     * @return Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
     * 
     */
    public Optional<Output<String>> restoreToTime() {
        return Optional.ofNullable(this.restoreToTime);
    }

    /**
     * Type of restore to be performed.
     * Valid options are `full-copy` (default) and `copy-on-write`.
     * 
     */
    @Import(name="restoreType")
    private @Nullable Output<String> restoreType;

    /**
     * @return Type of restore to be performed.
     * Valid options are `full-copy` (default) and `copy-on-write`.
     * 
     */
    public Optional<Output<String>> restoreType() {
        return Optional.ofNullable(this.restoreType);
    }

    /**
     * Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
     * 
     */
    @Import(name="sourceClusterIdentifier", required=true)
    private Output<String> sourceClusterIdentifier;

    /**
     * @return Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
     * 
     */
    public Output<String> sourceClusterIdentifier() {
        return this.sourceClusterIdentifier;
    }

    /**
     * Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
     * 
     */
    @Import(name="useLatestRestorableTime")
    private @Nullable Output<Boolean> useLatestRestorableTime;

    /**
     * @return Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
     * 
     */
    public Optional<Output<Boolean>> useLatestRestorableTime() {
        return Optional.ofNullable(this.useLatestRestorableTime);
    }

    private ClusterRestoreToPointInTimeArgs() {}

    private ClusterRestoreToPointInTimeArgs(ClusterRestoreToPointInTimeArgs $) {
        this.restoreToTime = $.restoreToTime;
        this.restoreType = $.restoreType;
        this.sourceClusterIdentifier = $.sourceClusterIdentifier;
        this.useLatestRestorableTime = $.useLatestRestorableTime;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterRestoreToPointInTimeArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterRestoreToPointInTimeArgs $;

        public Builder() {
            $ = new ClusterRestoreToPointInTimeArgs();
        }

        public Builder(ClusterRestoreToPointInTimeArgs defaults) {
            $ = new ClusterRestoreToPointInTimeArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param restoreToTime Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
         * 
         * @return builder
         * 
         */
        public Builder restoreToTime(@Nullable Output<String> restoreToTime) {
            $.restoreToTime = restoreToTime;
            return this;
        }

        /**
         * @param restoreToTime Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
         * 
         * @return builder
         * 
         */
        public Builder restoreToTime(String restoreToTime) {
            return restoreToTime(Output.of(restoreToTime));
        }

        /**
         * @param restoreType Type of restore to be performed.
         * Valid options are `full-copy` (default) and `copy-on-write`.
         * 
         * @return builder
         * 
         */
        public Builder restoreType(@Nullable Output<String> restoreType) {
            $.restoreType = restoreType;
            return this;
        }

        /**
         * @param restoreType Type of restore to be performed.
         * Valid options are `full-copy` (default) and `copy-on-write`.
         * 
         * @return builder
         * 
         */
        public Builder restoreType(String restoreType) {
            return restoreType(Output.of(restoreType));
        }

        /**
         * @param sourceClusterIdentifier Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
         * 
         * @return builder
         * 
         */
        public Builder sourceClusterIdentifier(Output<String> sourceClusterIdentifier) {
            $.sourceClusterIdentifier = sourceClusterIdentifier;
            return this;
        }

        /**
         * @param sourceClusterIdentifier Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
         * 
         * @return builder
         * 
         */
        public Builder sourceClusterIdentifier(String sourceClusterIdentifier) {
            return sourceClusterIdentifier(Output.of(sourceClusterIdentifier));
        }

        /**
         * @param useLatestRestorableTime Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
         * 
         * @return builder
         * 
         */
        public Builder useLatestRestorableTime(@Nullable Output<Boolean> useLatestRestorableTime) {
            $.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        /**
         * @param useLatestRestorableTime Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
         * 
         * @return builder
         * 
         */
        public Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            return useLatestRestorableTime(Output.of(useLatestRestorableTime));
        }

        public ClusterRestoreToPointInTimeArgs build() {
            $.sourceClusterIdentifier = Objects.requireNonNull($.sourceClusterIdentifier, "expected parameter 'sourceClusterIdentifier' to be non-null");
            return $;
        }
    }

}
