// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.aws.rds.inputs;

import com.pulumi.aws.rds.enums.InstanceType;
import com.pulumi.core.Either;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ClusterInstanceState extends com.pulumi.resources.ResourceArgs {

    public static final ClusterInstanceState Empty = new ClusterInstanceState();

    /**
     * Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
     * 
     */
    @Import(name="applyImmediately")
    private @Nullable Output<Boolean> applyImmediately;

    /**
     * @return Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
     * 
     */
    public Optional<Output<Boolean>> applyImmediately() {
        return Optional.ofNullable(this.applyImmediately);
    }

    /**
     * Amazon Resource Name (ARN) of cluster instance
     * 
     */
    @Import(name="arn")
    private @Nullable Output<String> arn;

    /**
     * @return Amazon Resource Name (ARN) of cluster instance
     * 
     */
    public Optional<Output<String>> arn() {
        return Optional.ofNullable(this.arn);
    }

    /**
     * Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
     * 
     */
    @Import(name="autoMinorVersionUpgrade")
    private @Nullable Output<Boolean> autoMinorVersionUpgrade;

    /**
     * @return Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
     * 
     */
    public Optional<Output<Boolean>> autoMinorVersionUpgrade() {
        return Optional.ofNullable(this.autoMinorVersionUpgrade);
    }

    /**
     * EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
     * 
     */
    @Import(name="availabilityZone")
    private @Nullable Output<String> availabilityZone;

    /**
     * @return EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
     * 
     */
    public Optional<Output<String>> availabilityZone() {
        return Optional.ofNullable(this.availabilityZone);
    }

    /**
     * Identifier of the CA certificate for the DB instance.
     * 
     */
    @Import(name="caCertIdentifier")
    private @Nullable Output<String> caCertIdentifier;

    /**
     * @return Identifier of the CA certificate for the DB instance.
     * 
     */
    public Optional<Output<String>> caCertIdentifier() {
        return Optional.ofNullable(this.caCertIdentifier);
    }

    /**
     * Identifier of the `aws.rds.Cluster` in which to launch this instance.
     * 
     */
    @Import(name="clusterIdentifier")
    private @Nullable Output<String> clusterIdentifier;

    /**
     * @return Identifier of the `aws.rds.Cluster` in which to launch this instance.
     * 
     */
    public Optional<Output<String>> clusterIdentifier() {
        return Optional.ofNullable(this.clusterIdentifier);
    }

    /**
     * Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
     * 
     */
    @Import(name="copyTagsToSnapshot")
    private @Nullable Output<Boolean> copyTagsToSnapshot;

    /**
     * @return Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
     * 
     */
    public Optional<Output<Boolean>> copyTagsToSnapshot() {
        return Optional.ofNullable(this.copyTagsToSnapshot);
    }

    /**
     * Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
     * 
     */
    @Import(name="customIamInstanceProfile")
    private @Nullable Output<String> customIamInstanceProfile;

    /**
     * @return Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
     * 
     */
    public Optional<Output<String>> customIamInstanceProfile() {
        return Optional.ofNullable(this.customIamInstanceProfile);
    }

    /**
     * Name of the DB parameter group to associate with this instance.
     * 
     */
    @Import(name="dbParameterGroupName")
    private @Nullable Output<String> dbParameterGroupName;

    /**
     * @return Name of the DB parameter group to associate with this instance.
     * 
     */
    public Optional<Output<String>> dbParameterGroupName() {
        return Optional.ofNullable(this.dbParameterGroupName);
    }

    /**
     * DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` of the attached `aws.rds.Cluster`.
     * 
     */
    @Import(name="dbSubnetGroupName")
    private @Nullable Output<String> dbSubnetGroupName;

    /**
     * @return DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` of the attached `aws.rds.Cluster`.
     * 
     */
    public Optional<Output<String>> dbSubnetGroupName() {
        return Optional.ofNullable(this.dbSubnetGroupName);
    }

    /**
     * Region-unique, immutable identifier for the DB instance.
     * 
     */
    @Import(name="dbiResourceId")
    private @Nullable Output<String> dbiResourceId;

    /**
     * @return Region-unique, immutable identifier for the DB instance.
     * 
     */
    public Optional<Output<String>> dbiResourceId() {
        return Optional.ofNullable(this.dbiResourceId);
    }

    /**
     * DNS address for this instance. May not be writable
     * 
     */
    @Import(name="endpoint")
    private @Nullable Output<String> endpoint;

    /**
     * @return DNS address for this instance. May not be writable
     * 
     */
    public Optional<Output<String>> endpoint() {
        return Optional.ofNullable(this.endpoint);
    }

    /**
     * Name of the database engine to be used for the RDS instance. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.
     * 
     */
    @Import(name="engine")
    private @Nullable Output<String> engine;

    /**
     * @return Name of the database engine to be used for the RDS instance. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.
     * 
     */
    public Optional<Output<String>> engine() {
        return Optional.ofNullable(this.engine);
    }

    /**
     * Database engine version.
     * 
     */
    @Import(name="engineVersion")
    private @Nullable Output<String> engineVersion;

    /**
     * @return Database engine version.
     * 
     */
    public Optional<Output<String>> engineVersion() {
        return Optional.ofNullable(this.engineVersion);
    }

    /**
     * Database engine version
     * 
     */
    @Import(name="engineVersionActual")
    private @Nullable Output<String> engineVersionActual;

    /**
     * @return Database engine version
     * 
     */
    public Optional<Output<String>> engineVersionActual() {
        return Optional.ofNullable(this.engineVersionActual);
    }

    /**
     * Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
     * 
     */
    @Import(name="identifier")
    private @Nullable Output<String> identifier;

    /**
     * @return Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
     * 
     */
    public Optional<Output<String>> identifier() {
        return Optional.ofNullable(this.identifier);
    }

    /**
     * Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     * 
     */
    @Import(name="identifierPrefix")
    private @Nullable Output<String> identifierPrefix;

    /**
     * @return Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
     * 
     */
    public Optional<Output<String>> identifierPrefix() {
        return Optional.ofNullable(this.identifierPrefix);
    }

    /**
     * Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details.
     * 
     */
    @Import(name="instanceClass")
    private @Nullable Output<Either<String,InstanceType>> instanceClass;

    /**
     * @return Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details.
     * 
     */
    public Optional<Output<Either<String,InstanceType>>> instanceClass() {
        return Optional.ofNullable(this.instanceClass);
    }

    /**
     * ARN for the KMS encryption key if one is set to the cluster.
     * 
     */
    @Import(name="kmsKeyId")
    private @Nullable Output<String> kmsKeyId;

    /**
     * @return ARN for the KMS encryption key if one is set to the cluster.
     * 
     */
    public Optional<Output<String>> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    /**
     * Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
     * 
     */
    @Import(name="monitoringInterval")
    private @Nullable Output<Integer> monitoringInterval;

    /**
     * @return Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
     * 
     */
    public Optional<Output<Integer>> monitoringInterval() {
        return Optional.ofNullable(this.monitoringInterval);
    }

    /**
     * ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
     * 
     */
    @Import(name="monitoringRoleArn")
    private @Nullable Output<String> monitoringRoleArn;

    /**
     * @return ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
     * 
     */
    public Optional<Output<String>> monitoringRoleArn() {
        return Optional.ofNullable(this.monitoringRoleArn);
    }

    /**
     * Network type of the DB instance.
     * 
     */
    @Import(name="networkType")
    private @Nullable Output<String> networkType;

    /**
     * @return Network type of the DB instance.
     * 
     */
    public Optional<Output<String>> networkType() {
        return Optional.ofNullable(this.networkType);
    }

    /**
     * Specifies whether Performance Insights is enabled or not.
     * 
     */
    @Import(name="performanceInsightsEnabled")
    private @Nullable Output<Boolean> performanceInsightsEnabled;

    /**
     * @return Specifies whether Performance Insights is enabled or not.
     * 
     */
    public Optional<Output<Boolean>> performanceInsightsEnabled() {
        return Optional.ofNullable(this.performanceInsightsEnabled);
    }

    /**
     * ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
     * 
     */
    @Import(name="performanceInsightsKmsKeyId")
    private @Nullable Output<String> performanceInsightsKmsKeyId;

    /**
     * @return ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
     * 
     */
    public Optional<Output<String>> performanceInsightsKmsKeyId() {
        return Optional.ofNullable(this.performanceInsightsKmsKeyId);
    }

    /**
     * Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to &#39;7&#39;.
     * 
     */
    @Import(name="performanceInsightsRetentionPeriod")
    private @Nullable Output<Integer> performanceInsightsRetentionPeriod;

    /**
     * @return Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to &#39;7&#39;.
     * 
     */
    public Optional<Output<Integer>> performanceInsightsRetentionPeriod() {
        return Optional.ofNullable(this.performanceInsightsRetentionPeriod);
    }

    /**
     * Database port
     * 
     */
    @Import(name="port")
    private @Nullable Output<Integer> port;

    /**
     * @return Database port
     * 
     */
    public Optional<Output<Integer>> port() {
        return Optional.ofNullable(this.port);
    }

    /**
     * Daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;. **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
     * 
     */
    @Import(name="preferredBackupWindow")
    private @Nullable Output<String> preferredBackupWindow;

    /**
     * @return Daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;. **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
     * 
     */
    public Optional<Output<String>> preferredBackupWindow() {
        return Optional.ofNullable(this.preferredBackupWindow);
    }

    /**
     * Window to perform maintenance in. Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
     * 
     */
    @Import(name="preferredMaintenanceWindow")
    private @Nullable Output<String> preferredMaintenanceWindow;

    /**
     * @return Window to perform maintenance in. Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
     * 
     */
    public Optional<Output<String>> preferredMaintenanceWindow() {
        return Optional.ofNullable(this.preferredMaintenanceWindow);
    }

    /**
     * Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
     * 
     */
    @Import(name="promotionTier")
    private @Nullable Output<Integer> promotionTier;

    /**
     * @return Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
     * 
     */
    public Optional<Output<Integer>> promotionTier() {
        return Optional.ofNullable(this.promotionTier);
    }

    /**
     * Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
     * 
     */
    @Import(name="publiclyAccessible")
    private @Nullable Output<Boolean> publiclyAccessible;

    /**
     * @return Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
     * 
     */
    public Optional<Output<Boolean>> publiclyAccessible() {
        return Optional.ofNullable(this.publiclyAccessible);
    }

    /**
     * Specifies whether the DB cluster is encrypted.
     * 
     */
    @Import(name="storageEncrypted")
    private @Nullable Output<Boolean> storageEncrypted;

    /**
     * @return Specifies whether the DB cluster is encrypted.
     * 
     */
    public Optional<Output<Boolean>> storageEncrypted() {
        return Optional.ofNullable(this.storageEncrypted);
    }

    /**
     * Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<Map<String,String>> tags;

    /**
     * @return Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * 
     */
    public Optional<Output<Map<String,String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    @Import(name="tagsAll")
    private @Nullable Output<Map<String,String>> tagsAll;

    /**
     * @return Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * 
     */
    public Optional<Output<Map<String,String>>> tagsAll() {
        return Optional.ofNullable(this.tagsAll);
    }

    /**
     * Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
     * 
     */
    @Import(name="writer")
    private @Nullable Output<Boolean> writer;

    /**
     * @return Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
     * 
     */
    public Optional<Output<Boolean>> writer() {
        return Optional.ofNullable(this.writer);
    }

    private ClusterInstanceState() {}

    private ClusterInstanceState(ClusterInstanceState $) {
        this.applyImmediately = $.applyImmediately;
        this.arn = $.arn;
        this.autoMinorVersionUpgrade = $.autoMinorVersionUpgrade;
        this.availabilityZone = $.availabilityZone;
        this.caCertIdentifier = $.caCertIdentifier;
        this.clusterIdentifier = $.clusterIdentifier;
        this.copyTagsToSnapshot = $.copyTagsToSnapshot;
        this.customIamInstanceProfile = $.customIamInstanceProfile;
        this.dbParameterGroupName = $.dbParameterGroupName;
        this.dbSubnetGroupName = $.dbSubnetGroupName;
        this.dbiResourceId = $.dbiResourceId;
        this.endpoint = $.endpoint;
        this.engine = $.engine;
        this.engineVersion = $.engineVersion;
        this.engineVersionActual = $.engineVersionActual;
        this.identifier = $.identifier;
        this.identifierPrefix = $.identifierPrefix;
        this.instanceClass = $.instanceClass;
        this.kmsKeyId = $.kmsKeyId;
        this.monitoringInterval = $.monitoringInterval;
        this.monitoringRoleArn = $.monitoringRoleArn;
        this.networkType = $.networkType;
        this.performanceInsightsEnabled = $.performanceInsightsEnabled;
        this.performanceInsightsKmsKeyId = $.performanceInsightsKmsKeyId;
        this.performanceInsightsRetentionPeriod = $.performanceInsightsRetentionPeriod;
        this.port = $.port;
        this.preferredBackupWindow = $.preferredBackupWindow;
        this.preferredMaintenanceWindow = $.preferredMaintenanceWindow;
        this.promotionTier = $.promotionTier;
        this.publiclyAccessible = $.publiclyAccessible;
        this.storageEncrypted = $.storageEncrypted;
        this.tags = $.tags;
        this.tagsAll = $.tagsAll;
        this.writer = $.writer;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ClusterInstanceState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ClusterInstanceState $;

        public Builder() {
            $ = new ClusterInstanceState();
        }

        public Builder(ClusterInstanceState defaults) {
            $ = new ClusterInstanceState(Objects.requireNonNull(defaults));
        }

        /**
         * @param applyImmediately Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(@Nullable Output<Boolean> applyImmediately) {
            $.applyImmediately = applyImmediately;
            return this;
        }

        /**
         * @param applyImmediately Specifies whether any database modifications are applied immediately, or during the next maintenance window. Default is`false`.
         * 
         * @return builder
         * 
         */
        public Builder applyImmediately(Boolean applyImmediately) {
            return applyImmediately(Output.of(applyImmediately));
        }

        /**
         * @param arn Amazon Resource Name (ARN) of cluster instance
         * 
         * @return builder
         * 
         */
        public Builder arn(@Nullable Output<String> arn) {
            $.arn = arn;
            return this;
        }

        /**
         * @param arn Amazon Resource Name (ARN) of cluster instance
         * 
         * @return builder
         * 
         */
        public Builder arn(String arn) {
            return arn(Output.of(arn));
        }

        /**
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
         * 
         * @return builder
         * 
         */
        public Builder autoMinorVersionUpgrade(@Nullable Output<Boolean> autoMinorVersionUpgrade) {
            $.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades will be applied automatically to the DB instance during the maintenance window. Default `true`.
         * 
         * @return builder
         * 
         */
        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            return autoMinorVersionUpgrade(Output.of(autoMinorVersionUpgrade));
        }

        /**
         * @param availabilityZone EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(@Nullable Output<String> availabilityZone) {
            $.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * @param availabilityZone EC2 Availability Zone that the DB instance is created in. See [docs](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) about the details.
         * 
         * @return builder
         * 
         */
        public Builder availabilityZone(String availabilityZone) {
            return availabilityZone(Output.of(availabilityZone));
        }

        /**
         * @param caCertIdentifier Identifier of the CA certificate for the DB instance.
         * 
         * @return builder
         * 
         */
        public Builder caCertIdentifier(@Nullable Output<String> caCertIdentifier) {
            $.caCertIdentifier = caCertIdentifier;
            return this;
        }

        /**
         * @param caCertIdentifier Identifier of the CA certificate for the DB instance.
         * 
         * @return builder
         * 
         */
        public Builder caCertIdentifier(String caCertIdentifier) {
            return caCertIdentifier(Output.of(caCertIdentifier));
        }

        /**
         * @param clusterIdentifier Identifier of the `aws.rds.Cluster` in which to launch this instance.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(@Nullable Output<String> clusterIdentifier) {
            $.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * @param clusterIdentifier Identifier of the `aws.rds.Cluster` in which to launch this instance.
         * 
         * @return builder
         * 
         */
        public Builder clusterIdentifier(String clusterIdentifier) {
            return clusterIdentifier(Output.of(clusterIdentifier));
        }

        /**
         * @param copyTagsToSnapshot Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToSnapshot(@Nullable Output<Boolean> copyTagsToSnapshot) {
            $.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * @param copyTagsToSnapshot Indicates whether to copy all of the user-defined tags from the DB instance to snapshots of the DB instance. Default `false`.
         * 
         * @return builder
         * 
         */
        public Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            return copyTagsToSnapshot(Output.of(copyTagsToSnapshot));
        }

        /**
         * @param customIamInstanceProfile Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
         * 
         * @return builder
         * 
         */
        public Builder customIamInstanceProfile(@Nullable Output<String> customIamInstanceProfile) {
            $.customIamInstanceProfile = customIamInstanceProfile;
            return this;
        }

        /**
         * @param customIamInstanceProfile Instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance.
         * 
         * @return builder
         * 
         */
        public Builder customIamInstanceProfile(String customIamInstanceProfile) {
            return customIamInstanceProfile(Output.of(customIamInstanceProfile));
        }

        /**
         * @param dbParameterGroupName Name of the DB parameter group to associate with this instance.
         * 
         * @return builder
         * 
         */
        public Builder dbParameterGroupName(@Nullable Output<String> dbParameterGroupName) {
            $.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        /**
         * @param dbParameterGroupName Name of the DB parameter group to associate with this instance.
         * 
         * @return builder
         * 
         */
        public Builder dbParameterGroupName(String dbParameterGroupName) {
            return dbParameterGroupName(Output.of(dbParameterGroupName));
        }

        /**
         * @param dbSubnetGroupName DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` of the attached `aws.rds.Cluster`.
         * 
         * @return builder
         * 
         */
        public Builder dbSubnetGroupName(@Nullable Output<String> dbSubnetGroupName) {
            $.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        /**
         * @param dbSubnetGroupName DB subnet group to associate with this DB instance. **NOTE:** This must match the `db_subnet_group_name` of the attached `aws.rds.Cluster`.
         * 
         * @return builder
         * 
         */
        public Builder dbSubnetGroupName(String dbSubnetGroupName) {
            return dbSubnetGroupName(Output.of(dbSubnetGroupName));
        }

        /**
         * @param dbiResourceId Region-unique, immutable identifier for the DB instance.
         * 
         * @return builder
         * 
         */
        public Builder dbiResourceId(@Nullable Output<String> dbiResourceId) {
            $.dbiResourceId = dbiResourceId;
            return this;
        }

        /**
         * @param dbiResourceId Region-unique, immutable identifier for the DB instance.
         * 
         * @return builder
         * 
         */
        public Builder dbiResourceId(String dbiResourceId) {
            return dbiResourceId(Output.of(dbiResourceId));
        }

        /**
         * @param endpoint DNS address for this instance. May not be writable
         * 
         * @return builder
         * 
         */
        public Builder endpoint(@Nullable Output<String> endpoint) {
            $.endpoint = endpoint;
            return this;
        }

        /**
         * @param endpoint DNS address for this instance. May not be writable
         * 
         * @return builder
         * 
         */
        public Builder endpoint(String endpoint) {
            return endpoint(Output.of(endpoint));
        }

        /**
         * @param engine Name of the database engine to be used for the RDS instance. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.
         * 
         * @return builder
         * 
         */
        public Builder engine(@Nullable Output<String> engine) {
            $.engine = engine;
            return this;
        }

        /**
         * @param engine Name of the database engine to be used for the RDS instance. Valid Values: `aurora-mysql`, `aurora-postgresql`, `mysql`, `postgres`.
         * 
         * @return builder
         * 
         */
        public Builder engine(String engine) {
            return engine(Output.of(engine));
        }

        /**
         * @param engineVersion Database engine version.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(@Nullable Output<String> engineVersion) {
            $.engineVersion = engineVersion;
            return this;
        }

        /**
         * @param engineVersion Database engine version.
         * 
         * @return builder
         * 
         */
        public Builder engineVersion(String engineVersion) {
            return engineVersion(Output.of(engineVersion));
        }

        /**
         * @param engineVersionActual Database engine version
         * 
         * @return builder
         * 
         */
        public Builder engineVersionActual(@Nullable Output<String> engineVersionActual) {
            $.engineVersionActual = engineVersionActual;
            return this;
        }

        /**
         * @param engineVersionActual Database engine version
         * 
         * @return builder
         * 
         */
        public Builder engineVersionActual(String engineVersionActual) {
            return engineVersionActual(Output.of(engineVersionActual));
        }

        /**
         * @param identifier Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
         * 
         * @return builder
         * 
         */
        public Builder identifier(@Nullable Output<String> identifier) {
            $.identifier = identifier;
            return this;
        }

        /**
         * @param identifier Identifier for the RDS instance, if omitted, Pulumi will assign a random, unique identifier.
         * 
         * @return builder
         * 
         */
        public Builder identifier(String identifier) {
            return identifier(Output.of(identifier));
        }

        /**
         * @param identifierPrefix Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
         * 
         * @return builder
         * 
         */
        public Builder identifierPrefix(@Nullable Output<String> identifierPrefix) {
            $.identifierPrefix = identifierPrefix;
            return this;
        }

        /**
         * @param identifierPrefix Creates a unique identifier beginning with the specified prefix. Conflicts with `identifier`.
         * 
         * @return builder
         * 
         */
        public Builder identifierPrefix(String identifierPrefix) {
            return identifierPrefix(Output.of(identifierPrefix));
        }

        /**
         * @param instanceClass Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details.
         * 
         * @return builder
         * 
         */
        public Builder instanceClass(@Nullable Output<Either<String,InstanceType>> instanceClass) {
            $.instanceClass = instanceClass;
            return this;
        }

        /**
         * @param instanceClass Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details.
         * 
         * @return builder
         * 
         */
        public Builder instanceClass(Either<String,InstanceType> instanceClass) {
            return instanceClass(Output.of(instanceClass));
        }

        /**
         * @param instanceClass Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details.
         * 
         * @return builder
         * 
         */
        public Builder instanceClass(String instanceClass) {
            return instanceClass(Either.ofLeft(instanceClass));
        }

        /**
         * @param instanceClass Instance class to use. For details on CPU and memory, see [Scaling Aurora DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html). Aurora uses `db.*` instance classes/types. Please see [AWS Documentation](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) for currently available instance classes and complete details.
         * 
         * @return builder
         * 
         */
        public Builder instanceClass(InstanceType instanceClass) {
            return instanceClass(Either.ofRight(instanceClass));
        }

        /**
         * @param kmsKeyId ARN for the KMS encryption key if one is set to the cluster.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(@Nullable Output<String> kmsKeyId) {
            $.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * @param kmsKeyId ARN for the KMS encryption key if one is set to the cluster.
         * 
         * @return builder
         * 
         */
        public Builder kmsKeyId(String kmsKeyId) {
            return kmsKeyId(Output.of(kmsKeyId));
        }

        /**
         * @param monitoringInterval Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
         * 
         * @return builder
         * 
         */
        public Builder monitoringInterval(@Nullable Output<Integer> monitoringInterval) {
            $.monitoringInterval = monitoringInterval;
            return this;
        }

        /**
         * @param monitoringInterval Interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0. Valid Values: 0, 1, 5, 10, 15, 30, 60.
         * 
         * @return builder
         * 
         */
        public Builder monitoringInterval(Integer monitoringInterval) {
            return monitoringInterval(Output.of(monitoringInterval));
        }

        /**
         * @param monitoringRoleArn ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
         * 
         * @return builder
         * 
         */
        public Builder monitoringRoleArn(@Nullable Output<String> monitoringRoleArn) {
            $.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        /**
         * @param monitoringRoleArn ARN for the IAM role that permits RDS to send enhanced monitoring metrics to CloudWatch Logs. You can find more information on the [AWS Documentation](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html) what IAM permissions are needed to allow Enhanced Monitoring for RDS Instances.
         * 
         * @return builder
         * 
         */
        public Builder monitoringRoleArn(String monitoringRoleArn) {
            return monitoringRoleArn(Output.of(monitoringRoleArn));
        }

        /**
         * @param networkType Network type of the DB instance.
         * 
         * @return builder
         * 
         */
        public Builder networkType(@Nullable Output<String> networkType) {
            $.networkType = networkType;
            return this;
        }

        /**
         * @param networkType Network type of the DB instance.
         * 
         * @return builder
         * 
         */
        public Builder networkType(String networkType) {
            return networkType(Output.of(networkType));
        }

        /**
         * @param performanceInsightsEnabled Specifies whether Performance Insights is enabled or not.
         * 
         * @return builder
         * 
         */
        public Builder performanceInsightsEnabled(@Nullable Output<Boolean> performanceInsightsEnabled) {
            $.performanceInsightsEnabled = performanceInsightsEnabled;
            return this;
        }

        /**
         * @param performanceInsightsEnabled Specifies whether Performance Insights is enabled or not.
         * 
         * @return builder
         * 
         */
        public Builder performanceInsightsEnabled(Boolean performanceInsightsEnabled) {
            return performanceInsightsEnabled(Output.of(performanceInsightsEnabled));
        }

        /**
         * @param performanceInsightsKmsKeyId ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
         * 
         * @return builder
         * 
         */
        public Builder performanceInsightsKmsKeyId(@Nullable Output<String> performanceInsightsKmsKeyId) {
            $.performanceInsightsKmsKeyId = performanceInsightsKmsKeyId;
            return this;
        }

        /**
         * @param performanceInsightsKmsKeyId ARN for the KMS key to encrypt Performance Insights data. When specifying `performance_insights_kms_key_id`, `performance_insights_enabled` needs to be set to true.
         * 
         * @return builder
         * 
         */
        public Builder performanceInsightsKmsKeyId(String performanceInsightsKmsKeyId) {
            return performanceInsightsKmsKeyId(Output.of(performanceInsightsKmsKeyId));
        }

        /**
         * @param performanceInsightsRetentionPeriod Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to &#39;7&#39;.
         * 
         * @return builder
         * 
         */
        public Builder performanceInsightsRetentionPeriod(@Nullable Output<Integer> performanceInsightsRetentionPeriod) {
            $.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        /**
         * @param performanceInsightsRetentionPeriod Amount of time in days to retain Performance Insights data. Valid values are `7`, `731` (2 years) or a multiple of `31`. When specifying `performance_insights_retention_period`, `performance_insights_enabled` needs to be set to true. Defaults to &#39;7&#39;.
         * 
         * @return builder
         * 
         */
        public Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            return performanceInsightsRetentionPeriod(Output.of(performanceInsightsRetentionPeriod));
        }

        /**
         * @param port Database port
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<Integer> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port Database port
         * 
         * @return builder
         * 
         */
        public Builder port(Integer port) {
            return port(Output.of(port));
        }

        /**
         * @param preferredBackupWindow Daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;. **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(@Nullable Output<String> preferredBackupWindow) {
            $.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * @param preferredBackupWindow Daily time range during which automated backups are created if automated backups are enabled. Eg: &#34;04:00-09:00&#34;. **NOTE:** If `preferred_backup_window` is set at the cluster level, this argument **must** be omitted.
         * 
         * @return builder
         * 
         */
        public Builder preferredBackupWindow(String preferredBackupWindow) {
            return preferredBackupWindow(Output.of(preferredBackupWindow));
        }

        /**
         * @param preferredMaintenanceWindow Window to perform maintenance in. Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(@Nullable Output<String> preferredMaintenanceWindow) {
            $.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * @param preferredMaintenanceWindow Window to perform maintenance in. Syntax: &#34;ddd:hh24:mi-ddd:hh24:mi&#34;. Eg: &#34;Mon:00:00-Mon:03:00&#34;.
         * 
         * @return builder
         * 
         */
        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            return preferredMaintenanceWindow(Output.of(preferredMaintenanceWindow));
        }

        /**
         * @param promotionTier Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
         * 
         * @return builder
         * 
         */
        public Builder promotionTier(@Nullable Output<Integer> promotionTier) {
            $.promotionTier = promotionTier;
            return this;
        }

        /**
         * @param promotionTier Default 0. Failover Priority setting on instance level. The reader who has lower tier has higher priority to get promoted to writer.
         * 
         * @return builder
         * 
         */
        public Builder promotionTier(Integer promotionTier) {
            return promotionTier(Output.of(promotionTier));
        }

        /**
         * @param publiclyAccessible Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(@Nullable Output<Boolean> publiclyAccessible) {
            $.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * @param publiclyAccessible Bool to control if instance is publicly accessible. Default `false`. See the documentation on [Creating DB Instances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html) for more details on controlling this property.
         * 
         * @return builder
         * 
         */
        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            return publiclyAccessible(Output.of(publiclyAccessible));
        }

        /**
         * @param storageEncrypted Specifies whether the DB cluster is encrypted.
         * 
         * @return builder
         * 
         */
        public Builder storageEncrypted(@Nullable Output<Boolean> storageEncrypted) {
            $.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * @param storageEncrypted Specifies whether the DB cluster is encrypted.
         * 
         * @return builder
         * 
         */
        public Builder storageEncrypted(Boolean storageEncrypted) {
            return storageEncrypted(Output.of(storageEncrypted));
        }

        /**
         * @param tags Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<Map<String,String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
         * 
         * @return builder
         * 
         */
        public Builder tags(Map<String,String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(@Nullable Output<Map<String,String>> tagsAll) {
            $.tagsAll = tagsAll;
            return this;
        }

        /**
         * @param tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
         * 
         * @return builder
         * 
         */
        public Builder tagsAll(Map<String,String> tagsAll) {
            return tagsAll(Output.of(tagsAll));
        }

        /**
         * @param writer Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
         * 
         * @return builder
         * 
         */
        public Builder writer(@Nullable Output<Boolean> writer) {
            $.writer = writer;
            return this;
        }

        /**
         * @param writer Boolean indicating if this instance is writable. `False` indicates this instance is a read replica.
         * 
         * @return builder
         * 
         */
        public Builder writer(Boolean writer) {
            return writer(Output.of(writer));
        }

        public ClusterInstanceState build() {
            return $;
        }
    }

}
